/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.Layers;

public class LayerSettingVector
extends LayerSetting {
    private GeoStyle m_geoStyle = null;
    private Layer m_layer = null;
    private Layers m_layers = null;
    private boolean isOwnerLayer = false;

    public LayerSettingVector() {
        GeoStyle geoStyle = new GeoStyle();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        this.m_geoStyle = InternalGeoStyle.createInstance(l);
        this.isOwnerLayer = false;
    }

    public LayerSettingVector(LayerSettingVector layerSettingVector) {
        if (layerSettingVector == null) {
            String string = InternalResource.loadString("layerSettingVector", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerSettingVector.isOwnerLayer) {
            if (layerSettingVector.m_layer == null) {
                String string = InternalResource.loadString("layerSettingVector", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(layerSettingVector.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("layerSettingVector", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        GeoStyle geoStyle = layerSettingVector.getStyle().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        this.m_geoStyle = InternalGeoStyle.createInstance(l);
        this.isOwnerLayer = false;
    }

    LayerSettingVector(Layer layer, Layers layers) {
        this.m_layer = layer;
        this.m_layers = layers;
        this.isOwnerLayer = true;
    }

    @Override
    public LayerSettingType getType() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        return LayerSettingType.VECTOR;
    }

    public GeoStyle getStyle() {
        if (this.isOwnerLayer) {
            long l;
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_geoStyle == null && (l = LayerNative.jni_GetStyle(l2)) != 0L) {
                this.m_geoStyle = InternalGeoStyle.createInstance(l);
            }
        }
        return this.m_geoStyle;
    }

    public void setStyle(GeoStyle style) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (style == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "LayerSettingVector_InvalidStyle", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (this.isOwnerLayer) {
            LayerNative.jni_SetStyle(l, l2);
        } else if (this.m_geoStyle == null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
            this.m_geoStyle = InternalGeoStyle.createInstance(l2);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
            InternalGeoStyle.changeHandle(this.m_geoStyle, l2);
        }
    }

    protected void finalize() {
        if (this.m_layer == null && this.m_geoStyle != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_geoStyle, true);
            this.m_geoStyle.dispose();
        }
    }

    @Override
    void clearHandle() {
        if (this.m_geoStyle != null) {
            InternalGeoStyle.clearHandle(this.m_geoStyle);
            this.m_geoStyle = null;
        }
        this.m_layer = null;
        this.m_layers = null;
    }
}

