/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.LabelMatrixImageCell;
import com.supermap.mapping.LabelMatrixNative;
import com.supermap.mapping.LabelMatrixSymbolCell;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeLabel;

public class LabelMatrix
extends InternalHandleDisposable {
    private Object[][] m_cells;
    ThemeLabel m_themeLabel;

    public LabelMatrix() {
        this.setHandle(LabelMatrixNative.jni_New(), true);
    }

    public LabelMatrix(int columnCount, int rowCount) {
        if (columnCount < 1 || rowCount < 1) {
            String string = InternalResource.loadString("LabelMatrix(int columnCount, int rowCount)", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.setHandle(LabelMatrixNative.jni_New(), true);
        this.setSize(columnCount, rowCount);
    }

    public LabelMatrix(LabelMatrix labelMatrix) {
        if (labelMatrix.getHandle() == 0L) {
            String string = InternalResource.loadString("LabelMatrix(LabelMatrix labelMatrix)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LabelMatrixNative.jni_Clone(labelMatrix.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)labelMatrix));
    }

    LabelMatrix(long handle, ThemeLabel themeLabel) {
        this.setHandle(handle, false);
        this.m_themeLabel = themeLabel;
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        this.m_cells = new Object[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                long l = LabelMatrixNative.jni_GetLabel(handle, i, j);
                if (l == 0L) {
                    this.m_cells[i][j] = null;
                    continue;
                }
                int n3 = LabelMatrixNative.jni_GetThemeLabelType(handle, i, j);
                if (n3 == 0 || n3 == 3) {
                    this.m_cells[i][j] = (ThemeLabel)Theme.createInstance(l, null);
                    ((ThemeLabel)((Object)this.m_cells[i][j])).setParent(this.m_themeLabel);
                    continue;
                }
                if (n3 == 2) {
                    this.m_cells[i][j] = new LabelMatrixImageCell(l, this.m_themeLabel);
                    continue;
                }
                if (n3 != 1) continue;
                this.m_cells[i][j] = new LabelMatrixSymbolCell(l, this.m_themeLabel);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeLabel));
    }

    public void setSize(int columnCount, int rowCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSize(int columnCount, int rowCount)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (columnCount < 1 || rowCount < 1) {
            String string = InternalResource.loadString("setSize(int columnCount, int rowCount)", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_cells = new Object[columnCount][rowCount];
        LabelMatrixNative.jni_SetSize(this.getHandle(), columnCount, rowCount);
    }

    public int getColumnCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColumnCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LabelMatrixNative.jni_GetColumnCount(this.getHandle());
    }

    public int getRowCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRowCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LabelMatrixNative.jni_GetRowCount(this.getHandle());
    }

    public Object get(int column, int row) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int column, int row)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || row < 0) {
            String string = InternalResource.loadString("get(int column, int row)", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (column > this.getColumnCount() || row > this.getRowCount()) {
            String string = InternalResource.loadString("get(int column, int row)", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_cells[column][row];
    }

    public void set(int column, int row, Object value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (column < 0 || row < 0) {
            String string = InternalResource.loadString("set(int column, int row, Object value)", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.m_cells[column][row] != null) {
                long l;
                com.supermap.data.InternalHandleDisposable internalHandleDisposable;
                if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                    internalHandleDisposable = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                    l = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                    if (l == 0L) {
                        String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                        throw new IllegalStateException(string);
                    }
                    internalHandleDisposable.clearHandle();
                }
                if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                    internalHandleDisposable = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                    l = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                    if (l == 0L) {
                        String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                        throw new IllegalStateException(string);
                    }
                    internalHandleDisposable.clearHandle();
                }
                if (this.m_cells[column][row] instanceof ThemeLabel) {
                    internalHandleDisposable = (ThemeLabel)((Object)this.m_cells[column][row]);
                    l = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                    if (l == 0L) {
                        String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                        throw new IllegalStateException(string);
                    }
                    internalHandleDisposable.clearHandle();
                }
            }
            LabelMatrixNative.jni_SetLabelNull(this.getHandle(), column, row);
            this.m_cells[column][row] = null;
        } else if (this.m_themeLabel == null) {
            long l;
            long l2;
            long l3;
            com.supermap.data.InternalHandleDisposable internalHandleDisposable;
            if (value instanceof LabelMatrixImageCell) {
                internalHandleDisposable = (LabelMatrixImageCell)((Object)value);
                l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                if (l3 == 0L) {
                    String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalStateException(string);
                }
                if (this.m_cells[column][row] != null) {
                    com.supermap.data.InternalHandleDisposable internalHandleDisposable2;
                    if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                        internalHandleDisposable2 = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable2);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        internalHandleDisposable2.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                        internalHandleDisposable2 = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable2);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        internalHandleDisposable2.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof ThemeLabel) {
                        internalHandleDisposable2 = (ThemeLabel)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable2);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        internalHandleDisposable2.clearHandle();
                    }
                    this.m_cells[column][row] = null;
                }
                l = LabelMatrixNative.jni_SetLabelMatrixImageCell(this.getHandle(), column, row, l3);
                this.m_cells[column][row] = LabelMatrixImageCell.createInstance(l);
            }
            if (value instanceof LabelMatrixSymbolCell) {
                internalHandleDisposable = (LabelMatrixSymbolCell)((Object)value);
                l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                if (l3 == 0L) {
                    String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalStateException(string);
                }
                if (this.m_cells[column][row] != null) {
                    if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                        LabelMatrixImageCell labelMatrixImageCell = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixImageCell);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixImageCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                        LabelMatrixSymbolCell labelMatrixSymbolCell = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixSymbolCell);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixSymbolCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof ThemeLabel) {
                        ThemeLabel themeLabel = (ThemeLabel)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        themeLabel.clearHandle();
                    }
                    this.m_cells[column][row] = null;
                }
                l = LabelMatrixNative.jni_SetLabelMatrixSymbolCell(this.getHandle(), column, row, l3);
                this.m_cells[column][row] = LabelMatrixSymbolCell.createInstance(l);
            }
            if (value instanceof ThemeLabel) {
                internalHandleDisposable = (ThemeLabel)((Object)value);
                l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                if (l3 == 0L) {
                    String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalStateException(string);
                }
                if (this.m_cells[column][row] != null) {
                    if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                        LabelMatrixImageCell labelMatrixImageCell = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixImageCell);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixImageCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                        LabelMatrixSymbolCell labelMatrixSymbolCell = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixSymbolCell);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixSymbolCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof ThemeLabel) {
                        ThemeLabel themeLabel = (ThemeLabel)((Object)this.m_cells[column][row]);
                        l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel);
                        if (l2 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        themeLabel.clearHandle();
                    }
                    this.m_cells[column][row] = null;
                }
                long l4 = LabelMatrixNative.jni_SetThemeLabel(this.getHandle(), column, row, l3);
                this.m_cells[column][row] = (ThemeLabel)ThemeLabel.createInstance(l4, null);
            }
        } else {
            long l;
            long l5;
            long l6;
            com.supermap.data.InternalHandleDisposable internalHandleDisposable;
            if (value instanceof LabelMatrixImageCell) {
                internalHandleDisposable = (LabelMatrixImageCell)((Object)value);
                l6 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                if (l6 == 0L) {
                    String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalStateException(string);
                }
                if (this.m_cells[column][row] != null) {
                    com.supermap.data.InternalHandleDisposable internalHandleDisposable3;
                    if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                        internalHandleDisposable3 = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable3);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        internalHandleDisposable3.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                        internalHandleDisposable3 = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable3);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        internalHandleDisposable3.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof ThemeLabel) {
                        internalHandleDisposable3 = (ThemeLabel)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable3);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        internalHandleDisposable3.clearHandle();
                    }
                    this.m_cells[column][row] = null;
                }
                l = LabelMatrixNative.jni_SetLabelMatrixImageCell(this.getHandle(), column, row, l6);
                this.m_cells[column][row] = new LabelMatrixImageCell(l, this.m_themeLabel);
            }
            if (value instanceof LabelMatrixSymbolCell) {
                internalHandleDisposable = (LabelMatrixSymbolCell)((Object)value);
                l6 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                if (l6 == 0L) {
                    String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalStateException(string);
                }
                if (this.m_cells[column][row] != null) {
                    if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                        LabelMatrixImageCell labelMatrixImageCell = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixImageCell);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixImageCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                        LabelMatrixSymbolCell labelMatrixSymbolCell = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixSymbolCell);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixSymbolCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof ThemeLabel) {
                        ThemeLabel themeLabel = (ThemeLabel)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        themeLabel.clearHandle();
                    }
                    this.m_cells[column][row] = null;
                }
                l = LabelMatrixNative.jni_SetLabelMatrixSymbolCell(this.getHandle(), column, row, l6);
                this.m_cells[column][row] = new LabelMatrixSymbolCell(l, this.m_themeLabel);
            }
            if (value instanceof ThemeLabel) {
                internalHandleDisposable = (ThemeLabel)((Object)value);
                l6 = InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
                if (l6 == 0L) {
                    String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalStateException(string);
                }
                if (this.m_cells[column][row] != null) {
                    if (this.m_cells[column][row] instanceof LabelMatrixImageCell) {
                        LabelMatrixImageCell labelMatrixImageCell = (LabelMatrixImageCell)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixImageCell);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixImageCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof LabelMatrixSymbolCell) {
                        LabelMatrixSymbolCell labelMatrixSymbolCell = (LabelMatrixSymbolCell)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrixSymbolCell);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        labelMatrixSymbolCell.clearHandle();
                    }
                    if (this.m_cells[column][row] instanceof ThemeLabel) {
                        ThemeLabel themeLabel = (ThemeLabel)((Object)this.m_cells[column][row]);
                        l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel);
                        if (l5 == 0L) {
                            String string = InternalResource.loadString("set(int column, int row, Object value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                            throw new IllegalStateException(string);
                        }
                        themeLabel.clearHandle();
                    }
                    this.m_cells[column][row] = null;
                }
                long l7 = LabelMatrixNative.jni_SetThemeLabel(this.getHandle(), column, row, l6);
                this.m_cells[column][row] = (ThemeLabel)ThemeLabel.createInstance(l7, null);
                ((ThemeLabel)((Object)this.m_cells[column][row])).setParent(this.m_themeLabel);
            }
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this.m_themeLabel = null;
        if (this.m_cells != null) {
            for (int i = 0; i < this.m_cells.length; ++i) {
                for (int j = 0; j < this.m_cells[i].length; ++j) {
                    if (this.m_cells[i][j] == null) continue;
                    if (this.m_cells[i][j] instanceof LabelMatrixImageCell) {
                        ((LabelMatrixImageCell)((Object)this.m_cells[i][j])).clearHandle();
                    }
                    if (this.m_cells[i][j] instanceof LabelMatrixSymbolCell) {
                        ((LabelMatrixSymbolCell)((Object)this.m_cells[i][j])).clearHandle();
                    }
                    if (!(this.m_cells[i][j] instanceof ThemeLabel)) continue;
                    ((ThemeLabel)((Object)this.m_cells[i][j])).clearHandle();
                }
            }
        }
        this.m_cells = null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            LabelMatrixNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    ThemeLabel getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColumnCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_themeLabel;
    }

    void changeHandle(long handle) {
        long l = this.getHandle();
        if (l != 0L) {
            LabelMatrixNative.jni_Delete(l);
        }
        this.setHandle(handle, false);
    }

    void refreshPartsList(long handle, ThemeLabel themeLabel) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
        this.m_themeLabel = themeLabel;
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        this.m_cells = new Object[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                long l = LabelMatrixNative.jni_GetLabel(handle, i, j);
                if (l == 0L) {
                    this.m_cells[i][j] = null;
                    continue;
                }
                int n3 = LabelMatrixNative.jni_GetThemeLabelType(handle, i, j);
                if (n3 == 0 || n3 == 3) {
                    this.m_cells[i][j] = (ThemeLabel)Theme.createInstance(l, null);
                    ((ThemeLabel)((Object)this.m_cells[i][j])).setParent(this.m_themeLabel);
                    continue;
                }
                if (n3 == 2) {
                    this.m_cells[i][j] = new LabelMatrixImageCell(l, this.m_themeLabel);
                    continue;
                }
                if (n3 != 1) continue;
                this.m_cells[i][j] = new LabelMatrixSymbolCell(l, this.m_themeLabel);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeLabel));
    }
}

