/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.license;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.jsuperpy.license.LoginResult;
import java.util.ArrayList;

final class IObjectsLicense {
    private static License m_license = new License();
    private static LoginResult m_licenseResult = LoginResult.NoLicense();
    private static ProductType[] g_iServerProducts = new ProductType[]{ProductType.ISERVER_MACHINE_LEARNING, ProductType.ISERVER_MACHINE_LEARNING_16CORES, ProductType.ISERVER_MACHINE_LEARNING_32CORES, ProductType.ISERVER_MACHINE_LEARNING_ADDITIONAL_2CORES};
    private static ProductType[] g_iDesktopProducts = new ProductType[]{ProductType.IDESKTOPJAVA_ENTERPRISE, ProductType.IDESKTOPJAVA_MACHINELEANING, ProductType.IDESKTOPJAVA_VIDEOMAP, ProductType.IDESKTOPJAVA_ADVANCE};
    private static ProductType[] g_bdtProducts = new ProductType[]{ProductType.IOBJECTS_SPARK_DEVELOP, ProductType.IOBJECTS_SPARK_RUNTIME};

    private IObjectsLicense() {
    }

    public static LoginResult checkCoreLicense() {
        if (m_licenseResult == LoginResult.OK()) {
            return m_licenseResult;
        }
        for (ProductType d : g_iServerProducts) {
            if (m_license.connect(d) != 0) continue;
            m_licenseResult = LoginResult.OK();
            return m_licenseResult;
        }
        for (ProductType d : g_iDesktopProducts) {
            if (m_license.connect(d) != 0) continue;
            m_licenseResult = LoginResult.OK();
            return m_licenseResult;
        }
        for (ProductType d : g_bdtProducts) {
            if (m_license.connect(d) != 0) continue;
            m_licenseResult = LoginResult.OK();
            return m_licenseResult;
        }
        m_licenseResult = IObjectsLicense.checkPythonObjectsLicense();
        return m_licenseResult;
    }

    private static LoginResult checkPythonObjectsLicense() {
        if (m_license.connect(ProductType.IOBJECTS_PYTHON_DEVELOP) != 0 && m_license.connect(ProductType.IOBJECTS_PYTHON_RUNTIME) != 0) {
            ArrayList trialLicenses = License.getTrialLicenses();
            int code = 0;
            for (ProductType d : trialLicenses) {
                code = m_license.connect(d);
                if (code != 0) continue;
                return LoginResult.OK();
            }
            return new LoginResult(code, License.getErrorMessage((int)code));
        }
        return LoginResult.OK();
    }
}

