/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

class HeartBeatClient
implements Runnable {
    private String m_address;
    private int m_port;
    public boolean m_isExit;

    public HeartBeatClient(String address, int port) {
        this.m_address = address;
        this.m_port = port;
        this.m_isExit = false;
    }

    @Override
    public void run() {
        try {
            Socket socket = new Socket(this.m_address, this.m_port);
            socket.setKeepAlive(true);
            int times = 1;
            int maxTimes = 3;
            DataInputStream input = new DataInputStream(socket.getInputStream());
            DataOutputStream output = new DataOutputStream(socket.getOutputStream());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (!this.m_isExit) {
                boolean is_get_from_server = false;
                try {
                    input.readUTF();
                    output.writeUTF("java client rep");
                    input.readUTF();
                    is_get_from_server = true;
                }
                catch (Exception e) {
                    Date now = new Date();
                    String strNow = df.format(now);
                    System.out.println("[SuperMap]: No data sent by the server is received, " + times + " times, " + strNow);
                }
                if (!is_get_from_server) {
                    Thread.sleep(1000L);
                    if (++times <= maxTimes) continue;
                    this.m_isExit = true;
                    continue;
                }
                times = 1;
            }
            input.close();
            output.close();
            socket.close();
            if (this.m_isExit) {
                System.out.println("No data sent by the server is received" + maxTimes + " times, exit java thread");
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

