/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetVector;
import com.supermap.jsuperpy.TileRef;
import com.supermap.jsuperpy.serializer.impl.TileSerializer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;

public final class DatasetUtils {
    public static boolean updateFields(DatasetVector dataset, int field, Object value, String attrFilter) {
        return dataset.updateField(field, value, attrFilter);
    }

    public static boolean updateFields(DatasetVector dataset, String field, Object value, String attrFilter) {
        return dataset.updateField(field, value, attrFilter);
    }

    public static boolean updateFieldsEx(DatasetVector dataset, int field, String value, String attrFilter) {
        return dataset.updateField(field, value, attrFilter);
    }

    public static boolean updateFieldsEx(DatasetVector dataset, String field, String value, String attrFilter) {
        return dataset.updateField(field, value, attrFilter);
    }

    public static void ReadDatasetToPb(Dataset dataset, boolean isOriginLeftUp, Double noValue, String server, int port) throws Exception {
        int width;
        int height;
        if (dataset instanceof DatasetImage) {
            height = ((DatasetImage)dataset).getHeight();
            width = ((DatasetImage)dataset).getWidth();
        } else if (dataset instanceof DatasetGrid) {
            height = ((DatasetGrid)dataset).getHeight();
            width = ((DatasetGrid)dataset).getWidth();
        } else {
            throw new IllegalArgumentException("unsupported dataset type " + dataset.getType().name());
        }
        Socket clientSocket = new Socket(server, port);
        DataOutputStream dos = new DataOutputStream(clientSocket.getOutputStream());
        DataInputStream ins = new DataInputStream(clientSocket.getInputStream());
        TileSerializer serializer = new TileSerializer();
        for (int j = 0; j < height; ++j) {
            int nRow = j;
            if (!isOriginLeftUp) {
                nRow = height - j - 1;
            }
            TileRef tileRef = new TileRef(dataset, 0, width - 1, nRow, nRow, width, 1);
            byte[] bytes = serializer.encode((Object)tileRef.getData(noValue));
            dos.writeInt(bytes.length);
            dos.flush();
            dos.write(bytes);
            dos.flush();
        }
        dos.writeInt(0);
        ins.readInt();
        clientSocket.close();
    }

    private static double[] readStream(byte[] values) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(values);
            DataInputStream dataStream = new DataInputStream(stream);
            int count = dataStream.readInt();
            double[] results = new double[count];
            for (int i = 0; i < count; ++i) {
                results[i] = dataStream.readDouble();
            }
            dataStream.close();
            stream.close();
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean SetRows(DatasetImage dataset, int rowIndex, byte[] rowData, int bandIndex) {
        int width = dataset.getWidth();
        double[] tokens = DatasetUtils.readStream(rowData);
        if (tokens.length != width) {
            System.err.println("count of values is not equal width");
            return false;
        }
        int i = 0;
        for (double value : tokens) {
            dataset.setValue(i, rowIndex, value, bandIndex);
            ++i;
        }
        return true;
    }

    public static boolean SetRows(DatasetGrid dataset, int rowIndex, byte[] rowData) {
        int width = dataset.getWidth();
        double[] tokens = DatasetUtils.readStream(rowData);
        if (tokens.length != width) {
            System.err.println("count of values is not equal width");
            return false;
        }
        int i = 0;
        for (double value : tokens) {
            dataset.setValue(i, rowIndex, value);
            ++i;
        }
        return true;
    }
}

