/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class LayeredFunctionScaleAParameter
extends SamplingFunctionParameter {
    private double m_dTotalCost = 0.0;
    private double m_dInitalCost = 0.0;
    private String m_strLayeredCostFieldName;
    private String m_strLayeredVarianceFieldName;

    private LayeredFunctionScaleAParameter() {
    }

    public LayeredFunctionScaleAParameter(double dTotalCost, double dInitalCost, String strLayeredVarianceFieldName, String strLayeredCostFieldName) {
        this.m_FunctionType = SamplingFunctionType.LAYEREDFUNCTIONSCALEA;
        this.setTotalCost(dTotalCost);
        this.setInitalCost(dInitalCost);
        this.setLayeredCostFieldName(strLayeredCostFieldName);
        this.setLayeredVarianceFieldName(strLayeredVarianceFieldName);
    }

    public double getTotalCost() {
        return this.m_dTotalCost;
    }

    public void setTotalCost(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("TotalCost", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dTotalCost = value;
    }

    public double getInitalCost() {
        return this.m_dInitalCost;
    }

    public void setInitalCost(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("InitalCost", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dInitalCost = value;
    }

    public String getLayeredCostFieldName() {
        return this.m_strLayeredCostFieldName;
    }

    public void setLayeredCostFieldName(String value) {
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("LayeredCostFieldName", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strLayeredCostFieldName = value;
    }

    public String getLayeredVarianceFieldName() {
        return this.m_strLayeredVarianceFieldName;
    }

    public void setLayeredVarianceFieldName(String value) {
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("LayeredVarianceFieldName", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strLayeredVarianceFieldName = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setTotalCost(handle, this.m_dTotalCost);
        SamplingParameterNative.jni_setInitalCost(handle, this.m_dInitalCost);
        SamplingParameterNative.jni_setLayeredCostFieldName(handle, this.m_strLayeredCostFieldName);
        SamplingParameterNative.jni_setLayeredVarianceFieldName(handle, this.m_strLayeredVarianceFieldName);
    }
}

