/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalGeometry;
import com.supermap.analyst.trafficanalyst.InternalHandleDisposable;
import com.supermap.analyst.trafficanalyst.TransferGuideItemNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Point2D;
import java.util.Calendar;
import java.util.Date;

public class TransferGuideItem {
    private double m_weight = 0.0;
    private double m_distance = 0.0;
    private double m_fare = 0.0;
    private double m_time = 0.0;
    private GeoLine m_geoLine = null;
    private Point2D m_startPoint2D = null;
    private Point2D m_endPoint2D = null;
    private int m_startIndex;
    private int m_endIndex;
    private int m_LineType;
    private boolean m_isWalk;
    private int m_passCount;
    private String m_lineName = "";
    private String m_startName = "";
    private String m_endName = "";
    private String m_lineNameEx = "";
    private String m_startNameEx = "";
    private String m_endNameEx = "";
    private Date m_firstTime = null;
    private Date m_lastTime = null;

    TransferGuideItem(long routeHandle) {
        this.getFromUGC(routeHandle);
    }

    public String getLineName() {
        return this.m_lineName;
    }

    public String getStartName() {
        return this.m_startName;
    }

    public String getEndName() {
        return this.m_endName;
    }

    public int getStartIndex() {
        return this.m_startIndex;
    }

    public int getEndIndex() {
        return this.m_endIndex;
    }

    public int getPassStopCount() {
        return this.m_passCount;
    }

    public Point2D getStartPosition() {
        return this.m_startPoint2D;
    }

    public Point2D getEndPosition() {
        return this.m_endPoint2D;
    }

    public double getDistance() {
        return this.m_distance;
    }

    public double getFare() {
        return this.m_fare;
    }

    public double getTime() {
        return this.m_time;
    }

    public boolean isWalking() {
        return this.m_isWalk;
    }

    public GeoLine getRoute() {
        return this.m_geoLine;
    }

    public int getLineType() {
        return this.m_LineType;
    }

    public Date getFirstTime() {
        return this.m_firstTime;
    }

    public Date getLastTime() {
        return this.m_lastTime;
    }

    private void getFromUGC(long routeHandle) {
        Calendar calendar;
        Object object;
        Object object2;
        long l = TransferGuideItemNative.jni_GetRoute(routeHandle);
        if (l != 0L) {
            object2 = (GeoLine)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)object2, false);
            if (object2.getPartCount() > 0) {
                object = object2.getPart(0);
                this.m_geoLine = new GeoLine(object);
            }
        }
        this.m_isWalk = TransferGuideItemNative.jni_IsWalking(routeHandle);
        object2 = new double[2];
        TransferGuideItemNative.jni_GetStartPosition(routeHandle, (double[])object2);
        this.m_startPoint2D = new Point2D((double)object2[0], (double)object2[1]);
        TransferGuideItemNative.jni_GetEndPosition(routeHandle, (double[])object2);
        this.m_endPoint2D = new Point2D((double)object2[0], (double)object2[1]);
        this.m_startIndex = TransferGuideItemNative.jni_GetStartIndex(routeHandle);
        this.m_endIndex = TransferGuideItemNative.jni_GetEndIndex(routeHandle);
        this.m_passCount = TransferGuideItemNative.jni_GetPassStopCount(routeHandle);
        this.m_lineName = TransferGuideItemNative.jni_GetLineName(routeHandle);
        this.m_startName = TransferGuideItemNative.jni_GetStartName(routeHandle);
        this.m_endName = TransferGuideItemNative.jni_GetEndName(routeHandle);
        this.m_lineNameEx = TransferGuideItemNative.jni_GetLineNameEx(routeHandle);
        this.m_startNameEx = TransferGuideItemNative.jni_GetStartNameEx(routeHandle);
        this.m_endNameEx = TransferGuideItemNative.jni_GetEndNameEx(routeHandle);
        this.m_time = TransferGuideItemNative.jni_GetTime(routeHandle);
        this.m_fare = TransferGuideItemNative.jni_GetFare(routeHandle);
        this.m_distance = TransferGuideItemNative.jni_GetDistance(routeHandle);
        this.m_LineType = TransferGuideItemNative.jni_GetLineType(routeHandle);
        object = TransferGuideItemNative.jni_GetFirstTime(routeHandle);
        if (object != null) {
            calendar = Calendar.getInstance();
            calendar.set(2000, 0, 1, (int)object[0], (int)object[1], 0);
            this.m_firstTime = calendar.getTime();
        }
        if ((object = (Object)TransferGuideItemNative.jni_GetLastTime(routeHandle)) != null) {
            calendar = Calendar.getInstance();
            calendar.set(2000, 0, 1, (int)object[0], (int)object[1], 0);
            this.m_lastTime = calendar.getTime();
        }
    }

    public String getLineAliasName() {
        return this.m_lineNameEx;
    }

    public String getStartAliasName() {
        return this.m_startNameEx;
    }

    public String getEndAliasName() {
        return this.m_endNameEx;
    }
}

