/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalHandle;
import com.supermap.analyst.trafficanalyst.TransferAnalystParameterNative;
import com.supermap.analyst.trafficanalyst.TransferPreference;
import com.supermap.analyst.trafficanalyst.TransferSearchMode;
import com.supermap.analyst.trafficanalyst.TransferTactic;
import com.supermap.data.DatasetVector;
import com.supermap.data.Point2D;
import java.util.Calendar;
import java.util.Date;

public class TransferAnalystParameter {
    private TransferSearchMode m_searchMode;
    private TransferPreference m_preference;
    private TransferTactic m_tactic;
    private int m_transferResultCount;
    private long m_startStopID;
    private long m_endStopID;
    private Point2D m_startPosition;
    private Point2D m_endPosition;
    private double m_walkingRatio;
    private long[] m_evadeStopIDs;
    private long[] m_evadeLineIDs;
    private long[] m_priorStopIDs;
    private long[] m_priorLineIDs;
    private Date m_time;
    private DatasetVector m_startStopDataset;
    private DatasetVector m_endStopDataset;
    private String m_weightName;

    public TransferAnalystParameter() {
        this.m_searchMode = TransferSearchMode.ID;
        this.m_startStopID = -1L;
        this.m_startStopDataset = null;
        this.m_endStopID = -1L;
        this.m_endStopDataset = null;
        this.m_startPosition = Point2D.getEMPTY();
        this.m_endPosition = Point2D.getEMPTY();
        this.m_weightName = "";
        this.m_transferResultCount = 5;
        this.m_walkingRatio = 10.0;
        this.m_tactic = TransferTactic.LESS_TRANSFER;
        this.m_preference = TransferPreference.NONE;
        this.m_time = null;
    }

    public TransferAnalystParameter(TransferAnalystParameter transferAnalystParameter) {
        this.setSearchMode(transferAnalystParameter.getSearchMode());
        this.setPreference(transferAnalystParameter.getPreference());
        this.m_startStopDataset = null;
        this.m_endStopDataset = null;
        this.setStartStopID(transferAnalystParameter.getStartStopID());
        this.setEndStopID(transferAnalystParameter.getEndStopID());
        this.m_startPosition = new Point2D(transferAnalystParameter.getStartPosition());
        this.m_endPosition = new Point2D(transferAnalystParameter.getEndPosition());
        this.setSolutionCount(transferAnalystParameter.getSolutionCount());
        this.setWalkingRatio(transferAnalystParameter.getWalkingRatio());
        this.setEvadeLines(transferAnalystParameter.getEvadeLines());
        this.setEvadeStops(transferAnalystParameter.getEvadeStops());
        this.setPriorLines(transferAnalystParameter.getPriorLines());
        this.setPriorStops(transferAnalystParameter.getPriorStops());
        this.setTravelTime(transferAnalystParameter.getTravelTime());
        this.setTactic(transferAnalystParameter.getTactic());
    }

    public long getStartStopID() {
        return this.m_startStopID;
    }

    public void setStartStopID(long value) {
        this.m_startStopID = value;
    }

    public long getEndStopID() {
        return this.m_endStopID;
    }

    public void setEndStopID(long value) {
        this.m_endStopID = value;
    }

    public Point2D getStartPosition() {
        return this.m_startPosition;
    }

    public void setStartPosition(Point2D value) {
        this.m_startPosition = value;
    }

    public Point2D getEndPosition() {
        return this.m_endPosition;
    }

    public void setEndPosition(Point2D value) {
        this.m_endPosition = value;
    }

    public int getSolutionCount() {
        return this.m_transferResultCount;
    }

    public void setSolutionCount(int value) {
        this.m_transferResultCount = value;
    }

    public double getWalkingRatio() {
        return this.m_walkingRatio;
    }

    public void setWalkingRatio(double value) {
        this.m_walkingRatio = value;
    }

    public TransferSearchMode getSearchMode() {
        return this.m_searchMode;
    }

    public void setSearchMode(TransferSearchMode value) {
        this.m_searchMode = value;
    }

    public TransferTactic getTactic() {
        return this.m_tactic;
    }

    public void setPreference(TransferPreference value) {
        this.m_preference = value;
    }

    public TransferPreference getPreference() {
        return this.m_preference;
    }

    public void setTactic(TransferTactic value) {
        this.m_tactic = value;
    }

    public long[] getEvadeStops() {
        if (this.m_evadeStopIDs != null) {
            return (long[])this.m_evadeStopIDs.clone();
        }
        return null;
    }

    public void setEvadeStops(long[] value) {
        if (value == null) {
            this.m_evadeStopIDs = null;
        } else {
            int n = value.length;
            this.m_evadeStopIDs = new long[n];
            for (int i = 0; i < n; ++i) {
                this.m_evadeStopIDs[i] = value[i];
            }
        }
    }

    public long[] getEvadeLines() {
        if (this.m_evadeLineIDs != null) {
            return (long[])this.m_evadeLineIDs.clone();
        }
        return null;
    }

    public void setEvadeLines(long[] value) {
        if (value == null) {
            this.m_evadeLineIDs = null;
        } else {
            int n = value.length;
            this.m_evadeLineIDs = new long[n];
            for (int i = 0; i < n; ++i) {
                this.m_evadeLineIDs[i] = value[i];
            }
        }
    }

    public long[] getPriorStops() {
        if (this.m_priorStopIDs != null) {
            return (long[])this.m_priorStopIDs.clone();
        }
        return null;
    }

    public void setPriorStops(long[] value) {
        if (value == null) {
            this.m_priorStopIDs = null;
        } else {
            int n = value.length;
            this.m_priorStopIDs = new long[n];
            for (int i = 0; i < n; ++i) {
                this.m_priorStopIDs[i] = value[i];
            }
        }
    }

    public long[] getPriorLines() {
        if (this.m_priorLineIDs != null) {
            return (long[])this.m_priorLineIDs.clone();
        }
        return null;
    }

    public void setPriorLines(long[] value) {
        if (value == null) {
            this.m_priorLineIDs = null;
        } else {
            int n = value.length;
            this.m_priorLineIDs = new long[n];
            for (int i = 0; i < n; ++i) {
                this.m_priorLineIDs[i] = value[i];
            }
        }
    }

    public Date getTravelTime() {
        return this.m_time;
    }

    public void setTravelTime(Date time) {
        this.m_time = time;
    }

    long setToUGC() {
        long l = 0L;
        if (this.m_startStopDataset != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_startStopDataset);
        }
        long l2 = 0L;
        if (this.m_endStopDataset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_startStopDataset);
        }
        int n = -1;
        int n2 = -1;
        if (this.m_time != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.m_time);
            n = calendar.get(11);
            n2 = calendar.get(12);
        }
        long l3 = 0L;
        l3 = this.m_searchMode == TransferSearchMode.ID ? TransferAnalystParameterNative.jni_New1(this.m_startStopID, l, this.m_endStopID, l2, this.m_weightName, this.m_transferResultCount, this.m_walkingRatio, this.m_tactic.value(), this.m_searchMode.value(), this.m_preference.value(), this.m_evadeStopIDs, this.m_evadeLineIDs, this.m_priorStopIDs, this.m_priorLineIDs, n, n2) : TransferAnalystParameterNative.jni_New2(l, l2, this.m_startPosition.getX(), this.m_startPosition.getY(), this.m_endPosition.getX(), this.m_endPosition.getY(), this.m_weightName, this.m_transferResultCount, this.m_walkingRatio, this.m_tactic.value(), this.m_searchMode.value(), this.m_preference.value(), this.m_evadeStopIDs, this.m_evadeLineIDs, this.m_priorStopIDs, this.m_priorLineIDs, n, n2);
        return l3;
    }
}

