/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.ProcessFileType;
import com.supermap.data.processing.TextureMappingMode;
import com.supermap.data.processing.TileDataInfos;
import com.supermap.data.processing.VectorExtrudeCacheBuilderNative;
import com.supermap.realspace.CacheFileType;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class VectorExtrudeCacheBuilder
extends InternalHandleDisposable {
    private DatasetVector m_dataset;
    private Dataset m_datasetRaster;
    private long m_selfEventHandle;
    private Vector m_steppedListeners;
    private Dataset attributeDataset = null;
    private static String m_senderMethodName;

    public VectorExtrudeCacheBuilder() {
        long l = VectorExtrudeCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = VectorExtrudeCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public VectorExtrudeCacheBuilder(DatasetVector dataset, String outputFolder, String name) {
        long l = 0L;
        if (dataset != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset)) == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(outputFolder);
        if (!file.exists()) {
            String string = InternalResource.loadString("outputFolder", "CacheBuilderSCI3D_OutputFolderNotExists", "processing_resources") + " " + outputFolder;
            throw new IllegalStateException(string);
        }
        if (name == null || name.length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = VectorExtrudeCacheBuilderNative.jni_New1(l, outputFolder, name);
        this.setHandle(l2, true);
        this.m_selfEventHandle = VectorExtrudeCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_dataset = dataset;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = VectorExtrudeCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
        this.getHandle();
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            VectorExtrudeCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.clearSelfEventHandle();
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            VectorExtrudeCacheBuilderNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    static void steppedCallBack(VectorExtrudeCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetNumThreads(this.getHandle());
    }

    public void setProcessThreadsCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessThreadsCount(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetNumThreads(this.getHandle(), value);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("setCacheName()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetCacheName(this.getHandle(), value);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), value);
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetTileWidth(this.getHandle());
    }

    public void setTileWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetTileWidth(this.getHandle(), value);
    }

    public void setFileType(CacheFileType fileType) {
        if (fileType == null) {
            String string = InternalResource.loadString("OSGBCacheFileType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (fileType == CacheFileType.OSGB) {
            n = 505;
        } else if (fileType == CacheFileType.S3M) {
            n = 511;
        } else if (fileType == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetFileType(this.getHandle(), n);
    }

    public CacheFileType getFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorExtrudeCacheBuilderNative.jni_GetFileType(this.getHandle());
        switch (n) {
            case 505: {
                n = 0;
                break;
            }
            case 511: {
                n = 1;
                break;
            }
            case 515: {
                n = 2;
                break;
            }
            default: {
                String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        return (CacheFileType)InternalEnum.parseUGCValue(CacheFileType.class, n);
    }

    public void setObjectFiltrateThreshold(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setObjectFiltrateThreshold(double value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetObjectFiltrateValue(this.getHandle(), value);
    }

    public double getObjectFiltrateThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getObjectFiltrateThreshold", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetObjectFiltrateValue(this.getHandle());
    }

    public DatasetVector getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    public void setDataset(DatasetVector value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset(DatasetVector value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (value != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value)) == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_dataset = value;
        VectorExtrudeCacheBuilderNative.jni_setDataset(this.getHandle(), l);
    }

    public DatasetVolume getDatasetVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" getDatasetVolume()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetVolume datasetVolume = null;
        if (this.m_datasetRaster != null && this.m_datasetRaster.getType() == DatasetType.VOLUME) {
            datasetVolume = (DatasetVolume)this.m_datasetRaster;
        }
        return datasetVolume;
    }

    @Deprecated
    public void setDatasetVolume(DatasetVolume volume) {
        if (null == volume) {
            String string = InternalResource.loadString("volume", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)volume);
        if (0L == l) {
            String string = InternalResource.loadString("volume", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetDatasetRaster(this.getHandle(), l);
    }

    public double getPixelPerMeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPixelPerMeter()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetPixelPerMeter(this.getHandle());
    }

    public void setPixelPerMeter(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetPixelPerMeter(this.getHandle(), value);
    }

    public double getExtrudeHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtrudeHeight()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetExtrudeHeight(this.getHandle());
    }

    public void setExtrudeHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtrudeHeight(double value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetExtrudeHeight(this.getHandle(), value);
    }

    public String getExtendedHeightField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendedHeightField()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetExtrudeFieldName(this.getHandle());
    }

    public void setExtendedHeightField(String fieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtendedHeightField(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetExtrudeFieldName(this.getHandle(), fieldName);
    }

    public String getBottomAltitudeField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendedHeightField()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetBottomAltitudeFieldName(this.getHandle());
    }

    public void setBottomAltitudeField(String fieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtendedHeightField(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetBottomAltitudeFieldName(this.getHandle(), fieldName);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle);
    }

    public ArrayList<TileDataInfos> getTileInfosArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileInfosArray", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TileDataInfos> arrayList = new ArrayList<TileDataInfos>();
        int[] nArray = new int[1];
        long l = VectorExtrudeCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), nArray);
        if (nArray[0] != 0 && l != 0L) {
            Object[] objectArray = new Object[nArray[0]];
            String[] stringArray = new String[nArray[0]];
            VectorExtrudeCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), l, stringArray, objectArray);
            if (stringArray != null && objectArray != null && objectArray.length == stringArray.length) {
                for (int i = 0; i < stringArray.length; ++i) {
                    double[] dArray = (double[])objectArray[i];
                    Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
                    TileDataInfos tileDataInfos = new TileDataInfos();
                    tileDataInfos.setName(stringArray[i]);
                    tileDataInfos.setBounds(rectangle2D);
                    arrayList.add(tileDataInfos);
                }
            }
        }
        return arrayList;
    }

    public boolean toConfigAndIndexFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toConfigAndIndexFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_ToFile(this.getHandle(), path);
    }

    public void setTileInfos(TileDataInfos value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("VectorExtrudeCacheBuilderNative", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.getName() == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = value.getName().split("_");
        if (stringArray.length != 4) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        VectorExtrudeCacheBuilderNative.jni_SetTileInfos(this.getHandle(), n, n2, n3);
    }

    public String getStoreyHeightField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStoreyHeightField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetStoreyHeightField(this.getHandle());
    }

    public void setStoreyHeightField(String storeyHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStoreyHeightField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetStoreyHeightField(this.getHandle(), storeyHeight);
    }

    public TextureMappingMode getTextureCoordsMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextureCoordsMode", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorExtrudeCacheBuilderNative.jni_GetTextureCoordsMode(this.getHandle());
        return (TextureMappingMode)InternalEnum.parseUGCValue(TextureMappingMode.class, n);
    }

    public void setTextureCoordsMode(TextureMappingMode mapModel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextureCoordsMode", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetTextureCoordsModel(this.getHandle(), mapModel.value());
    }

    public int getLODSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLODSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetLODSize(this.getHandle());
    }

    public void setLODSize(int LODSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLODSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetLODSize(this.getHandle(), LODSize);
    }

    public String getFloorCountField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFloorCountField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetFloorCountField(this.getHandle());
    }

    public void setFloorCountField(String floorCountField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFloorCountField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetFloorCountField(this.getHandle(), floorCountField);
    }

    public String getUserIDField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUserIDField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_GetUserIDField(this.getHandle());
    }

    public void setUserIDField(String userIDField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserIDField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetUserIDField(this.getHandle(), userIDField);
    }

    public Dataset getAttributeDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAttributeDataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.attributeDataset;
    }

    public void setAttributeDataset(Dataset attributeDataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAttributeDataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)attributeDataset);
        VectorExtrudeCacheBuilderNative.jni_SetAttributeDataset(this.getHandle(), l);
        this.attributeDataset = attributeDataset;
    }

    public boolean buildAttribute() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildAttribute", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getAttributeDataset() == null || this.getDataset() == null) {
            String string = InternalResource.loadString("noDataset", "Handle_UndisposableObject", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_BuildOnlyAttribute(this.getHandle());
    }

    public boolean isSimplify() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSimplify", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_IsRegionLods(this.getHandle());
    }

    public void setSimplify(boolean isSimplify) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSimplify", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetRegionLods(this.getHandle(), isSimplify);
    }

    public boolean isHasOutline() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isHasOutline", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorExtrudeCacheBuilderNative.jni_IsCreateEdge(this.getHandle());
    }

    public void setHasOutline(boolean isCreateEdge) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHasOutline", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetCreateEdge(this.getHandle(), isCreateEdge);
    }

    public ProcessFileType getProcessType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorExtrudeCacheBuilderNative.jni_GetProcessType(this.getHandle());
        return (ProcessFileType)InternalEnum.parseUGCValue(ProcessFileType.class, n);
    }

    public void setProcessType(ProcessFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorExtrudeCacheBuilderNative.jni_SetProcessType(this.getHandle(), value.value());
    }
}

