/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVolume;
import com.supermap.data.InternalHandle;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.OSGBVolumeCacheBuilderNative;
import java.io.File;
import java.util.Vector;

public class OSGBVolumeCacheBuilder
extends InternalHandleDisposable {
    private Dataset m_dataset;
    private long m_selfEventHandle;
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;

    public OSGBVolumeCacheBuilder() {
        long l = OSGBVolumeCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = OSGBVolumeCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public OSGBVolumeCacheBuilder(DatasetVolume dataset, String osgbFile) {
        long l = OSGBVolumeCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.m_dataset = dataset;
        this.setOSGBFile(osgbFile);
    }

    private void checkParam() {
        File file = new File(this.getOSGBFile());
        if (!file.exists()) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "CacheBuilder_DirectoryNotFound", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    private void processDataset() {
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "CacheBuilder_InvalidDataset", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)this.m_dataset);
        if (0L == l) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "CacheBuilder_InvalidDataset", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVolumeCacheBuilderNative.jni_SetDataset(this.getHandle(), l);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.processDataset();
        this.checkParam();
        return OSGBVolumeCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
    }

    public DatasetVolume getDatasetVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetVolume datasetVolume = null;
        if (this.m_dataset != null && this.m_dataset.getType() == DatasetType.VOLUME) {
            datasetVolume = (DatasetVolume)this.m_dataset;
        }
        return datasetVolume;
    }

    public void setDatasetVolume(DatasetVolume value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_dataset = value;
    }

    public String getOSGBFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVolumeCacheBuilderNative.jni_GetOSGBFile(this.getHandle());
    }

    public void setOSGBFile(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVolumeCacheBuilderNative.jni_SetOSGBFile(this.getHandle(), value);
    }

    public String getVolName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVolumeCacheBuilderNative.jni_GetVolName(this.getHandle());
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(OSGBVolumeCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "OSGBVolumeCacheBuilder";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public void setVolName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVolumeCacheBuilderNative.jni_SetVolName(this.getHandle(), value);
    }

    public boolean buildWithTextureRemapping() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVolumeCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.processDataset();
        this.checkParam();
        return OSGBVolumeCacheBuilderNative.jni_BuildWithTextureRemapping(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.m_dataset = null;
            OSGBVolumeCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean isLODBuild() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLODBuild", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVolumeCacheBuilderNative.jni_IsLODBuild(this.getHandle());
    }

    public void setLODBuild(boolean isLODBuild) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLODBuild", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVolumeCacheBuilderNative.jni_SetLODBuild(this.getHandle(), isLODBuild);
    }
}

