/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.CompressedTextureType;
import com.supermap.data.DatasetVector;
import com.supermap.data.EncodeType;
import com.supermap.data.Environment;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.ConfigType;
import com.supermap.data.processing.DatasetSetting;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoStyle3D;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalProcessingEnum;
import com.supermap.data.processing.InternalProcessingToolkit;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.OSGBVectorCacheBuilderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.TileInfos;
import com.supermap.data.processing.Tiles;
import com.supermap.data.processing.VectorCacheTileType;
import com.supermap.realspace.CacheFileType;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Scene;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class OSGBVectorCacheBuilder
extends InternalHandleDisposable {
    private Recordset m_recordset;
    private DatasetVector m_dataset;
    private long m_selfEventHandle;
    private Vector m_steppedListeners;
    private String m_password;
    private ArrayList<DatasetSetting> settingList;
    private static String m_senderMethodName;

    @Deprecated
    private OSGBVectorCacheBuilder(Recordset recordset, DatasetVector dataset, String outputFolder, String name) {
        long l = 0L;
        long l2 = 0L;
        if (recordset != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset)) == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (dataset != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset)) == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(outputFolder);
        if (!file.exists()) {
            String string = InternalResource.loadString("outputFolder", "CacheBuilderSCI3D_OutputFolderNotExists", "processing_resources") + " " + outputFolder;
            throw new IllegalStateException(string);
        }
        if (name == null || name.length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = OSGBVectorCacheBuilderNative.jni_New(l, l2, outputFolder, name);
        this.setHandle(l3, true);
        this.m_selfEventHandle = OSGBVectorCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_dataset = dataset;
        this.m_recordset = recordset;
    }

    public OSGBVectorCacheBuilder() {
        long l = OSGBVectorCacheBuilderNative.jni_New3();
        this.setHandle(l, true);
        this.m_selfEventHandle = OSGBVectorCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public OSGBVectorCacheBuilder(Recordset recordset, String outputFolder) {
        this(recordset, null, outputFolder, recordset.getDataset().getName());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
    }

    public OSGBVectorCacheBuilder(Recordset recordset, String outputFolder, String cacheName) {
        this(recordset, null, outputFolder, cacheName);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
    }

    public OSGBVectorCacheBuilder(DatasetVector dataset, String outputFolder, String cacheName) {
        this(null, dataset, outputFolder, cacheName);
    }

    public Recordset getRecordset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_recordset;
    }

    @Deprecated
    public void setRecordset(Recordset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRecordset(Recordset value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (value != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value)) == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_recordset = value;
        OSGBVectorCacheBuilderNative.jni_setRecordset(this.getHandle(), l);
        this.m_dataset = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public DatasetVector getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    @Deprecated
    public void setDataset(DatasetVector value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset(DatasetVector value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (value != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value)) == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_dataset = value;
        OSGBVectorCacheBuilderNative.jni_setDataset(this.getHandle(), l);
        this.m_recordset = null;
    }

    @Deprecated
    public String[] getFieldNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = OSGBVectorCacheBuilderNative.jni_GetFieldNames(this.getHandle());
        return InternalProcessingToolkit.splitString(string, ";");
    }

    @Deprecated
    public void setFieldNames(String[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFieldNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (value == null) {
            OSGBVectorCacheBuilderNative.jni_SetFieldNames(this.getHandle(), null);
            return;
        }
        string = InternalProcessingToolkit.joinString(value, ";");
        OSGBVectorCacheBuilderNative.jni_SetFieldNames(this.getHandle(), string);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        OSGBVectorCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBoudns(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        OSGBVectorCacheBuilderNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("setCacheName()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetCacheName(this.getHandle(), value);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), value);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBVectorCacheBuilderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalProcessingEnum.parseUGCValue(StorageType.class, n);
    }

    @Deprecated
    public void setStorageType(StorageType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType(StorageType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetStorageType(this.getHandle(), InternalProcessingEnum.getUGCValue(value));
    }

    @Deprecated
    public int getLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetLevel(this.getHandle());
    }

    @Deprecated
    public void setLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLevel(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetLevel(this.getHandle(), value);
    }

    @Deprecated
    public int getUpdateSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUpdateSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetUpdateSize(this.getHandle());
    }

    @Deprecated
    public void setUpdateSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUpdateSize(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetUpdateSize(this.getHandle(), value);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_password;
    }

    public void setPassword(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPassword(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_password = value;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_password == null || this.m_password.trim().length() == 0) {
            return OSGBVectorCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
        }
        boolean bl = false;
        bl = OSGBVectorCacheBuilderNative.jni_BuildWithPassword(this.getHandle(), this.m_selfEventHandle, this.m_password);
        this.getHandle();
        return bl;
    }

    @Deprecated
    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset == null && this.m_recordset == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = OSGBVectorCacheBuilderNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle, this.m_password);
        this.getHandle();
        return bl;
    }

    @Deprecated
    public boolean buildTexture(String texPath, int level) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildTexture(String texPath, int level)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset == null && this.m_recordset == null) {
            String string = InternalResource.loadString("buildTexture(String texPath, int level)", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = OSGBVectorCacheBuilderNative.jni_BuildTexture(this.getHandle(), texPath, level);
        return bl;
    }

    @Deprecated
    public String[] computeFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = OSGBVectorCacheBuilderNative.jni_ComputeFileName(this.getHandle());
        return InternalProcessingToolkit.splitString(string, ";");
    }

    @Deprecated
    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_ComputeLevel(this.getHandle());
    }

    @Deprecated
    public boolean toConfigFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_ToFile(this.getHandle(), path);
    }

    @Deprecated
    public boolean fromConfigFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_FromFile(this.getHandle(), path);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            OSGBVectorCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.clearSelfEventHandle();
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            OSGBVectorCacheBuilderNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    static void steppedCallBack(OSGBVectorCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBVectorCacheBuilderNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    @Deprecated
    public void setEncodeType(EncodeType encodeType) {
        if (encodeType == null) {
            String string = InternalResource.loadString("EncodeType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    public CompressedTextureType getCompressedTextureType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBVectorCacheBuilderNative.jni_GetCompressedTextureType(this.getHandle());
        return (CompressedTextureType)InternalEnum.parseUGCValue(CompressedTextureType.class, n);
    }

    @Deprecated
    public void setCompressedTextureType(CompressedTextureType value) {
        if (value == null) {
            String string = InternalResource.loadString("CompressedTextureType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetCompressedTextureType(this.getHandle(), value.value());
    }

    @Deprecated
    public VectorCacheTileType getVectorCacheTileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVectorCacheTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBVectorCacheBuilderNative.jni_GetVectorCacheTileType(this.getHandle());
        return (VectorCacheTileType)InternalEnum.parseUGCValue(VectorCacheTileType.class, n);
    }

    @Deprecated
    public void setVectorCacheTileType(VectorCacheTileType eTileType) {
        if (eTileType == null) {
            String string = InternalResource.loadString("VectorCacheTileType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVectorCacheTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetVectorCacheTileType(this.getHandle(), eTileType.value());
    }

    @Deprecated
    public void setOutputScale(double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (scale < Environment.getMaxEqualZeroPrecision() || scale > 1.0 - Environment.getMaxEqualZeroPrecision()) {
            String string = InternalResource.loadString("setScale(double)", "ScaleRangeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetScale(this.getHandle(), scale);
    }

    public double getOutputScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale(double)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetScale(this.getHandle());
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDynamicPrjCoordSysType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBVectorCacheBuilderNative.jni_GetVectorSplitType(this.getHandle());
        PrjCoordSysType prjCoordSysType = n == 0 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset != null || this.m_recordset != null) {
            PrjCoordSysType prjCoordSysType = this.m_dataset != null ? this.m_dataset.getPrjCoordSys().getType() : this.m_recordset.getDataset().getPrjCoordSys().getType();
            if (prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && prjType == PrjCoordSysType.PCS_NON_EARTH) {
                String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
            if (prjCoordSysType == PrjCoordSysType.PCS_NON_EARTH && prjType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
                String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        int n = prjType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 0 : 1;
        OSGBVectorCacheBuilderNative.jni_SetVectorSplitType(this.getHandle(), n);
    }

    @Deprecated
    public Boolean isTileExistsInConfigFile(double scale, int row, int col) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsTileExistsInConfigFile(double, row, col)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_IsTileExistsInConfigFile(this.getHandle(), scale, row, col);
    }

    @Deprecated
    public Boolean addTileInfoToConfigFile(double scale, int row, int col) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addTileInfoToConfigFile(double, row, col)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_AddTileInfoToConfigFile(this.getHandle(), scale, row, col);
    }

    @Deprecated
    public Tile[] getTiles(Rectangle2D tileBounds, double scale, VectorCacheTileType eTileType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles(tileBounds, scale, eTileType)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tiles tiles = null;
        long l = OSGBVectorCacheBuilderNative.jni_GetTiles(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), scale, eTileType.value());
        tiles = new Tiles(l);
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetTileWidth(this.getHandle());
    }

    public void setTileWidth(double tileWidthValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileWidth", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetTileWidth(this.getHandle(), tileWidthValue);
    }

    @Deprecated
    public ArrayList<byte[]> getConfigStream(ConfigType configType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConfigStream", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (configType == ConfigType.CONFIG_AND_INDEX_FILE) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            byte[] byArray = OSGBVectorCacheBuilderNative.jni_GetConfigStream(this.getHandle(), ConfigType.CONFIGUE_FILE.value());
            byte[] byArray2 = OSGBVectorCacheBuilderNative.jni_GetConfigStream(this.getHandle(), ConfigType.INDEX_DATA_FILE.value());
            arrayList.add(byArray);
            arrayList.add(byArray2);
            return arrayList;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = OSGBVectorCacheBuilderNative.jni_GetConfigStream(this.getHandle(), configType.value());
        arrayList.add(byArray);
        return arrayList;
    }

    public GeoStyle3D getUserDefStyle3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUserDefStyle3D", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = OSGBVectorCacheBuilderNative.jni_GetUserDefStyle3D(this.getHandle());
        if (l == 0L) {
            return null;
        }
        return InternalGeoStyle3D.createInstance(l);
    }

    public void setUserDefStyle3D(GeoStyle3D geoStyle3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserDefStyle3D", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
        OSGBVectorCacheBuilderNative.jni_SetUserDefStyle3D(this.getHandle(), l);
    }

    public boolean getTileBoundClip() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileBoundClip", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_GetTileBoundClip(this.getHandle());
    }

    public void setTileBoundClip(boolean clipValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileBoundClip", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetTileBoundClip(this.getHandle(), clipValue);
    }

    public CacheFileType getCacheType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBVectorCacheBuilderNative.jni_GetFileType(this.getHandle());
        switch (n) {
            case 505: {
                n = 0;
                break;
            }
            case 511: {
                n = 1;
                break;
            }
            case 515: {
                n = 2;
                break;
            }
            default: {
                String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        return (CacheFileType)InternalEnum.parseUGCValue(CacheFileType.class, n);
    }

    public void setFileType(CacheFileType fileType) {
        if (fileType == null) {
            String string = InternalResource.loadString("setFileType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (fileType == CacheFileType.OSGB) {
            n = 505;
        } else if (fileType == CacheFileType.S3M) {
            n = 511;
        } else if (fileType == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetFileType(this.getHandle(), n);
    }

    public ArrayList<DatasetSetting> getDatasetSettingArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetSettingArray", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.settingList;
    }

    public void setDatasetSettingArray(ArrayList<DatasetSetting> datasetSettings) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDatasetSettingArray", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.settingList = datasetSettings;
        if (datasetSettings == null || datasetSettings.size() == 0) {
            return;
        }
        ArrayList<DatasetVector> arrayList = new ArrayList<DatasetVector>();
        String[] stringArray = new String[datasetSettings.size()];
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < datasetSettings.size(); ++i) {
            DatasetSetting datasetSetting = datasetSettings.get(i);
            arrayList.add(datasetSetting.getDataset());
            stringArray[i] = datasetSetting.getUserIDField();
            String[] stringArray2 = datasetSetting.getFieldNames();
            if (stringArray2 == null) continue;
            for (n = 0; n < stringArray2.length; ++n) {
                arrayList2.add(stringArray2[n]);
            }
            arrayList3.add(stringArray2.length);
        }
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)arrayList.get(i));
        }
        String[] stringArray3 = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringArray3[i] = (String)arrayList2.get(i);
        }
        int[] nArray = new int[arrayList3.size()];
        for (n = 0; n < arrayList3.size(); ++n) {
            nArray[n] = (Integer)arrayList3.get(n);
        }
        OSGBVectorCacheBuilderNative.jni_SetDatasetSettingArray(this.getHandle(), lArray, stringArray, stringArray3, nArray);
    }

    public void setScene(Scene value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVectorCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetScene(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
    }

    public void setLayer(Layer3DDataset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVectorCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("layer3D", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        OSGBVectorCacheBuilderNative.jni_SetLayer(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
    }

    public ArrayList<TileInfos> getTileInfosArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVectorCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TileInfos> arrayList = new ArrayList<TileInfos>();
        int[] nArray = new int[1];
        long l = OSGBVectorCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), nArray);
        if (nArray[0] != 0 && l != 0L) {
            Object[] objectArray = new Object[nArray[0]];
            String[] stringArray = new String[nArray[0]];
            OSGBVectorCacheBuilderNative.jni_GetTileInfosArray2(this.getHandle(), l, stringArray, objectArray);
            if (stringArray != null && objectArray != null && objectArray.length == stringArray.length) {
                for (int i = 0; i < stringArray.length; ++i) {
                    double[] dArray = (double[])objectArray[i];
                    Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
                    TileInfos tileInfos = new TileInfos();
                    tileInfos.setName(stringArray[i]);
                    tileInfos.setBounds(rectangle2D);
                    arrayList.add(tileInfos);
                }
            }
        }
        return arrayList;
    }

    @Deprecated
    public boolean toConfigAndIndexFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBVectorCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBVectorCacheBuilderNative.jni_ToFile(this.getHandle(), path);
    }

    public OSGBVectorCacheBuilder(Scene scene, Layer3DDataset layer3DDataset, String outputFolder, String cacheName) {
        if (layer3DDataset == null) {
            String string = InternalResource.loadString("layer3DDataset", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        this.m_dataset = (DatasetVector)layer3DDataset.getDataset();
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset);
        if (scene != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)scene);
        }
        if (layer3DDataset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)layer3DDataset);
        }
        long l4 = OSGBVectorCacheBuilderNative.jni_New2(l, l3, l2, outputFolder, cacheName);
        this.setHandle(l4, true);
        this.m_selfEventHandle = OSGBVectorCacheBuilderNative.jni_NewSelfEventHandle(this);
    }
}

