/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.ColorDictionary;
import com.supermap.data.CompressedTextureType;
import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Geometry;
import com.supermap.data.Point3D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TextureData;
import com.supermap.data.processing.CacheLimitTextureSize;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalTextureData;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.OSGBCacheBuilderNative;
import com.supermap.data.processing.ProcessFileType;
import com.supermap.data.processing.PyramidSplitType;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TextureProcessingType;
import com.supermap.data.processing.TileInfos;
import com.supermap.data.processing.VertexOptimizationType;
import com.supermap.data.processing.VertexWeightMode;
import com.supermap.realspace.CacheFileType;
import com.supermap.tilestorage.TileStorageConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class OSGBCacheBuilder
extends InternalHandleDisposable {
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;
    private long m_selfEventHandle;
    private Recordset m_recordset;
    private DatasetVector m_dataset;
    private String[] fieldsNames = null;

    public OSGBCacheBuilder() {
        long l = OSGBCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = OSGBCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_dataset = null;
        this.m_recordset = null;
    }

    public OSGBCacheBuilder(DatasetVector dataset, String outputFolder, String name) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        this.m_dataset = dataset;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = OSGBCacheBuilderNative.jni_New1(l, outputFolder, name);
        this.setHandle(l2, true);
        this.m_selfEventHandle = OSGBCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_recordset = null;
        this.m_dataset = dataset;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            OSGBCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public DatasetVector getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    public void setDataset(DatasetVector value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        OSGBCacheBuilderNative.jni_SetDataset(this.getHandle(), l);
        this.m_dataset = value;
        this.m_recordset = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        OSGBCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        OSGBCacheBuilderNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetCacheName(this.getHandle(), name);
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDynamicPrjCoordSysType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetTileSplitType(this.getHandle());
        PrjCoordSysType prjCoordSysType = n == 0 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset != null || this.m_recordset != null) {
            PrjCoordSysType prjCoordSysType = this.m_dataset != null ? this.m_dataset.getPrjCoordSys().getType() : this.m_recordset.getDataset().getPrjCoordSys().getType();
            if (prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && prjType == PrjCoordSysType.PCS_NON_EARTH) {
                String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
            if (prjCoordSysType == PrjCoordSysType.PCS_NON_EARTH && prjType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
                String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        int n = prjType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 0 : 1;
        OSGBCacheBuilderNative.jni_SetTileSplitType(this.getHandle(), n);
    }

    public void setFileType(CacheFileType fileType) {
        if (fileType == null) {
            String string = InternalResource.loadString("OSGBCacheFileType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (fileType == CacheFileType.OSGB) {
            n = 505;
        } else if (fileType == CacheFileType.S3M) {
            n = 511;
        } else if (fileType == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetFileType(this.getHandle(), n);
    }

    public CacheFileType getFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetFileType(this.getHandle());
        switch (n) {
            case 505: {
                n = 0;
                break;
            }
            case 511: {
                n = 1;
                break;
            }
            case 515: {
                n = 2;
                break;
            }
            default: {
                String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        return (CacheFileType)InternalEnum.parseUGCValue(CacheFileType.class, n);
    }

    public void setIsCalNormal(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsCalNormal()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetIsCalNormal(this.getHandle(), value);
    }

    public boolean getIsCalNormal() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsCalNormal()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetIsCalNormal(this.getHandle());
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), name);
    }

    public double getOutputScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetOutputScale(this.getHandle());
    }

    public void setOutputScale(double value) {
        double d = 1.0E-10;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value < d || value > 1.0 - d) {
            String string = InternalResource.loadString("setOutputScale()", "ArgumentOutOfRange", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetOutputScale(this.getHandle(), value);
    }

    public ProcessFileType getProcessType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetProcessType(this.getHandle());
        return (ProcessFileType)InternalEnum.parseUGCValue(ProcessFileType.class, n);
    }

    public void setProcessType(ProcessFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessType(ProcessFileType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetProcessType(this.getHandle(), value.value());
    }

    public void setRecordset(Recordset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRecordset(Recordset value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (value != null && 0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value))) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetRecordset(this.getHandle(), l);
        this.m_recordset = value;
        this.m_dataset = null;
    }

    public Recordset getRecordset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_recordset;
    }

    public void setTileWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileWidth", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetTileWidth(this.getHandle(), value);
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetTileWidth(this.getHandle());
    }

    public void setLODSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLODSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetLODSize(this.getHandle(), value);
    }

    public int getLODSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLODSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetLODSize(this.getHandle());
    }

    public void setMipmapCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMipmapCount", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetMipmapCount(this.getHandle(), value);
    }

    public int getMipmapCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMipmapCount", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetMipmapCount(this.getHandle());
    }

    public void setObjectFiltrateThreshold(double dbValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetObjectFiltrateThreshold(this.getHandle(), dbValue);
    }

    public double getObjectFiltrateThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getObjectFiltrateThreshold", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetObjectFiltrateThreshold(this.getHandle());
    }

    public void setSimplifyPercent(Map<Integer, Double> mapPercent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSimplifyPercent", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[mapPercent.size()];
        double[] dArray = new double[mapPercent.size()];
        int n = 0;
        for (Integer n2 : mapPercent.keySet()) {
            Double d = mapPercent.get(n2);
            nArray[n] = n2;
            dArray[n] = d;
            ++n;
        }
        OSGBCacheBuilderNative.jni_SetSimplifyPercent(this.getHandle(), nArray, dArray);
    }

    public HashMap<Integer, Double> getSimplifyPercent() {
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        double[] dArray = OSGBCacheBuilderNative.jni_GetSimplifyPercent(this.getHandle());
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                hashMap.put(i, dArray[i]);
            }
        }
        return hashMap;
    }

    public void setTilePyramidSplitType(PyramidSplitType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetTilePyramidSplitType(this.getHandle(), value.value());
    }

    public PyramidSplitType getTilePyramidSplitType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetTilePyramidSplitType(this.getHandle());
        return (PyramidSplitType)InternalEnum.parseUGCValue(PyramidSplitType.class, n);
    }

    public boolean getIsInstance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsInstance()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = OSGBCacheBuilderNative.jni_GetIsInstance(this.getHandle());
        return bl;
    }

    public void setIsInstance(boolean bInstance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsInstance", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetIsInstance(this.getHandle(), bInstance);
    }

    public void setConnectionInfo(TileStorageConnection connInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)connInfo);
        OSGBCacheBuilderNative.jni_SetConnectionInfo(this.getHandle(), l);
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType(StorageType storageType)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetStorageType(this.getHandle(), storageType.value());
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setTextureSharing(boolean bShare) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextureSharing", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetTextureSharing(this.getHandle(), bShare);
    }

    public boolean getTextureSharing() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextureSharing", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetTextureSharing(this.getHandle());
    }

    public ArrayList<Rectangle2D> getTileBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileBounds", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<Rectangle2D> arrayList = null;
        Object[] objectArray = OSGBCacheBuilderNative.jni_GetTileBounds(this.getHandle());
        if (objectArray != null) {
            arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < objectArray.length; ++i) {
                double[] dArray = (double[])objectArray[i];
                arrayList.add(new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]));
            }
        }
        return arrayList;
    }

    public void setDatasetArray(DatasetVector[] arrDataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[arrDataset.length];
        for (int i = 0; i < arrDataset.length; ++i) {
            long l;
            lArray[i] = l = InternalHandle.getHandle((com.supermap.data.InternalHandle)arrDataset[i]);
        }
        OSGBCacheBuilderNative.jni_SetDatasetArray(this.getHandle(), lArray);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return OSGBCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setProcessThreadsCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetProcessThreadsCount(this.getHandle(), value);
    }

    public ArrayList<TileInfos> getTileInfosArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TileInfos> arrayList = new ArrayList<TileInfos>();
        int[] nArray = new int[1];
        long l = OSGBCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), nArray);
        if (nArray[0] != 0 && l != 0L) {
            Object[] objectArray = new Object[nArray[0]];
            String[] stringArray = new String[nArray[0]];
            OSGBCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), l, stringArray, objectArray);
            if (stringArray != null && objectArray != null && objectArray.length == stringArray.length) {
                for (int i = 0; i < stringArray.length; ++i) {
                    double[] dArray = (double[])objectArray[i];
                    Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
                    TileInfos tileInfos = new TileInfos();
                    tileInfos.setName(stringArray[i]);
                    tileInfos.setBounds(rectangle2D);
                    arrayList.add(tileInfos);
                }
            }
        }
        return arrayList;
    }

    public boolean toConfigAndIndexFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_ToFile(this.getHandle(), path);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle);
    }

    public boolean buildTiles() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_BuildWithoutConfigFile2(this.getHandle(), this.m_selfEventHandle);
    }

    static void steppedCallBack(OSGBCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            OSGBCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, String[] fileNames) {
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFile(configFileName, position.getX(), position.getY(), position.getZ(), l, fileNames, null);
    }

    public static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, String[] fileNames, TileStorageConnection mongoConn) {
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        String[] stringArray = null;
        if (mongoConn != null) {
            stringArray = new String[]{mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword()};
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFile(configFileName, position.getX(), position.getY(), position.getZ(), l, fileNames, stringArray);
    }

    static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, String rootNodeInfoDir, String rootNodePrefix, TileStorageConnection mongoConn, boolean bDiscrete) {
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        String[] stringArray = null;
        if (mongoConn != null) {
            stringArray = new String[]{mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword()};
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFileBaseXml(configFileName, position.getX(), position.getY(), position.getZ(), l, rootNodeInfoDir, rootNodePrefix, stringArray, bDiscrete);
    }

    public static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, boolean bNEU, String[] fileNames) {
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFile(configFileName, position.getX(), position.getY(), position.getZ(), l, bNEU, fileNames);
    }

    public static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, CoordSysTransParameter coordSysTransParam, CoordSysTransMethod coordSysTransMethod, ArrayList<String> fileNames) {
        String[] stringArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            stringArray[i] = fileNames.get(i);
        }
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        long l2 = 0L;
        if (value != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)coordSysTransParam);
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFile3(configFileName, position.getX(), position.getY(), position.getZ(), l, l2, coordSysTransMethod.value(), stringArray);
    }

    public static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, CoordSysTransParameter coordSysTransParam, CoordSysTransMethod coordSysTransMethod, boolean bNEU, ArrayList<String> fileNames) {
        String[] stringArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            stringArray[i] = fileNames.get(i);
        }
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        long l2 = 0L;
        if (value != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)coordSysTransParam);
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFile4(configFileName, position.getX(), position.getY(), position.getZ(), l, l2, coordSysTransMethod.value(), bNEU, stringArray);
    }

    public static boolean generateConfigFile(String configFileName, Point3D position, PrjCoordSys value, PrjCoordSys valueDes, CoordSysTransParameter coordSysTransParam, CoordSysTransMethod coordSysTransMethod, ArrayList<String> fileNames) {
        String[] stringArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            stringArray[i] = fileNames.get(i);
        }
        long l = 0L;
        if (value != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        }
        long l2 = 0L;
        if (valueDes != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)valueDes);
        }
        long l3 = 0L;
        if (value != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)coordSysTransParam);
        }
        return OSGBCacheBuilderNative.jni_GenerateConfigFile5(configFileName, position.getX(), position.getY(), position.getZ(), l, l2, l3, coordSysTransMethod.value(), stringArray);
    }

    public static boolean combineOSGBFile(String outputFileName, ArrayList<String> fileNames, double dPercent, double dDistance, float fErrorValue) {
        if (fileNames == null) {
            String string = InternalResource.loadString("fileNames", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            stringArray[i] = fileNames.get(i);
        }
        return OSGBCacheBuilderNative.jni_CombineOSGBFile(outputFileName, stringArray, dPercent, dDistance, fErrorValue);
    }

    public static boolean osgbFile2MongoDB(String scpFileName, TileStorageConnection mongoConn, String scpMongoFile) {
        return OSGBCacheBuilderNative.jni_OSGBFile2MongoDB(scpFileName, mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword(), mongoConn.getStorageType().value(), scpMongoFile);
    }

    public static boolean b3dmFile2MongoDB(String scpFileName, TileStorageConnection mongoConn) {
        return OSGBCacheBuilderNative.jni_B3DMFile2MongoDB(scpFileName, mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword(), mongoConn.getStorageType().value());
    }

    public boolean buildTile(HashMap<String, int[]> geoModelIDs, boolean bCombineModels) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (geoModelIDs == null) {
            String string = InternalResource.loadString("geoModelIDs", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = geoModelIDs.size();
        String[] stringArray = new String[n];
        Object[] objectArray = new Object[n];
        Set<Map.Entry<String, int[]>> set = geoModelIDs.entrySet();
        Iterator<Map.Entry<String, int[]>> iterator = set.iterator();
        Map.Entry<String, int[]> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            stringArray[i] = entry.getKey();
            objectArray[i] = entry.getValue();
        }
        return OSGBCacheBuilderNative.jni_BuildTile(this.getHandle(), stringArray, objectArray, bCombineModels, this.getOutputFolder());
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        OSGBCacheBuilderNative.jni_GetPosition(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setPosition(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetPosition(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public static ArrayList<TextureData> getExtrudeRegionTexFromVoxelGrid(Geometry geometry, double height, DatasetVolume volume, ColorDictionary table) {
        long[] lArray;
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == volume) {
            String string = InternalResource.loadString("volume", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)volume);
        if (0L == l2) {
            String string = InternalResource.loadString("volume", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (table != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)table);
        }
        if ((lArray = OSGBCacheBuilderNative.jni_GetExtrudeRegionTexFromVoxelGrid(l, height, l2, l3)) == null) {
            return null;
        }
        ArrayList<TextureData> arrayList = new ArrayList<TextureData>();
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(InternalTextureData.createInstance(lArray[i]));
        }
        return arrayList;
    }

    public boolean isRemoveNormal() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_IsRemoveNormal(this.getHandle());
    }

    public void setRemoveNormal(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetRemoveNormal(this.getHandle(), value);
    }

    public void setTileInfos(TileInfos value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.getName() == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = value.getName().split("_");
        if (stringArray.length != 4) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        OSGBCacheBuilderNative.jni_SetTileInfos(this.getHandle(), n, n2, n3);
    }

    public void setTileInfos(ArrayList<TileInfos> infos) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileInfos", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (infos == null || infos.size() == 0) {
            String string = InternalResource.loadString("infos", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[infos.size() * 3];
        for (int i = 0; i < infos.size(); ++i) {
            TileInfos tileInfos = infos.get(i);
            String[] stringArray = tileInfos.getName().split("_");
            if (stringArray.length != 4) {
                String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            int n3 = Integer.parseInt(stringArray[3]);
            nArray[3 * i] = n;
            nArray[3 * i + 1] = n2;
            nArray[3 * i + 2] = n3;
        }
        OSGBCacheBuilderNative.jni_SetTileInfos2(this.getHandle(), nArray);
    }

    @Deprecated
    public boolean buildWithTileClip() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithTileClip", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return OSGBCacheBuilderNative.jni_BuildWithTileClip(this.getHandle());
    }

    public boolean isHasOutLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_IsHasOutLine(this.getHandle());
    }

    public void setHasOutLine(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OSGBCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetHasOutLine(this.getHandle(), value);
    }

    public boolean isCombineRepeatTextures() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsCombineRepeatTextures", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_IsCombineRepeatTextures(this.getHandle());
    }

    public void setCombineRepeatTextures(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCombineRepeatTextures", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetCombineRepeatTextures(this.getHandle(), value);
    }

    public void setLimitTextureSize(CacheLimitTextureSize value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetLimitTextureSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetLimitTextureSize(this.getHandle(), value.value());
    }

    public CacheLimitTextureSize getLimitTextureSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetLimitTextureSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetLimitTextureSize(this.getHandle());
        return (CacheLimitTextureSize)InternalEnum.parseUGCValue(CacheLimitTextureSize.class, n);
    }

    public void setCompressedTextureType(CompressedTextureType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCompressedTextureType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetCompressedTextureType(this.getHandle(), value.value());
    }

    public CompressedTextureType getCompressedTextureType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCompressedTextureType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetCompressedTextureType(this.getHandle());
        return (CompressedTextureType)InternalEnum.parseUGCValue(CompressedTextureType.class, n);
    }

    public TextureProcessingType getTextureProcessingType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextureProcessing", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetTextureProcessing(this.getHandle());
        return (TextureProcessingType)InternalEnum.parseUGCValue(TextureProcessingType.class, n);
    }

    public void setTextureProcessingType(TextureProcessingType processingType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextureProcessing", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetTextureProcessing(this.getHandle(), processingType.value());
    }

    public String getCategoryField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCategoryField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetCategoryField(this.getHandle());
    }

    public void setCategoryField(String categoryFieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCategoryField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetCategoryField(this.getHandle(), categoryFieldName);
    }

    public VertexWeightMode getVertexWeightMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVertexWeightMode", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetVertexWeightMode(this.getHandle());
        return (VertexWeightMode)InternalEnum.parseUGCValue(VertexWeightMode.class, n);
    }

    public void setVertexWeightMode(VertexWeightMode modeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVertexWeightMode", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetVertexWeightMode(this.getHandle(), modeType.value());
    }

    public VertexOptimizationType getVertexOptimizationType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVertexOptimizationType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = OSGBCacheBuilderNative.jni_GetVertexOptimizationType(this.getHandle());
        return (VertexOptimizationType)InternalEnum.parseUGCValue(VertexOptimizationType.class, n);
    }

    public void setVertexOptimizationType(VertexOptimizationType vertexOptimizationType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVertexOptimizationType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetVertexOptimizationType(this.getHandle(), vertexOptimizationType.value());
    }

    public String getUserIDField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUserIDField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetUserIDField(this.getHandle());
    }

    public void setUserIDField(String userIDName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserIDField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetUserIDField(this.getHandle(), userIDName);
    }

    public boolean isLogEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLogEnable", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetErrorLogOut(this.getHandle());
    }

    public void setLogEnable(boolean isErrorLogOut) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLogEnable", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetErrorLogOut(this.getHandle(), isErrorLogOut);
    }

    public String[] getFieldsNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldsNames", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.fieldsNames;
    }

    public void setFieldsNames(String[] fieldsNames) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFieldsNames", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.fieldsNames = fieldsNames;
        OSGBCacheBuilderNative.jni_SetFieldNames(this.getHandle(), fieldsNames);
    }

    public static boolean combineRootNodes(String inScpFilePath, String saveSCPName, int combineLevel, HashMap<Integer, Double> simplifyPercent, int threadCount) {
        if (inScpFilePath == null || inScpFilePath.length() == 0 || saveSCPName == null || saveSCPName.equals("") || simplifyPercent == null) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (Integer object2 : simplifyPercent.keySet()) {
            arrayList.add(object2);
            arrayList2.add(simplifyPercent.get(object2));
        }
        Object object3 = arrayList.stream().mapToInt(Integer::valueOf).toArray();
        double[] dArray = arrayList2.stream().mapToDouble(Double::valueOf).toArray();
        boolean bl = OSGBCacheBuilderNative.jni_CombineRootNodes(inScpFilePath, saveSCPName, combineLevel, (int[])object3, dArray, threadCount);
        return bl;
    }

    public static boolean combineRootNodes(String[] inScpFilePaths, String saveSCPFullPath, int combineLevel, HashMap<Integer, Double> simplifyPercent, int threadCount) {
        if (inScpFilePaths == null || inScpFilePaths.length == 0 || saveSCPFullPath == null || saveSCPFullPath.equals("") || simplifyPercent == null) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (Integer object2 : simplifyPercent.keySet()) {
            arrayList.add(object2);
            arrayList2.add(simplifyPercent.get(object2));
        }
        Object object3 = arrayList.stream().mapToInt(Integer::valueOf).toArray();
        double[] dArray = arrayList2.stream().mapToDouble(Double::valueOf).toArray();
        boolean bl = OSGBCacheBuilderNative.jni_CombineRootNodes2(inScpFilePaths, saveSCPFullPath, combineLevel, (int[])object3, dArray, threadCount);
        return bl;
    }

    public double getTileHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileHeight", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return OSGBCacheBuilderNative.jni_GetTileHeight(this.getHandle());
    }

    public void setTileHeight(double setTileHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileHeight", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        OSGBCacheBuilderNative.jni_SetTileHeight(this.getHandle(), setTileHeight);
    }
}

