/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalPrjCoordSys;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.MapCacheFileNative;
import com.supermap.data.processing.MapCacheVersion;
import com.supermap.data.processing.MapTilingMode;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import com.supermap.data.processing.Tiles;
import com.supermap.mapping.Map;
import java.awt.Color;
import java.util.HashMap;

public class MapCacheFile
extends com.supermap.data.processing.InternalHandleDisposable {
    private Map m_map = null;
    private PrjCoordSys m_prjCoordSys = null;

    public MapCacheFile() {
        long l = MapCacheFileNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCacheFileNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public MapCacheVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetVersion(this.getHandle());
        MapCacheVersion mapCacheVersion = null;
        mapCacheVersion = (MapCacheVersion)InternalEnum.parseUGCValue(MapCacheVersion.class, n);
        return mapCacheVersion;
    }

    public double[] getScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = MapCacheFileNative.jni_GetScales(this.getHandle());
        return dArray;
    }

    String getHashCode() {
        return MapCacheFileNative.jni_GetHashCode(this.getHandle());
    }

    @Deprecated
    private Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_map;
    }

    @Deprecated
    private void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map == null) {
            MapCacheFileNative.jni_SetMap(this.getHandle(), 0L);
        } else {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)map) == 0L) {
                String string = InternalResource.loadString("setMap()", "Global_ArgumentNull", "processing_resources");
                throw new IllegalStateException(string);
            }
            MapCacheFileNative.jni_SetMap(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)map));
        }
        this.m_map = map;
    }

    public boolean open(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.open(fileName, "");
    }

    public boolean open(String fileName, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null) {
            String string = InternalResource.loadString("open()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName.length() == 0) {
            String string = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheFileNative.jni_Open(this.getHandle(), fileName, password);
        if (bl && this.m_prjCoordSys != null) {
            InternalPrjCoordSys.clearHandle(this.m_prjCoordSys);
            this.m_prjCoordSys = null;
        }
        return bl;
    }

    public boolean checkTileBoundsValid(Rectangle2D tileBounds, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("checkTileBoundsValid()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_CheckTileBoundsValid(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), scale);
    }

    public Tile[] getTiles(Rectangle2D tileBounds, double scale, String pwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.getTiles(tileBounds, scale, pwd, "");
    }

    public Tile[] getTiles(Rectangle2D tileBounds, double scale, String pwd, String hashCode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tiles tiles = null;
        long l = MapCacheFileNative.jni_GetTiles(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), scale, pwd, hashCode);
        tiles = new Tiles(l);
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public Tile[] getTiles(Rectangle2D tileBounds, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.getTiles(tileBounds, scale, "");
    }

    public boolean clear(Rectangle2D tileBounds, double[] scales) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_Clear(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), scales);
    }

    public boolean saveAsSCI3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveAsSCI3D()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_SaveAsSCI3D(this.getHandle());
    }

    @Deprecated
    private CacheImageType getImageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetImageType(this.getHandle());
        CacheImageType cacheImageType = null;
        cacheImageType = (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
        return cacheImageType;
    }

    @Deprecated
    private CacheImageSize getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetImageSize(this.getHandle());
        CacheImageSize cacheImageSize = null;
        switch (n) {
            case 0: {
                cacheImageSize = CacheImageSize.SIZE64;
                break;
            }
            case 1: {
                cacheImageSize = CacheImageSize.SIZE128;
                break;
            }
            case 2: {
                cacheImageSize = CacheImageSize.SIZE256;
                break;
            }
            case 3: {
                cacheImageSize = CacheImageSize.SIZE512;
                break;
            }
            case 4: {
                cacheImageSize = CacheImageSize.SIZE1024;
                break;
            }
            case 5: {
                cacheImageSize = CacheImageSize.SIZE2048;
                break;
            }
            default: {
                cacheImageSize = CacheImageSize.SIZE256;
            }
        }
        return cacheImageSize;
    }

    public boolean merge(String path, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("merge()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_Merge(this.getHandle(), path, password);
    }

    public boolean merge(String path) {
        return this.merge(path, "");
    }

    public GeoRegion getValidRegion(Rectangle2D bounds, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValidRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = MapCacheFileNative.jni_GetValidRegion(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), scale);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l);
            com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)geoRegion, true);
        }
        return geoRegion;
    }

    public boolean convert(StorageType type, String dest, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convert()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_Convert(this.getHandle(), type.value(), dest, password);
    }

    boolean convertSingleCompactFile(String compactFilePath, String outputPath) {
        return MapCacheFileNative.jni_ConvertSingleCompactFile(this.getHandle(), compactFilePath, outputPath);
    }

    public boolean hitTest(Point2D point, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_HitTest(this.getHandle(), point.getX(), point.getY(), scale);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheFileNative.jni_GetCacheName(this.getHandle());
        if ((string == null || string.length() == 0) && this.m_map != null) {
            string = this.m_map.getName();
        }
        return string;
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_prjCoordSys == null && (l = MapCacheFileNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this.m_prjCoordSys = InternalPrjCoordSys.createInstance(l, false);
        }
        return this.m_prjCoordSys;
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheFileNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Rectangle2D getIndexBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheFileNative.jni_GetIndexBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = null;
        long l = MapCacheFileNative.jni_GetClipRegion(this.getHandle());
        if (l != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l);
            com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)geoRegion, true);
        }
        return geoRegion;
    }

    public TileFormat getTileFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetTileFormat(this.getHandle());
        TileFormat tileFormat = null;
        tileFormat = (TileFormat)InternalEnum.parseUGCValue(TileFormat.class, n);
        return tileFormat;
    }

    public TileSize getTileSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetTileSize(this.getHandle());
        TileSize tileSize = null;
        switch (n) {
            case 0: {
                tileSize = TileSize.SIZE64;
                break;
            }
            case 1: {
                tileSize = TileSize.SIZE128;
                break;
            }
            case 2: {
                tileSize = TileSize.SIZE256;
                break;
            }
            case 3: {
                tileSize = TileSize.SIZE512;
                break;
            }
            case 4: {
                tileSize = TileSize.SIZE1024;
                break;
            }
            default: {
                tileSize = TileSize.SIZE256;
            }
        }
        return tileSize;
    }

    public MapTilingMode getTilingMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingMode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetTilingMode(this.getHandle());
        MapTilingMode mapTilingMode = null;
        mapTilingMode = (MapTilingMode)InternalEnum.parseUGCValue(MapTilingMode.class, n);
        return mapTilingMode;
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetStorageType(this.getHandle());
        StorageType storageType = null;
        storageType = (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
        return storageType;
    }

    public boolean isTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_IsTransparent(this.getHandle());
    }

    public boolean isFillMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_IsFillMargin(this.getHandle());
    }

    public double getDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDPI()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_GetDPI(this.getHandle());
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetOutputScalesCount(this.getHandle());
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        MapCacheFileNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    @Deprecated
    private double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return null;
    }

    int getImageCompress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetImageCompress(this.getHandle());
        return n;
    }

    public Color getDefaultColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultColor()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheFileNative.jni_GetDefaultColor(this.getHandle());
        Color color = new Color(n, true);
        return color;
    }

    protected void clearHandle() {
        if (this.m_prjCoordSys != null) {
            InternalPrjCoordSys.clearHandle(this.m_prjCoordSys);
            this.m_prjCoordSys = null;
        }
        this.setHandle(0L);
    }

    public boolean reload() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reload()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheFileNative.jni_Reload(this.getHandle());
    }

    public boolean clear(double scale, Rectangle2D tileBounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{scale};
        return MapCacheFileNative.jni_Clear(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), dArray);
    }

    public boolean extract(double[] scales, GeoRegion region, StorageType type, String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("extract()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(type);
        boolean bl = MapCacheFileNative.jni_Extract(this.getHandle(), scales, InternalHandle.getHandle((com.supermap.data.InternalHandle)region), n, path);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return bl;
    }

    public boolean extract(GeoRegion region, String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("extract()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheFileNative.jni_Extract(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)region), path);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return bl;
    }

    public boolean clear(double[] scales, GeoRegion region) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheFileNative.jni_Clear(this.getHandle(), scales, InternalHandle.getHandle((com.supermap.data.InternalHandle)region));
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return bl;
    }

    public boolean clear(GeoRegion region) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheFileNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)region));
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return bl;
    }
}

