/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVolume;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderSCI3DNative;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.ImageTilingMode;
import com.supermap.data.processing.InternalColors;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.Tiles;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ImageCacheBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private Dataset m_dataset = null;
    private boolean m_isDataset;
    private GeoRegion m_region = null;
    private long m_selfEventHandle;
    private long m_pUGGlobalImageBuilder;
    transient Vector m_steppedListeners;
    private static String m_senderMethodName;
    private String m_imageFileName;
    private String m_password;
    private Colors m_colorTable = null;
    private double[] m_gridValueTable = null;
    private boolean m_isNeededToReplace;
    private boolean m_isLocalTile;

    private void initialize() {
        long l = CacheBuilderSCI3DNative.jni_New();
        this.m_pUGGlobalImageBuilder = CacheBuilderSCI3DNative.jni_New2();
        this.setHandle(l, true);
        this.m_isNeededToReplace = false;
        this.m_dataset = null;
        this.m_region = null;
        this.setOutputFolder("");
        this.setCacheName("");
        Colors colors = new Colors();
        com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)colors, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l2, false);
        this.m_selfEventHandle = CacheBuilderSCI3DNative.jni_NewSelfEventHandle(this);
    }

    private void initialize(DatasetImage dataset, String outputFolder, String cacheName) {
        long l = CacheBuilderSCI3DNative.jni_New();
        this.m_pUGGlobalImageBuilder = CacheBuilderSCI3DNative.jni_New2();
        this.setHandle(l, true);
        this.m_isNeededToReplace = false;
        this.setDataset(dataset);
        this.m_region = null;
        this.setOutputFolder(outputFolder);
        this.setCacheName(cacheName);
        Colors colors = new Colors();
        com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)colors, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l2, false);
        this.m_selfEventHandle = CacheBuilderSCI3DNative.jni_NewSelfEventHandle(this);
    }

    private void processDataset() {
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset.getType() == DatasetType.MOSAIC) {
            CacheBuilderSCI3DNative.jni_SetDatasetMosaic(this.m_pUGGlobalImageBuilder, l);
        } else {
            CacheBuilderSCI3DNative.jni_SetDataset(this.getHandle(), this.m_pUGGlobalImageBuilder, l);
        }
    }

    public ImageCacheBuilder() {
        this.initialize();
        this.m_isLocalTile = true;
    }

    public ImageCacheBuilder(DatasetImage dataset, String outputFolder) {
        this.initialize(dataset, outputFolder, "");
        this.m_isLocalTile = true;
        this.computeLevel();
    }

    public ImageCacheBuilder(DatasetImage dataset, String outputFolder, String name) {
        this.initialize(dataset, outputFolder, name);
        this.m_isLocalTile = true;
        this.computeLevel();
    }

    public DatasetImage getDataset() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetImage datasetImage = null;
        if (this.m_dataset instanceof DatasetImage) {
            datasetImage = (DatasetImage)this.m_dataset;
        }
        return datasetImage;
    }

    public void setDataset(DatasetImage dataset) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_isLocalTile = true;
        this.m_dataset = dataset;
        this.m_isDataset = true;
    }

    public DatasetGrid getDatasetGrid() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetGrid datasetGrid = null;
        if (this.m_dataset instanceof DatasetGrid) {
            datasetGrid = (DatasetGrid)this.m_dataset;
        }
        return datasetGrid;
    }

    public void setDatasetGrid(DatasetGrid datasetGrid) {
        if (datasetGrid == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_isLocalTile = false;
        this.m_dataset = datasetGrid;
        this.m_isDataset = true;
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_GetOutputFolder(this.getHandle());
        }
        return CacheBuilderSCI3DNative.jni_GetOutputFolder2(this.m_pUGGlobalImageBuilder);
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetOutputFolder(this.getHandle(), this.m_pUGGlobalImageBuilder, value);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_GetCacheName(this.getHandle());
        }
        return CacheBuilderSCI3DNative.jni_GetCacheName2(this.m_pUGGlobalImageBuilder);
    }

    public void setCacheName(String value) {
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetCacheName(this.getHandle(), this.m_pUGGlobalImageBuilder, value);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        l = this.m_isLocalTile ? CacheBuilderSCI3DNative.jni_GetClipRegion(this.getHandle()) : CacheBuilderSCI3DNative.jni_GetClipRegion2(this.m_pUGGlobalImageBuilder);
        if (this.m_region == null) {
            if (l != 0L) {
                this.m_region = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this.m_region, false);
                if (this.m_region.isEmpty()) {
                    this.m_region = null;
                }
            }
        } else {
            InternalGeoRegion.clearHandle(this.m_region);
            InternalGeoRegion.refreshHandle(this.m_region, l);
        }
        return this.m_region;
    }

    public void setClipRegion(GeoRegion clipRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (clipRegion == null) {
            CacheBuilderSCI3DNative.jni_SetClipRegion(this.getHandle(), 0L, this.m_pUGGlobalImageBuilder);
            this.m_region = null;
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
                throw new IllegalArgumentException(string);
            }
            CacheBuilderSCI3DNative.jni_SetClipRegion(this.getHandle(), l, this.m_pUGGlobalImageBuilder);
        }
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
    }

    public boolean computeOutputScales() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        boolean bl = false;
        bl = this.m_isLocalTile ? CacheBuilderSCI3DNative.jni_ComputeOutputScales(this.getHandle()) : CacheBuilderSCI3DNative.jni_ComputeOutputScales2(this.m_pUGGlobalImageBuilder);
        return bl;
    }

    public double[] getDefaultOutputScales() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_GetDefaultOutputScales(this.getHandle());
        }
        return CacheBuilderSCI3DNative.jni_GetDefaultOutputScales2(this.m_pUGGlobalImageBuilder);
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        n = this.m_isLocalTile ? CacheBuilderSCI3DNative.jni_GetOutputScalesCount(this.getHandle()) : CacheBuilderSCI3DNative.jni_GetOutputScalesCount2(this.m_pUGGlobalImageBuilder);
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        if (this.m_isLocalTile) {
            CacheBuilderSCI3DNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        } else {
            CacheBuilderSCI3DNative.jni_GetOutputScaleCaptions2(this.m_pUGGlobalImageBuilder, dArray, stringArray);
        }
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public void setOutputScaleCaptions(HashMap<Double, String> scaleCaptions) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (scaleCaptions == null) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = scaleCaptions.size();
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        Set<Map.Entry<Double, String>> set = scaleCaptions.entrySet();
        Iterator<Map.Entry<Double, String>> iterator = set.iterator();
        Map.Entry<Double, String> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            stringArray[i] = entry.getValue();
        }
        if (this.m_isLocalTile) {
            CacheBuilderSCI3DNative.jni_SetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        } else {
            CacheBuilderSCI3DNative.jni_SetOutputScaleCaptions2(this.m_pUGGlobalImageBuilder, dArray, stringArray);
        }
    }

    public double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_GetOutputScales(this.getHandle());
        }
        double[] dArray = null;
        return dArray;
    }

    public void setOutputScales(double[] values) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (values == null) {
            return;
        }
        if (this.m_isLocalTile && !CacheBuilderSCI3DNative.jni_SetOutputScales(this.getHandle(), values)) {
            String string = InternalResource.loadString("ImageCacheBuilder", "CacheBuilder_IllegalScales", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return 0;
        }
        return CacheBuilderSCI3DNative.jni_GetBeginLevel(this.m_pUGGlobalImageBuilder);
    }

    public void setBeginLevel(int beginLevel) {
        if (beginLevel < 0) {
            String string = InternalResource.loadString("beginLevel", "CacheBuilderSCI3D_BeginLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return;
        }
        CacheBuilderSCI3DNative.jni_SetBeginLevel(this.m_pUGGlobalImageBuilder, beginLevel);
    }

    public String getImageFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        if (imageFileName == null || imageFileName.trim().length() == 0) {
            String string = InternalResource.loadString("imageFileName", "CacheBuilderSCI3D_ImageFileNameShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_imageFileName = imageFileName;
        this.m_isDataset = false;
        CacheBuilderSCI3DNative.jni_SetImageFileName(this.getHandle(), imageFileName);
    }

    public CacheImageType getImageType() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        n = this.m_isLocalTile ? CacheBuilderSCI3DNative.jni_GetImageType(this.getHandle()) : CacheBuilderSCI3DNative.jni_GetImageType2(this.m_pUGGlobalImageBuilder);
        return (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
    }

    public void setImageType(CacheImageType imageType) {
        if (imageType == null) {
            String string = InternalResource.loadString("imageType", "CacheBuilderSCI3D_CacheImageTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetImageType(this.getHandle(), this.m_pUGGlobalImageBuilder, imageType.value());
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        n = this.m_isLocalTile ? CacheBuilderSCI3DNative.jni_GetStorageType(this.getHandle()) : CacheBuilderSCI3DNative.jni_GetStorageType2(this.m_pUGGlobalImageBuilder);
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (storageType == null) {
            String string = InternalResource.loadString("storageType", "CacheBuilderS_StorageTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetStorageType(this.getHandle(), this.m_pUGGlobalImageBuilder, storageType.value());
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return 0;
        }
        return CacheBuilderSCI3DNative.jni_GetEndLevel(this.m_pUGGlobalImageBuilder);
    }

    public void setEndLevel(int endLevel) {
        if (endLevel < 0) {
            String string = InternalResource.loadString("endLevel", "CacheBuilderSCI3D_EndLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return;
        }
        CacheBuilderSCI3DNative.jni_SetEndLevel(this.m_pUGGlobalImageBuilder, endLevel);
    }

    public int getDefaultBeginLevel() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return 0;
        }
        return CacheBuilderSCI3DNative.jni_GetDefaultBeginLevel(this.m_pUGGlobalImageBuilder);
    }

    public int getDefaultEndLevel() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return 0;
        }
        return CacheBuilderSCI3DNative.jni_GetDefaultEndLevel(this.m_pUGGlobalImageBuilder);
    }

    public int getSampleSize() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_GetSampleSize(this.getHandle());
        }
        return CacheBuilderSCI3DNative.jni_GetSampleSize2(this.m_pUGGlobalImageBuilder);
    }

    public void setSampleSize(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("sampleSize", "CacheBuilderSCI3D_SampleSizeShouldNotBeNegative", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        int n = CacheBuilderSCI3DNative.jni_GetSampleSize(this.getHandle());
        CacheBuilderSCI3DNative.jni_SetSampleSize(this.getHandle(), this.m_pUGGlobalImageBuilder, value);
        if (n != value) {
            this.computeOutputScales();
        }
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_password;
    }

    public void setPassword(String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_password = password;
    }

    public Colors getColorTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = CacheBuilderSCI3DNative.jni_GetColorTable(this.getHandle());
        if (this.m_colorTable != null && l != 0L && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_colorTable) != l) {
            InternalColors.changeHandle(this.m_colorTable, l);
        }
        return this.m_colorTable;
    }

    public void setColorTable(Colors colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorTable(Colors colorTable)()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Colors colors = new Colors(colorTable);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        CacheBuilderSCI3DNative.jni_SetColorTable(this.getHandle(), l);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
    }

    public double[] getGridValueTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridValueTable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_gridValueTable;
    }

    public void setGridValueTable(double[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridValueTable(double[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = (double[])value.clone();
        CacheBuilderSCI3DNative.jni_SetGridValueTable(this.getHandle(), dArray);
        this.m_gridValueTable = value;
    }

    public Color getSpecialValueColor() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        n = this.m_isLocalTile ? CacheBuilderSCI3DNative.jni_GetGridSpecialValueColor(this.getHandle()) : CacheBuilderSCI3DNative.jni_GetGridSpecialValueColor2(this.m_pUGGlobalImageBuilder);
        return new Color(n);
    }

    public void setSpecialValueColor(Color value) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = value.getRGB();
        CacheBuilderSCI3DNative.jni_SetGridSpecialValueColor(this.getHandle(), this.m_pUGGlobalImageBuilder, n);
    }

    public double getSpecialValue() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_GetGridSpecialValue(this.getHandle());
        }
        return CacheBuilderSCI3DNative.jni_GetGridSpecialValue2(this.m_pUGGlobalImageBuilder);
    }

    public void setSpecialValue(double value) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetGridSpecialValue(this.getHandle(), this.m_pUGGlobalImageBuilder, value);
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_IsSpecialValueTransparent(this.getHandle());
        }
        return CacheBuilderSCI3DNative.jni_IsSpecialValueTransparent2(this.m_pUGGlobalImageBuilder);
    }

    public void setSpecialValueTransparent(boolean transparent) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetSpecialValueTransparent(this.getHandle(), this.m_pUGGlobalImageBuilder, transparent);
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDynamicProjection()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        int n = CacheBuilderSCI3DNative.jni_GetDynamicPrjCoordSysType(this.getHandle());
        PrjCoordSysType prjCoordSysType = this.m_isLocalTile ? (n == 1 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH) : PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicProjection(boolean dynamicProjection)", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        if (this.m_isLocalTile) {
            int n = prjType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 1 : 0;
            CacheBuilderSCI3DNative.jni_SetDynamicPrjCoordSysType(this.getHandle(), n);
        }
    }

    public boolean build() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getBeginLevel() > this.getEndLevel()) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCI3D_EndLevelShouldNotLessThanBeginLevel", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_isLocalTile) {
            if (this.m_password == null || this.m_password.trim().length() == 0) {
                return CacheBuilderSCI3DNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
            }
            return CacheBuilderSCI3DNative.jni_BuildWithPassword(this.getHandle(), this.m_selfEventHandle, this.m_password);
        }
        return CacheBuilderSCI3DNative.jni_Build2(this.m_pUGGlobalImageBuilder, this.m_selfEventHandle, this.m_password);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getBeginLevel() > this.getEndLevel()) {
            String string = InternalResource.loadString("build(String password)", "CacheBuilderSCI3D_EndLevelShouldNotLessThanBeginLevel", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (this.m_isLocalTile) {
            bl = this.m_password == null || this.m_password.trim().length() == 0 ? CacheBuilderSCI3DNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle) : CacheBuilderSCI3DNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle, this.m_password);
        } else {
            return CacheBuilderSCI3DNative.jni_BuildWithoutConfigFile2(this.m_pUGGlobalImageBuilder, this.m_selfEventHandle, this.m_password);
        }
        ((Object)((Object)this)).hashCode();
        return bl;
    }

    public boolean computeLevel() {
        if (this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        return CacheBuilderSCI3DNative.jni_ComputeLevel(this.m_pUGGlobalImageBuilder);
    }

    @Deprecated
    public String[] computeImageFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset && (this.m_dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset) == 0L)) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCI3DNative.jni_ComputeImageFileName(this.getHandle());
        return InternalToolkitProcessing.splitString(string, ";");
    }

    @Deprecated
    public String[] computeImageFileName(int specialLevel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset && (this.m_dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset) == 0L)) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCI3DNative.jni_ComputeImageFileName(this.getHandle(), specialLevel);
        return InternalToolkitProcessing.splitString(string, ";");
    }

    public boolean toConfigFile(String fileName) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isDataset) {
            this.processDataset();
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_ToFile(this.getHandle(), fileName);
        }
        return CacheBuilderSCI3DNative.jni_ToFile2(this.m_pUGGlobalImageBuilder, fileName);
    }

    public boolean fromConfigFile(String fileName) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isLocalTile) {
            return CacheBuilderSCI3DNative.jni_FromFile(this.getHandle(), fileName);
        }
        return CacheBuilderSCI3DNative.jni_FromFile2(this.m_pUGGlobalImageBuilder, fileName);
    }

    public Tile[] getTiles(Rectangle2D tileBounds, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = null;
        if (this.m_isLocalTile) {
            Tiles tiles = null;
            long l = CacheBuilderSCI3DNative.jni_GetTiles(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), scale);
            tiles = new Tiles(l);
            tileArray = new Tile[tiles.getCount()];
            for (int i = 0; i < tiles.getCount(); ++i) {
                tileArray[i] = tiles.get(i);
            }
        }
        return tileArray;
    }

    public ImageTilingMode getTilingMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ImageTilingMode imageTilingMode = ImageTilingMode.LOCAL;
        imageTilingMode = this.m_isLocalTile ? ImageTilingMode.LOCAL : ImageTilingMode.GLOBAL;
        return imageTilingMode;
    }

    public void setTilingMode(ImageTilingMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.m_isLocalTile;
        if (value == ImageTilingMode.GLOBAL) {
            this.m_isLocalTile = false;
        } else if (value == ImageTilingMode.LOCAL) {
            this.m_isLocalTile = true;
        }
        if (bl != this.m_isLocalTile) {
            this.computeOutputScales();
        }
    }

    public DatasetVolume getDatasetVolume() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetVolume datasetVolume = null;
        if (this.m_dataset != null && this.m_dataset instanceof DatasetVolume) {
            datasetVolume = (DatasetVolume)this.m_dataset;
        }
        return datasetVolume;
    }

    public void setDatasetVolume(DatasetVolume value) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_dataset = value;
        this.m_isDataset = true;
    }

    public DatasetMosaic getDatasetMosaic() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetMosaic datasetMosaic = null;
        if (this.m_dataset != null && this.m_dataset instanceof DatasetMosaic) {
            datasetMosaic = (DatasetMosaic)this.m_dataset;
        }
        return datasetMosaic;
    }

    public void setDatasetMosaic(DatasetMosaic value) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("ImageCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_dataset = value;
        this.m_isDataset = true;
        this.m_pUGGlobalImageBuilder = CacheBuilderSCI3DNative.jni_UpdateGlobalImage(this.m_pUGGlobalImageBuilder);
    }

    public boolean SciConfigFileToSci3DConfigFile(String sciSourcePath, String outPutFileName, String password) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("SciConfigFileToSci3DConfigFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_SciToSci3d(this.m_pUGGlobalImageBuilder, sciSourcePath, outPutFileName, password);
    }

    public byte[] extractFilesFromSciCache(String[] sourceFileNames) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("extractFilesFromSciCache", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_ExtractCacheFiles(this.m_pUGGlobalImageBuilder, sourceFileNames);
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("getProcessThreadsCount", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetProcessThreadsCount2(this.m_pUGGlobalImageBuilder);
    }

    public void setProcessThreadsCount(int threadsCount) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("setProcessThreadsCount", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetProcessThreadsCount2(this.m_pUGGlobalImageBuilder, threadsCount);
    }

    public int getBlockScale() {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("getBlockScale", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetBlockScale2(this.m_pUGGlobalImageBuilder);
    }

    public void setBlockScale(int blockScale) {
        if (this.getHandle() == 0L && this.m_pUGGlobalImageBuilder == 0L) {
            String string = InternalResource.loadString("setBlockScale", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetBlockScale2(this.m_pUGGlobalImageBuilder, blockScale);
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(ImageCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            CacheBuilderSCI3DNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    protected void clearHandle() {
        if (this.m_dataset != null) {
            this.m_dataset = null;
        }
        if (this.m_region != null) {
            InternalGeoRegion.clearHandle(this.m_region);
            this.m_region = null;
        }
        this.setHandle(0L);
        this.m_pUGGlobalImageBuilder = 0L;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderSCI3DNative.jni_Delete(this.getHandle(), this.m_pUGGlobalImageBuilder);
            this.clearHandle();
            this.clearSelfEventHandle();
        }
    }
}

