/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Enum;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Unit;
import com.supermap.data.processing.CacheTileParameter;
import com.supermap.data.processing.CacheWriterListener;
import com.supermap.data.processing.CompactTileParameter;
import com.supermap.data.processing.MapTilingMode;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class CacheWriter {
    private String m_cacheName = "Cache";
    private TileFormat m_tileFormat = TileFormat.JPG;
    private TileSize m_tileSize = TileSize.SIZE256;
    private String m_hashCode = "";
    private HashMap<Double, String> m_cacheScaleCaptions = new HashMap();
    private Double m_version = 5.1;
    private String m_providerURL = "";
    private PrjCoordSys m_prjCoordSys = null;
    private Color m_defaultColor = Color.white;
    private Boolean m_transparent = false;
    private int m_tileCompress = 100;
    private Boolean m_fillMargin = true;
    private StorageType m_tileStorageType = StorageType.Original;
    private MapTilingMode m_cacheMode = MapTilingMode.LOCAL;
    private Boolean m_hashCodeEnabled = false;
    private Double m_cacheDPI = 96.0;
    private Rectangle2D m_cacheBounds = new Rectangle2D();
    private Rectangle2D m_indexBounds = new Rectangle2D();
    private Rectangle2D m_dataBounds = new Rectangle2D();
    private String m_clipRegion = "";
    private String m_outputFolder;
    private ArrayList<CacheWriterListener> m_cacheWriterListener = new ArrayList();
    private String m_mongoSetting = "";
    private String m_gpkgSetting = "";
    private String m_versionSetting = "";
    private String m_versionDescription = "";
    private Boolean m_ignoreInvalidDrawing = false;
    private Boolean m_mvtStyleWithoutFont = false;
    private Boolean m_mvtWithAllField = false;
    private int m_mvtTilebuffer = 16;
    private int m_mvtTileExtent = 4096;
    private Boolean m_mvtWithoutFilter = false;
    private Boolean m_mvtSimplifyGeometry = true;
    private Boolean m_mvtTriangleList = false;
    private String m_cacheSources = "";
    private Boolean m_buildFromOriginalResolution = false;
    private Double m_scaleOriginalResolution = 0.0;

    public String getCacheName() {
        return this.m_cacheName;
    }

    public void setCacheName(String name) {
        this.m_cacheName = name;
    }

    public TileFormat getTileFormat() {
        return this.m_tileFormat;
    }

    public void setTileFormat(TileFormat tileFormat) {
        this.m_tileFormat = tileFormat;
    }

    public TileSize getTileSize() {
        return this.m_tileSize;
    }

    public void setTileSize(TileSize tileSize) {
        this.m_tileSize = tileSize;
    }

    public String getHashCode() {
        return this.m_hashCode;
    }

    public void setHashCode(String hashCode) {
        this.m_hashCode = hashCode;
    }

    public HashMap<Double, String> getCacheScaleCaptions() {
        return this.m_cacheScaleCaptions;
    }

    public void setCacheScaleCaptions(HashMap<Double, String> newScaleCaptions) {
        this.m_cacheScaleCaptions = newScaleCaptions;
    }

    public void setCacheScaleCaptions(Double[] scales) {
        this.m_cacheScaleCaptions.clear();
        for (Double d : scales) {
            if (this.m_cacheScaleCaptions.containsKey(d)) continue;
            this.m_cacheScaleCaptions.put(d, String.valueOf(Math.round(1.0 / d)));
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        return this.m_prjCoordSys;
    }

    public void setPrjCoordSys(PrjCoordSys projCoordSys) {
        this.m_prjCoordSys = projCoordSys;
    }

    public double getDPI() {
        return this.m_cacheDPI;
    }

    public void setDPI(double dpi) {
        this.m_cacheDPI = dpi;
    }

    public StorageType getStorageType() {
        return this.m_tileStorageType;
    }

    public void setStorageType(StorageType storageType) {
        this.m_tileStorageType = storageType;
    }

    public Rectangle2D getCacheBounds() {
        return this.m_cacheBounds;
    }

    public void setCacheBounds(Rectangle2D bounds) {
        this.m_cacheBounds = bounds;
    }

    public Rectangle2D getIndexBounds() {
        return this.m_indexBounds;
    }

    public void setIndexBounds(Rectangle2D bounds) {
        this.m_indexBounds = bounds;
    }

    public String getOutputFolder() {
        return this.m_outputFolder;
    }

    public void setOutputFolder(String folder) {
        this.m_outputFolder = folder;
    }

    public Boolean getTransparent() {
        return this.m_transparent;
    }

    public void setTransparent(Boolean transparent) {
        this.m_transparent = transparent;
    }

    public String getProvider() {
        return this.m_providerURL;
    }

    public void setProvider(String provider) {
        this.m_providerURL = provider;
    }

    public String[] getMongoConnectionInfo() {
        if (!this.m_mongoSetting.isEmpty()) {
            String[] stringArray = new String[]{this.getXmlContext(this.m_mongoSetting, "Server", true), this.getXmlContext(this.m_mongoSetting, "Database", true), this.getXmlContext(this.m_mongoSetting, "Name", true)};
            return stringArray;
        }
        return null;
    }

    public String[] getGPKGConnectionInfo() {
        if (!this.m_gpkgSetting.isEmpty()) {
            String[] stringArray = new String[]{this.getXmlContext(this.m_gpkgSetting, "Server", true)};
            return stringArray;
        }
        return null;
    }

    public String getVersionSetting() {
        return this.m_versionSetting;
    }

    public String getVersionDescription() {
        return this.m_versionDescription;
    }

    public Boolean getMvtStyleWithoutFont() {
        return this.m_mvtStyleWithoutFont;
    }

    public void setMvtStyleWithoutFont(Boolean value) {
        this.m_mvtStyleWithoutFont = value;
    }

    public Boolean getMvtWithAllField() {
        return this.m_mvtWithAllField;
    }

    public void setMvtWithAllField(Boolean value) {
        this.m_mvtWithAllField = value;
    }

    public int getMvtTileBuffer() {
        return this.m_mvtTilebuffer;
    }

    public void setMvtTileBuffer(int value) {
        this.m_mvtTilebuffer = value;
    }

    public int getMvtTileExtent() {
        return this.m_mvtTileExtent;
    }

    public void setMvtTileExtent(int value) {
        this.m_mvtTileExtent = value;
    }

    public boolean getMvtTriangleList() {
        return this.m_mvtTriangleList;
    }

    public Boolean isbuildFromOriginalResolution() {
        return this.m_buildFromOriginalResolution;
    }

    public void addCacheWriterListener(CacheWriterListener listener) {
        if (!this.m_cacheWriterListener.contains(listener)) {
            this.m_cacheWriterListener.add(listener);
        }
    }

    public void removeCacheWriterListener(CacheWriterListener listener) {
        this.m_cacheWriterListener.remove(listener);
    }

    void fireCacheWriterListener(CacheTileParameter cacheTile, CompactTileParameter compactTile) {
        for (CacheWriterListener cacheWriterListener : this.m_cacheWriterListener) {
            cacheWriterListener.writTile(cacheTile, compactTile);
        }
    }

    public void writeTile(CacheTileParameter cacheTile, CompactTileParameter compactTile) {
        this.fireCacheWriterListener(cacheTile, compactTile);
    }

    public Boolean Build() throws Exception {
        Boolean bl;
        File file = new File(this.m_outputFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (this.m_outputFolder.isEmpty()) {
            return false;
        }
        file = new File(this.m_outputFolder + "/" + this.m_cacheName + "/" + this.parseTileFormat(this.m_tileFormat) + "_" + this.m_tileSize.value() + "_" + this.m_hashCode);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(bl = Boolean.valueOf((bl = this.ToConfigFile(this.m_outputFolder + "/" + this.m_cacheName + "/" + this.m_cacheName + ".sci")) != false && this.ToConfigFile(file.getPath() + "/" + this.m_cacheName + ".inf") != false)).booleanValue()) {
            return false;
        }
        for (double d : this.m_cacheScaleCaptions.keySet()) {
            double d2 = this.getTileResolustion(d);
            int n = (int)Math.floor((this.m_cacheBounds.getLeft() - this.m_indexBounds.getLeft()) / d2);
            int n2 = (int)Math.floor(-((this.m_cacheBounds.getTop() - this.m_indexBounds.getTop()) / d2));
            int n3 = (int)Math.floor((this.m_cacheBounds.getRight() - this.m_indexBounds.getLeft()) / d2);
            int n4 = (int)Math.floor(-((this.m_cacheBounds.getBottom() - this.m_indexBounds.getTop()) / d2));
            for (int i = n2; i <= n4; ++i) {
                for (int j = n; j <= n3; ++j) {
                    Rectangle2D rectangle2D = new Rectangle2D(this.m_indexBounds.getLeft() + (double)j * d2, this.m_indexBounds.getTop() - (double)(i + 1) * d2, this.m_indexBounds.getLeft() + (double)(j + 1) * d2, this.m_indexBounds.getTop() - (double)i * d2);
                    String string = this.getTilePath(d, i, j);
                    CacheTileParameter cacheTileParameter = new CacheTileParameter(d, i, j, rectangle2D, string);
                    CompactTileParameter compactTileParameter = null;
                    if (this.m_tileStorageType == StorageType.Compact) {
                        compactTileParameter = new CompactTileParameter(i % 128, j % 128);
                    }
                    this.writeTile(cacheTileParameter, compactTileParameter);
                }
            }
        }
        return true;
    }

    public double getReolustion(double scale) {
        double d = this.AdjustUnitsRatio();
        double d2 = 1.0 / (scale * this.m_cacheDPI / 254.0);
        return d2 /= d;
    }

    public double getTileResolustion(double scale) {
        return this.getReolustion(scale) * (double)this.m_tileSize.value();
    }

    public double AdjustUnitsRatio() {
        double d = 0.0;
        d = this.m_prjCoordSys.getCoordUnit().equals((Object)Unit.DEGREE) ? this.m_prjCoordSys.getGeoCoordSys().getGeoDatum().getGeoSpheroid().getAxis() * (double)(this.m_prjCoordSys.getCoordUnit().value() - 1000000000) * 10000.0 * Math.PI / 3.1415922E8 : (double)this.m_prjCoordSys.getCoordUnit().value();
        return d;
    }

    public String getTilePath(Double scale, int row, int col) {
        if (scale <= 0.0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_outputFolder);
        if (!this.m_outputFolder.endsWith("/") && !this.m_outputFolder.endsWith("\\")) {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.m_cacheName);
        stringBuilder.append("/");
        stringBuilder.append(this.parseTileFormat(this.m_tileFormat));
        stringBuilder.append("_");
        stringBuilder.append(this.m_tileSize.value());
        stringBuilder.append("_");
        stringBuilder.append(this.m_hashCode);
        stringBuilder.append("/");
        Double d = 0.0;
        for (Double d2 : this.m_cacheScaleCaptions.keySet()) {
            if (!(Math.abs(d2 - scale) < 1.0E-15)) continue;
            d = d2;
            break;
        }
        if (!d.equals(0.0)) {
            stringBuilder.append(this.m_cacheScaleCaptions.get(d));
        } else {
            stringBuilder.append(Math.round(1.0 / scale));
        }
        stringBuilder.append("/");
        int n = row < 0 ? row / 128 - 1 : row / 128;
        stringBuilder.append(n);
        stringBuilder.append("/");
        n = col < 0 ? col / 128 - 1 : col / 128;
        stringBuilder.append(n);
        if (this.m_tileStorageType == StorageType.Original) {
            stringBuilder.append("/");
            stringBuilder.append(row);
            stringBuilder.append("x");
            stringBuilder.append(col);
            stringBuilder.append(this.getTileExtension(this.m_tileFormat));
        } else {
            stringBuilder.append(".cf");
        }
        return stringBuilder.toString();
    }

    public Boolean ToConfigFile(String fileName) throws Exception {
        this.m_dataBounds = this.m_cacheBounds;
        if (this.m_indexBounds.isEmpty()) {
            this.m_indexBounds = this.m_cacheBounds;
        }
        return !this.m_cacheName.isEmpty() && this.m_prjCoordSys != null && this.m_cacheDPI > 0.0 && !this.m_cacheBounds.isEmpty() && this.ToConfig(fileName) != false;
    }

    private Boolean ToConfig(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                boolean bl = file.createNewFile();
                if (!bl) {
                    return false;
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                return false;
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            String string = System.getProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuilder.append(string);
            stringBuilder.append("<SuperMapCache>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Version>");
            stringBuilder.append(String.format("%d.0", (int)(this.m_version * 10.0) / 10));
            stringBuilder.append("</sml:Version>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MinorVersion>");
            stringBuilder.append(String.valueOf((int)(this.m_version * 10.0) % 10));
            stringBuilder.append("</sml:MinorVersion>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:VersionRequired>");
            stringBuilder.append(String.format("%d.0", (int)(this.m_version * 10.0) / 10));
            stringBuilder.append("</sml:VersionRequired>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:CacheName>");
            stringBuilder.append(this.m_cacheName);
            stringBuilder.append("</sml:CacheName>");
            stringBuilder.append(string);
            if (this.m_providerURL.isEmpty()) {
                stringBuilder.append("<sml:Provider/>");
            } else {
                stringBuilder.append("<sml:Provider>");
                stringBuilder.append(this.m_providerURL);
                stringBuilder.append("</sml:Provider>");
            }
            stringBuilder.append(string);
            stringBuilder.append("<sml:MapName>");
            stringBuilder.append(this.m_cacheName);
            stringBuilder.append("</sml:MapName>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:HashCode>");
            stringBuilder.append(this.m_hashCode);
            stringBuilder.append("</sml:HashCode>");
            stringBuilder.append(string);
            stringBuilder.append(this.m_prjCoordSys.toXML(20031211));
            stringBuilder.append("<sml:ImageType>");
            stringBuilder.append((Object)this.m_tileFormat);
            stringBuilder.append("</sml:ImageType>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:DefaultColor>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Red>");
            stringBuilder.append(String.format("0x%X", this.m_defaultColor.getRed()));
            stringBuilder.append("</sml:Red>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Green>");
            stringBuilder.append(String.format("0x%X", this.m_defaultColor.getGreen()));
            stringBuilder.append("</sml:Green>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Blue>");
            stringBuilder.append(String.format("0x%X", this.m_defaultColor.getBlue()));
            stringBuilder.append("</sml:Blue>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Alpha>");
            stringBuilder.append(String.format("0x%X", this.m_defaultColor.getAlpha()));
            stringBuilder.append("</sml:Alpha>");
            stringBuilder.append(string);
            stringBuilder.append("</sml:DefaultColor>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Transparent>");
            stringBuilder.append(this.m_transparent.toString().toUpperCase());
            stringBuilder.append("</sml:Transparent>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:ImageCompress>");
            stringBuilder.append(this.m_tileCompress);
            stringBuilder.append("</sml:ImageCompress>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:FillMargin>");
            stringBuilder.append(this.m_fillMargin.toString().toUpperCase());
            stringBuilder.append("</sml:FillMargin>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:StorageType>");
            stringBuilder.append((Object)this.m_tileStorageType);
            stringBuilder.append("</sml:StorageType>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:TileType>");
            stringBuilder.append((Object)this.m_cacheMode);
            stringBuilder.append("</sml:TileType>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:HashCodeEnabled>");
            stringBuilder.append(this.m_hashCodeEnabled.toString().toUpperCase());
            stringBuilder.append("</sml:HashCodeEnabled>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:ImageSize>");
            stringBuilder.append(this.m_tileSize.value());
            stringBuilder.append("</sml:ImageSize>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Bounds>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Left>");
            stringBuilder.append(this.m_cacheBounds.getLeft());
            stringBuilder.append("</sml:Left>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Top>");
            stringBuilder.append(this.m_cacheBounds.getTop());
            stringBuilder.append("</sml:Top>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Right>");
            stringBuilder.append(this.m_cacheBounds.getRight());
            stringBuilder.append("</sml:Right>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Bottom>");
            stringBuilder.append(this.m_cacheBounds.getBottom());
            stringBuilder.append("</sml:Bottom>");
            stringBuilder.append(string);
            stringBuilder.append("</sml:Bounds>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:CoordRatio>");
            stringBuilder.append(String.valueOf(this.m_cacheDPI / 25.4));
            stringBuilder.append("</sml:CoordRatio>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:IndexBounds>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Left>");
            stringBuilder.append(this.m_indexBounds.getLeft());
            stringBuilder.append("</sml:Left>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Top>");
            stringBuilder.append(this.m_indexBounds.getTop());
            stringBuilder.append("</sml:Top>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Right>");
            stringBuilder.append(this.m_indexBounds.getRight());
            stringBuilder.append("</sml:Right>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Bottom>");
            stringBuilder.append(this.m_indexBounds.getBottom());
            stringBuilder.append("</sml:Bottom>");
            stringBuilder.append(string);
            stringBuilder.append("</sml:IndexBounds>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MapBounds>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Left>");
            stringBuilder.append(this.m_dataBounds.getLeft());
            stringBuilder.append("</sml:Left>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Top>");
            stringBuilder.append(this.m_dataBounds.getTop());
            stringBuilder.append("</sml:Top>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Right>");
            stringBuilder.append(this.m_dataBounds.getRight());
            stringBuilder.append("</sml:Right>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Bottom>");
            stringBuilder.append(this.m_dataBounds.getBottom());
            stringBuilder.append("</sml:Bottom>");
            stringBuilder.append(string);
            stringBuilder.append("</sml:MapBounds>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:Scales>");
            stringBuilder.append(string);
            Set<Double> set = this.m_cacheScaleCaptions.keySet();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.addAll(set);
            Collections.sort(arrayList);
            for (Double d : arrayList) {
                stringBuilder.append("<sml:Scale>");
                stringBuilder.append(string);
                stringBuilder.append("<sml:Value>");
                stringBuilder.append(d);
                stringBuilder.append("</sml:Value>");
                stringBuilder.append(string);
                stringBuilder.append("<sml:Caption>");
                stringBuilder.append(this.m_cacheScaleCaptions.get(d));
                stringBuilder.append("</sml:Caption>");
                stringBuilder.append(string);
                stringBuilder.append("</sml:Scale>");
                stringBuilder.append(string);
            }
            stringBuilder.append("</sml:Scales>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:ClipRegion>");
            stringBuilder.append(this.m_clipRegion);
            stringBuilder.append("</sml:ClipRegion>");
            stringBuilder.append(string);
            if (!this.m_mongoSetting.isEmpty()) {
                stringBuilder.append("<sml:MongoSetting>");
                stringBuilder.append(this.m_mongoSetting);
                stringBuilder.append("</sml:MongoSetting>");
                stringBuilder.append(string);
                stringBuilder.append("<sml:VersionSetting>");
                stringBuilder.append(this.m_versionSetting);
                stringBuilder.append("</sml:VersionSetting>");
                stringBuilder.append(string);
                stringBuilder.append("<sml:VersionDescription>");
                stringBuilder.append(this.m_versionDescription);
                stringBuilder.append("</sml:VersionDescription>");
                stringBuilder.append(string);
            }
            if (!this.m_gpkgSetting.isEmpty()) {
                stringBuilder.append("<sml:GPKGSetting>");
                stringBuilder.append(this.m_gpkgSetting);
                stringBuilder.append("</sml:GPKGSetting>");
                stringBuilder.append(string);
            }
            stringBuilder.append("<sml:IgnoreInvalidDrawing>");
            stringBuilder.append(this.m_ignoreInvalidDrawing.toString().toUpperCase());
            stringBuilder.append("</sml:IgnoreInvalidDrawing>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTStyleWithoutFont>");
            stringBuilder.append(this.m_mvtStyleWithoutFont.toString().toUpperCase());
            stringBuilder.append("</sml:MVTStyleWithoutFont>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTWithAllField>");
            stringBuilder.append(this.m_mvtWithAllField.toString().toUpperCase());
            stringBuilder.append("</sml:MVTWithAllField>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTTileBuffer>");
            stringBuilder.append(this.m_mvtTilebuffer);
            stringBuilder.append("</sml:MVTTileBuffer>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTTileExtent>");
            stringBuilder.append(this.m_mvtTileExtent);
            stringBuilder.append("</sml:MVTTileExtent>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTWithoutFilter>");
            stringBuilder.append(this.m_mvtWithoutFilter);
            stringBuilder.append("</sml:MVTWithoutFilter>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTSimplifyGeometry>");
            stringBuilder.append(this.m_mvtSimplifyGeometry);
            stringBuilder.append("</sml:MVTSimplifyGeometry>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:MVTTriangleList>");
            stringBuilder.append(this.m_mvtTriangleList);
            stringBuilder.append("</sml:MVTTriangleList>");
            stringBuilder.append(string);
            if (!this.m_cacheSources.isEmpty()) {
                stringBuilder.append("<sml:MVTCacheSources>");
                stringBuilder.append(this.m_cacheSources);
                stringBuilder.append("</sml:MVTCacheSources>");
                stringBuilder.append(string);
            }
            stringBuilder.append("<sml:BuildFromOriginalResolution>");
            stringBuilder.append(this.m_buildFromOriginalResolution);
            stringBuilder.append("</sml:BuildFromOriginalResolution>");
            stringBuilder.append(string);
            stringBuilder.append("<sml:ScaleOriginalResolution>");
            stringBuilder.append(this.m_scaleOriginalResolution);
            stringBuilder.append("</sml:ScaleOriginalResolution>");
            stringBuilder.append(string);
            stringBuilder.append("</SuperMapCache>");
            fileOutputStream.write(stringBuilder.toString().getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean FromConfigFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return false;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Object object;
            byte[] byArray = new byte[(int)file.length()];
            String string = "";
            if (fileInputStream.read(byArray) > 0) {
                string = new String(byArray, "UTF-8");
            }
            if (!string.contains("<SuperMapCache>")) {
                Boolean bl = false;
                return bl;
            }
            String string2 = this.getXmlContext(string, "sml:Version", true);
            if (Double.valueOf(string2) != 5.0) {
                Boolean bl = false;
                return bl;
            }
            this.m_version = 5.1;
            this.m_cacheName = string2 = this.getXmlContext(string, "sml:CacheName", true);
            string2 = this.getXmlContext(string, "sml:Provider", true);
            if (!string2.isEmpty()) {
                this.m_providerURL = string2;
            }
            this.m_hashCode = string2 = this.getXmlContext(string, "sml:HashCode", true);
            string2 = this.getXmlContext(string, "sml:CoordinateReferenceSystem", false);
            if (this.m_prjCoordSys == null) {
                this.m_prjCoordSys = new PrjCoordSys();
            }
            if (!this.m_prjCoordSys.fromXML(string2, 20031211)) {
                Boolean bl = false;
                return bl;
            }
            string2 = this.getXmlContext(string, "sml:ImageType", true);
            this.m_tileFormat = (TileFormat)Enum.parse(((Object)((Object)this.m_tileFormat)).getClass(), (String)string2);
            string2 = this.getXmlContext(string, "sml:DefaultColor", true);
            String string3 = this.getXmlContext(string2, "sml:Red", true);
            int n = Integer.valueOf(string3.replaceAll("0x", ""), 16);
            string3 = this.getXmlContext(string2, "sml:Green", true);
            int n2 = Integer.valueOf(string3.replaceAll("0x", ""), 16);
            string3 = this.getXmlContext(string2, "sml:Blue", true);
            int n3 = Integer.valueOf(string3.replaceAll("0x", ""), 16);
            string3 = this.getXmlContext(string2, "sml:Alpha", true);
            int n4 = Integer.valueOf(string3.replaceAll("0x", ""), 16);
            this.m_defaultColor = new Color(n, n2, n3, n4);
            string2 = this.getXmlContext(string, "sml:Transparent", true);
            this.m_transparent = Boolean.valueOf(string2);
            string2 = this.getXmlContext(string, "sml:ImageCompress", true);
            this.m_tileCompress = Integer.valueOf(string2);
            string2 = this.getXmlContext(string, "sml:FillMargin", true);
            this.m_fillMargin = Boolean.valueOf(string2);
            string2 = this.getXmlContext(string, "sml:StorageType", true);
            this.m_tileStorageType = (StorageType)Enum.parse(((Object)((Object)this.m_tileStorageType)).getClass(), (String)string2);
            string2 = this.getXmlContext(string, "sml:TileType", true);
            this.m_cacheMode = (MapTilingMode)Enum.parse(((Object)((Object)this.m_cacheMode)).getClass(), (String)string2);
            string2 = this.getXmlContext(string, "sml:HashCodeEnabled", true);
            this.m_hashCodeEnabled = Boolean.valueOf(string2);
            string2 = this.getXmlContext(string, "sml:ImageSize", true);
            this.m_tileSize = (TileSize)Enum.parse(((Object)((Object)this.m_tileSize)).getClass(), (int)Integer.valueOf(string2));
            string2 = this.getXmlContext(string, "sml:Bounds", true);
            string3 = this.getXmlContext(string2, "sml:Left", true);
            Double d = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Top", true);
            Double d2 = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Right", true);
            Double d3 = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Bottom", true);
            Double d4 = Double.valueOf(string3);
            this.m_cacheBounds = new Rectangle2D(d.doubleValue(), d4.doubleValue(), d3.doubleValue(), d2.doubleValue());
            string2 = this.getXmlContext(string, "sml:CoordRatio", true);
            this.m_cacheDPI = Double.valueOf(string2) * 25.4;
            string2 = this.getXmlContext(string, "sml:IndexBounds", true);
            string3 = this.getXmlContext(string2, "sml:Left", true);
            d = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Top", true);
            d2 = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Right", true);
            d3 = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Bottom", true);
            d4 = Double.valueOf(string3);
            this.m_indexBounds = new Rectangle2D(d.doubleValue(), d4.doubleValue(), d3.doubleValue(), d2.doubleValue());
            string2 = this.getXmlContext(string, "sml:MapBounds", true);
            string3 = this.getXmlContext(string2, "sml:Left", true);
            d = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Top", true);
            d2 = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Right", true);
            d3 = Double.valueOf(string3);
            string3 = this.getXmlContext(string2, "sml:Bottom", true);
            d4 = Double.valueOf(string3);
            this.m_dataBounds = new Rectangle2D(d.doubleValue(), d4.doubleValue(), d3.doubleValue(), d2.doubleValue());
            string2 = this.getXmlContext(string, "sml:Scales", true);
            this.m_cacheScaleCaptions.clear();
            while (string2.contains("sml:Scale")) {
                string3 = this.getXmlContext(string2, "sml:Scale", false);
                object = this.getXmlContext(string3, "sml:Value", true);
                Double d5 = Double.valueOf((String)object);
                String string4 = this.getXmlContext(string3, "sml:Caption", true);
                if (!this.m_cacheScaleCaptions.containsKey(d5)) {
                    this.m_cacheScaleCaptions.put(d5, string4);
                }
                string2 = string2.replaceAll(string3, "");
            }
            string2 = this.getXmlContext(string, "sml:ClipRegion", true);
            if (!string2.isEmpty()) {
                this.m_clipRegion = string2;
            }
            if (!(string2 = this.getXmlContext(string, "sml:MongoSetting", true)).isEmpty()) {
                this.m_mongoSetting = string2;
            }
            if (!(string2 = this.getXmlContext(string, "sml:GPKGSetting", true)).isEmpty()) {
                this.m_gpkgSetting = string2;
            }
            if (!(string2 = this.getXmlContext(string, "sml:VersionSetting", true)).isEmpty()) {
                this.m_versionSetting = string2;
            }
            if (!(string2 = this.getXmlContext(string, "sml:VersionDescription", true)).isEmpty()) {
                this.m_versionDescription = string2;
            }
            if (!(string2 = this.getXmlContext(string, "sml:IgnoreInvalidDrawing", true)).isEmpty()) {
                this.m_ignoreInvalidDrawing = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTStyleWithoutFont", true)).isEmpty()) {
                this.m_mvtStyleWithoutFont = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTWithAllField", true)).isEmpty()) {
                this.m_mvtWithAllField = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTTileBuffer", true)).isEmpty()) {
                this.m_mvtTilebuffer = Integer.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTTileExtent", true)).isEmpty()) {
                this.m_mvtTileExtent = Integer.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTWithoutFilter", true)).isEmpty()) {
                this.m_mvtWithoutFilter = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTSimplifyGeometry", true)).isEmpty()) {
                this.m_mvtSimplifyGeometry = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTTriangleList", true)).isEmpty()) {
                this.m_mvtTriangleList = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:MVTCacheSources", true)).isEmpty()) {
                this.m_cacheSources = string2;
            }
            if (!(string2 = this.getXmlContext(string, "sml:BuildFromOriginalResolution", true)).isEmpty()) {
                this.m_buildFromOriginalResolution = Boolean.valueOf(string2);
            }
            if (!(string2 = this.getXmlContext(string, "sml:ScaleOriginalResolution", true)).isEmpty()) {
                this.m_scaleOriginalResolution = Double.valueOf(string2);
            }
            object = true;
            return object;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    private String getXmlContext(String source, String element, Boolean inner) {
        if (source.isEmpty() || element.isEmpty()) {
            return "";
        }
        String string = "<" + element + ">";
        String string2 = "</" + element + ">";
        int n = source.indexOf(string);
        if (n < 0) {
            return "";
        }
        int n2 = source.indexOf(string2, n);
        if (n2 < 0 || n2 <= n) {
            return "";
        }
        if (inner.booleanValue()) {
            return source.substring(n + string.length(), n2);
        }
        return source.substring(n, n2 + string2.length());
    }

    public String parseTileFormat() {
        return this.parseTileFormat(this.m_tileFormat);
    }

    private String parseTileFormat(TileFormat format) {
        String string = "";
        switch (format.value()) {
            case 122: {
                string = "J";
                break;
            }
            case 123: {
                string = "P";
                break;
            }
            case 124: {
                string = "G";
                break;
            }
            case 147: {
                string = "JP";
                break;
            }
            case 517: {
                string = "WP";
                break;
            }
            case 8888: {
                string = "P8";
                break;
            }
        }
        return string;
    }

    private String getTileExtension(TileFormat format) {
        String string = "";
        switch (format.value()) {
            case 122: 
            case 147: {
                string = ".jpg";
                break;
            }
            case 123: 
            case 8888: {
                string = ".png";
                break;
            }
            case 124: {
                string = ".gif";
                break;
            }
            case 517: {
                string = ".webp";
                break;
            }
        }
        return string;
    }
}

