/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingUSGSDEMNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingUSGSDEM
extends ImportSetting {
    public ImportSettingUSGSDEM() {
        long l = ImportSettingUSGSDEMNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.RASTER);
    }

    public ImportSettingUSGSDEM(ImportSettingUSGSDEM importSettingUSGSDEM) {
        if (importSettingUSGSDEM == null) {
            String string = InternalResource.loadString("importSettingUSGSDEM", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingUSGSDEM);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingUSGSDEM", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingUSGSDEMNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingUSGSDEM.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingUSGSDEM.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingUSGSDEM.getTargetPrjCoordSys());
        super.setDataType(DataType.RASTER);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingUSGSDEM));
    }

    public ImportSettingUSGSDEM(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public ImportSettingUSGSDEM(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public boolean isPyramidBuilt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPyramidBuilt()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingUSGSDEMNative.jni_IsPyramidBuilt(this.getHandle());
    }

    public void setPyramidBuilt(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPyramidBuilt(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingUSGSDEMNative.jni_SetPyramidBuilt(this.getHandle(), value);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingUSGSDEMNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingUSGSDEMNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingUSGSDEMNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingUSGSDEMNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] ignoreValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (ignoreValues == null) {
            ignoreValues = new double[]{};
        }
        ImportSettingUSGSDEMNative.jni_SetIgnoreValues(this.getHandle(), ignoreValues);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingUSGSDEMNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

