/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Charset;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfoNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalFieldInfo;
import com.supermap.data.conversion.InternalHandle;
import com.supermap.data.conversion.InternalResource;
import java.util.ArrayList;
import java.util.HashMap;

public class ImportDataInfo
extends InternalHandle {
    private String m_filePath;
    private FileType m_fileType;
    FieldInfos m_sourceFieldInfos;
    FieldInfos m_targetFieldInfos;
    HashMap<String, String> m_dictTargetFieldNames;
    ArrayList<Integer> m_importFieldState;
    HashMap<Integer, String> m_changeName;
    HashMap<Integer, FieldType> m_changeFieldType;
    ArrayList<Integer> m_sourceIndex;
    ArrayList<Integer> m_targetIndex;

    protected ImportDataInfo() {
    }

    ImportDataInfo(long handle, String filePath, FileType fileType, String targetName) {
        this.setHandle(handle);
        this.m_filePath = filePath;
        this.m_fileType = fileType;
        if (this.m_fileType.equals((Object)FileType.MIF) || this.m_fileType.equals((Object)FileType.TAB) || this.m_fileType.equals((Object)FileType.DXF) || this.m_fileType.equals((Object)FileType.DWG) || this.m_fileType.equals((Object)FileType.DGN) || this.m_fileType.equals((Object)FileType.VCT) || this.m_fileType.equals((Object)FileType.GJB5068) || this.m_fileType.equals((Object)FileType.GJB9121) || this.m_fileType.equals((Object)FileType.SHP) || this.m_fileType.equals((Object)FileType.COVERAGE) || this.m_fileType.equals((Object)FileType.TEMSBuildingVector) || this.m_fileType.equals((Object)FileType.TEMSVector) || this.m_fileType.equals((Object)FileType.TEMSTEXT) || this.m_fileType.equals((Object)FileType.ENCS57) || this.m_fileType.equals((Object)FileType.KML) || this.m_fileType.equals((Object)FileType.KMZ) || this.m_fileType.equals((Object)FileType.MAPGIS) || this.m_fileType.equals((Object)FileType.LIDAR) || this.m_fileType.equals((Object)FileType.SCV) || this.m_fileType.equals((Object)FileType.CSV) || this.m_fileType.equals((Object)FileType.GML) || this.m_fileType.equals((Object)FileType.E00) || this.m_fileType.equals((Object)FileType.SDEVector) || this.m_fileType.equals((Object)FileType.FileGDBVector) || this.m_fileType.equals((Object)FileType.DBF) || this.m_fileType.equals((Object)FileType.GeoPackage) || this.m_fileType.equals((Object)FileType.ORANGETAB) || this.m_fileType.equals((Object)FileType.GEOJSON) || this.m_fileType.equals((Object)FileType.OSM) || this.m_fileType.equals((Object)FileType.PersonalGDBVector)) {
            this.initSourceAndTargetFields();
            this.m_importFieldState = new ArrayList();
            this.m_changeName = new HashMap();
            this.m_sourceIndex = new ArrayList();
            this.m_targetIndex = new ArrayList();
            this.m_changeFieldType = new HashMap();
        }
    }

    private void initSourceAndTargetFields() {
        this.m_sourceFieldInfos = new FieldInfos();
        this.m_targetFieldInfos = new FieldInfos();
        this.m_dictTargetFieldNames = new HashMap();
        int n = ImportDataInfoNative.jni_GetFieldCount(this.getHandle());
        long[] lArray = new long[n];
        ImportDataInfoNative.jni_GetSourceFieldInfos(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = InternalFieldInfo.createInstance(lArray[i]);
            boolean bl = false;
            if (this.m_sourceFieldInfos.get(fieldInfo.getName()) == null) {
                bl = true;
            }
            if (fieldInfo.isSystemField() || fieldInfo.getName().toUpperCase().startsWith("SM") || !bl) continue;
            this.m_sourceFieldInfos.add(fieldInfo.clone());
            this.m_targetFieldInfos.add(fieldInfo.clone());
            this.m_dictTargetFieldNames.put(fieldInfo.getName(), fieldInfo.getName());
        }
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        if (this.m_fileType.equals((Object)FileType.MIF) || this.m_fileType.equals((Object)FileType.TAB) || this.m_fileType.equals((Object)FileType.DXF) || this.m_fileType.equals((Object)FileType.DWG) || this.m_fileType.equals((Object)FileType.SHP) || this.m_fileType.equals((Object)FileType.COVERAGE) || this.m_fileType.equals((Object)FileType.TEMSBuildingVector) || this.m_fileType.equals((Object)FileType.TEMSVector) || this.m_fileType.equals((Object)FileType.TEMSTEXT) || this.m_fileType.equals((Object)FileType.ENCS57) || this.m_fileType.equals((Object)FileType.KML) || this.m_fileType.equals((Object)FileType.KMZ) || this.m_fileType.equals((Object)FileType.MAPGIS) || this.m_fileType.equals((Object)FileType.LIDAR) || this.m_fileType.equals((Object)FileType.SCV) || this.m_fileType.equals((Object)FileType.CSV) || this.m_fileType.equals((Object)FileType.GML) || this.m_fileType.equals((Object)FileType.E00) || this.m_fileType.equals((Object)FileType.SDEVector) || this.m_fileType.equals((Object)FileType.FileGDBVector) || this.m_fileType.equals((Object)FileType.VCT) || this.m_fileType.equals((Object)FileType.GJB5068) || this.m_fileType.equals((Object)FileType.GJB9121) || this.m_fileType.equals((Object)FileType.DGN) || this.m_fileType.equals((Object)FileType.GeoPackage) || this.m_fileType.equals((Object)FileType.ORANGETAB) || this.m_fileType.equals((Object)FileType.GEOJSON) || this.m_fileType.equals((Object)FileType.OSM) || this.m_fileType.equals((Object)FileType.PersonalGDBVector)) {
            ImportDataInfoNative.jni_GetBounds(this.getHandle(), dArray);
        } else if (this.m_fileType.equals((Object)FileType.PNG) || this.m_fileType.equals((Object)FileType.TIF) || this.m_fileType.equals((Object)FileType.IMG) || this.m_fileType.equals((Object)FileType.GRD) || this.m_fileType.equals((Object)FileType.GIF) || this.m_fileType.equals((Object)FileType.JPG) || this.m_fileType.equals((Object)FileType.RAW) || this.m_fileType.equals((Object)FileType.SIT) || this.m_fileType.equals((Object)FileType.BMP) || this.m_fileType.equals((Object)FileType.GRIB) || this.m_fileType.equals((Object)FileType.GBDEM) || this.m_fileType.equals((Object)FileType.USGSDEM) || this.m_fileType.equals((Object)FileType.BIL) || this.m_fileType.equals((Object)FileType.BIP) || this.m_fileType.equals((Object)FileType.BSQ) || this.m_fileType.equals((Object)FileType.TEMSClutter) || this.m_fileType.equals((Object)FileType.SDERaster) || this.m_fileType.equals((Object)FileType.FileGDBRaster) || this.m_fileType.equals((Object)FileType.ARCINFO_BINGRID) || this.m_fileType.equals((Object)FileType.ECW) || this.m_fileType.equals((Object)FileType.JP2) || this.m_fileType.equals((Object)FileType.MrSID) || this.m_fileType.equals((Object)FileType.VRT) || this.m_fileType.equals((Object)FileType.NetCDF)) {
            ImportDataInfoNative.jni_GetBounds2(this.getHandle(), dArray);
        }
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public String getTargetName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetName()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (this.m_fileType.equals((Object)FileType.MIF) || this.m_fileType.equals((Object)FileType.TAB) || this.m_fileType.equals((Object)FileType.DXF) || this.m_fileType.equals((Object)FileType.DWG) || this.m_fileType.equals((Object)FileType.SHP) || this.m_fileType.equals((Object)FileType.COVERAGE) || this.m_fileType.equals((Object)FileType.TEMSBuildingVector) || this.m_fileType.equals((Object)FileType.TEMSVector) || this.m_fileType.equals((Object)FileType.TEMSTEXT) || this.m_fileType.equals((Object)FileType.ENCS57) || this.m_fileType.equals((Object)FileType.KML) || this.m_fileType.equals((Object)FileType.KMZ) || this.m_fileType.equals((Object)FileType.MAPGIS) || this.m_fileType.equals((Object)FileType.LIDAR) || this.m_fileType.equals((Object)FileType.SCV) || this.m_fileType.equals((Object)FileType.CSV) || this.m_fileType.equals((Object)FileType.GML) || this.m_fileType.equals((Object)FileType.E00) || this.m_fileType.equals((Object)FileType.SDEVector) || this.m_fileType.equals((Object)FileType.FileGDBVector) || this.m_fileType.equals((Object)FileType.DGN) || this.m_fileType.equals((Object)FileType.VCT) || this.m_fileType.equals((Object)FileType.GJB5068) || this.m_fileType.equals((Object)FileType.GJB9121) || this.m_fileType.equals((Object)FileType.DBF) || this.m_fileType.equals((Object)FileType.GeoPackage) || this.m_fileType.equals((Object)FileType.ORANGETAB) || this.m_fileType.equals((Object)FileType.GEOJSON) || this.m_fileType.equals((Object)FileType.OSM) || this.m_fileType.equals((Object)FileType.PersonalGDBVector)) {
            string = ImportDataInfoNative.jni_GetTargetName(this.getHandle());
        } else if (this.m_fileType.equals((Object)FileType.PNG) || this.m_fileType.equals((Object)FileType.TIF) || this.m_fileType.equals((Object)FileType.IMG) || this.m_fileType.equals((Object)FileType.GRD) || this.m_fileType.equals((Object)FileType.GIF) || this.m_fileType.equals((Object)FileType.JPG) || this.m_fileType.equals((Object)FileType.RAW) || this.m_fileType.equals((Object)FileType.SIT) || this.m_fileType.equals((Object)FileType.BMP) || this.m_fileType.equals((Object)FileType.GRIB) || this.m_fileType.equals((Object)FileType.GBDEM) || this.m_fileType.equals((Object)FileType.USGSDEM) || this.m_fileType.equals((Object)FileType.BIL) || this.m_fileType.equals((Object)FileType.BIP) || this.m_fileType.equals((Object)FileType.BSQ) || this.m_fileType.equals((Object)FileType.TEMSClutter) || this.m_fileType.equals((Object)FileType.SDERaster) || this.m_fileType.equals((Object)FileType.FileGDBRaster) || this.m_fileType.equals((Object)FileType.ARCINFO_BINGRID) || this.m_fileType.equals((Object)FileType.MrSID) || this.m_fileType.equals((Object)FileType.ECW) || this.m_fileType.equals((Object)FileType.JP2) || this.m_fileType.equals((Object)FileType.EGC) || this.m_fileType.equals((Object)FileType.VRT) || this.m_fileType.equals((Object)FileType.NetCDF)) {
            string = ImportDataInfoNative.jni_GetTargetNameRaster(this.getHandle());
        }
        return string;
    }

    public void setTargetName(String targetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetName(String targetName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fileType.equals((Object)FileType.MIF) || this.m_fileType.equals((Object)FileType.TAB) || this.m_fileType.equals((Object)FileType.DXF) || this.m_fileType.equals((Object)FileType.DWG) || this.m_fileType.equals((Object)FileType.SHP) || this.m_fileType.equals((Object)FileType.COVERAGE) || this.m_fileType.equals((Object)FileType.TEMSBuildingVector) || this.m_fileType.equals((Object)FileType.TEMSVector) || this.m_fileType.equals((Object)FileType.TEMSTEXT) || this.m_fileType.equals((Object)FileType.ENCS57) || this.m_fileType.equals((Object)FileType.KML) || this.m_fileType.equals((Object)FileType.KMZ) || this.m_fileType.equals((Object)FileType.MAPGIS) || this.m_fileType.equals((Object)FileType.LIDAR) || this.m_fileType.equals((Object)FileType.SCV) || this.m_fileType.equals((Object)FileType.CSV) || this.m_fileType.equals((Object)FileType.GML) || this.m_fileType.equals((Object)FileType.E00) || this.m_fileType.equals((Object)FileType.SDEVector) || this.m_fileType.equals((Object)FileType.FileGDBVector) || this.m_fileType.equals((Object)FileType.DGN) || this.m_fileType.equals((Object)FileType.VCT) || this.m_fileType.equals((Object)FileType.GJB5068) || this.m_fileType.equals((Object)FileType.GJB9121) || this.m_fileType.equals((Object)FileType.DBF) || this.m_fileType.equals((Object)FileType.GeoPackage) || this.m_fileType.equals((Object)FileType.ORANGETAB) || this.m_fileType.equals((Object)FileType.GEOJSON) || this.m_fileType.equals((Object)FileType.OSM) || this.m_fileType.equals((Object)FileType.PersonalGDBVector)) {
            ImportDataInfoNative.jni_SetTargetName(this.getHandle(), targetName);
        } else if (this.m_fileType.equals((Object)FileType.PNG) || this.m_fileType.equals((Object)FileType.TIF) || this.m_fileType.equals((Object)FileType.IMG) || this.m_fileType.equals((Object)FileType.GRD) || this.m_fileType.equals((Object)FileType.GIF) || this.m_fileType.equals((Object)FileType.JPG) || this.m_fileType.equals((Object)FileType.RAW) || this.m_fileType.equals((Object)FileType.SIT) || this.m_fileType.equals((Object)FileType.BMP) || this.m_fileType.equals((Object)FileType.GRIB) || this.m_fileType.equals((Object)FileType.GBDEM) || this.m_fileType.equals((Object)FileType.USGSDEM) || this.m_fileType.equals((Object)FileType.BIL) || this.m_fileType.equals((Object)FileType.BIP) || this.m_fileType.equals((Object)FileType.BSQ) || this.m_fileType.equals((Object)FileType.TEMSClutter) || this.m_fileType.equals((Object)FileType.SDERaster) || this.m_fileType.equals((Object)FileType.FileGDBRaster) || this.m_fileType.equals((Object)FileType.ARCINFO_BINGRID) || this.m_fileType.equals((Object)FileType.ECW) || this.m_fileType.equals((Object)FileType.MrSID) || this.m_fileType.equals((Object)FileType.JP2) || this.m_fileType.equals((Object)FileType.EGC) || this.m_fileType.equals((Object)FileType.VRT) || this.m_fileType.equals((Object)FileType.NetCDF)) {
            ImportDataInfoNative.jni_SetTargetNameRaster(this.getHandle(), targetName);
        }
    }

    public String getSourceFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFile()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_filePath;
    }

    public Charset getSourceCharset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceCharset()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fileType.equals((Object)FileType.MIF) || this.m_fileType.equals((Object)FileType.TAB) || this.m_fileType.equals((Object)FileType.SHP)) {
            int n = ImportDataInfoNative.jni_GetSourceCharset(this.getHandle());
            return (Charset)InternalEnum.parseUGCValue(Charset.class, n);
        }
        return Charset.DEFAULT;
    }

    FieldInfo[] getSourceFieldInfos_base() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_sourceFieldInfos.toArray();
    }

    FieldInfo[] getTargetFieldInfos_base() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_targetFieldInfos.toArray();
    }

    boolean changeFieldName_base(String oldName, String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ChangeFieldName(String oldName, String newName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (oldName.equalsIgnoreCase(newName)) {
            return true;
        }
        int n = this.m_sourceFieldInfos.indexOf(oldName);
        if (n == -1) {
            String string = InternalResource.loadString("oldName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_dictTargetFieldNames.get(oldName);
        int n2 = this.m_targetFieldInfos.indexOf(string);
        if (n2 == -1) {
            String string2 = InternalResource.loadString("targetName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.getAvailableName(newName);
        this.m_targetFieldInfos.get(n2).setName(string3);
        this.m_targetFieldInfos.get(n2).setCaption(string3);
        this.m_changeName.put(n, string3);
        this.m_dictTargetFieldNames.put(oldName, string3);
        return true;
    }

    boolean changeFieldType_base(String oldName, FieldType fieldType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("changeFieldType(String oldName, FieldType fieldType)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_sourceFieldInfos.indexOf(oldName);
        if (n == -1) {
            String string = InternalResource.loadString("oldName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_dictTargetFieldNames.get(oldName);
        int n2 = this.m_targetFieldInfos.indexOf(string);
        if (n2 == -1) {
            String string2 = InternalResource.loadString("targetName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string2);
        }
        this.m_targetFieldInfos.get(n2).setType(fieldType);
        this.m_targetFieldInfos.get(n2).setType(fieldType);
        this.m_changeFieldType.put(n, fieldType);
        return true;
    }

    boolean setImportFieldState_base(String oldName, boolean excludeField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportFieldState(String fieldname,Boolean excludeField)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_dictTargetFieldNames.containsKey(oldName)) {
            String string = InternalResource.loadString("oldName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_sourceFieldInfos.indexOf(oldName);
        if (n == -1) {
            String string = InternalResource.loadString("oldName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_dictTargetFieldNames.get(oldName);
        int n2 = this.m_targetFieldInfos.indexOf(string);
        if (excludeField) {
            if (n2 != -1) {
                this.m_targetFieldInfos.remove(n2);
                this.m_importFieldState.add(n);
            }
        } else if (n2 == -1) {
            FieldInfo fieldInfo = this.m_sourceFieldInfos.get(n).clone();
            String string2 = this.getAvailableName(oldName);
            fieldInfo.setName(string2);
            fieldInfo.setCaption(string2);
            this.m_targetFieldInfos.insert(n, fieldInfo);
            this.m_importFieldState.remove((Object)n);
        }
        return true;
    }

    boolean getImportFieldState_base(String oldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportFieldState(String oldName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_dictTargetFieldNames.containsKey(oldName)) {
            String string = InternalResource.loadString("oldName", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_dictTargetFieldNames.get(oldName);
        int n = this.m_targetFieldInfos.indexOf(string);
        if (n == -1) {
            return false;
        }
        FieldInfo fieldInfo = this.m_targetFieldInfos.get(n).clone();
        return fieldInfo != null && fieldInfo.getName().trim().length() > 0;
    }

    boolean exchangeFieldOrder_base(String tagFieldName1, String tagFieldName2) {
        String string;
        int n;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("exchangeFieldOrder(String tagFieldName1, String tagFieldName2)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string2);
        }
        if (tagFieldName1 == null || tagFieldName1.trim().length() == 0) {
            String string3 = InternalResource.loadString("tagFieldName1", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        if (tagFieldName2 == null || tagFieldName2.trim().length() == 0) {
            String string4 = InternalResource.loadString("tagFieldName2", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string4);
        }
        int n2 = this.m_targetFieldInfos.indexOf(tagFieldName1);
        if (n2 == -1) {
            String string5 = InternalResource.loadString("tagFieldName1", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string5);
        }
        int n3 = this.m_targetFieldInfos.indexOf(tagFieldName2);
        if (n3 == -1) {
            String string6 = InternalResource.loadString("tagFieldName2", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string6);
        }
        String string7 = "";
        String string8 = "";
        Object[] objectArray = this.m_dictTargetFieldNames.keySet().toArray();
        int n4 = this.m_dictTargetFieldNames.size();
        for (n = 0; n < n4; ++n) {
            string = this.m_dictTargetFieldNames.get(objectArray[n]);
            if (string.compareToIgnoreCase(tagFieldName1) == 0) {
                string7 = (String)objectArray[n];
            }
            if (string.compareToIgnoreCase(tagFieldName2) != 0) continue;
            string8 = (String)objectArray[n];
        }
        n = this.m_sourceFieldInfos.indexOf(string7);
        if (n == -1) {
            string = InternalResource.loadString("tagFieldName1", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n5 = this.m_sourceFieldInfos.indexOf(string8);
        if (n5 == -1) {
            String string9 = InternalResource.loadString("tagFieldName2", "ImportDataInfo_FieldNameIsNotExist", "conversion_resources");
            throw new IllegalArgumentException(string9);
        }
        this.m_targetFieldInfos.exchange(n2, n3);
        this.m_sourceIndex.add(n);
        this.m_targetIndex.add(n5);
        return true;
    }

    ArrayList<Integer> getFieldState() {
        return this.m_importFieldState;
    }

    HashMap<Integer, String> getChangeName() {
        return this.m_changeName;
    }

    ArrayList<Integer> getSourceIndex() {
        return this.m_sourceIndex;
    }

    ArrayList<Integer> getTargetIndex() {
        return this.m_targetIndex;
    }

    HashMap<Integer, FieldType> getChangeFieldType() {
        return this.m_changeFieldType;
    }

    private String getAvailableName(String srcName) {
        if (this.m_targetFieldInfos.indexOf(srcName) == -1) {
            return srcName;
        }
        if (srcName.lastIndexOf(95) == -1) {
            return this.getAvailableName(srcName + "_" + 1);
        }
        String string = srcName.substring(0, srcName.lastIndexOf(95));
        String string2 = srcName.substring(srcName.lastIndexOf(95) + 1);
        if (!this.isNumStr(string2)) {
            return this.getAvailableName(srcName + "_" + 1);
        }
        return this.getAvailableName(string + "_" + (Integer.parseInt(string2) + 1));
    }

    private boolean isNumStr(String str) {
        StringBuffer stringBuffer = new StringBuffer(str);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) >= '0' || stringBuffer.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    protected void clearHandle() {
        super.clearHandle();
        this.m_sourceFieldInfos = null;
        this.m_targetFieldInfos = null;
    }

    protected void Init() {
        this.m_sourceFieldInfos.clear();
        this.m_targetFieldInfos.clear();
        this.m_dictTargetFieldNames.clear();
        this.m_importFieldState.clear();
        this.m_changeName.clear();
        this.m_changeFieldType.clear();
        int n = ImportDataInfoNative.jni_GetFieldCount(this.getHandle());
        long[] lArray = new long[n];
        ImportDataInfoNative.jni_GetSourceFieldInfos(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = InternalFieldInfo.createInstance(lArray[i]);
            boolean bl = false;
            if (this.m_sourceFieldInfos.get(fieldInfo.getName()) == null) {
                bl = true;
            }
            if (fieldInfo.isSystemField() || fieldInfo.getName().toUpperCase().startsWith("SM") || !bl) continue;
            this.m_sourceFieldInfos.add(fieldInfo.clone());
            this.m_targetFieldInfos.add(fieldInfo.clone());
            this.m_dictTargetFieldNames.put(fieldInfo.getName(), fieldInfo.getName());
        }
    }
}

