/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.TIFFCompression;

public class ExportSettingTIF
extends ExportSetting {
    private boolean m_exportingPRJFile;
    private boolean m_exportingGeoTransformFile;
    private boolean m_bExportAsTile;
    private TIFFCompression m_nCompression;

    public ExportSettingTIF() {
        this.m_exportingPRJFile = true;
        this.m_exportingGeoTransformFile = true;
        this.m_type = FileType.TIF;
        this.m_bExportAsTile = false;
        this.m_nCompression = TIFFCompression.COMPRESSION_NONE;
    }

    public ExportSettingTIF(ExportSettingTIF exportSettingTIF) {
        super(exportSettingTIF);
        this.setExportingPRJFile(exportSettingTIF.isExportingPRJFile());
        this.setExportingGeoTransformFile(exportSettingTIF.isExportingGeoTransformFile());
        this.setExportAsTile(exportSettingTIF.isExportAsTile());
        this.m_type = FileType.TIF;
        this.setCompression(exportSettingTIF.m_nCompression);
    }

    public ExportSettingTIF(Object sourceData, String targetFilePath, FileType targetFileType) {
        super(sourceData, targetFilePath, targetFileType);
        this.m_exportingPRJFile = true;
        this.m_exportingGeoTransformFile = true;
        this.m_bExportAsTile = false;
        this.m_type = FileType.TIF;
        this.m_nCompression = TIFFCompression.COMPRESSION_NONE;
    }

    @Deprecated
    public boolean isExportingPRJFile() {
        return this.m_exportingPRJFile;
    }

    @Deprecated
    public void setExportingPRJFile(boolean value) {
        this.m_exportingPRJFile = value;
    }

    public boolean isExportAsTile() {
        return this.m_bExportAsTile;
    }

    public void setExportAsTile(boolean bExportAsTile) {
        this.m_bExportAsTile = bExportAsTile;
    }

    public boolean isExportingGeoTransformFile() {
        return this.m_exportingGeoTransformFile;
    }

    public void setExportingGeoTransformFile(boolean value) {
        this.m_exportingGeoTransformFile = value;
    }

    @Override
    public FileType getTargetFileType() {
        return this.m_type;
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (FileType.TIF != type) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_type = FileType.TIF;
    }

    public TIFFCompression getCompression() {
        return this.m_nCompression;
    }

    public void setCompression(TIFFCompression compression) {
        this.m_nCompression = compression;
    }
}

