/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.SerializerUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class StringArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return String[].class;
    }

    @Override
    public String getTypeName() {
        return "SL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof String[]) {
            String[] values = (String[])value;
            int count = values.length;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (int i = 0; i < count; ++i) {
                String str = values[i];
                byte[] bys = SerializerUtil.encodeString(str);
                byte[] lenBys = SerializerUtil.encodeInt(bys.length);
                byte[] allBytes = new byte[bys.length + lenBys.length];
                System.arraycopy(lenBys, 0, allBytes, 0, lenBys.length);
                System.arraycopy(bys, 0, allBytes, lenBys.length, bys.length);
                try {
                    stream.write(allBytes);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return stream.toByteArray();
        }
        return new byte[0];
    }

    public String[] decode(byte[] bys) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bys);
        byte[] lenBytes = new byte[4];
        ArrayList<String> results = new ArrayList<String>();
        try {
            while (stream.read(lenBytes) == 4) {
                int len = SerializerUtil.decodeInt(lenBytes);
                byte[] bytes = new byte[len];
                stream.read(bytes);
                String strValue = SerializerUtil.decodeString(bytes);
                results.add(strValue);
            }
            String[] resultStrs = new String[results.size()];
            results.toArray(resultStrs);
            return resultStrs;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new String[0];
        }
    }
}

