/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.QueryParameter;

class SpatialComparePattern
extends Enum {
    public static final SpatialComparePattern IGNORE = new SpatialComparePattern(1, 1);
    public static final SpatialComparePattern INTERSECT = new SpatialComparePattern(2, 2);
    public static final SpatialComparePattern NONINTERSECT = new SpatialComparePattern(3, 3);

    private SpatialComparePattern(int value, int ugcValue) {
        super(value, ugcValue);
    }

    private String toUGCString() {
        if (this.equals(IGNORE)) {
            return "*";
        }
        if (this.equals(INTERSECT)) {
            return "T";
        }
        if (this.equals(NONINTERSECT)) {
            return "F";
        }
        return "";
    }

    static final SpatialComparePattern parseUGCString(String str) {
        if (str.length() != 1) {
            return null;
        }
        if (str.equalsIgnoreCase("T")) {
            return INTERSECT;
        }
        if (str.equalsIgnoreCase("F")) {
            return NONINTERSECT;
        }
        if (str.equalsIgnoreCase("*")) {
            return IGNORE;
        }
        return null;
    }

    static final SpatialComparePattern[][] toArray(String str) {
        if (str.length() != 9) {
            return null;
        }
        SpatialComparePattern[][] spatialComparePatternArray = new SpatialComparePattern[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                char c = str.charAt(i * 3 + j);
                spatialComparePatternArray[i][j] = SpatialComparePattern.parseUGCString(String.valueOf(c));
            }
        }
        return spatialComparePatternArray;
    }

    static final String toUGCString(SpatialComparePattern[][] patterns) {
        if (!QueryParameter.isValidSpatialFilter(patterns)) {
            return "";
        }
        String string = "";
        if (patterns.length == 3 && patterns[0].length == 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    stringBuffer.append(patterns[i][j].toUGCString());
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

