/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Animation;
import com.supermap.data.BoundingBox;
import com.supermap.data.GeoModelNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Meshes;
import com.supermap.data.NodeAnimation;
import com.supermap.data.Point3D;
import java.io.File;

public class GeoModel
extends Geometry3D {
    protected Meshes m_meshes;
    private Animation m_animation;
    private NodeAnimation m_nodeAnimation;

    public GeoModel() {
        this.setHandle(GeoModelNative.jni_New(), true);
    }

    public GeoModel(GeoModel geoModel) {
        if (geoModel == null) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoModel);
        if (l == 0L) {
            String string = InternalResource.loadString("geoModel", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoModelNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoModel);
    }

    GeoModel(long handle) {
        this.setHandle(handle, false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModelNative.jni_GetName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModelNative.jni_SetName(this.getHandle(), name);
    }

    public Meshes getMeshes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeshes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_meshes == null) {
            this.m_meshes = new Meshes(this.getHandle());
        }
        return this.m_meshes;
    }

    public Animation getAnimation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeshes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoModelNative.jni_GetAnimation(this.getHandle());
        if (this.m_animation == null) {
            this.m_animation = new Animation(l);
        }
        return this.m_animation;
    }

    public boolean fromFile(String file) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile(String file)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (file == null) {
            String string = InternalResource.loadString("file", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file2 = new File(file);
        if (!file2.exists()) {
            String string = InternalResource.loadString("file", "GeoModel_TheFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoModelNative.jni_FromFile(this.getHandle(), file);
    }

    public boolean toStreamFile(String strStreamFile) {
        return GeoModelNative.jni_ToStreamFile(this.getHandle(), strStreamFile);
    }

    public boolean fromFile(String file, Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile(String file, Point3D position)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (file == null) {
            String string = InternalResource.loadString("file", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.fromFile(file);
        if (bl) {
            this.setPosition(position);
        }
        return bl;
    }

    public boolean toSGM(String fileSGM) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toSGM(String fileSGM)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fileSGM == null) {
            String string = InternalResource.loadString("fileSGM", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoModelNative.jni_ToSGM(this.getHandle(), fileSGM);
    }

    public boolean toSGZ(String fileSGZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toSGZ(String fileSGZ)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fileSGZ == null) {
            String string = InternalResource.loadString("fileSGM", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoModelNative.jni_ToSGZ(this.getHandle(), fileSGZ);
    }

    @Override
    public GeoModel clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoModel(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoModelNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected static GeoModel creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoModel(handle);
    }

    public void computeBoundingBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeBoundingBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoModelNative.jni_ComputeBoundingBox(this.getHandle());
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBoundingBox(BoundingBox boundingBox)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = boundingBox.getHandle();
        GeoModelNative.jni_SetBoundingBox(this.getHandle(), l);
    }

    @Override
    protected void clearHandle() {
        if (this.m_animation != null) {
            this.m_animation.clearHandle();
            this.m_animation = null;
        }
        if (this.m_nodeAnimation != null) {
            this.m_nodeAnimation.clearHandle();
            this.m_nodeAnimation = null;
        }
        this.setHandle(0L);
    }

    protected static void clearMeshes(GeoModel model) {
        model.m_meshes = null;
    }

    public NodeAnimation getNodeAnimation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNodeAnimation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoModelNative.jni_GetNodeAnimation(this.getHandle());
        if (this.m_nodeAnimation == null) {
            this.m_nodeAnimation = new NodeAnimation(l);
        }
        return this.m_nodeAnimation;
    }
}

