/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CornerFillStartMode;
import com.supermap.data.Enum;
import com.supermap.data.FillDirectionType;
import com.supermap.data.GeoMapBorderFillType;
import com.supermap.data.GeoMapBorderNative;
import com.supermap.data.GeoMapBorderType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TextStyle;
import java.awt.Color;
import java.io.File;

public class GeoMapBorder
extends Geometry {
    private GeoStyle m_inFrameStyle;
    private GeoStyle m_outFrameStyle;
    private GeoStyle m_inLineStyle;
    private GeoStyle m_outLineStyle;
    private GeoStyle m_fillStyle;
    private TextStyle m_fillTextStyle;
    private TextStyle m_cornerFillTextStyle;

    public GeoMapBorder() {
        long l = GeoMapBorderNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMapBorder(GeoMapBorder geoMapBorder) {
        if (geoMapBorder == null) {
            String string = InternalResource.loadString("geoMapBorder", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMapBorder);
        if (l == 0L) {
            String string = InternalResource.loadString("geoMapBorder", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapBorderNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapBorder);
    }

    GeoMapBorder(long handle) {
        this.setHandle(handle, false);
    }

    public GeoMapBorderType getBorderType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapBorderNative.jni_GetBorderType(this.getHandle());
        return (GeoMapBorderType)Enum.parseUGCValue(GeoMapBorderType.class, n);
    }

    public void setBorderType(GeoMapBorderType geoMapBorderType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(GeoMapBorderType geoMapBorderType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapBorderType == null) {
            String string = InternalResource.loadString("geoMapBorderType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapBorderType.value();
        GeoMapBorderNative.jni_SetBorderType(this.getHandle(), n);
    }

    public GeoMapBorderFillType getFillType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapBorderNative.jni_GetFillType(this.getHandle());
        return (GeoMapBorderFillType)Enum.parseUGCValue(GeoMapBorderFillType.class, n);
    }

    public void setFillType(GeoMapBorderFillType geoMapBorderFillType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillType(GeoMapBorderFillType geoMapBorderFillType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapBorderFillType == null) {
            String string = InternalResource.loadString("geoMapBorderFillType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapBorderFillType.value();
        GeoMapBorderNative.jni_SetFillType(this.getHandle(), n);
    }

    public GeoMapBorderFillType getCornerFillType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerFillType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapBorderNative.jni_GetCornerFillType(this.getHandle());
        return (GeoMapBorderFillType)Enum.parseUGCValue(GeoMapBorderFillType.class, n);
    }

    public void setCornerFillType(GeoMapBorderFillType geoMapBorderFillType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerFillType(GeoMapBorderFillType geoMapBorderFillType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapBorderFillType == null) {
            String string = InternalResource.loadString("geoMapBorderFillType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapBorderFillType.value();
        GeoMapBorderNative.jni_SetCornerFillType(this.getHandle(), n);
    }

    public String getFillImageFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillImageFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetFillImageFile(this.getHandle());
    }

    public void setFillImageFile(String value) {
        File file;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillImageFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value != null && !value.equals("") && !(file = new File(value)).exists()) {
            String string = InternalResource.loadString("value", "GeoMapBorder_TheFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetFillImageFile(this.getHandle(), value);
    }

    public String getCornerFillImageFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerFillImageFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetCornerFillImageFile(this.getHandle());
    }

    public void setCornerFillImageFile(String value) {
        File file;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerFillImageFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value != null && !value.equals("") && !(file = new File(value)).exists()) {
            String string = InternalResource.loadString("value", "GeoMapBorder_TheFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetCornerFillImageFile(this.getHandle(), value);
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        GeoMapBorderNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    @Override
    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public Color getInFrameColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInFrameColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoMapBorderNative.jni_GetInFrameColor(this.getHandle()), true);
        return color;
    }

    public void setInFrameColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetInFrameColor(this.getHandle(), value.getRGB());
    }

    public GeoStyle getInFrameStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInFrameStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_inFrameStyle == null && (l = GeoMapBorderNative.jni_GetInFrameStyle(this.getHandle())) != 0L) {
            this.m_inFrameStyle = new GeoStyle(l);
        }
        return this.m_inFrameStyle;
    }

    public void setInFrameStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInFrameStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetInFrameStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getInFrameWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInFrameWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetInFrameWidth(this.getHandle());
    }

    public void setInFrameWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInFrameWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetInFrameWidth(this.getHandle(), value);
    }

    public int getInFrameInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInFrameInterval()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetInFrameInterval(this.getHandle());
    }

    public void setInFrameInterval(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInFrameInterval(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_IntervalShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetInFrameInterval(this.getHandle(), value);
    }

    public Color getOutFrameColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutFrameColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoMapBorderNative.jni_GetOutFrameColor(this.getHandle()), true);
        return color;
    }

    public void setOutFrameColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutFrameColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetOutFrameColor(this.getHandle(), value.getRGB());
    }

    public GeoStyle getOutFrameStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutFrameStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_outFrameStyle == null && (l = GeoMapBorderNative.jni_GetOutFrameStyle(this.getHandle())) != 0L) {
            this.m_outFrameStyle = new GeoStyle(l);
        }
        return this.m_outFrameStyle;
    }

    public void setOutFrameStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutFrameStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetOutFrameStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getOutFrameWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutFrameWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetOutFrameWidth(this.getHandle());
    }

    public void setOutFrameWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutFrameWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetOutFrameWidth(this.getHandle(), value);
    }

    public int getOutFrameInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutFrameInterval()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetOutFrameInterval(this.getHandle());
    }

    public void setOutFrameInterval(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutFrameInterval(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_IntervalShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetOutFrameInterval(this.getHandle(), value);
    }

    public Color getInLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoMapBorderNative.jni_GetInLineColor(this.getHandle()), true);
        return color;
    }

    public void setInLineColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInLineColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetInLineColor(this.getHandle(), value.getRGB());
    }

    public GeoStyle getInLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_inLineStyle == null && (l = GeoMapBorderNative.jni_GetInLineStyle(this.getHandle())) != 0L) {
            this.m_inLineStyle = new GeoStyle(l);
        }
        return this.m_inLineStyle;
    }

    public void setInLineStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInLineStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetInLineStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getInLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetInLineWidth(this.getHandle());
    }

    public void setInLineWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInLineWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetInLineWidth(this.getHandle(), value);
    }

    public int getInLineInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInLineInterval()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetInLineInterval(this.getHandle());
    }

    public void setInLineInterval(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInLineInterval(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_IntervalShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetInLineInterval(this.getHandle(), value);
    }

    public Color getOutLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoMapBorderNative.jni_GetOutLineColor(this.getHandle()), true);
        return color;
    }

    public void setOutLineColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutLineColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetOutLineColor(this.getHandle(), value.getRGB());
    }

    public GeoStyle getOutLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_outLineStyle == null && (l = GeoMapBorderNative.jni_GetOutLineStyle(this.getHandle())) != 0L) {
            this.m_outLineStyle = new GeoStyle(l);
        }
        return this.m_outLineStyle;
    }

    public void setOutLineStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutLineStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetOutLineStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getOutLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetOutLineWidth(this.getHandle());
    }

    public void setOutLineWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutLineWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetOutLineWidth(this.getHandle(), value);
    }

    public int getOutLineInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutLineInterval()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetOutLineInterval(this.getHandle());
    }

    public void setOutLineInterval(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutLineInterval(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GeoMapBorder_IntervalShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetOutLineInterval(this.getHandle(), value);
    }

    public FillDirectionType getFillDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillDirection()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapBorderNative.jni_GetFillDirection(this.getHandle());
        return (FillDirectionType)Enum.parseUGCValue(FillDirectionType.class, n);
    }

    public void setFillDirection(FillDirectionType fillDirectionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillDirection(FillDirectionType fillDirectionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fillDirectionType == null) {
            String string = InternalResource.loadString("fillDirectionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = fillDirectionType.value();
        GeoMapBorderNative.jni_SetFillDirection(this.getHandle(), n);
    }

    public CornerFillStartMode getCornerFillStartMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerFillStartMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapBorderNative.jni_GetCornerFillStartMode(this.getHandle());
        return (CornerFillStartMode)Enum.parseUGCValue(CornerFillStartMode.class, n);
    }

    public void setCornerFillStartMode(CornerFillStartMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerFillStartMode(CornerFillStartMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = mode.value();
        GeoMapBorderNative.jni_SetCornerFillStartMode(this.getHandle(), n);
    }

    public GeoStyle getFillStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fillStyle == null && (l = GeoMapBorderNative.jni_GetFillStyle(this.getHandle())) != 0L) {
            this.m_fillStyle = new GeoStyle(l);
        }
        return this.m_fillStyle;
    }

    public void setFillStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetFillStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public String getFillText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetFillText(this.getHandle());
    }

    public void setFillText(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillText(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetFillText(this.getHandle(), value);
    }

    public TextStyle getFillTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fillTextStyle == null && (l = GeoMapBorderNative.jni_GetFillTextStyle(this.getHandle())) != 0L) {
            this.m_fillTextStyle = new TextStyle(l);
        }
        return this.m_fillTextStyle;
    }

    public void setFillTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetFillTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public String getCornerFillText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerFillText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapBorderNative.jni_GetCornerFillText(this.getHandle());
    }

    public void setCornerFillText(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerFillText(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapBorderNative.jni_SetCornerFillText(this.getHandle(), value);
    }

    public TextStyle getCornerFillTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerFillTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_cornerFillTextStyle == null && (l = GeoMapBorderNative.jni_GetCornerFillTextStyle(this.getHandle())) != 0L) {
            this.m_cornerFillTextStyle = new TextStyle(l);
        }
        return this.m_cornerFillTextStyle;
    }

    public void setCornerFillTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerFillTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapBorderNative.jni_SetCornerFillTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    @Override
    public GeoMapBorder clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMapBorder(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapBorderNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_cornerFillTextStyle != null) {
            this.m_cornerFillTextStyle.clearHandle();
            this.m_cornerFillTextStyle = null;
        }
        if (this.m_fillStyle != null) {
            this.m_fillStyle.clearHandle();
            this.m_fillStyle = null;
        }
        if (this.m_fillTextStyle != null) {
            this.m_fillTextStyle.clearHandle();
            this.m_fillTextStyle = null;
        }
        if (this.m_inFrameStyle != null) {
            this.m_inFrameStyle.clearHandle();
            this.m_inFrameStyle = null;
        }
        if (this.m_inLineStyle != null) {
            this.m_inLineStyle.clearHandle();
            this.m_inLineStyle = null;
        }
        if (this.m_outFrameStyle != null) {
            this.m_outFrameStyle.clearHandle();
            this.m_outFrameStyle = null;
        }
        if (this.m_outLineStyle != null) {
            this.m_outLineStyle.clearHandle();
            this.m_outLineStyle = null;
        }
        this.setHandle(0L);
    }
}

