/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import Aladdin.Hasp;
import com.supermap.License;
import com.supermap.LicenseConnectMode;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseService;
import com.supermap.ProductType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LicenseHaspServiceImpl
implements LicenseService {
    private static int g_fault_tolerant_count = 1;
    static final String vendorCode = "JrNeGqM4xOWYWW2sd+Yf0q72MnQwMbX2/OS2HdnY9jrwtEt+VKmr5fRvV6P0qDgv8OoF9FYVmmeYsxqXd0niNfALXlGoaDjhSfsrtEzUICDsfJc3VIinxpWcQye+bZ0izZT7ZCXzYvZeEKHrteLtt9cFzNlUljbYp8EKjri1e9UeqJn5Qqcy8sceclr0pJjg4pXbGnRJB8fCF+R76sU/mWJ+hSdWmgUV10yy01tjYUex8wWmyiE0xmknqZ5RuLzQn8dsLwgS1ul+6RFl+CbNpyxHVxgGTzffBbSZwRDimdb9dM3LiChXIklEowTcRRiYGtR0sg+l2B+kQnJJ3eL23Anx4fnsGls2p1ZJYuEyh7XHlrJB4OF5VqsKcIH3iJaWVuwY2dqq32mYXT3rN4MVbbrjTa14yvvUM+a7OdmNsYnkgjhlc/DT3fQSPhR0M2CcDeQMeuw2MzvvTkhp6nwvu/GjO86KKFOAm6jD97h4Bl9FYRlNF9T/bl1XKCi/gNcq8mOjpmjKWiQsvnaMZXxfDZcvmmwshjjkVYsTJKWY4OwwcouYcm4uZEsOlFUlWvMWRTUYAeFoprR5QYIo8YZY/wIDTn+Xnk+mguApfF9mLbyvmX5tmnEEzvnuQFqBJRTWzMLnOp36F/1m4ImQbA/VwRQFRZwrVnYeV1+ERz07DTL87y11frp4pB138QGjM7Eeng7nx1ErPnG77HV6Kg87CRLz5sI1fiOJ6+QqUqaHC9IsbCrIRLm/UJv6QR6HcQFwIFaZQ5IFLvwO6l5rd4VAPIAcY+PsQe4YPFRfD201Tp/1Qk6+7mAh7bq3kagccWnXOZZ5XtrtpCg6N0Ebo5QRbw4SZY+8KVvg93xmrPbAtbW7/nI1WxINzi8HtRNhnq8lxirf4dIkTpiGDNHylTwPAbpc6FEzu2Dlm7FnORxXX8s=";
    private static final String REPLACE_CODE = "@_@";
    private static final String SCOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><haspscope>@_@</haspscope>";
    private static final String HL_Block = "<hasp type=\"HASP-HL\" >@_@</hasp>";
    private static final String HOST_Block = "<license_manager hostname=\"@_@\" />";
    private static final String IP_Block = "<license_manager ip=\"@_@\" />";
    private static final String KeyID_Block = "<hasp id=\"@_@\" />";
    static int SuperMap_License_Error_Hasp_Load_Library_Error = 4001;
    static String PROGRAM_PATH = "C:/Program Files/Common Files/SuperMap/License/";
    static String OPT_PATH = "/opt/SuperMap/License/";
    private static LicenseConnectMode g_connectMode = LicenseConnectMode.DEFAULT;
    private static String g_connectParamString = "";
    private static boolean g_configLoaded;
    private Hasp m_hasp;
    private int m_featureID;

    public LicenseHaspServiceImpl() {
        if (!g_configLoaded && g_connectMode == LicenseConnectMode.DEFAULT && g_connectParamString.equals("")) {
            LicenseHaspServiceImpl.FindAndReadConfig();
        }
    }

    public void dispose() {
        this.disconnect();
    }

    public int connect(ProductType product) {
        int productValue = product.getUGCValue();
        return this.connect(productValue);
    }

    public int connect(int featureID) {
        this.disconnect();
        int resultCode = SuperMap_License_Error_Hasp_Load_Library_Error;
        this.m_featureID = featureID;
        for (int i = 0; i < g_fault_tolerant_count; ++i) {
            this.m_hasp = new Hasp(featureID);
            if (this.m_hasp == null) {
                return resultCode;
            }
            this.internalLogin();
            resultCode = this.m_hasp.getLastError();
            if (resultCode == 0) break;
        }
        return resultCode;
    }

    public String getLicenseConnectServer() {
        return g_connectParamString;
    }

    public void setLicenseConnectServer(String value) {
        g_connectParamString = value;
    }

    public LicenseConnectMode getLicenseConnectMode() {
        return g_connectMode;
    }

    public void setLicenseConnectMode(LicenseConnectMode value) {
        g_connectMode = value;
    }

    public static void setLicenseConnectTolerantCount(int count) {
        g_fault_tolerant_count = count;
    }

    public static int getLicenseConnectTolerantCount() {
        return g_fault_tolerant_count;
    }

    public String getC2V() {
        if (this.m_hasp == null) {
            this.m_hasp = new Hasp(0L);
        }
        String server = HOST_Block.replace(REPLACE_CODE, "localhost");
        switch (g_connectMode.getUGCValue()) {
            case 3: {
                server = HOST_Block.replace(REPLACE_CODE, "localhost");
            }
            case 5: {
                server = HOST_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                break;
            }
            case 6: {
                server = IP_Block.replace(REPLACE_CODE, g_connectParamString.trim());
            }
        }
        String format = "<haspformat format=\"host_fingerprint\"/>";
        String info = this.m_hasp.getInfo(SCOPE.replace(REPLACE_CODE, server), format, vendorCode);
        return info;
    }

    private void internalLogin() {
        switch (g_connectMode.getUGCValue()) {
            case 0: {
                this.m_hasp.login(vendorCode);
                break;
            }
            case 1: {
                String server = "";
                if (g_connectParamString.isEmpty()) {
                    server = HL_Block.replace(REPLACE_CODE, server);
                } else if (g_connectParamString.trim().matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                    String ip = IP_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                    server = HL_Block.replace(REPLACE_CODE, ip);
                } else {
                    String host = HOST_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                    server = HL_Block.replace(REPLACE_CODE, host);
                }
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 3: {
                String server = HOST_Block.replace(REPLACE_CODE, "localhost");
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 4: {
                String server = HOST_Block.replace(REPLACE_CODE, "~localhost");
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 5: {
                String server = HOST_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 6: {
                String server = IP_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 7: {
                String server = KeyID_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
        }
    }

    public int verify() {
        if (this.m_hasp == null) {
            return SuperMap_License_Error_Hasp_Load_Library_Error;
        }
        int resultCode = -1;
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (this.m_hasp != null) {
            this.m_hasp.encrypt(data);
            resultCode = this.m_hasp.getLastError();
        }
        if (resultCode != 0 && (resultCode = this.connect(this.m_featureID)) == 0) {
            for (int i = 0; i < g_fault_tolerant_count; ++i) {
                this.m_hasp.encrypt(data);
                if (this.m_hasp.getLastError() == 0) break;
            }
        }
        return resultCode;
    }

    public void disconnect() {
        try {
            if (this.m_hasp != null) {
                this.m_hasp.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getUser() {
        return this.readRONames(true);
    }

    public String getCompany() {
        return this.readRONames(false);
    }

    private String readRONames(Boolean isUser) {
        int offset = 0;
        byte[] data = new byte[256];
        String name = "";
        if (this.m_hasp != null && this.verify() == 0) {
            this.m_hasp.read(65525L, offset, data);
            int status = this.m_hasp.getLastError();
            if (0 == status) {
                String unicode = "";
                try {
                    unicode = new String(data, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                unicode = unicode.trim();
                int pos = unicode.indexOf("|");
                if (pos >= 0) {
                    name = isUser != false ? unicode.substring(0, pos) : unicode.substring(pos + 1, unicode.length());
                }
            }
        }
        return name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public LicenseFeatureInfo getFeatureInfo() {
        LicenseFeatureInfo result = null;
        if (this.m_hasp == null) {
            return result;
        }
        if (this.verify() == 0) {
            String format = "<haspformat root=\"hasp_info\">    <feature>       <attribute name=\"id\" />       <attribute name=\"name\" />       <attribute name=\"locked\" />       <attribute name=\"expired\" />       <attribute name=\"disabled\" />       <attribute name=\"usable\" />       <attribute name=\"vmenabled\" />           <element name=\"license\" />       <element name=\"concurrency\" />         <hasp>          <attribute name=\"id\" />          <attribute name=\"type\" />        </hasp>    </feature></haspformat>";
            String info = this.m_hasp.getSessionInfo(format);
            int status = this.m_hasp.getLastError();
            if (0 == status) {
                StringReader sr = new StringReader(info);
                InputSource is = new InputSource(sr);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = null;
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                Document doc = null;
                try {
                    doc = builder.parse(is);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Element root = doc.getDocumentElement();
                Element featureNode = License.getFirstElementByName((Element)root, (String)"feature");
                String temp = featureNode.getAttribute("id");
                long id = LicenseHaspServiceImpl.parseLong(temp);
                String name = featureNode.getAttribute("name");
                temp = featureNode.getAttribute("vmenabled");
                boolean vmenable = LicenseHaspServiceImpl.parseBoolean(temp);
                temp = featureNode.getAttribute("locked");
                boolean locked = LicenseHaspServiceImpl.parseBoolean(temp);
                Element licenseNode = License.getFirstElementByName((Element)featureNode, (String)"license");
                Element element = License.getFirstElementByName((Element)licenseNode, (String)"license_type");
                temp = element.getFirstChild().getNodeValue();
                boolean istrial = locked ? false : temp.equals("trial");
                Calendar cl = Calendar.getInstance();
                cl.clear();
                element = License.getFirstElementByName((Element)licenseNode, (String)"time_start");
                if (element != null) {
                    temp = element.getFirstChild().getNodeValue();
                    int num = LicenseHaspServiceImpl.parseInt(temp);
                    cl.add(13, num += 28800);
                }
                if (cl.get(1) == 1970) {
                    cl.set(1, 9999);
                }
                Date startTime = cl.getTime();
                element = License.getFirstElementByName((Element)licenseNode, (String)"total_time");
                if (element != null) {
                    temp = element.getFirstChild().getNodeValue();
                    int num = LicenseHaspServiceImpl.parseInt(temp);
                    cl.add(13, num);
                }
                if (cl.get(1) == 1970) {
                    cl.set(1, 9999);
                }
                Date endTime = cl.getTime();
                if ("expiration".equalsIgnoreCase(temp)) {
                    cl = Calendar.getInstance();
                    cl.setTimeInMillis(1000L * Long.parseLong(License.getFirstElementByName((Element)licenseNode, (String)"exp_date").getFirstChild().getNodeValue()));
                    endTime = cl.getTime();
                }
                Element conElement = License.getFirstElementByName((Element)featureNode, (String)"concurrency");
                element = License.getFirstElementByName((Element)conElement, (String)"seats");
                temp = element.getFirstChild().getNodeValue();
                int maxlogin = 0;
                maxlogin = temp.equals("unlimited") ? 65535 : LicenseHaspServiceImpl.parseInt(temp);
                element = License.getFirstElementByName((Element)conElement, (String)"export");
                String mode = temp = element.getFirstChild().getNodeValue();
                Element haspElement = License.getFirstElementByName((Element)featureNode, (String)"hasp");
                temp = haspElement.getAttribute("id");
                long keyid = LicenseHaspServiceImpl.parseLong(temp);
                temp = haspElement.getAttribute("type");
                String keytype = "";
                if (temp.contains("HL")) {
                    keytype = "Hardware Key";
                } else if (temp.contains("SL")) {
                    keytype = "Soft License";
                }
                String version = "";
                if (id < 10000L) {
                    version = "700";
                } else if (id > 9999L && id < 19999L) {
                    version = "900";
                }
                result = new LicenseFeatureInfo(id, name, mode, istrial, vmenable, maxlogin, startTime, endTime, keyid, keytype, version);
            }
        }
        return result;
    }

    private static int parseInt(String value) {
        int result = Integer.MIN_VALUE;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private static long parseLong(String value) {
        long result = Long.MIN_VALUE;
        try {
            result = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private static boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    public String getErrorMessage(int code) {
        String errorMessage = "";
        switch (code) {
            case 0: {
                errorMessage = "ok";
                break;
            }
            case 1: {
                errorMessage = "hasp_mem_range";
                break;
            }
            case 2: {
                errorMessage = "hasp_inv_prognum_opt";
                break;
            }
            case 3: {
                errorMessage = "hasp_insuf_mem";
                break;
            }
            case 4: {
                errorMessage = "hasp_tmof";
                break;
            }
            case 5: {
                errorMessage = "hasp_access_denied";
                break;
            }
            case 6: {
                errorMessage = "hasp_incompat_feature";
                break;
            }
            case 7: {
                errorMessage = "hasp_container_not_found";
                break;
            }
            case 8: {
                errorMessage = "hasp_too_short";
                break;
            }
            case 9: {
                errorMessage = "hasp_inv_hnd";
                break;
            }
            case 10: {
                errorMessage = "hasp_inv_fileid";
                break;
            }
            case 11: {
                errorMessage = "hasp_old_driver";
                break;
            }
            case 12: {
                errorMessage = "hasp_no_time";
                break;
            }
            case 13: {
                errorMessage = "hasp_sys_err";
                break;
            }
            case 14: {
                errorMessage = "hasp_no_driver";
                break;
            }
            case 15: {
                errorMessage = "hasp_inv_format";
                break;
            }
            case 16: {
                errorMessage = "hasp_req_not_supp";
                break;
            }
            case 17: {
                errorMessage = "hasp_inv_update_obj";
                break;
            }
            case 18: {
                errorMessage = "hasp_keyid_not_found";
                break;
            }
            case 19: {
                errorMessage = "hasp_inv_update_data";
                break;
            }
            case 20: {
                errorMessage = "hasp_inv_update_notsupp";
                break;
            }
            case 21: {
                errorMessage = "hasp_inv_update_cntr";
                break;
            }
            case 22: {
                errorMessage = "hasp_inv_vcode";
                break;
            }
            case 23: {
                errorMessage = "hasp_enc_not_supp";
                break;
            }
            case 24: {
                errorMessage = "hasp_inv_time";
                break;
            }
            case 25: {
                errorMessage = "hasp_no_battery_power";
                break;
            }
            case 26: {
                errorMessage = "hasp_no_ack_space";
                break;
            }
            case 27: {
                errorMessage = "hasp_ts_detected";
                break;
            }
            case 28: {
                errorMessage = "hasp_feature_type_not_impl";
                break;
            }
            case 29: {
                errorMessage = "hasp_unknown_alg";
                break;
            }
            case 30: {
                errorMessage = "hasp_inv_sig";
                break;
            }
            case 31: {
                errorMessage = "hasp_feature_not_found";
                break;
            }
            case 32: {
                errorMessage = "hasp_no_log";
                break;
            }
            case 33: {
                errorMessage = "hasp_local_comm_err";
                break;
            }
            case 34: {
                errorMessage = "hasp_unknown_vcode";
                break;
            }
            case 35: {
                errorMessage = "hasp_inv_spec";
                break;
            }
            case 36: {
                errorMessage = "hasp_inv_scope";
                break;
            }
            case 37: {
                errorMessage = "hasp_too_many_keys";
                break;
            }
            case 38: {
                errorMessage = "hasp_too_many_users";
                break;
            }
            case 39: {
                errorMessage = "hasp_broken_session";
                break;
            }
            case 40: {
                errorMessage = "hasp_remote_comm_err";
                break;
            }
            case 41: {
                errorMessage = "hasp_feature_expired";
                break;
            }
            case 42: {
                errorMessage = "hasp_old_lm";
                break;
            }
            case 43: {
                errorMessage = "hasp_device_err";
                break;
            }
            case 44: {
                errorMessage = "hasp_update_blocked";
                break;
            }
            case 45: {
                errorMessage = "hasp_time_err";
                break;
            }
            case 46: {
                errorMessage = "hasp_schan_err";
                break;
            }
            case 47: {
                errorMessage = "hasp_storage_corrupt";
                break;
            }
            case 48: {
                errorMessage = "hasp_no_vlib";
                break;
            }
            case 49: {
                errorMessage = "hasp_inv_vlib";
                break;
            }
            case 50: {
                errorMessage = "hasp_scope_results_empty";
                break;
            }
            case 51: {
                errorMessage = "hasp_vm_detected";
                break;
            }
            case 52: {
                errorMessage = "hasp_hardware_modified";
                break;
            }
            case 53: {
                errorMessage = "hasp_user_denied";
                break;
            }
            case 54: {
                errorMessage = "hasp_update_too_old";
                break;
            }
            case 55: {
                errorMessage = "hasp_update_too_new";
                break;
            }
            case 56: {
                errorMessage = "hasp_old_vlib";
                break;
            }
            case 57: {
                errorMessage = "hasp_upload_error";
                break;
            }
            case 58: {
                errorMessage = "hasp_inv_recipient";
                break;
            }
            case 59: {
                errorMessage = "hasp_inv_detach_action";
                break;
            }
            case 60: {
                errorMessage = "hasp_too_many_products";
                break;
            }
            case 61: {
                errorMessage = "hasp_inv_product";
                break;
            }
            case 62: {
                errorMessage = "hasp_unknown_recipient";
                break;
            }
            case 63: {
                errorMessage = "hasp_inv_duration";
                break;
            }
            case 64: {
                errorMessage = "hasp_clone_detected";
                break;
            }
            case 65: {
                errorMessage = "hasp_update_already_added";
                break;
            }
            case 66: {
                errorMessage = "hasp_hasp_inactive";
                break;
            }
            case 67: {
                errorMessage = "hasp_no_deatchable_feature";
                break;
            }
            case 68: {
                errorMessage = "hasp_too_many_hosts";
                break;
            }
            case 69: {
                errorMessage = "hasp_rehost_not_allowed";
                break;
            }
            case 70: {
                errorMessage = "hasp_license_rehosted";
                break;
            }
            case 71: {
                errorMessage = "hasp_rehost_already_applied";
                break;
            }
            case 72: {
                errorMessage = "hasp_cannot_read_file";
                break;
            }
            case 400: {
                errorMessage = "hasp_no_api_dylib";
                break;
            }
            case 401: {
                errorMessage = "hasp_inv_api_dylib";
                break;
            }
            case 501: {
                errorMessage = "hasp_inv_param";
                break;
            }
            case 650: {
                errorMessage = "hasp_inv_port_type";
                break;
            }
            case 651: {
                errorMessage = "hasp_inv_port";
                break;
            }
            case 698: {
                errorMessage = "hasp_not_impl";
                break;
            }
            case 699: {
                errorMessage = "hasp_int_err";
                break;
            }
        }
        return errorMessage;
    }

    static void FindAndReadConfig() {
        g_configLoaded = true;
        ArrayList<String> findPathes = new ArrayList<String>();
        findPathes.add(License.getUGOBasePath());
        findPathes.add(PROGRAM_PATH);
        findPathes.add(OPT_PATH);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().equals(License.CONNECTION_CONFIG_FILE_NAME);
            }
        };
        String configFile = null;
        File dir = null;
        for (String string : findPathes) {
            File[] files;
            if (string == null || string.isEmpty() || !(dir = new File(string)).exists() || (files = dir.listFiles(filter)).length <= 0) continue;
            configFile = files[0].getAbsolutePath();
            break;
        }
        if (configFile != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            Document doc = null;
            try {
                doc = builder.parse(new File(configFile));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Element root = doc.getDocumentElement();
            String temp = License.getElementValueByName((Element)root, (String)"ConnectMode");
            temp = temp.trim().toUpperCase();
            if (temp.equals("")) {
                return;
            }
            if (temp.equals("HLONLY")) {
                g_connectMode = LicenseConnectMode.HL_ONLY;
            } else if (temp.equals("LOCALONLY")) {
                g_connectMode = LicenseConnectMode.LOCAL_ONLY;
            } else if (temp.equals("REMOTEONLY")) {
                g_connectMode = LicenseConnectMode.REMOTE_ONLY;
            } else if (temp.equals("SPECIFIEDHOSTNAME")) {
                g_connectMode = LicenseConnectMode.SPECIFIED_HOSTNAME;
            } else if (temp.equals("SPECIFIEDIP")) {
                g_connectMode = LicenseConnectMode.SPECIFIED_IP;
            } else if (temp.equals("SPECIFIEDKEYID")) {
                g_connectMode = LicenseConnectMode.SPECIFIED_KEYID;
            }
            temp = License.getElementValueByName((Element)root, (String)"ConnectServer");
            g_connectParamString = temp.trim();
        }
    }

    public Boolean isCloudLicense() {
        return false;
    }

    public String getImplName() {
        return "HASP";
    }
}

