/*
 * Decompiled with CFR 0.152.
 */
package Aladdin;

import Aladdin.HaspApiVersion;
import Aladdin.HaspStatus;
import Aladdin.HaspTime;

public class Hasp {
    private int[] handle = new int[]{0};
    private long featureid;
    private int status = 0;
    public static final String HASP_UPDATEINFO = new String("<haspformat format=\"updateinfo\"/>");
    public static final String HASP_SESSIONINFO = new String("<haspformat format=\"sessioninfo\"/>");
    public static final String HASP_KEYINFO = new String("<haspformat format=\"keyinfo\"/>");
    public static final String HASP_FINGERPRINT = new String("<haspformat format=\"host_fingerprint\"/>");
    public static final String HASP_RECIPIENT = new String("<haspformat root=\"location\">    <license_manager>    <attribute name=\"id\" />    <attribute name=\"time\" />    <element name=\"hostname\" />    <element name=\"version\" />    <element name=\"host_fingerprint\" />  </license_manager></haspformat> \n");
    public static final long HASP_FEATURETYPE_MASK = -65536L;
    public static final long HASP_PROGNUM_FEATURETYPE = -65536L;
    public static final long HASP_PROGNUM_MASK = 255L;
    public static final long HASP_PROGNUM_OPT_MASK = 65280L;
    public static final long HASP_PROGNUM_OPT_NO_LOCAL = 32768L;
    public static final long HASP_PROGNUM_OPT_NO_REMOTE = 16384L;
    public static final long HASP_PROGNUM_OPT_PROCESS = 8192L;
    public static final long HASP_PROGNUM_OPT_CLASSIC = 4096L;
    public static final long HASP_PROGNUM_OPT_TS = 2048L;
    public static final long HASP_DEFAULT_FID = 0L;
    public static final long HASP_PROGNUM_DEFAULT_FID = -65536L;
    public static final int HASP_MIN_BLOCK_SIZE = 16;
    public static final long HASP_MIN_BLOCK_SIZE_LEGACY = 8L;
    public static final int HASP_FILEID_MAIN = 65520;
    public static final long HASP_FILEID_LICENSE = 65522L;
    public static final long HASP_FILEID_RW = 65524L;
    public static final long HASP_FILEID_RO = 65525L;

    public int getLastError() {
        return this.status;
    }

    private static native int Login(long var0, String var2, int[] var3);

    private static native int LoginScope(long var0, String var2, String var3, int[] var4);

    private static native int Logout(int var0);

    private static native int Encrypt(int var0, byte[] var1, int var2);

    private static native int Decrypt(int var0, byte[] var1, int var2);

    private static native int GetRtc(int var0, long[] var1);

    private static native int LegacyEncrypt(int var0, byte[] var1, int var2);

    private static native int LegacyDecrypt(int var0, byte[] var1, int var2);

    private static native int LegacySetRtc(int var0, long var1);

    private static native int LegacySetIdletime(int var0, short var1);

    private static native byte[] GetSessioninfo(int var0, String var1, int[] var2);

    private static native byte[] GetInfo(String var0, String var1, String var2, int[] var3);

    private static native void Free(long var0);

    private static native String Update(String var0, int[] var1);

    private static native byte[] Detach(String var0, String var1, String var2, String var3, int[] var4);

    private static native byte[] Transfer(String var0, String var1, String var2, String var3, int[] var4);

    private static native int Read(int var0, long var1, int var3, int var4, byte[] var5);

    private static native int Write(int var0, long var1, int var3, int var4, byte[] var5);

    private static native int GetSize(int var0, long var1, int[] var3);

    public Hasp(long paramLong) {
        this.featureid = paramLong;
        this.handle[0] = 0;
    }

    protected void finalize() {
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String paramString) {
        if (paramString == null) {
            this.status = 22;
        } else {
            Hasp hasp = this;
            synchronized (hasp) {
                this.logout();
                this.status = Hasp.Login(this.featureid, paramString, this.handle);
            }
        }
        return this.status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginScope(String paramString1, String paramString2) {
        if (paramString2 == null) {
            this.status = 22;
        } else if (paramString1 == null) {
            this.status = 36;
        } else {
            Hasp hasp = this;
            synchronized (hasp) {
                this.logout();
                this.status = Hasp.LoginScope(this.featureid, paramString1, paramString2, this.handle);
            }
        }
        return this.status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout() {
        if (this.handle[0] == 0) {
            this.status = 9;
            return true;
        }
        Hasp hasp = this;
        synchronized (hasp) {
            this.status = Hasp.Logout(this.handle[0]);
            if (this.status == 0) {
                this.handle[0] = 0;
            }
        }
        return this.status == 0;
    }

    @Deprecated
    public boolean encrypt(byte[] paramArrayOfByte, int paramInt) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt > paramArrayOfByte.length ? 501 : Hasp.Encrypt(this.handle[0], paramArrayOfByte, paramInt));
        return this.status == 0;
    }

    public boolean encrypt(byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : Hasp.Encrypt(this.handle[0], paramArrayOfByte, paramArrayOfByte.length);
        return this.status == 0;
    }

    @Deprecated
    public boolean decrypt(byte[] paramArrayOfByte, int paramInt) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt > paramArrayOfByte.length ? 501 : Hasp.Decrypt(this.handle[0], paramArrayOfByte, paramInt));
        return this.status == 0;
    }

    public boolean decrypt(byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : Hasp.Decrypt(this.handle[0], paramArrayOfByte, paramArrayOfByte.length);
        return this.status == 0;
    }

    public String getInfo(String paramString1, String paramString2, String paramString3) {
        byte[] arrayOfByte = new byte[]{0};
        int[] arrayOfInt = new int[]{0};
        String str = null;
        this.status = 0;
        if (paramString3 == null) {
            this.status = 22;
        } else if (paramString1 == null) {
            this.status = 36;
        } else if (paramString2 == null) {
            this.status = 15;
        }
        if (this.status != 0) {
            return null;
        }
        arrayOfByte = Hasp.GetInfo(paramString1, paramString2, paramString3, arrayOfInt);
        this.status = arrayOfInt[0];
        if (this.status == 0) {
            str = new String(arrayOfByte);
        }
        return str;
    }

    public String getSessionInfo(String paramString) {
        byte[] arrayOfByte = new byte[]{0};
        int[] arrayOfInt = new int[]{0};
        String str = null;
        if (paramString == null) {
            this.status = 15;
            return null;
        }
        arrayOfByte = Hasp.GetSessioninfo(this.handle[0], paramString, arrayOfInt);
        this.status = arrayOfInt[0];
        if (this.status == 0) {
            str = new String(arrayOfByte);
        }
        return str;
    }

    @Deprecated
    public boolean read(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt1 < 0 ? 501 : (paramInt2 > paramArrayOfByte.length ? 501 : Hasp.Read(this.handle[0], paramLong, paramInt1, paramInt2, paramArrayOfByte)));
        return this.status == 0;
    }

    public boolean read(long paramLong, int paramInt, byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt < 0 ? 501 : Hasp.Read(this.handle[0], paramLong, paramInt, paramArrayOfByte.length, paramArrayOfByte));
        return this.status == 0;
    }

    @Deprecated
    public boolean write(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt1 < 0 ? 501 : (paramInt2 > paramArrayOfByte.length ? 501 : Hasp.Write(this.handle[0], paramLong, paramInt1, paramInt2, paramArrayOfByte)));
        return this.status == 0;
    }

    public boolean write(long paramLong, int paramInt, byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt < 0 ? 501 : Hasp.Write(this.handle[0], paramLong, paramInt, paramArrayOfByte.length, paramArrayOfByte));
        return this.status == 0;
    }

    public int getSize(long paramLong) {
        int[] arrayOfInt = new int[]{0};
        this.status = Hasp.GetSize(this.handle[0], paramLong, arrayOfInt);
        return arrayOfInt[0];
    }

    public String update(String paramString) {
        int[] arrayOfInt = new int[]{0};
        String str = null;
        if (paramString == null) {
            this.status = 501;
            return null;
        }
        str = Hasp.Update(paramString, arrayOfInt);
        this.status = arrayOfInt[0];
        return str;
    }

    public HaspTime getRealTimeClock() {
        long[] arrayOfLong = new long[]{0L};
        this.status = Hasp.GetRtc(this.handle[0], arrayOfLong);
        HaspTime localHaspTime = new HaspTime(arrayOfLong[0]);
        if (this.status == 0) {
            this.status = localHaspTime.getLastError();
        }
        return localHaspTime;
    }

    public HaspApiVersion getVersion(String paramString) {
        HaspApiVersion localHaspApiVersion = new HaspApiVersion(paramString);
        this.status = localHaspApiVersion.getLastError();
        return localHaspApiVersion;
    }

    @Deprecated
    public boolean legacyencrypt(byte[] paramArrayOfByte, int paramInt) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt > paramArrayOfByte.length ? 501 : Hasp.LegacyEncrypt(this.handle[0], paramArrayOfByte, paramInt));
        return this.status == 0;
    }

    public boolean legacyencrypt(byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : Hasp.LegacyEncrypt(this.handle[0], paramArrayOfByte, paramArrayOfByte.length);
        return this.status == 0;
    }

    @Deprecated
    public boolean legacydecrypt(byte[] paramArrayOfByte, int paramInt) {
        this.status = paramArrayOfByte == null ? 501 : (paramInt > paramArrayOfByte.length ? 501 : Hasp.LegacyDecrypt(this.handle[0], paramArrayOfByte, paramInt));
        return this.status == 0;
    }

    public boolean legacydecrypt(byte[] paramArrayOfByte) {
        this.status = paramArrayOfByte == null ? 501 : Hasp.LegacyDecrypt(this.handle[0], paramArrayOfByte, paramArrayOfByte.length);
        return this.status == 0;
    }

    @Deprecated
    public boolean legacysetRtc(short paramShort) {
        this.status = Hasp.LegacySetRtc(this.handle[0], paramShort);
        return this.status == 0;
    }

    public boolean legacysetRtc(long paramLong) {
        this.status = Hasp.LegacySetRtc(this.handle[0], paramLong);
        return this.status == 0;
    }

    public boolean legacysetIdletime(short paramShort) {
        this.status = Hasp.LegacySetIdletime(this.handle[0], paramShort);
        return this.status == 0;
    }

    @Deprecated
    public String detach(String paramString1, String paramString2, String paramString3, String paramString4) {
        byte[] arrayOfByte = new byte[]{0};
        int[] arrayOfInt = new int[]{0};
        String str = null;
        if (paramString1 == null) {
            this.status = 501;
        } else if (paramString2 == null) {
            this.status = 36;
        } else if (paramString3 == null) {
            this.status = 22;
        } else if (paramString4 == null) {
            this.status = 501;
        }
        if (this.status != 0) {
            return null;
        }
        arrayOfByte = Hasp.Detach(paramString1, paramString2, paramString3, paramString4, arrayOfInt);
        this.status = arrayOfInt[0];
        if (this.status == 0) {
            str = new String(arrayOfByte);
        }
        return str;
    }

    public String transfer(String paramString1, String paramString2, String paramString3, String paramString4) {
        byte[] arrayOfByte = new byte[]{0};
        int[] arrayOfInt = new int[]{0};
        String str = null;
        if (paramString1 == null) {
            this.status = 501;
        } else if (paramString2 == null) {
            this.status = 36;
        } else if (paramString3 == null) {
            this.status = 22;
        } else if (paramString4 == null) {
            this.status = 501;
        }
        if (this.status != 0) {
            return null;
        }
        arrayOfByte = Hasp.Transfer(paramString1, paramString2, paramString3, paramString4, arrayOfInt);
        this.status = arrayOfInt[0];
        if (this.status == 0) {
            str = new String(arrayOfByte);
        }
        return str;
    }

    static {
        HaspStatus.Init();
    }
}

