/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.ANNCellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.ANNCellularAutomataResult;
import com.supermap.analyst.spatialanalyst.ANNParameter;
import com.supermap.analyst.spatialanalyst.ANNTrainIterationResult;
import com.supermap.analyst.spatialanalyst.ANNTrainResult;
import com.supermap.analyst.spatialanalyst.ArtificialNeuralNetworkCANative;
import com.supermap.analyst.spatialanalyst.CAFlushedEvent;
import com.supermap.analyst.spatialanalyst.CAFlushedListener;
import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.PrincipalComponentAnalysisCANative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.PixelFormat;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class ANNCellularAutomata
extends InternalHandleDisposable {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static transient Vector m_CAFlushedListeners;
    ANNTrainResult m_ANNTrainResult;
    private boolean m_bInitialization;
    private boolean m_bTrained;

    public ANNCellularAutomata() {
        long l = ArtificialNeuralNetworkCANative.jni_New();
        this.setHandle(l, true);
        this.m_bInitialization = false;
        this.m_bTrained = false;
        this.m_ANNTrainResult = null;
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            // empty if block
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            ArtificialNeuralNetworkCANative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private void setCellularAutomataParameter(CellularAutomataParameter value) {
        long l = super.getHandle();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.getCellGrid());
        DatasetGrid[] datasetGridArray = value.getSpatialVariableGrids();
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGridArray[i]);
        }
        long l3 = 0L;
        if (value.getOutputDataSource() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.getOutputDataSource());
        }
        PrincipalComponentAnalysisCANative.jni_setCellularAutomataParameter(l, l2, lArray, l3, value.getOutputDatasetName(), value.IsSave(), value.getSaveFrequency(), value.getFlushFrequency(), value.getSimulationCount(), value.getFlushFilePathName(), value.getIterations());
    }

    private ANNTrainResult getANNTrainResult() {
        return this.m_ANNTrainResult;
    }

    public boolean initializeAnn(DatasetGrid trainStartCellGrid, DatasetGrid trainEndCellGrid, int[] annTrainValues, DatasetGrid[] spatialVariableGrids, ANNParameter annParameter) {
        int n;
        ANNCellularAutomata.verifyLicense();
        if (null == trainStartCellGrid || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)trainStartCellGrid)) {
            String string = InternalResource.loadString("trainStartCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (trainStartCellGrid.getPixelFormat() != PixelFormat.BIT8 && trainStartCellGrid.getPixelFormat() != PixelFormat.BIT16 && trainStartCellGrid.getPixelFormat() != PixelFormat.BIT32 && trainStartCellGrid.getPixelFormat() != PixelFormat.BIT64 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT1 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT4 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT8 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT16 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("trainStartCellGrid", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == trainStartCellGrid || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)trainStartCellGrid)) {
            String string = InternalResource.loadString("trainStartCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (trainEndCellGrid.getPixelFormat() != PixelFormat.BIT8 && trainEndCellGrid.getPixelFormat() != PixelFormat.BIT16 && trainEndCellGrid.getPixelFormat() != PixelFormat.BIT32 && trainEndCellGrid.getPixelFormat() != PixelFormat.BIT64 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT1 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT4 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT8 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT16 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("trainEndCellGrid", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (annTrainValues == null || annTrainValues.length == 0) {
            String string = InternalResource.loadString("annTrainValues", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (annTrainValues.length < 2) {
            String string = InternalResource.loadString("annTrainValues", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (spatialVariableGrids == null || spatialVariableGrids.length == 0) {
            String string = InternalResource.loadString("spatialVariableGrids", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < spatialVariableGrids.length; ++i) {
            if (spatialVariableGrids[i] != null && 0L != InternalHandle.getHandle((com.supermap.data.InternalHandle)spatialVariableGrids[i])) continue;
            String string = InternalResource.loadString("spatialVariableGrids[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.CheckParameter(annParameter);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)trainStartCellGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)trainEndCellGrid);
        long[] lArray = new long[spatialVariableGrids.length];
        for (n = 0; n < spatialVariableGrids.length; ++n) {
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)spatialVariableGrids[n]);
        }
        n = annParameter.getNeighborhoodNumber();
        double d = annParameter.getLearningRate();
        int n2 = annParameter.getSampleCount();
        String[] stringArray = new String[1];
        boolean bl = ArtificialNeuralNetworkCANative.jni_initializationAnn(super.getHandle(), l, l2, annTrainValues, lArray, annParameter.isCustomNeighborhood(), annParameter.getCustomNeighborhoods(), n, d, n2, stringArray);
        if (!bl && stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        this.m_bInitialization = true;
        return bl;
    }

    public ANNTrainResult annTrain(double dErrorRate, int nMaxTimes) {
        ANNCellularAutomata.verifyLicense();
        if (!this.m_bInitialization) {
            String string = InternalResource.loadString("Please execute 'initializationAnn()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        this.CheckParameter(dErrorRate, nMaxTimes);
        this.m_ANNTrainResult = null;
        String[] stringArray = new String[1];
        double[] dArray = ArtificialNeuralNetworkCANative.jni_annTrain(super.getHandle(), dErrorRate, nMaxTimes, stringArray);
        if (dArray != null && dArray.length > 0) {
            double d = dArray[dArray.length - 1];
            int n = (dArray.length - 1) / 2;
            if (n != 0) {
                ArrayList<ANNTrainIterationResult> arrayList = new ArrayList<ANNTrainIterationResult>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(new ANNTrainIterationResult((int)dArray[2 * i], dArray[2 * i + 1]));
                }
                this.m_ANNTrainResult = new ANNTrainResult(arrayList, d);
            } else {
                this.m_ANNTrainResult = new ANNTrainResult(null, d);
            }
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        this.m_bTrained = true;
        return this.m_ANNTrainResult;
    }

    public ANNCellularAutomataResult annCellularAutomata(Datasource outputDatasource, String outputDatasetName, ANNCellularAutomataParameter annCAParameter) {
        Object object;
        this.CheckParameter(annCAParameter);
        if (!this.m_bTrained) {
            String string = InternalResource.loadString("Please execute 'annTrain()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (null == outputDatasource || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource)) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasetName == null || outputDatasetName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("outputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.setCellularAutomataParameter(annCAParameter.getCellularAutomataParameter());
        long l = 0L;
        if (annCAParameter.isCheckResult()) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)annCAParameter.getEndCellGrid());
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        long[] lArray = new long[]{0L};
        String[] stringArray = new String[1];
        double[] dArray = ArtificialNeuralNetworkCANative.jni_annCA(super.getHandle(), l2, outputDatasetName, annCAParameter.isCheckResult(), l, annCAParameter.getThreshold(), annCAParameter.getAlpha(), annCAParameter.getConversionRules(), annCAParameter.getConversionClassIDs(), lArray, stringArray);
        ANNCellularAutomataResult aNNCellularAutomataResult = null;
        DatasetGrid datasetGrid = null;
        if (lArray[0] != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(lArray[0], outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
            object = ArtificialNeuralNetworkCANative.jni_getIterationResults(super.getHandle());
            if (object != null && ((long[])object).length != 0) {
                for (int i = 0; i < ((long[])object).length; ++i) {
                    DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(object[i], annCAParameter.getCellularAutomataParameter().getOutputDataSource());
                    InternalDatasets.add(annCAParameter.getCellularAutomataParameter().getOutputDataSource().getDatasets(), (Dataset)datasetGrid2);
                }
            }
        }
        if (lArray[0] != 0L) {
            if (dArray != null && dArray.length > 1) {
                object = new ArrayList();
                ArrayList<Double> arrayList = new ArrayList<Double>();
                int n = dArray.length / 2;
                for (int i = 0; i < n; ++i) {
                    ((ArrayList)object).add(dArray[i * 2]);
                    arrayList.add(dArray[i * 2 + 1]);
                }
                aNNCellularAutomataResult = new ANNCellularAutomataResult((ArrayList<Double>)object, arrayList, datasetGrid);
            } else {
                aNNCellularAutomataResult = new ANNCellularAutomataResult(null, null, datasetGrid);
            }
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return aNNCellularAutomataResult;
    }

    private void CheckParameter(double dErrorRate, int nMaxTimes) {
        if (dErrorRate <= 0.0 || dErrorRate > 1.0) {
            String string = InternalResource.loadString("dErrorRate", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (nMaxTimes < 10) {
            String string = InternalResource.loadString("nMaxTimes", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    private void CheckParameter(ANNParameter para) {
        Object object;
        if (para == null) {
            String string = InternalResource.loadString("ArtificialNeuralNetworkParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (para.getLearningRate() <= 0.0 || para.getLearningRate() > 1.0) {
            String string = InternalResource.loadString("ArtificialNeuralNetworkParameter.getLearningRate()", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!para.isCustomNeighborhood()) {
            if (para.getNeighborhoodNumber() <= 0) {
                String string = InternalResource.loadString("ArtificialNeuralNetworkParameter.getLearningRate()", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else {
            object = para.getCustomNeighborhoods();
            if (object == null || ((boolean[][])object).length == 0) {
                String string = InternalResource.loadString("ArtificialNeuralNetworkParameter.getCustomNeighborhoods", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            for (int i = 0; i < ((boolean[][])object).length; ++i) {
                if (object[i] == null || object[i].length == 0) {
                    String string = InternalResource.loadString("ANNCellularAutomataParameter.getCustomNeighborhoods[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string);
                }
                if (object[i].length == ((boolean[][])object).length) continue;
                String string = InternalResource.loadString("ANNCellularAutomataParameter.getCustomNeighborhoods[" + i + "] and ANNCellularAutomataParameter.getCustomNeighborhoods must have the same length.", "ArgumentInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
        }
        if (para.getSampleCount() <= 0) {
            object = InternalResource.loadString("ArtificialNeuralNetworkParameter.getSampleCount()", "GlobalGreaterThanHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException((String)object);
        }
    }

    private void CheckParameter(ANNCellularAutomataParameter para) {
        int n;
        if (para == null) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        CellularAutomataParameter.CheckParameter(para.getCellularAutomataParameter());
        if (para.isCheckResult() && (null == para.getEndCellGrid() || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)para.getEndCellGrid()))) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter.getEndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getThreshold() <= 0.0 || para.getThreshold() > 1.0) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter.getThreshold()", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getAlpha() <= 0 || para.getAlpha() > 10) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter.getAlpha()", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean[][] blArray = para.getConversionRules();
        int[] nArray = para.getConversionClassIDs();
        if (blArray == null || blArray.length == 0) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter.getConversionRules()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (nArray == null || nArray.length == 0) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter.getConversionClassIDs()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (nArray == null || blArray.length == 0) {
            String string = InternalResource.loadString("ANNCellularAutomataParameter.getConversionClassIDs and ANNCellularAutomataParameter.getConversionRules must have the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n] == null || blArray[n].length == 0) {
                String string = InternalResource.loadString("ANNCellularAutomataParameter.getConversionRules[" + n + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (blArray[n].length == blArray.length) continue;
            String string = InternalResource.loadString("ANNCellularAutomataParameter.ConversionRules[" + n + "] and ANNCellularAutomataParameter.ConversionRules must have the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < nArray.length; ++n) {
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[n] != nArray[i]) continue;
                String string = InternalResource.loadString("ANNCellularAutomataParameter.ConversionClassIDs[" + n + "] repeat.", "ArgumentInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ANNCellularAutomata";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        ANNCellularAutomata.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addCAFlushedListener(CAFlushedListener l) {
        if (m_CAFlushedListeners == null) {
            m_CAFlushedListeners = new Vector();
        }
        if (!m_CAFlushedListeners.contains(l)) {
            m_CAFlushedListeners.add(l);
        }
    }

    public static synchronized void removeCAFlushedListener(CAFlushedListener l) {
        if (m_CAFlushedListeners != null && m_CAFlushedListeners.contains(l)) {
            m_CAFlushedListeners.remove(l);
        }
    }

    protected static void fireCAFlushed(CAFlushedEvent event) {
        if (m_CAFlushedListeners != null) {
            Vector vector = m_CAFlushedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CAFlushedListener)vector.elementAt(i)).CAFlushed(event);
            }
        }
    }

    static void CAFlushedCallBack(String strFlushFilePathName) {
        Object object = new Object();
        CAFlushedEvent cAFlushedEvent = new CAFlushedEvent(object, strFlushFilePathName);
        ANNCellularAutomata.fireCAFlushed(cAFlushedEvent);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

