/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.edu;

import com.supermap.data.License;
import com.supermap.data.edu.util.EduLicenseParam;
import com.supermap.data.edu.util.EduLicenseResult;
import com.supermap.data.edu.util.EduLicenseService;
import com.supermap.data.edu.util.EduProductType;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EducationLicense {
    private static String _serverHost = "";
    private static long _autoUpdateInterval = 3600000L;
    private static ScheduledExecutorService _scheduExec = Executors.newScheduledThreadPool(1);
    private static Runnable _loginRunnable = null;
    private static boolean _isDebug = false;

    public static void main(String[] args) {
        EducationLicense.login();
        License lic = new License();
        int code = lic.connect(10002);
        System.out.println("code = " + code);
        EducationLicense.logout();
        code = lic.connect(10002);
        System.out.println("code = " + code);
        System.out.println("end");
    }

    public static boolean login() {
        return EducationLicense.runLogin("https://supermapeduserver.com:9583");
    }

    public static boolean login(String serverHost) {
        return EducationLicense.runLogin(serverHost);
    }

    public static void setAutoUpdateInterval(long milliseconds) {
        _autoUpdateInterval = milliseconds;
        if (_loginRunnable != null) {
            _scheduExec.scheduleAtFixedRate(_loginRunnable, _autoUpdateInterval, _autoUpdateInterval, TimeUnit.MILLISECONDS);
        }
    }

    public static void logout() {
        EducationLicense.setLicense("");
        _scheduExec.shutdown();
        if (_isDebug) {
            System.out.println("logout sucessed!");
        }
    }

    public static boolean isDebugEnable() {
        return _isDebug;
    }

    public static void setDebugEnable(boolean isDebug) {
        _isDebug = isDebug;
    }

    private static boolean runLogin(String serverHost) {
        _serverHost = serverHost;
        _loginRunnable = new Runnable(){

            @Override
            public void run() {
                boolean isSuccess = EducationLicense.loginInternal(_serverHost);
                System.out.println("run");
                if (!isSuccess) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("autoupdate login error");
                    sb.append("server:" + _serverHost);
                }
            }
        };
        _scheduExec.scheduleAtFixedRate(_loginRunnable, _autoUpdateInterval, _autoUpdateInterval, TimeUnit.MILLISECONDS);
        return EducationLicense.loginInternal(serverHost);
    }

    private static boolean loginInternal(String serverHost) {
        boolean result = false;
        EduLicenseService server = new EduLicenseService();
        EduLicenseParam param = new EduLicenseParam();
        param.setProductType(EduProductType.IOBJECTS);
        param.setUrl(serverHost);
        EduLicenseResult licResult = server.apply(param);
        if (licResult != null && licResult.getMessage().equals("\u6210\u529f")) {
            String licenseData = licResult.getData();
            EducationLicense.setLicense(licenseData);
            result = true;
            if (_isDebug) {
                System.out.println("login sucessed! license data :" + licenseData);
            }
        } else if (_isDebug) {
            System.out.println("connect education license server error: " + licResult.getMessage());
        }
        return result;
    }

    private static void setLicense(String licenseXML) {
        License.setSpecifyLicenseXML((String)licenseXML);
    }
}

