/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.google.gson.Gson;
import com.supermap.data.CloudLicense;
import com.supermap.data.CloudLicenseError;
import com.supermap.data.InternalResource;
import com.supermap.data.LicensePostParams;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Locale;
import java.util.Properties;

class RequestParas {
    private static String g_MacAddress;
    private static String g_IPAddress;
    private static String g_HostName;

    RequestParas() {
    }

    private static byte[] getUsedMAC() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
        byte[] mac = null;
        while (ni.hasMoreElements()) {
            NetworkInterface netI = ni.nextElement();
            mac = netI.getHardwareAddress();
            if (!netI.isUp() || netI == null || mac == null || mac.length != 6) continue;
            break;
        }
        if (mac != null) {
            return mac;
        }
        InetAddress address = InetAddress.getLocalHost();
        NetworkInterface iface = NetworkInterface.getByInetAddress(address);
        mac = iface.getHardwareAddress();
        if (mac == null) {
            mac = iface.getInetAddresses().nextElement().getAddress();
        }
        return mac;
    }

    public static String buildGetLicensePost() {
        String versionMsg;
        LicensePostParams params = new LicensePostParams();
        Properties props = System.getProperties();
        params.machine.ipAddr = g_IPAddress;
        params.machine.macAddr = g_MacAddress;
        params.machine.name = g_HostName;
        params.machine.osArch = RequestParas.getSystemArch();
        String osName = props.getProperty("os.name");
        if (osName.toLowerCase().contains("8.1")) {
            osName = "Windows 10 or 8.1";
        }
        params.machine.osName = osName;
        params.software.name = "SuperMap iObjects Java";
        params.software.productType = CloudLicense.UGO_TYPE_DEFINE;
        params.software.arch = props.getProperty("sun.arch.data.model");
        params.software.version = CloudLicense.VERSION_DEFINE;
        params.software.versionDetail = versionMsg = InternalResource.loadString((String)"", (String)"Global_ProductionVersion", (String)"data_resources");
        Gson gson = new Gson();
        String result = gson.toJson(params);
        return result;
    }

    static String getSystemArch() {
        String result = "Unknown";
        try {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            result = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        }
        catch (Exception e) {
            CloudLicenseError.setLastError("getSystemArch warning...");
            CloudLicenseError.setLastError(e);
        }
        return result;
    }

    static {
        try {
            InetAddress address = InetAddress.getLocalHost();
            g_IPAddress = address.getHostAddress();
            g_HostName = address.getHostName().toString();
            byte[] mac = RequestParas.getUsedMAC();
            String conSym = "";
            conSym = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "-" : ":";
            Formatter formatter = new Formatter();
            for (int i = 0; i < mac.length; ++i) {
                g_MacAddress = formatter.format(Locale.getDefault(), "%02X%s", mac[i], i < mac.length - 1 ? conSym : "").toString();
            }
        }
        catch (Exception e) {
            CloudLicenseError.setLastError("get local MAC address error...");
            CloudLicenseError.setLastError(e);
        }
    }
}

