/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Toolkit;
import com.supermap.realspace.networkanalyst.InternalHandle;
import com.supermap.realspace.networkanalyst.InternalHandleDisposable;
import com.supermap.realspace.networkanalyst.InternalResource;
import com.supermap.realspace.networkanalyst.InternalToolkitNetworkAnalyst3D;
import com.supermap.realspace.networkanalyst.TransportationAnalyst3DNative;
import com.supermap.realspace.networkanalyst.TransportationAnalystCheckResult3D;
import com.supermap.realspace.networkanalyst.TransportationAnalystParameter3D;
import com.supermap.realspace.networkanalyst.TransportationAnalystResult3D;
import com.supermap.realspace.networkanalyst.TransportationAnalystSetting3D;
import com.supermap.realspace.networkanalyst.WeightFieldInfos3D;
import java.util.ArrayList;
import java.util.HashMap;

public class TransportationAnalyst3D
extends InternalHandleDisposable {
    private TransportationAnalystSetting3D m_analystSetting = null;
    private boolean m_modelLoaded = false;
    private License m_license;
    private long[] m_analystHandles = null;

    public TransportationAnalyst3D() {
        this.checkLicense();
        this.m_analystHandles = new long[3];
        long l = TransportationAnalyst3DNative.jni_New(this.m_analystHandles);
        this.setHandle(l, true);
        this.m_analystSetting = new TransportationAnalystSetting3D();
        this.m_modelLoaded = false;
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst3D.managerProducts(InternalToolkitNetworkAnalyst3D.getRealspaceNetworkAnalystProducts());
        this.m_license = InternalToolkitNetworkAnalyst3D.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this.unLoadLicense();
        if (this.getHandle() != 0L) {
            TransportationAnalyst3DNative.jni_Delete(this.getHandle(), this.m_analystHandles);
            this.setHandle(0L);
            this.m_analystHandles[0] = 0L;
            this.m_analystHandles[1] = 0L;
            this.m_analystHandles[2] = 0L;
            this.m_analystHandles = null;
            this.clearHandle();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean load() {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        boolean bl3 = this.m_analystSetting.getNeedLoadModel();
        boolean bl4 = this.m_analystSetting.getNeedLoadTurnModel();
        if (bl3) {
            Toolkit.clearErrors();
            bl = TransportationAnalyst3DNative.jni_LoadModel(this.getHandle());
            if (!bl) {
                this.m_analystSetting.setNeedLoadModel(true);
                String string = Toolkit.getLastError();
                throw new IllegalArgumentException(string);
            }
            this.m_analystSetting.setNeedLoadModel(false);
        } else {
            bl = true;
        }
        if (bl4) {
            DatasetVector datasetVector = this.m_analystSetting.getTurnDataset();
            if (datasetVector != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) != 0L) {
                bl2 = TransportationAnalyst3DNative.jni_LoadTurnModel(this.getHandle());
            } else {
                TransportationAnalyst3DNative.jni_UnLoadTurnModel(this.getHandle());
                bl2 = true;
            }
            if (bl2) {
                this.m_analystSetting.setNeedLoadTurnModel(false);
            } else {
                this.m_analystSetting.setNeedLoadTurnModel(true);
            }
        } else {
            bl2 = true;
        }
        boolean bl5 = true;
        if (bl3 || bl4) {
            bl5 = TransportationAnalyst3DNative.jni_LoadObject(this.getHandle(), this.m_analystHandles);
        }
        this.m_modelLoaded = bl && bl2;
        if (!bl) return false;
        if (!bl2) return false;
        if (!bl5) return false;
        return true;
    }

    public TransportationAnalystSetting3D getAnalystSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalystSetting()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting;
    }

    public void setAnalystSetting(TransportationAnalystSetting3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!this.getAnalystSetting().equals(value)) {
            this.m_analystSetting.copyFrom(value);
        }
    }

    public TransportationAnalystResult3D findPath(TransportationAnalystParameter3D parameter) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string4);
        }
        boolean bl = false;
        long l2 = TransportationAnalyst3DNative.jni_FindPath(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), bl);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult3D(l2);
        }
        return null;
    }

    protected void clearHandle() {
        if (this.m_analystSetting != null) {
            this.m_analystSetting = null;
        }
    }

    void setAnalsytSettingToUGC() {
        String[] stringArray;
        WeightFieldInfos3D weightFieldInfos3D;
        if (!this.m_analystSetting.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray2 = new String[]{this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField(), this.m_analystSetting.getTurnNodeIDField(), this.m_analystSetting.getTurnFEdgeIDField(), this.m_analystSetting.getTurnTEdgeIDField(), this.m_analystSetting.getNodeNameField(), this.m_analystSetting.getEdgeNameField(), this.m_analystSetting.getRuleField()};
        DatasetVector datasetVector2 = this.m_analystSetting.getTurnDataset();
        if (datasetVector2 != null && !datasetVector2.isOpen()) {
            datasetVector2.open();
        }
        String[] stringArray3 = this.m_analystSetting.getTurnWeightFields();
        String[] stringArray4 = this.m_analystSetting.getFTSingleWayRuleValues();
        String[] stringArray5 = this.m_analystSetting.getTFSingleWayRuleValues();
        String[] stringArray6 = this.m_analystSetting.getProhibitedWayRuleValues();
        String[] stringArray7 = this.m_analystSetting.getTwoWayRuleValues();
        String[] stringArray8 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
        if (!TransportationAnalyst3D.isNetworkFieldsAllRight(stringArray8, datasetVector)) {
            String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            weightFieldInfos3D = datasetVector2.getType();
            if (weightFieldInfos3D != DatasetType.TABULAR) {
                String string = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeTabular", "networkanalyst3d_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
                throw new IllegalStateException(string);
            }
            stringArray = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!TransportationAnalyst3D.isTurnFieldsAllRight(stringArray, datasetVector2)) {
                String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
            if (!TransportationAnalyst3D.isTurnFieldsAllRight(stringArray3, datasetVector2)) {
                String string = InternalResource.loadString("turnWeightFields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((weightFieldInfos3D = this.m_analystSetting.getWeightFieldInfos()) == null || weightFieldInfos3D.getCount() <= 0) {
            stringArray = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "TransportationAnalyst_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException((String)stringArray);
        }
        stringArray = null;
        String[] stringArray9 = null;
        String[] stringArray10 = null;
        int n = weightFieldInfos3D.getCount();
        stringArray = new String[n];
        stringArray9 = new String[n];
        stringArray10 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = weightFieldInfos3D.get(i).getName();
            stringArray9[i] = weightFieldInfos3D.get(i).getFTWeightField();
            stringArray10[i] = weightFieldInfos3D.get(i).getTFWeightField();
        }
        int[] nArray = this.m_analystSetting.getBarrierNodes();
        int[] nArray2 = this.m_analystSetting.getBarrierEdges();
        double d = this.m_analystSetting.getTolerance();
        String string = this.m_analystSetting.getEdgeFilter();
        TransportationAnalyst3DNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, l2, stringArray2, stringArray, stringArray9, stringArray10, stringArray3, nArray, nArray2, stringArray4, stringArray5, stringArray6, stringArray7, d, string);
        this.m_analystSetting.setNeedSet(false);
    }

    private boolean isLoadModelNeeded() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadModelNeeded()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting.getNeedSet() || !this.m_modelLoaded;
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        if (networkDataset.getChildDataset().isAvailableFieldName(fields[0])) {
            return false;
        }
        int n = fields.length;
        for (int i = 1; i < n; ++i) {
            if (!networkDataset.isAvailableFieldName(fields[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean isTurnFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = true;
        int n = fields.length;
        for (int i = 1; i < n; ++i) {
            if (!networkDataset.isAvailableFieldName(fields[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public TransportationAnalystCheckResult3D check() {
        int n;
        int n2;
        int n3;
        int[] nArray;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Check(List<Integer> arcErrorInfos, List<Integer> nodeErrorInfos)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if ((nArray = TransportationAnalyst3DNative.jni_Check(this.getHandle())) == null || nArray.length < 3) {
            return null;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        if (nArray.length == 3) {
            return new TransportationAnalystCheckResult3D(hashMap2, hashMap);
        }
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = 3;
        int n8 = n7 + n4;
        for (n3 = n7; n3 < n8; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap2.put(n2, n);
        }
        n7 = n8;
        n8 += n5;
        for (n3 = n7; n3 < n8; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap.put(n2, n);
        }
        n7 += n8;
        n8 += n6;
        for (n3 = n7; n3 < n8; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap3.put(n2, n);
        }
        return new TransportationAnalystCheckResult3D(hashMap2, hashMap);
    }

    boolean checkWeightField() {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setCursorType(CursorType.STATIC);
        queryParameter.setHasGeometry(false);
        queryParameter.setAttributeFilter("1<0");
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null) {
            return false;
        }
        for (int i = 0; i < this.m_analystSetting.getWeightFieldInfos().getCount(); ++i) {
            int n;
            String string = this.m_analystSetting.getWeightFieldInfos().get(i).getFTWeightField();
            String string2 = this.m_analystSetting.getWeightFieldInfos().get(i).getTFWeightField();
            queryParameter.setResultFields(new String[]{string});
            Recordset recordset = datasetVector.query(queryParameter);
            FieldInfos fieldInfos = recordset.getFieldInfos();
            int n2 = fieldInfos.getCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                String string3 = fieldInfos.get(n).getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                String string4 = InternalResource.loadString(string, "Global_EnumValueIsError", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string4);
            }
            recordset.dispose();
            queryParameter.setResultFields(new String[]{string2});
            recordset = this.m_analystSetting.getNetworkDataset().query(queryParameter);
            fieldInfos = recordset.getFieldInfos();
            n2 = fieldInfos.getCount();
            n = 0;
            for (int j = 0; j < n2; ++j) {
                String string5 = fieldInfos.get(j).getName();
                if (!string5.equalsIgnoreCase(string2)) continue;
                n = 1;
            }
            if (n == 0) {
                String string6 = InternalResource.loadString(string2, "Global_EnumValueIsError", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string6);
            }
            recordset.dispose();
        }
        return true;
    }
}

