/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldSign;
import com.supermap.data.FieldType;
import com.supermap.data.QueryParameter;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.networkanalyst.FacilityAnalyst3D;
import com.supermap.realspace.networkanalyst.FacilityAnalystSetting3D;
import com.supermap.realspace.networkanalyst.InternalDatasetVector;
import com.supermap.realspace.networkanalyst.InternalDatasets;
import com.supermap.realspace.networkanalyst.InternalHandle;
import com.supermap.realspace.networkanalyst.InternalHandleDisposable;
import com.supermap.realspace.networkanalyst.InternalResource;
import com.supermap.realspace.networkanalyst.InternalToolkitNetworkAnalyst3D;
import com.supermap.realspace.networkanalyst.NetworkBuilder3DNative;
import com.supermap.realspace.networkanalyst.NetworkSplitMode3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class NetworkBuilder3D {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private NetworkBuilder3D() {
    }

    public static boolean buildFacilityNetworkDirections(FacilityAnalystSetting3D facilityAnalystSetting, int[] sourceIDs, int[] sinkIDs, String nodeTypeField) {
        int n;
        Object object;
        NetworkBuilder3D.verifyLicense();
        if (facilityAnalystSetting == null) {
            String string = InternalResource.loadString("facilityAnalystSetting", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        String string = facilityAnalystSetting.getDirectionField();
        DatasetVector datasetVector = facilityAnalystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string2 = InternalResource.loadString("network", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string2);
        }
        if (string != null && datasetVector.isAvailableFieldName(string)) {
            object = new FieldInfo();
            object.setName(string);
            object.setType(FieldType.INT32);
            object.setCaption(string);
            object.setMaxLength(4);
            datasetVector.getFieldInfos().add((FieldInfo)object);
        }
        if (datasetVector.getChildDataset().isAvailableFieldName(nodeTypeField)) {
            object = new FieldInfo();
            object.setName(nodeTypeField);
            object.setType(FieldType.INT32);
            object.setCaption(nodeTypeField);
            object.setMaxLength(4);
            datasetVector.getChildDataset().getFieldInfos().add((FieldInfo)object);
        }
        object = new FacilityAnalyst3D();
        ((FacilityAnalyst3D)((Object)object)).setAnalystSetting(facilityAnalystSetting);
        ((FacilityAnalyst3D)((Object)object)).load();
        if (sourceIDs == null && sinkIDs == null) {
            String string3 = InternalResource.loadString("sourceIDs and sinkIDs", "NetworkBuilder_BuildFacilityNetworkDirectionsBothSourceIDsAndSinkIDsAreNull", "networkanalyst3d_resources");
            throw new NullPointerException(string3);
        }
        if (sourceIDs != null) {
            for (n = 0; n < sourceIDs.length; ++n) {
                if (sourceIDs[n] > 0) continue;
                String string4 = InternalResource.loadString("sourceIDs[" + n + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string4);
            }
        }
        if (sinkIDs != null) {
            for (n = 0; n < sinkIDs.length; ++n) {
                if (sinkIDs[n] > 0) continue;
                String string5 = InternalResource.loadString("sinkIDs[" + n + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string5);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
        boolean bl = false;
        bl = NetworkBuilder3DNative.jni_BuildFacilityNetworkDirections(l, "", sourceIDs, sinkIDs, string, nodeTypeField);
        ((FacilityAnalyst3D)((Object)object)).clearHandle();
        return bl;
    }

    private static boolean isLongName(String name) {
        String string = "sm_seq_" + name + "_node";
        return string.length() > 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static DatasetVector buildNetwork(DatasetVector line3D, DatasetVector point3D, String edgeIDField, String fromNodeField, String toNodeField, String nodeIDField, Datasource outputDatasource, String networkDatasetName) {
        NetworkBuilder3D.verifyLicense();
        if (line3D == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (line3D.getType() != DatasetType.LINE3D && line3D.getType() != DatasetType.LINEEPS) {
            String string = InternalResource.loadString("line3D", "NetworkBuilder_DatasetTypeMustBeLine3D", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (point3D == null) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (point3D.getType() != DatasetType.POINT3D && point3D.getType() != DatasetType.POINTEPS) {
            String string = InternalResource.loadString("pointDataset", "NetworkBuilder_DatasetTypeMustBePoint3D", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (point3D.getPrjCoordSys().getType() != line3D.getPrjCoordSys().getType()) {
            String string = InternalResource.loadString("pointDataset & lineDataset", "ProjectionNotSame", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (networkDatasetName == null) {
            String string = InternalResource.loadString("networkDatasetName", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = networkDatasetName;
        String string2 = string + "_Node";
        if (!outputDatasource.getDatasets().isAvailableDatasetName(string2)) {
            String string3 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameIsNotAvailabe", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string3);
        }
        if (fromNodeField == null) {
            String string4 = InternalResource.loadString("fromNodeField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string4);
        }
        FieldInfo fieldInfo = line3D.getFieldInfos().get(fromNodeField);
        if (fieldInfo == null) {
            String string5 = InternalResource.loadString("fromNodeField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string5);
        }
        HashSet<FieldType> hashSet = new HashSet<FieldType>();
        hashSet.add(FieldType.INT16);
        hashSet.add(FieldType.INT32);
        hashSet.add(FieldType.INT64);
        hashSet.add(FieldType.TEXT);
        hashSet.add(FieldType.WTEXT);
        hashSet.add(FieldType.CHAR);
        if (!hashSet.contains(fieldInfo.getType())) {
            String string6 = InternalResource.loadString("fromNodeField", "FieldType_UnSupport", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string6);
        }
        if (toNodeField == null) {
            String string7 = InternalResource.loadString("toNodeField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string7);
        }
        fieldInfo = line3D.getFieldInfos().get(toNodeField);
        if (fieldInfo == null) {
            String string8 = InternalResource.loadString("toNodeField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string8);
        }
        if (!hashSet.contains(fieldInfo.getType())) {
            String string9 = InternalResource.loadString("toNodeField", "FieldType_UnSupport", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string9);
        }
        if (nodeIDField == null) {
            String string10 = InternalResource.loadString("nodeIDField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string10);
        }
        fieldInfo = point3D.getFieldInfos().get(nodeIDField);
        if (fieldInfo == null) {
            String string11 = InternalResource.loadString("nodeIDField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string11);
        }
        if (!hashSet.contains(fieldInfo.getType())) {
            String string12 = InternalResource.loadString("nodeIDField", "FieldType_UnSupport", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string12);
        }
        String string13 = edgeIDField;
        if (edgeIDField == null) {
            string13 = "SMID";
        } else {
            fieldInfo = line3D.getFieldInfos().get(edgeIDField);
            if (fieldInfo == null) {
                String string14 = InternalResource.loadString("edgeIDField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string14);
            }
            if (!hashSet.contains(fieldInfo.getType())) {
                String string15 = InternalResource.loadString("edgeIDField", "FieldType_UnSupport", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string15);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line3D);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)point3D);
        long l4 = NetworkBuilder3DNative.jni_BuildNetwork2(l2, l3, string13, fromNodeField, toNodeField, nodeIDField, l, networkDatasetName);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector buildNetwork(DatasetVector line3D, String[] lineFieldNames, Datasource outputDatasource, String networkDatasetName, NetworkSplitMode3D networkSplitMode, double tolerance) {
        NetworkBuilder3D.verifyLicense();
        if (networkSplitMode != NetworkSplitMode3D.NONE && networkSplitMode != NetworkSplitMode3D.LINE_SPLIT_BY_POINT_AND_LINE) {
            String string = InternalResource.loadString("networkSplitMode", "Global_EnumValueIsError", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        return NetworkBuilder3D.buildNetwork(line3D, null, lineFieldNames, null, outputDatasource, networkDatasetName, networkSplitMode, tolerance);
    }

    public static DatasetVector buildNetwork(DatasetVector line3D, DatasetVector point3D, String[] lineFieldNames, String[] pointFieldNames, Datasource outputDatasource, String networkDatasetName, NetworkSplitMode3D networkSplitMode, double tolerance) {
        NetworkBuilder3D.verifyLicense();
        if (line3D == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (line3D.getType() != DatasetType.LINE3D) {
            String string = InternalResource.loadString("lineDataset", "NetworkBuilder_DatasetTypeMustBeLine3D", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)line3D)};
        long[] lArray2 = null;
        if (point3D != null) {
            lArray2 = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)point3D)};
            if (point3D.getType() != DatasetType.POINT3D) {
                String string = InternalResource.loadString("pointDataset", "NetworkBuilder_DatasetTypeMustBePoint3D", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
            if (point3D.getPrjCoordSys().getType() != line3D.getPrjCoordSys().getType()) {
                String string = InternalResource.loadString("pointDataset & lineDataset", "ProjectionNotSame", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
        } else {
            lArray2 = new long[]{};
        }
        if (networkDatasetName == null || networkDatasetName.trim().length() == 0 || !outputDatasource.getDatasets().isAvailableDatasetName(networkDatasetName)) {
            String string = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameIsNotAvailabe", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = networkDatasetName;
        String string2 = string + "_Node";
        if (!outputDatasource.getDatasets().isAvailableDatasetName(string2)) {
            String string3 = InternalResource.loadString("networkDatasetName", "NetworkBuilder_DatasetNameIsNotAvailabe", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string3);
        }
        if (networkSplitMode == null) {
            String string4 = InternalResource.loadString("networkSplitMode", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string4);
        }
        if (tolerance < 0.0) {
            String string5 = InternalResource.loadString("tolerance", "NetworkBuilder_ToleranceShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n = networkSplitMode.value();
        long l2 = NetworkBuilder3DNative.jni_BuildNetwork(lArray, lArray2, lineFieldNames, pointFieldNames, l, networkDatasetName, n, tolerance);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    private static DatasetVector createTurnTable(DatasetVector networkDataset, QueryParameter queryParameter, Datasource outputDatasource, String outputDatasetName) {
        NetworkBuilder3D.verifyLicense();
        if (networkDataset == null) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!networkDataset.getType().equals((Object)DatasetType.NETWORK3D)) {
            String string = InternalResource.loadString("networkDataset", "NetworkBuilder_CreateTurnTableDatasetTypeMustBeNetwor", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("networkDataset", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)queryParameter);
        if (l2 == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l3 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource.getDatasets().contains(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasource", "Datasource_DatasetNameIsInvalid", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l4 = NetworkBuilder3DNative.jni_CreateTurnTable(l, l2, l3, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter);
        return datasetVector;
    }

    public static boolean fixRingEdgeErrors(DatasetVector networkDataset, Collection<Integer> errorIDs) {
        if (networkDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset) == 0L) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (networkDataset.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("networkDataset.getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (errorIDs == null) {
            String string = InternalResource.loadString("errorIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        return NetworkBuilder3D.fixRingEdgeErrors(networkDataset, errorIDs, networkDataset.getFieldNameBySign(FieldSign.EDGEID), networkDataset.getFieldNameBySign(FieldSign.FNODE), networkDataset.getFieldNameBySign(FieldSign.TNODE), networkDataset.getChildDataset().getFieldNameBySign(FieldSign.NODEID));
    }

    public static boolean fixRingEdgeErrors(DatasetVector networkDataset, Collection<Integer> errorIDs, String edgeIDField, String fromNodeIDField, String toNodeIDField, String nodeIDField) {
        if (networkDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset) == 0L) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (networkDataset.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("networkDataset.getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        FieldInfos fieldInfos = networkDataset.getFieldInfos();
        if (edgeIDField == null) {
            String string = InternalResource.loadString("edgeIDField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos.indexOf(edgeIDField) == -1) {
            String string = InternalResource.loadString("edgeIDField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (fromNodeIDField == null) {
            String string = InternalResource.loadString("fromNodeIDField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos.indexOf(fromNodeIDField) == -1) {
            String string = InternalResource.loadString("fromNodeIDField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (toNodeIDField == null) {
            String string = InternalResource.loadString("toNodeIDField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos.indexOf(toNodeIDField) == -1) {
            String string = InternalResource.loadString("toNodeIDField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        FieldInfos fieldInfos2 = networkDataset.getChildDataset().getFieldInfos();
        if (nodeIDField == null) {
            String string = InternalResource.loadString("nodeIDField", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (fieldInfos2.indexOf(nodeIDField) == -1) {
            String string = InternalResource.loadString("nodeIDField", "DatasetFieldNameIsInvalid", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (errorIDs == null) {
            String string = InternalResource.loadString("errorIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (errorIDs.size() == 0) {
            return true;
        }
        int[] nArray = new int[errorIDs.size()];
        int n = 0;
        for (Integer n2 : errorIDs) {
            nArray[n++] = n2;
        }
        return NetworkBuilder3DNative.jni_FixEdgeStartEndEqualErrors(InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset), nArray, edgeIDField, fromNodeIDField, toNodeIDField, nodeIDField);
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "NetworkBuilder";
        boolean bl = InternalToolkitNetworkAnalyst3D.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        NetworkBuilder3D.fireStepped(steppedEvent);
        InternalToolkitNetworkAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst3D.managerProducts(InternalToolkitNetworkAnalyst3D.getRealspaceNetworkAnalystProducts());
        m_license = InternalToolkitNetworkAnalyst3D.verifyLicense(arrayList);
    }
}

