/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressMatchResult;
import com.supermap.analyst.addressmatching.AddressMatchResultsNative;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import java.util.HashMap;

public class AddressMatchResults
extends InternalHandleDisposable {
    private HashMap m_datasetHashMap;
    private AddressMatchResult[] m_results;
    private int m_count;

    AddressMatchResults(long handle, HashMap datasetHashMap) {
        this.setHandle(handle, true);
        this.m_count = AddressMatchResultsNative.jni_GetResultCount(handle);
        this.m_results = new AddressMatchResult[this.m_count];
        this.m_datasetHashMap = datasetHashMap;
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            AddressMatchResultsNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this.m_count;
    }

    public AddressMatchResult get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new IndexOutOfBoundsException(string);
        }
        AddressMatchResult addressMatchResult = this.m_results[index];
        if (addressMatchResult == null) {
            long l = AddressMatchResultsNative.jni_GetResultHandle(this.getHandle(), index);
            this.m_results[index] = addressMatchResult = new AddressMatchResult(l, this.m_datasetHashMap);
        }
        return addressMatchResult;
    }

    protected void clearHandle() {
        this.m_count = 0;
        if (this.m_results != null) {
            this.m_results = null;
        }
    }
}

