/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.addressmatching.AddressMatchNative;
import com.supermap.analyst.addressmatching.AddressMatchParameter;
import com.supermap.analyst.addressmatching.AddressMatchResults;
import com.supermap.analyst.addressmatching.AddressMatchSetting;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import java.util.ArrayList;
import java.util.HashMap;

public class AddressMatch
extends InternalHandleDisposable {
    private AddressMatchSetting m_setting;
    private boolean m_isLoaded;
    private License m_license;

    public AddressMatch() {
        this.checkLicense();
        long l = AddressMatchNative.jni_New();
        this.setHandle(l, true);
        this.m_setting = new AddressMatchSetting();
        this.m_isLoaded = false;
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitAddressMatching.managerProducts(InternalToolkitAddressMatching.getAddressMatchingProducts());
        this.m_license = InternalToolkitAddressMatching.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this.unLoadLicense();
        if (this.getHandle() != 0L) {
            AddressMatchNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this.m_setting != null) {
            this.m_setting = null;
        }
    }

    public AddressMatchSetting getSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSetting()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this.m_setting;
    }

    public void setSetting(AddressMatchSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSetting(AddressMatchSetting value)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_setting.equals(value)) {
            this.m_setting.copyFrom(value);
        }
    }

    public boolean load() {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        DatasetVector[] datasetVectorArray = this.m_setting.getDatasets();
        int n = datasetVectorArray.length;
        if (n <= 0) {
            String string = InternalResource.loadString("getSetting().getDatasets().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[i]);
        }
        String[] stringArray = this.m_setting.getFields();
        if (stringArray.length <= 0) {
            String string = InternalResource.loadString("getSetting().getFields().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        String string = this.m_setting.getDictionaryFile();
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("getSetting().getDictionaryFile()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        bl = AddressMatchNative.jni_Load(this.getHandle(), lArray, stringArray, string);
        this.m_setting.setChanged(false);
        if (bl) {
            this.m_isLoaded = true;
        }
        return bl;
    }

    public AddressMatchResults match(AddressMatchParameter parameter) {
        Object object;
        int n;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(AddressMatchParameter parameter)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadNeeded()) {
            String string = InternalResource.loadString("", "AddressMatch_LoadNeeded", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getSearchAddress();
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("parameter.getSearchAddress()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        DatasetVector[] datasetVectorArray = parameter.getSearchDatasets() != null && parameter.getSearchDatasets().length > 0 ? parameter.getSearchDatasets() : this.getSetting().getDatasets();
        int n2 = datasetVectorArray.length;
        long[] lArray = new long[n2];
        HashMap<GeoRegion, DatasetVector> hashMap = new HashMap<GeoRegion, DatasetVector>();
        for (n = 0; n < n2; ++n) {
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[n]);
            int[] nArray = AddressMatchNative.jni_GetDatasetLayerIDs(this.getHandle(), lArray[n]);
            if (nArray == null) continue;
            for (int i = 0; i < nArray.length; ++i) {
                object = new Integer(nArray[i]);
                if (hashMap.containsKey(object)) continue;
                hashMap.put((GeoRegion)object, datasetVectorArray[n]);
            }
        }
        n = parameter.getResultCount();
        long l = 0L;
        object = parameter.getSearchRegion();
        if (object != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
        }
        boolean bl = parameter.isLocationReturn();
        boolean bl2 = parameter.isAddressSegmented();
        long l2 = AddressMatchNative.jni_Match(this.getHandle(), string, lArray, n, l, bl, bl2);
        AddressMatchResults addressMatchResults = null;
        if (l2 != 0L) {
            addressMatchResults = new AddressMatchResults(l2, hashMap);
        }
        return addressMatchResults;
    }

    public String segmentAddress(String value) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSetting()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return AddressMatchNative.jni_SegmentAddress(this.getHandle(), value);
    }

    private boolean isLoadNeeded() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadNeeded()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this.m_setting.isChanged() || !this.m_isLoaded;
    }
}

