/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialstatistics.InternalDatasetVector;
import com.supermap.analyst.spatialstatistics.InternalDatasets;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.InternalToolkitSpatialStatistics;
import com.supermap.analyst.spatialstatistics.PatternsParameter;
import com.supermap.analyst.spatialstatistics.WeightsUtilitiesNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class WeightsUtilities {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private WeightsUtilities() {
    }

    public static boolean buildWeightMatrix(DatasetVector sourceDatasetVector, String uniqueIDFieldName, String filePath, PatternsParameter patternsParameter) {
        WeightsUtilities.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasetVector.getFieldInfos().indexOf(uniqueIDFieldName) == -1) {
            String string = InternalResource.loadString("uniqueIDFieldName", "GlobalSpecifiedNameNotExists", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (patternsParameter == null) {
            String string = InternalResource.loadString("patternsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)patternsParameter);
        String[] stringArray = new String[1];
        boolean bl = false;
        bl = WeightsUtilitiesNative.jni_BuildWeightMatrix(l, uniqueIDFieldName, filePath, l2, stringArray);
        if (!bl && stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)patternsParameter));
        return bl;
    }

    public static DatasetVector converToTableDataset(String filePath, Datasource targetDatasource, String targetDatasetName) {
        WeightsUtilities.verifyLicense();
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        String[] stringArray = new String[1];
        long l2 = WeightsUtilitiesNative.jni_ConverToTable(filePath, l, targetDatasetName, stringArray);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "WeightsUtilities";
        boolean bl = InternalToolkitSpatialStatistics.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        WeightsUtilities.fireStepped(steppedEvent);
        InternalToolkitSpatialStatistics.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialStatistics.managerProducts(InternalToolkitSpatialStatistics.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialStatistics.verifyLicense(arrayList);
    }
}

