/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.TrackPoint;
import com.supermap.data.GeoLine;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class TrajectoryPreprocessingResult {
    private TrackPoint[] m_changedPoints;
    private Point2D[] m_tracks;

    TrajectoryPreprocessingResult(Point2D[] changedPoints, int[] changedIndexes, int[] removedIndexes, TrackPoint[] sourcePoints) {
        int n;
        int n2;
        this.m_changedPoints = new TrackPoint[sourcePoints.length];
        for (n2 = 0; n2 < sourcePoints.length; ++n2) {
            this.m_changedPoints[n2] = new TrackPoint(sourcePoints[n2]);
        }
        for (n2 = 0; n2 < changedIndexes.length; ++n2) {
            n = changedIndexes[n2];
            TrackPoint trackPoint = this.m_changedPoints[n];
            this.m_changedPoints[n] = new TrackPoint(changedPoints[n2], trackPoint.getTime());
        }
        for (n2 = 0; n2 < removedIndexes.length; ++n2) {
            this.m_changedPoints[removedIndexes[n2]] = null;
        }
        n2 = 0;
        for (n = 0; n < this.m_changedPoints.length; ++n) {
            if (this.m_changedPoints[n] == null) continue;
            ++n2;
        }
        this.m_tracks = new Point2D[n2];
        n = 0;
        for (int i = 0; i < this.m_changedPoints.length; ++i) {
            if (this.m_changedPoints[i] == null) continue;
            this.m_tracks[n++] = this.m_changedPoints[i].getPoint();
        }
    }

    public TrackPoint[] getRectifiedPoints() {
        return this.m_changedPoints;
    }

    public Point2D[] getTrackPoints() {
        return this.m_tracks;
    }

    public GeoLine getTrackLine() {
        if (this.m_tracks != null && this.m_tracks.length > 1) {
            return new GeoLine(new Point2Ds(this.m_tracks));
        }
        return null;
    }
}

