/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.MapMatchingLikelyResult;
import com.supermap.analyst.networkanalyst.MapMatchingLikelyResults;
import com.supermap.analyst.networkanalyst.MapMatchingNative;
import com.supermap.analyst.networkanalyst.MapMatchingResult;
import com.supermap.analyst.networkanalyst.PathAnalystSetting;
import com.supermap.analyst.networkanalyst.SSCPathAnalystSetting;
import com.supermap.analyst.networkanalyst.TrackPoint;
import com.supermap.analyst.networkanalyst.TransportationPathAnalystSetting;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.PrjCoordSys;
import java.util.Date;
import java.util.List;

public class MapMatching
extends InternalHandleDisposable {
    private PathAnalystSetting m_analystSetting;
    private PrjCoordSys m_prj;

    public MapMatching() {
        this.setHandle(MapMatchingNative.jni_New(), true);
    }

    public boolean setPathAnalystSetting(PathAnalystSetting setting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPathAnalystSetting", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (setting == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (setting instanceof TransportationPathAnalystSetting) {
            TransportationPathAnalystSetting transportationPathAnalystSetting = (TransportationPathAnalystSetting)setting;
            if (transportationPathAnalystSetting.load()) {
                this.m_analystSetting = transportationPathAnalystSetting;
                MapMatchingNative.jni_SetPathAnalystSetting(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationPathAnalystSetting), false);
                this.m_prj = transportationPathAnalystSetting.getNetworkDataset().getPrjCoordSys();
                return true;
            }
            this.m_analystSetting = null;
            String string = InternalResource.loadString("setPathAnalystSetting", "PathAnalystSettingLoadFailed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (setting instanceof SSCPathAnalystSetting) {
            SSCPathAnalystSetting sSCPathAnalystSetting = (SSCPathAnalystSetting)setting;
            if (sSCPathAnalystSetting.load()) {
                this.m_analystSetting = setting;
                MapMatchingNative.jni_SetPathAnalystSetting(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)sSCPathAnalystSetting), true);
                this.m_prj = sSCPathAnalystSetting.getNetworkDataset().getPrjCoordSys();
                return true;
            }
            this.m_analystSetting = null;
            String string = InternalResource.loadString("setPathAnalystSetting", "PathAnalystSettingLoadFailed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        String string = InternalResource.loadString("setPathAnalystSetting", "Global_ArgumentTypeInvalid", "networkanalyst_resources");
        throw new IllegalArgumentException(string);
    }

    public PathAnalystSetting getPathAnalystSetting() {
        return this.m_analystSetting;
    }

    public MapMatching setMeasurementError(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMeasurementError", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!(value > 0.0)) {
            String string = InternalResource.loadString("setMeasurementError", "MustBeGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        MapMatchingNative.jni_SetMeasurementError(this.getHandle(), value);
        return this;
    }

    public double getMeasurementError() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMeasurementError", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return MapMatchingNative.jni_GetMeasurementError(this.getHandle());
    }

    public double getMaxLimitedSpeed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxLimitedSpeed", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        double d = MapMatchingNative.jni_GetMaxSpeed(this.getHandle());
        return d * 3600.0 / 1000.0;
    }

    public MapMatching setMaxLimitedSpeed(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxLimitedSpeed", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value > 0.0) {
            value = value * 1000.0 / 3600.0;
        }
        MapMatchingNative.jni_SetMaxSpeed(this.getHandle(), value);
        return this;
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            MapMatchingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public MapMatchingResult batchMatch(List<TrackPoint> coordinates) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (coordinates == null) {
            String string = InternalResource.loadString("coordinates", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (coordinates.size() == 0) {
            String string = InternalResource.loadString("coordinates", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[coordinates.size()];
        double[] dArray2 = new double[coordinates.size()];
        long[] lArray = new long[coordinates.size()];
        int n = 0;
        for (TrackPoint trackPoint : coordinates) {
            dArray[n] = trackPoint.getPoint().getX();
            dArray2[n] = trackPoint.getPoint().getY();
            Date date = trackPoint.getTime();
            lArray[n] = date != null ? date.getTime() : 0L;
            ++n;
        }
        long l = MapMatchingNative.jni_Match1(this.getHandle(), dArray, dArray2, lArray);
        if (l != 0L) {
            return MapMatchingResult.parse(l, true, this.m_prj);
        }
        return null;
    }

    public DatasetVector batchMatch(DatasetVector sourceDataset, String idField, String timeField, double splitTimeMilliseconds, Datasource outputDatasource, String outputDatasetName, String resultTrackIndexField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rectifyDataset", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getFieldInfos().indexOf(timeField) == -1) {
            String string = InternalResource.loadString("timeField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        FieldType fieldType = sourceDataset.getFieldInfos().get(timeField).getType();
        if (fieldType != FieldType.TIME && fieldType != FieldType.DATETIME) {
            String string = InternalResource.loadString("timeField", "FieldType_UnSupport", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitTimeMilliseconds <= 0.0) {
            String string = InternalResource.loadString("splitTimeMilliseconds", "MustBeGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasetName == null) {
            String string = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "Datasource_DatasetNameIsInvalid", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = (DatasetVector)outputDatasource.getDatasets().createFromTemplate(outputDatasetName, (Dataset)sourceDataset);
        if (datasetVector == null) {
            return null;
        }
        if (MapMatchingNative.jni_Match3(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset), idField, timeField, splitTimeMilliseconds, InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector), resultTrackIndexField)) {
            return datasetVector;
        }
        outputDatasource.getDatasets().delete(datasetVector.getName());
        return null;
    }

    public MapMatchingLikelyResult[] match(TrackPoint coordinate, boolean isNewTrack) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (coordinate == null) {
            String string = InternalResource.loadString("coordinate", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = 0L;
        if (coordinate.getTime() != null) {
            l2 = coordinate.getTime().getTime();
        }
        if ((l = MapMatchingNative.jni_Match2(this.getHandle(), coordinate.getPoint().x, coordinate.getPoint().y, l2, isNewTrack)) != 0L) {
            return MapMatchingLikelyResults.parse(l, true, this.m_prj);
        }
        return null;
    }
}

