/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart.conversion;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.chart.S57DatasetGroupExtInfo;
import com.supermap.chart.conversion.DataExportChartNative;
import com.supermap.chart.conversion.ExportChartSteppedEvent;
import com.supermap.chart.conversion.ExportChartSteppedListener;
import com.supermap.chart.conversion.ExportResultChart;
import com.supermap.chart.conversion.ExportSettingChart;
import com.supermap.chart.conversion.ExportSettingChartS57;
import com.supermap.chart.conversion.ExportSettingCharts;
import com.supermap.chart.conversion.FileTypeChart;
import com.supermap.chart.conversion.InternalHandle;
import com.supermap.chart.conversion.InternalHandleDisposable;
import com.supermap.chart.conversion.InternalResource;
import com.supermap.chart.conversion.InternalToolkiConversion;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class DataExportChart
extends InternalHandleDisposable {
    private static License m_license;
    private ExportSettingCharts m_ExportSettings = new ExportSettingCharts();
    private long m_selfEventHandle;
    private int m_completed = 0;
    transient Vector m_steppedListeners;

    public DataExportChart() {
        this.setHandle(DataExportChartNative.jni_New(), true);
    }

    public ExportResultChart run() {
        ExportSettingChart[] exportSettingChartArray;
        DataExportChart.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("importData()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_selfEventHandle = DataExportChartNative.jni_NewSelfEventHandle(this.getHandle(), this);
        this.m_completed = 0;
        int n = this.m_ExportSettings.getCount();
        ArrayList<ExportSettingChart> arrayList = new ArrayList<ExportSettingChart>();
        ArrayList<ExportSettingChart> arrayList2 = new ArrayList<ExportSettingChart>();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                if (!this.m_ExportSettings.get(i).check()) {
                    arrayList2.add(this.m_ExportSettings.get(i));
                    continue;
                }
                if (this.m_ExportSettings.get(i) instanceof ExportSettingChart) {
                    Object object;
                    ExportSettingChartS57 exportSettingChartS57;
                    exportSettingChartArray = this.m_ExportSettings.get(i);
                    String string = exportSettingChartArray.getTargetFilePath();
                    boolean bl = exportSettingChartArray.isOverwrite();
                    int n2 = exportSettingChartArray.getTargetFileTypeChart().value();
                    long[] lArray = null;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    DatasetGroup datasetGroup = null;
                    if (n2 == FileTypeChart.S57.value() && (datasetGroup = (exportSettingChartS57 = (ExportSettingChartS57)exportSettingChartArray).getSourceData()) != null) {
                        Dataset[] datasetArray;
                        Integer n3;
                        int n4;
                        int n5 = 0;
                        object = new S57DatasetGroupExtInfo(datasetGroup);
                        if (!object.isChartDatasetGroup()) {
                            arrayList2.add(this.m_ExportSettings.get(i));
                            continue;
                        }
                        HashMap hashMap = object.getFeatureDatasets();
                        Object[] objectArray = hashMap.keySet().toArray();
                        int n6 = objectArray.length;
                        int n7 = 0;
                        for (n4 = 0; n4 < n6; ++n4) {
                            n3 = (Integer)objectArray[n4];
                            datasetArray = (Dataset[])hashMap.get(n3);
                            n7 += datasetArray.length;
                        }
                        lArray = new long[n7 += 8];
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getDSIDDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getVectorIsolatedDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getVectorConnectedDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getVectorEdgeDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getFeatureToPointDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getFeatureToEdgeDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getFeatureRelationShipDataset());
                        lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)object.getFeatureRelationShipDataset());
                        for (n4 = 0; n4 < n6; ++n4) {
                            n3 = (Integer)objectArray[n4];
                            datasetArray = (Dataset[])hashMap.get(n3);
                            for (int j = 0; j < datasetArray.length; ++j) {
                                Dataset dataset = datasetArray[j];
                                lArray[n5++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
                            }
                        }
                    }
                    bl3 = exportSettingChartArray instanceof ExportSettingChartS57 ? DataExportChartNative.jni_ExportDataChartS57(this.getHandle(), lArray, string, bl, InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGroup)) : DataExportChartNative.jni_ExportDataNormal(this.getHandle(), lArray, string, n2, bl);
                    ++this.m_completed;
                    int n8 = this.m_completed * 100 / n;
                    ExportSettingChart exportSettingChart = this.getExportSettingCharts().get(this.m_completed - 1);
                    object = new ExportChartSteppedEvent((Object)this, null, null, n8, 100, exportSettingChart, n, false);
                    this.fireStepped((ExportChartSteppedEvent)object);
                    if (((ExportChartSteppedEvent)object).getCancel()) break;
                    if (bl3) {
                        arrayList.add(this.m_ExportSettings.get(i));
                        continue;
                    }
                    arrayList2.add(this.m_ExportSettings.get(i));
                    continue;
                }
                arrayList2.add(this.m_ExportSettings.get(i));
            }
        }
        this.clearSelfEventHandle();
        ExportSettingChart[] exportSettingChartArray2 = new ExportSettingChart[arrayList.size()];
        exportSettingChartArray = new ExportSettingChart[arrayList2.size()];
        arrayList.toArray(exportSettingChartArray2);
        arrayList2.toArray(exportSettingChartArray);
        return new ExportResultChart(exportSettingChartArray2, exportSettingChartArray);
    }

    public ExportSettingCharts getExportSettingCharts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExportSettingCharts()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_ExportSettings;
    }

    public void setExportSettingCharts(ExportSettingCharts exportSettings) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExportSettings(ExportSettingCharts settings)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (exportSettings == null) {
            String string = InternalResource.loadString("setExportSettingCharts(ExportSettingCharts exportSettings)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_ExportSettings.clear();
        for (int i = 0; i < exportSettings.getCount(); ++i) {
            String string = exportSettings.get(i).getClass().getName();
            if (string.compareTo("com.supermap.chart.conversion.ExportSettingChart") == 0) {
                this.m_ExportSettings.add(new ExportSettingChart(exportSettings.get(i)));
                continue;
            }
            if (string.compareTo("com.supermap.chart.conversion.ExportSettingChartS57") != 0) continue;
            this.m_ExportSettings.add(new ExportSettingChartS57((ExportSettingChartS57)exportSettings.get(i)));
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            DataExportChartNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this.clearSelfEventHandle();
    }

    public synchronized void addExportSteppedListener(ExportChartSteppedListener exportChartSteppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(exportChartSteppedListener)) {
            this.m_steppedListeners.add(exportChartSteppedListener);
        }
    }

    public synchronized void removeExportSteppedListener(ExportChartSteppedListener exportChartSteppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(exportChartSteppedListener)) {
            this.m_steppedListeners.remove(exportChartSteppedListener);
        }
    }

    protected void fireStepped(ExportChartSteppedEvent exportChartSteppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ExportChartSteppedListener)vector.elementAt(i)).stepped(exportChartSteppedEvent);
            }
        }
    }

    static void exportSteppedCallBack(DataExportChart dataExport, int nPercent, long cancelHandle, String title, String message) {
        int n = nPercent;
        int n2 = dataExport.getExportSettingCharts().getCount();
        int n3 = dataExport.m_completed;
        ExportSettingChart exportSettingChart = dataExport.getExportSettingCharts().get(n3);
        if (n3 >= n2) {
            return;
        }
        int n4 = n3 * 100 / n2;
        Boolean bl = InternalToolkiConversion.getHandleBooleanValue(cancelHandle);
        ExportChartSteppedEvent exportChartSteppedEvent = new ExportChartSteppedEvent((Object)dataExport, title, message, n4, n, exportSettingChart, n2, bl);
        dataExport.fireStepped(exportChartSteppedEvent);
        InternalToolkiConversion.setHandleBooleanValue(cancelHandle, exportChartSteppedEvent.getCancel());
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataExportChartNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkiConversion.managerProducts(InternalToolkiConversion.getChartProducts());
        m_license = InternalToolkiConversion.verifyLicense(arrayList);
    }
}

