/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.License;
import com.supermap.LicenseFeatureInfo;
import com.supermap.ProductType;
import com.supermap.data.AboutBox;
import com.supermap.data.Datasources;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Layouts;
import com.supermap.data.Maps;
import com.supermap.data.Resources;
import com.supermap.data.Scenes;
import com.supermap.data.Toolkit;
import com.supermap.data.WorkspaceCaptionChangedEvent;
import com.supermap.data.WorkspaceCaptionChangedListener;
import com.supermap.data.WorkspaceClosedEvent;
import com.supermap.data.WorkspaceClosedListener;
import com.supermap.data.WorkspaceClosingEvent;
import com.supermap.data.WorkspaceClosingListener;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.WorkspaceConnectionInfoNative;
import com.supermap.data.WorkspaceCreatedEvent;
import com.supermap.data.WorkspaceCreatedListener;
import com.supermap.data.WorkspaceNative;
import com.supermap.data.WorkspaceOpenedEvent;
import com.supermap.data.WorkspaceOpenedListener;
import com.supermap.data.WorkspaceSavedAsEvent;
import com.supermap.data.WorkspaceSavedAsListener;
import com.supermap.data.WorkspaceSavedEvent;
import com.supermap.data.WorkspaceSavedListener;
import com.supermap.data.WorkspaceType;
import com.supermap.data.WorkspaceVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;

public class Workspace
extends InternalHandleDisposable {
    private WorkspaceConnectionInfo m_connectionInfo;
    private Datasources m_datasources;
    private Maps m_maps;
    private Scenes m_scenes;
    private transient CopyOnWriteArrayList<WorkspaceOpenedListener> m_openedListeners;
    private transient CopyOnWriteArrayList<WorkspaceCreatedListener> m_createdListeners;
    private transient CopyOnWriteArrayList<WorkspaceClosingListener> m_closingListeners;
    private transient CopyOnWriteArrayList<WorkspaceClosedListener> m_closedListeners;
    private transient CopyOnWriteArrayList<WorkspaceSavedAsListener> m_savedAsListeners;
    private transient CopyOnWriteArrayList<WorkspaceSavedListener> m_savedListeners;
    private transient CopyOnWriteArrayList<WorkspaceCaptionChangedListener> m_captionChangedListeners;
    private License m_license;
    private Resources m_Resources;
    private Layouts m_Layouts;

    public Workspace() {
        this.checkLicense();
        long l = WorkspaceNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        l = WorkspaceNative.jni_GetConnectionInfo(this.getHandle());
        this.m_connectionInfo = new WorkspaceConnectionInfo(l, false, true);
        this.m_connectionInfo.reset();
        this.m_maps = new Maps(this);
        this.m_datasources = new Datasources(this);
        this.m_scenes = new Scenes(this);
        this.m_Layouts = new Layouts(this);
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = Toolkit.managerProducts(Toolkit.getDataProducts());
        this.m_license = Toolkit.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this.m_license.getFeatureInfo();
        if (licenseFeatureInfo != null) {
            Toolkit.setMappingRuntimeLicenseMode(licenseFeatureInfo.isTrial());
            Toolkit.updateStatus();
            if (this.m_license.isCloudLicense().booleanValue()) {
                Toolkit.SetIsUseCloudLicense(this.m_license.isCloudLicense());
                Toolkit.SetCloudLicenseText(this.m_license.getCompany());
            }
        } else {
            Toolkit.setMappingRuntimeLicenseMode(true);
            Toolkit.updateStatus();
        }
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    public WorkspaceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_connectionInfo;
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String caption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getCaption();
        WorkspaceNative.jni_SetCaption(this.getHandle(), caption);
        WorkspaceCaptionChangedEvent workspaceCaptionChangedEvent = new WorkspaceCaptionChangedEvent(this, this, string, caption);
        this.fireCaptionChanged(workspaceCaptionChangedEvent);
    }

    public Datasources getDatasources() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasources;
    }

    public Maps getMaps() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaps()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_maps;
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isModified()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetIsModified(this.getHandle());
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String description) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (description == null) {
            description = "";
        }
        WorkspaceNative.jni_SetDescription(this.getHandle(), description);
    }

    public WorkspaceType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceNative.jni_GetType(this.getHandle());
        WorkspaceType workspaceType = (WorkspaceType)Enum.parseUGCValue(WorkspaceType.class, n);
        return workspaceType;
    }

    public WorkspaceVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceNative.jni_GetVersion(this.getHandle());
        return (WorkspaceVersion)Enum.parseUGCValue(WorkspaceVersion.class, n);
    }

    public Date getLastUpdateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLastUpdateTime()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = WorkspaceNative.jni_GetLastUpdateTime(this.getHandle());
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public void aboutBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("aboutBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        AboutBox aboutBox = new AboutBox();
    }

    public boolean create(WorkspaceConnectionInfo connectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("create()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_maps.clear();
        this.m_datasources.clearChildHandle();
        boolean bl = WorkspaceNative.jni_Create(this.getHandle(), connectionInfo.getHandle());
        if (bl) {
            WorkspaceCreatedEvent workspaceCreatedEvent = new WorkspaceCreatedEvent(this, this, connectionInfo);
            this.fireCreated(workspaceCreatedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    public boolean open(WorkspaceConnectionInfo connectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkLicense();
        this.close();
        Toolkit.clearErrors();
        boolean bl = WorkspaceNative.jni_Open(this.getHandle(), connectionInfo.getHandle());
        if (!bl) {
            this.getConnectionInfo().setReadOnly(false);
            this.getConnectionInfo().setVersion(WorkspaceVersion.UGC20);
            this.getConnectionInfo().setReadOnly(true);
        }
        this.getDatasources().reset();
        WorkspaceVersion workspaceVersion = this.getConnectionInfo().getVersion();
        this.setConnectionInfo(connectionInfo);
        WorkspaceConnectionInfoNative.jni_SetVersion(this.getConnectionInfo().getHandle(), workspaceVersion.getUGCValue());
        if (bl) {
            WorkspaceOpenedEvent workspaceOpenedEvent = new WorkspaceOpenedEvent(this, this);
            this.fireOpened(workspaceOpenedEvent);
        }
        if (!bl) {
            return bl;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    public boolean saveAs(WorkspaceConnectionInfo connectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveAs()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setConnectionInfo(connectionInfo);
        boolean bl = WorkspaceNative.jni_SaveAs(this.getHandle(), connectionInfo.getHandle());
        if (bl) {
            WorkspaceSavedAsEvent workspaceSavedAsEvent = new WorkspaceSavedAsEvent(this, this);
            this.fireSavedAs(workspaceSavedAsEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        WorkspaceClosingEvent workspaceClosingEvent = new WorkspaceClosingEvent(this, this);
        this.fireClosing(workspaceClosingEvent);
        if (workspaceClosingEvent.getCancel()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.getMaps().clear();
            this.getScenes().clear();
            WorkspaceNative.jni_Close(this.getHandle());
            this.getDatasources().clearChildHandle();
            if (this.m_Resources != null) {
                this.m_Resources.clearHandle();
                this.m_Resources = null;
            }
            this.getConnectionInfo().reset();
            this.reset();
        }
        object = new WorkspaceClosedEvent(this, this);
        this.fireClosed((WorkspaceClosedEvent)object);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
            WorkspaceNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this.unLoadLicense();
    }

    protected static void refresh(Workspace ws) {
        ws.getDatasources().refresh();
    }

    public boolean save() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("save()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = WorkspaceNative.jni_Save(this.getHandle());
        if (bl) {
            WorkspaceSavedEvent workspaceSavedEvent = new WorkspaceSavedEvent(this, this);
            this.fireSaved(workspaceSavedEvent);
        }
        return bl;
    }

    public static boolean deleteWorkspace(WorkspaceConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = connectionInfo.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = WorkspaceNative.jni_DeleteWorkspace(l);
        if (bl) {
            connectionInfo.clearHandle();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    public static String[] getWorkspaceName(WorkspaceConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            String string = InternalResource.loadString("getWorkspaceName()", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = connectionInfo.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        if (connectionInfo.getType().equals(WorkspaceType.DEFAULT)) {
            stringArray = null;
        } else if (connectionInfo.getType().equals(WorkspaceType.SXW) || connectionInfo.getType().equals(WorkspaceType.SMW) || connectionInfo.getType().equals(WorkspaceType.SXWU) || connectionInfo.getType().equals(WorkspaceType.SMWU)) {
            String string = connectionInfo.getServer();
            stringArray = new String[]{string};
            if (string.toLowerCase().endsWith(".sxw")) {
                int n = string.toLowerCase().lastIndexOf(".sxw");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".smw")) {
                int n = string.toLowerCase().lastIndexOf(".smw");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".sxwu")) {
                int n = string.toLowerCase().lastIndexOf(".sxwu");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".smwu")) {
                int n = string.toLowerCase().lastIndexOf(".smwu");
                stringArray[0] = string.substring(0, n);
            }
        } else {
            stringArray = WorkspaceNative.jni_GetWorkspaceName(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return stringArray;
    }

    public Resources getResources() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_Resources == null && (l = WorkspaceNative.jni_GetResources(this.getHandle())) != 0L) {
            this.m_Resources = new Resources(this, l);
        }
        return this.m_Resources;
    }

    public Scenes getScenes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScenes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_scenes;
    }

    public Layouts getLayouts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayouts()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_Layouts;
    }

    public boolean changePassword(String oldPassword, String newPassword) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("changePassword(String oldPassword, String newPassword)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldPassword == null || newPassword == null) {
            String string = InternalResource.loadString("password", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        return WorkspaceNative.jni_ChangePassword(this.getHandle(), oldPassword, newPassword);
    }

    void reset() {
        WorkspaceNative.jni_Reset(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.m_datasources != null) {
            this.m_datasources.clearHandle();
            this.m_datasources = null;
        }
        if (this.m_maps != null) {
            this.m_maps.clearHandle();
            this.m_maps = null;
        }
        if (this.m_Layouts != null) {
            this.m_Layouts.clearHandle();
            this.m_Layouts = null;
        }
        if (this.m_connectionInfo != null) {
            this.m_connectionInfo.clearHandle();
            this.m_connectionInfo = null;
        }
        if (this.m_Resources != null) {
            this.m_Resources.clearHandle();
            this.m_Resources = null;
        }
        if (this.m_scenes != null) {
            this.m_scenes.clearHandle();
            this.m_scenes = null;
        }
        this.setHandle(0L);
    }

    License getLicense() {
        return this.m_license;
    }

    private void setConnectionInfo(WorkspaceConnectionInfo info) {
        WorkspaceConnectionInfoNative.jni_SetValue(this.getConnectionInfo().getHandle(), info.getHandle());
    }

    public synchronized void addOpenedListener(WorkspaceOpenedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_openedListeners == null) {
            this.m_openedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_openedListeners.contains(listener)) {
            this.m_openedListeners.add(listener);
        }
    }

    public void removeOpenedListener(WorkspaceOpenedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeOpenedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_openedListeners != null && this.m_openedListeners.contains(listener)) {
            this.m_openedListeners.remove(listener);
        }
    }

    public synchronized void addCreatedListener(WorkspaceCreatedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addCreatedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_createdListeners == null) {
            this.m_createdListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_createdListeners.contains(listener)) {
            this.m_createdListeners.add(listener);
        }
    }

    public void removeCreatedListener(WorkspaceCreatedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeCreatedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_createdListeners != null && this.m_createdListeners.contains(listener)) {
            this.m_createdListeners.remove(listener);
        }
    }

    public synchronized void addClosingListener(WorkspaceClosingListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addClosingListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_closingListeners == null) {
            this.m_closingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_closingListeners.contains(listener)) {
            this.m_closingListeners.add(listener);
        }
    }

    public void removeClosingListener(WorkspaceClosingListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeClosingListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_closingListeners != null && this.m_closingListeners.contains(listener)) {
            this.m_closingListeners.remove(listener);
        }
    }

    protected void fireOpened(WorkspaceOpenedEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireOpened()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_openedListeners != null) {
            CopyOnWriteArrayList<WorkspaceOpenedListener> copyOnWriteArrayList = this.m_openedListeners;
            for (WorkspaceOpenedListener workspaceOpenedListener : copyOnWriteArrayList) {
                workspaceOpenedListener.workspaceOpened(event);
            }
        }
    }

    protected void fireCreated(WorkspaceCreatedEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireCreated()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_createdListeners != null) {
            CopyOnWriteArrayList<WorkspaceCreatedListener> copyOnWriteArrayList = this.m_createdListeners;
            for (WorkspaceCreatedListener workspaceCreatedListener : copyOnWriteArrayList) {
                workspaceCreatedListener.workspaceCreated(event);
            }
        }
    }

    protected void fireClosing(WorkspaceClosingEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosing()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_closingListeners != null) {
            CopyOnWriteArrayList<WorkspaceClosingListener> copyOnWriteArrayList = this.m_closingListeners;
            for (WorkspaceClosingListener workspaceClosingListener : copyOnWriteArrayList) {
                workspaceClosingListener.workspaceClosing(event);
            }
        }
    }

    public synchronized void addClosedListener(WorkspaceClosedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addClosedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_closedListeners == null) {
            this.m_closedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_closedListeners.contains(listener)) {
            this.m_closedListeners.add(listener);
        }
    }

    public void removeClosedListener(WorkspaceClosedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeClosedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_closedListeners != null && this.m_closedListeners.contains(listener)) {
            this.m_closedListeners.remove(listener);
        }
    }

    protected void fireClosed(WorkspaceClosedEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_closedListeners != null) {
            CopyOnWriteArrayList<WorkspaceClosedListener> copyOnWriteArrayList = this.m_closedListeners;
            for (WorkspaceClosedListener workspaceClosedListener : copyOnWriteArrayList) {
                workspaceClosedListener.workspaceClosed(event);
            }
        }
    }

    public synchronized void addSavedAsListener(WorkspaceSavedAsListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addSavedAsListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_savedAsListeners == null) {
            this.m_savedAsListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_savedAsListeners.contains(listener)) {
            this.m_savedAsListeners.add(listener);
        }
    }

    public void removeSavedAsListener(WorkspaceSavedAsListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeSavedAsListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_savedAsListeners != null && this.m_savedAsListeners.contains(listener)) {
            this.m_savedAsListeners.remove(listener);
        }
    }

    protected void fireSavedAs(WorkspaceSavedAsEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_savedAsListeners != null) {
            CopyOnWriteArrayList<WorkspaceSavedAsListener> copyOnWriteArrayList = this.m_savedAsListeners;
            for (WorkspaceSavedAsListener workspaceSavedAsListener : copyOnWriteArrayList) {
                workspaceSavedAsListener.workspaceSavedAs(event);
            }
        }
    }

    public synchronized void addSavedListener(WorkspaceSavedListener listener) {
        if (this.m_savedListeners == null) {
            this.m_savedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_savedListeners.contains(listener)) {
            this.m_savedListeners.add(listener);
        }
    }

    public void removeSavedListener(WorkspaceSavedListener listener) {
        if (this.m_savedListeners != null && this.m_savedListeners.contains(listener)) {
            this.m_savedListeners.remove(listener);
        }
    }

    protected void fireSaved(WorkspaceSavedEvent event) {
        if (this.m_savedListeners != null) {
            CopyOnWriteArrayList<WorkspaceSavedListener> copyOnWriteArrayList = this.m_savedListeners;
            for (WorkspaceSavedListener workspaceSavedListener : copyOnWriteArrayList) {
                workspaceSavedListener.workspaceSaved(event);
            }
        }
    }

    public synchronized void addCaptionChangedListener(WorkspaceCaptionChangedListener listener) {
        if (this.m_captionChangedListeners == null) {
            this.m_captionChangedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_captionChangedListeners.contains(listener)) {
            this.m_captionChangedListeners.add(listener);
        }
    }

    public void removeCaptionChangedListener(WorkspaceCaptionChangedListener listener) {
        if (this.m_captionChangedListeners != null && this.m_captionChangedListeners.contains(listener)) {
            this.m_captionChangedListeners.remove(listener);
        }
    }

    protected void fireCaptionChanged(WorkspaceCaptionChangedEvent event) {
        if (this.m_captionChangedListeners != null) {
            CopyOnWriteArrayList<WorkspaceCaptionChangedListener> copyOnWriteArrayList = this.m_captionChangedListeners;
            for (WorkspaceCaptionChangedListener workspaceCaptionChangedListener : copyOnWriteArrayList) {
                workspaceCaptionChangedListener.workspaceCaptionChanged(event);
            }
        }
    }

    static void loadPlugins() {
        WorkspaceNative.jni_InitPlugins();
    }

    public String getDesktopInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDesktopInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetDesktopInfo(this.getHandle());
    }

    public void setDesktopInfo(String desktopInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDesktopInfo(String desktopInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desktopInfo == null) {
            desktopInfo = "";
        }
        WorkspaceNative.jni_SetDesktopInfo(this.getHandle(), desktopInfo);
    }

    static {
        Environment.LoadWrapJ();
        Workspace.loadPlugins();
        License.setUGOBasePath(Environment.getUGOBasePath());
    }
}

