/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.SpatialIndexInfoNative;
import com.supermap.data.SpatialIndexType;

public class SpatialIndexInfo
extends InternalHandleDisposable {
    public SpatialIndexInfo() {
        long l = SpatialIndexInfoNative.jni_New();
        this.setHandle(l, true);
    }

    public SpatialIndexInfo(SpatialIndexType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = SpatialIndexInfoNative.jni_New2(type.getUGCValue());
        this.setHandle(l, true);
    }

    public SpatialIndexInfo(int leafObjectCount) {
        long l = SpatialIndexInfoNative.jni_New3(leafObjectCount);
        this.setHandle(l, true);
    }

    public SpatialIndexInfo(String tileField) {
        long l = SpatialIndexInfoNative.jni_New4(tileField);
        this.setHandle(l, true);
    }

    public SpatialIndexInfo(double tileWidth, double tileHeight) {
        if (tileWidth <= 0.0) {
            String string = InternalResource.loadString("tileWidth", "SpatialIndexInfo_TileWidthShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tileHeight <= 0.0) {
            String string = InternalResource.loadString("tileHeight", "SpatialIndexInfo_TileHeightShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SpatialIndexInfoNative.jni_New5(tileWidth, tileHeight);
        this.setHandle(l, true);
    }

    public SpatialIndexInfo(Point2D gridCenter, double gridSize0, double gridSize1, double gridSize2) {
        if (gridCenter == null) {
            String string = InternalResource.loadString("gridCenter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (gridCenter.isEmpty()) {
            String string = InternalResource.loadString("gridCenter", "Point2D_IsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (gridSize0 <= 0.0) {
            String string = InternalResource.loadString("gridSize0", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (gridSize1 <= 0.0) {
            String string = InternalResource.loadString("gridSize1", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (gridSize2 <= 0.0) {
            String string = InternalResource.loadString("gridSize2", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SpatialIndexInfoNative.jni_New6(gridCenter.getX(), gridCenter.getY(), gridSize0, gridSize1, gridSize2);
        this.setHandle(l, true);
    }

    public SpatialIndexInfo(SpatialIndexInfo spatialIndexInfo) {
        if (spatialIndexInfo == null || spatialIndexInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("gridCenter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = SpatialIndexInfoNative.jni_New7(spatialIndexInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(spatialIndexInfo);
    }

    SpatialIndexInfo(long handle) {
        this.setHandle(handle, false);
    }

    protected static SpatialIndexInfo createInstance(long handle) {
        if (handle == 0L) {
            return null;
        }
        return new SpatialIndexInfo(handle);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SpatialIndexInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public SpatialIndexInfo clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new SpatialIndexInfo(this);
    }

    public SpatialIndexType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SpatialIndexInfoNative.jni_GetType(this.getHandle());
        return (SpatialIndexType)Enum.parseUGCValue(SpatialIndexType.class, n);
    }

    public void setType(SpatialIndexType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        SpatialIndexInfoNative.jni_SetType(this.getHandle(), type.getUGCValue());
    }

    public int getLeafObjectCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeafObjectCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetLeafObjectCount(this.getHandle());
    }

    public void setLeafObjectCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeafObjectCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialIndexInfoNative.jni_SetLeafObjectCount(this.getHandle(), value);
    }

    @Deprecated
    public String getTileField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileField()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetTileField(this.getHandle());
    }

    @Deprecated
    public void setTileField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileField(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialIndexInfoNative.jni_SetTileField(this.getHandle(), value);
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetTileWidth(this.getHandle());
    }

    public void setTileWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "SpatialIndexInfo_TileWidthShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetTileWidth(this.getHandle(), value);
    }

    public double getTileHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetTileHeight(this.getHandle());
    }

    public void setTileHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "SpatialIndexInfo_TileHeightShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetTileHeight(this.getHandle(), value);
    }

    public Point2D getGridCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = SpatialIndexInfoNative.jni_GetGridCenter(this.getHandle());
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setGridCenter(Point2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (value.isEmpty()) {
            String string = InternalResource.loadString("value", "Point2D_IsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridCenter(this.getHandle(), value.getX(), value.getY());
    }

    public double getGridSize0() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridSize0()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetGridSize0(this.getHandle());
    }

    public void setGridSize0(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridSize0(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridSize0(this.getHandle(), value);
    }

    public double getGridSize1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridSize1()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetGridSize1(this.getHandle());
    }

    public void setGridSize1(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridSize1(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridSize1(this.getHandle(), value);
    }

    public double getGridSize2() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridSize2()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetGridSize2(this.getHandle());
    }

    public void setGridSize2(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridSize2(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridSize2(this.getHandle(), value);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Type = ");
        stringBuffer.append(this.getType().name());
        stringBuffer.append(",LeafObjectCount=");
        stringBuffer.append(this.getLeafObjectCount());
        stringBuffer.append(",TileField=\"");
        stringBuffer.append(this.getTileField());
        stringBuffer.append("\",TileWidth=");
        stringBuffer.append(this.getTileWidth());
        stringBuffer.append(",TileHeight=");
        stringBuffer.append(this.getTileHeight());
        stringBuffer.append(",GridCenter=");
        stringBuffer.append(this.getGridCenter());
        stringBuffer.append(",GridSize0=");
        stringBuffer.append(this.getGridSize0());
        stringBuffer.append(",GridSize1=");
        stringBuffer.append(this.getGridSize1());
        stringBuffer.append(",=GridSize2=");
        stringBuffer.append(this.getGridSize2());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

