/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.annotation;

import com.supermap.annotation.GPInputFieldDef;
import com.supermap.annotation.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Optional;

class GPInputField {
    private Class<?> declaredType;
    private Field field;
    private String inputFieldName;
    private IGetter getter;
    private ISetter setter;

    private GPInputField(Class<?> declaredType, String inputFieldName, Field field, IGetter getter, ISetter setter) {
        this.declaredType = declaredType;
        this.inputFieldName = inputFieldName;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    public Class<?> getDeclaredType() {
        return this.declaredType;
    }

    public Field getField() {
        return this.field;
    }

    public String getInputFieldName() {
        return this.inputFieldName;
    }

    public Object getFieldValue(Object src) {
        return this.getter.getValue(src);
    }

    public void setFieldValue(Object src, Object value) {
        this.setter.setValue(src, value);
    }

    public static GPInputField findField(Class<?> declaredType, String fieldName) {
        Objects.requireNonNull(declaredType);
        return GPInputField.findFieldByAnnotation(declaredType, fieldName);
    }

    private static GPInputField findFieldByAnnotation(Class<?> declaredType, String fieldName) {
        Field[] fieldArray;
        for (Field field : fieldArray = declaredType.getDeclaredFields()) {
            GPInputFieldDef gPInputFieldDef = field.getAnnotation(GPInputFieldDef.class);
            if (gPInputFieldDef == null || !gPInputFieldDef.name().equals(fieldName)) continue;
            IGetter iGetter = null;
            ISetter iSetter = null;
            Method method = GPInputField.findMethod(declaredType, gPInputFieldDef.getter(), null);
            Method method2 = GPInputField.findMethod(declaredType, gPInputFieldDef.setter(), field.getType());
            if (!Modifier.isPublic(field.getModifiers())) {
                iGetter = Optional.ofNullable(method).map(MethodGetter::new).orElse(null);
                iSetter = Optional.ofNullable(method2).map(MethodSetter::new).orElse(null);
            } else {
                iGetter = Optional.ofNullable(method).map(MethodGetter::new).map(IGetter.class::cast).orElse(new FieldGetter(field));
                iSetter = Optional.ofNullable(method2).map(MethodSetter::new).map(ISetter.class::cast).orElse(new FieldSetter(field));
            }
            if (iGetter == null || iSetter == null) {
                return null;
            }
            return new GPInputField(declaredType, fieldName, field, iGetter, iSetter);
        }
        return null;
    }

    private static Method findMethod(Class<?> declaredType, String methodName, Class<?> ... parameterTypes) {
        if (Utils.isNullOrEmpty(methodName)) {
            return null;
        }
        try {
            return declaredType.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    static class MethodSetter
    implements ISetter {
        private Method method;

        public MethodSetter(Method method) {
            Objects.requireNonNull(method);
            this.method = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(Object src, Object value) {
            try {
                if (this.method.isAccessible()) {
                    this.method.setAccessible(true);
                }
                this.method.invoke(src, value);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            finally {
                this.method.setAccessible(false);
            }
        }
    }

    static class FieldSetter
    implements ISetter {
        private Field field;

        public FieldSetter(Field field) {
            this.field = field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(Object src, Object value) {
            Objects.requireNonNull(src);
            try {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                this.field.set(src, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            finally {
                this.field.setAccessible(false);
            }
        }
    }

    static interface ISetter {
        public void setValue(Object var1, Object var2);
    }

    static class MethodGetter
    implements IGetter {
        private Method method;

        public MethodGetter(Method method) {
            Objects.requireNonNull(method);
            this.method = method;
        }

        @Override
        public Object getValue(Object src) {
            try {
                if (!this.method.isAccessible()) {
                    this.method.setAccessible(true);
                }
                return this.method.invoke(src, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
                return null;
            }
        }
    }

    static class FieldGetter
    implements IGetter {
        private Field field;

        public FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object getValue(Object src) {
            try {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                Object object = this.field.get(src);
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            finally {
                this.field.setAccessible(false);
            }
            return null;
        }
    }

    static interface IGetter {
        public Object getValue(Object var1);
    }
}

