/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressMatchResultNative;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.data.DatasetVector;
import com.supermap.data.Point2D;
import java.util.HashMap;

public class AddressMatchResult
extends InternalHandle {
    private HashMap m_datasetHashMap;

    AddressMatchResult(long handle, HashMap datasetHashMap) {
        this.setHandle(handle);
        this.m_datasetHashMap = datasetHashMap;
    }

    public DatasetVector getDataset() {
        int n = AddressMatchResultNative.jni_GetDatasetIndex(this.getHandle());
        Integer n2 = new Integer(n);
        DatasetVector datasetVector = (DatasetVector)this.m_datasetHashMap.get(n2);
        return datasetVector;
    }

    public int getDatasetIndex() {
        return AddressMatchResultNative.jni_GetDatasetIndex(this.getHandle());
    }

    public int getID() {
        return AddressMatchResultNative.jni_GetID(this.getHandle());
    }

    public double getScore() {
        return AddressMatchResultNative.jni_GetScore(this.getHandle());
    }

    public String getAddress() {
        return AddressMatchResultNative.jni_GetAddress(this.getHandle());
    }

    @Deprecated
    public String getProvince() {
        return AddressMatchResultNative.jni_GetProvince(this.getHandle());
    }

    @Deprecated
    public String getCity() {
        return AddressMatchResultNative.jni_GetCity(this.getHandle());
    }

    @Deprecated
    public String getCounty() {
        return AddressMatchResultNative.jni_GetCounty(this.getHandle());
    }

    public String getTopGroupName() {
        return AddressMatchResultNative.jni_GetProvince(this.getHandle());
    }

    public String getSecondaryGroupName() {
        return AddressMatchResultNative.jni_GetCity(this.getHandle());
    }

    public String getLowestGroupName() {
        return AddressMatchResultNative.jni_GetCounty(this.getHandle());
    }

    public Point2D getLocation() {
        double[] dArray = new double[2];
        AddressMatchResultNative.jni_GetLocation(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public String[] getAddresses() {
        return AddressMatchResultNative.jni_GetAddresses(this.getHandle());
    }
}

