/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialstatistics.BShadeEstimateMethod;
import com.supermap.analyst.spatialstatistics.BShadeEstimationResult;
import com.supermap.analyst.spatialstatistics.BShadeSamplingParameter;
import com.supermap.analyst.spatialstatistics.BShadeSamplingResult;
import com.supermap.analyst.spatialstatistics.InternalDatasetVector;
import com.supermap.analyst.spatialstatistics.InternalDatasets;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.InternalToolkitSpatialStatistics;
import com.supermap.analyst.spatialstatistics.LayeredRandomSamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.LayeredRandomSamplingParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingInferenceNative;
import com.supermap.analyst.spatialstatistics.SamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.SamplingParameter;
import com.supermap.analyst.spatialstatistics.SandwichRandomSamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.SandwichRandomSamplingParameter;
import com.supermap.analyst.spatialstatistics.SimpleRandomSamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.SimpleRandomSamplingParameter;
import com.supermap.analyst.spatialstatistics.SpatialLayeredRandomSamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.SpatialLayeredRandomSamplingParameter;
import com.supermap.analyst.spatialstatistics.SpatialSimpleRandomSamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.SpatialSimpleRandomSamplingParameter;
import com.supermap.analyst.spatialstatistics.SystematicRandomSamplingInferenceResult;
import com.supermap.analyst.spatialstatistics.SystematicRandomSamplingParameter;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SamplingInference {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private SamplingInference() {
    }

    public static DatasetVector SPA(DatasetVector sourceDataset, DatasetVector referenceDataset, String srcUniqueIDFieldName, String srcDataFieldName, String refUniqueIDFieldName, String[] refDataFieldNames, Datasource outputDatasource, String outputDatasetName) {
        SamplingInference.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (referenceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceDataset) == 0L) {
            String string = InternalResource.loadString("referenceDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("sourceDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (referenceDataset.getType() != DatasetType.REGION && referenceDataset.getType() != DatasetType.POINT && referenceDataset.getType() != DatasetType.LINE && referenceDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("referenceDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcUniqueIDFieldName == null || srcUniqueIDFieldName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("srcUniqueIDFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcDataFieldName == null || srcDataFieldName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("srcDataFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (refUniqueIDFieldName == null || refUniqueIDFieldName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("refUniqueIDFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (refDataFieldNames == null || refDataFieldNames.length == 0) {
            String string = InternalResource.loadString("refDataFieldNames", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < refDataFieldNames.length; ++i) {
            if (refDataFieldNames[i] != null && !refDataFieldNames[i].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("refDataFieldNames[" + i + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceDataset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        String[] stringArray = new String[1];
        long l4 = SamplingInferenceNative.jni_SPA(l, l2, srcUniqueIDFieldName, srcDataFieldName, refUniqueIDFieldName, refDataFieldNames, l3, outputDatasetName, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
        return datasetVector;
    }

    public static BShadeEstimationResult BShadeEstimation(DatasetVector sourceDataset, DatasetVector historicalDataset, String[] srcDataFieldNames, String[] histDataFieldNames, BShadeEstimateMethod estimateMethod, Datasource outputDatasource, String outputDatasetName) {
        int n;
        SamplingInference.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (historicalDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)historicalDataset) == 0L) {
            String string = InternalResource.loadString("historicalDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("sourceDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (historicalDataset.getType() != DatasetType.REGION && historicalDataset.getType() != DatasetType.POINT && historicalDataset.getType() != DatasetType.LINE && historicalDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("historicalDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcDataFieldNames == null || srcDataFieldNames.length == 0) {
            String string = InternalResource.loadString("srcDataFieldNames", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < srcDataFieldNames.length; ++n) {
            if (srcDataFieldNames[n] != null && !srcDataFieldNames[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("srcDataFieldNames[" + n + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (histDataFieldNames == null || histDataFieldNames.length == 0) {
            String string = InternalResource.loadString("histDataFieldNames", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < histDataFieldNames.length; ++n) {
            if (histDataFieldNames[n] != null && !histDataFieldNames[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("histDataFieldNames[" + n + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)historicalDataset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n2 = InternalEnum.getUGCValue(estimateMethod);
        double[] dArray = new double[1 + srcDataFieldNames.length];
        String[] stringArray = new String[1];
        long l4 = SamplingInferenceNative.jni_BShadeEstimation(l, l2, srcDataFieldNames, histDataFieldNames, n2, l3, outputDatasetName, dArray, stringArray);
        BShadeEstimationResult bShadeEstimationResult = null;
        if (l4 == 0L) {
            if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
        } else {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            double d = dArray[0];
            double[] dArray2 = new double[srcDataFieldNames.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[i + 1];
            }
            bShadeEstimationResult = new BShadeEstimationResult(datasetVector, d, dArray2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
        return bShadeEstimationResult;
    }

    public static BShadeSamplingResult[] BShadeSampling(DatasetVector historicalDataset, String[] histDataFieldNames, BShadeSamplingParameter para) {
        SamplingInference.verifyLicense();
        if (historicalDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)historicalDataset) == 0L) {
            String string = InternalResource.loadString("historicalDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (historicalDataset.getType() != DatasetType.REGION && historicalDataset.getType() != DatasetType.POINT && historicalDataset.getType() != DatasetType.LINE && historicalDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("historicalDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (histDataFieldNames == null || histDataFieldNames.length == 0) {
            String string = InternalResource.loadString("srcDataFieldNames", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < histDataFieldNames.length; ++i) {
            if (histDataFieldNames[i] != null && !histDataFieldNames[i].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("histDataFieldNames[" + i + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (para == null) {
            String string = InternalResource.loadString("para", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)historicalDataset);
        String[] stringArray = new String[1];
        long[] lArray = SamplingInferenceNative.jni_BShadeSampling(l, histDataFieldNames, InternalEnum.getUGCValue(para.getBShadeSampleNumberMethod()), InternalEnum.getUGCValue(para.getBShadeEstimateMethod()), para.getSelectSampleNumber(), para.getSelectSampleRangeL(), para.getSelectSampleRangeU(), para.getSelectSampleRangeStep(), para.getInitialTemperature(), para.getMinTemperature(), para.getMinEnergy(), para.getCoolRate(), para.getMaxConsecutiveRejection(), para.getMaxTry(), para.getMaxSuccess(), para.getMaxFullCombination(), stringArray);
        BShadeSamplingResult[] bShadeSamplingResultArray = null;
        if (lArray == null) {
            if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
        } else {
            bShadeSamplingResultArray = new BShadeSamplingResult[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                bShadeSamplingResultArray[i] = new BShadeSamplingResult(lArray[i]);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)historicalDataset);
        return bShadeSamplingResultArray;
    }

    private static DatasetVector internalSpatialSampling(Dataset dataset, DatasetVector sampleRangeDataset, Datasource outputDatasource, String outputDatasetName, SamplingParameter para, int nSampleType, DatasetVector reportingUnitDataset) {
        SamplingInference.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (dataset.getType() != DatasetType.REGION && dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.GRID) {
            String string = InternalResource.loadString("dataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sampleRangeDataset != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)sampleRangeDataset) == 0L) {
                String string = InternalResource.loadString("sampleRangeDataset", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
                throw new NullPointerException(string);
            }
            if (sampleRangeDataset.getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("sampleRangeDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (!(nSampleType != 3 && nSampleType != 5 && nSampleType != 6 || sampleRangeDataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)sampleRangeDataset) != 0L)) {
            String string = InternalResource.loadString("sampleRangeDataset", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (nSampleType == 4 && (para.m_dSpatialRelation < 0.0 || para.m_dSpatialRelation > 1.0)) {
            String string = InternalResource.loadString("SpatialSimpleRandomSamplingParameter.SpatialAutocorrelationCoefficient", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (nSampleType == 6) {
            if (reportingUnitDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)reportingUnitDataset) == 0L) {
                String string = InternalResource.loadString("reportingUnitDataset", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
                throw new NullPointerException(string);
            }
            if (reportingUnitDataset.getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("reportingUnitDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (dataset.getType() == DatasetType.REGION && para.getResolution() <= 0.0) {
            String string = InternalResource.loadString("SamplingParameter.Resolution", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getExpandRatio() < 0.0 || para.getExpandRatio() > 1.0) {
            String string = InternalResource.loadString("SamplingParameter.ExpandRatio", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (!para.m_SetFunction || para.getSamplingFunctionParameter() == null) {
            String string = InternalResource.loadString("SamplingParameter.SamplingFunctionParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (para.isProportion()) {
            if (para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.FUNCTIONPROPORTIONA && para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.FUNCTIONPROPORTIONB && para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.FUNCTIONPROPORTIONC && para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.FUNCTIONPROPORTIOND && para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.FUNCTIONPROPORTIONE && para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.LAYEREDFUNCTIONPROPORTIONA && para.getSamplingFunctionParameter().getFunctionType() != SamplingFunctionType.LAYEREDFUNCTIONPROPORTIONB) {
                String string = InternalResource.loadString("SamplingParameter.IsProportion", "Global_ArgumentTypeInvalid", "spatialstatistics_resources");
                throw new NullPointerException(string);
            }
        } else if (para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.FUNCTIONPROPORTIONA || para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.FUNCTIONPROPORTIONB || para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.FUNCTIONPROPORTIONC || para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.FUNCTIONPROPORTIOND || para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.FUNCTIONPROPORTIONE || para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.LAYEREDFUNCTIONPROPORTIONA || para.getSamplingFunctionParameter().getFunctionType() == SamplingFunctionType.LAYEREDFUNCTIONPROPORTIONB) {
            String string = InternalResource.loadString("SamplingParameter.IsProportion", "Global_ArgumentTypeInvalid", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = 0L;
        if (sampleRangeDataset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sampleRangeDataset);
        }
        long l3 = 0L;
        if (reportingUnitDataset != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)reportingUnitDataset);
        }
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)para);
        String[] stringArray = new String[1];
        long l6 = SamplingInferenceNative.jni_InternalSpatialSampling(l, l2, l3, l4, outputDatasetName, l5, nSampleType, stringArray);
        DatasetVector datasetVector = null;
        if (l6 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l6, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)para));
        return datasetVector;
    }

    private static SamplingInferenceResult internalSpatialSamplingInference(DatasetVector pointDataset, String strSampleFieldName, double dConfidenceLevel, int nSampleType, String strLayeredIDFieldName, String strPopulationFieldName, DatasetVector layeredDataset, DatasetVector reportingUnitDataset) {
        String string;
        SamplingInference.verifyLicense();
        if (pointDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDataset) == 0L) {
            String string2 = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string2);
        }
        if (strSampleFieldName == null || strSampleFieldName.trim().equalsIgnoreCase("")) {
            String string3 = InternalResource.loadString("strSampleFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string3);
        }
        if (dConfidenceLevel < 0.0 || dConfidenceLevel > 1.0) {
            String string4 = InternalResource.loadString("dConfidenceLevel", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string4);
        }
        if (nSampleType == 3 || nSampleType == 5 || nSampleType == 6) {
            if (strLayeredIDFieldName == null || strLayeredIDFieldName.trim().equalsIgnoreCase("")) {
                String string5 = InternalResource.loadString("strLayeredIDFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                throw new IllegalArgumentException(string5);
            }
            if (strPopulationFieldName == null || strPopulationFieldName.trim().equalsIgnoreCase("")) {
                String string6 = InternalResource.loadString("strPopulationFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                throw new IllegalArgumentException(string6);
            }
            if (pointDataset.getFieldInfos().indexOf(strLayeredIDFieldName) == -1) {
                String string7 = InternalResource.loadString("strLayeredIDFieldName", "GlobalSpecifiedNameNotExists", "spatialstatistics_resources");
                throw new IllegalArgumentException(string7);
            }
            if (pointDataset.getFieldInfos().indexOf(strPopulationFieldName) == -1) {
                String string8 = InternalResource.loadString("strPopulationFieldName", "GlobalSpecifiedNameNotExists", "spatialstatistics_resources");
                throw new IllegalArgumentException(string8);
            }
            string = pointDataset.getFieldInfos().get(strLayeredIDFieldName);
            if (string == null || string.getType() != FieldType.INT16 && string.getType() != FieldType.INT32 && string.getType() != FieldType.INT64) {
                String string9 = InternalResource.loadString("strLayeredIDFieldName", "InterPolator_UnsupportedFieldType", "spatialstatistics_resources");
                throw new IllegalArgumentException(string9);
            }
            string = pointDataset.getFieldInfos().get(strPopulationFieldName);
            if (string == null || string.getType() != FieldType.INT16 && string.getType() != FieldType.INT32 && string.getType() != FieldType.INT64) {
                String string10 = InternalResource.loadString("strPopulationFieldName", "InterPolator_UnsupportedFieldType", "spatialstatistics_resources");
                throw new IllegalArgumentException(string10);
            }
        }
        if (nSampleType == 6) {
            if (reportingUnitDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)reportingUnitDataset) == 0L) {
                string = InternalResource.loadString("reportingUnitDataset", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
                throw new NullPointerException(string);
            }
            if (reportingUnitDataset.getType() != DatasetType.REGION) {
                string = InternalResource.loadString("reportingUnitDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (layeredDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)layeredDataset) == 0L) {
                string = InternalResource.loadString("layeredDataset", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
                throw new NullPointerException(string);
            }
            if (layeredDataset.getType() != DatasetType.REGION) {
                string = InternalResource.loadString("layeredDataset", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDataset);
        long l2 = 0L;
        if (reportingUnitDataset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)reportingUnitDataset);
        }
        long l3 = 0L;
        if (layeredDataset != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)layeredDataset);
        }
        String[] stringArray = new String[1];
        double[] dArray = SamplingInferenceNative.jni_InternalSpatialSamplingInference(l, l3, l2, strSampleFieldName, dConfidenceLevel, nSampleType, strLayeredIDFieldName, strPopulationFieldName, stringArray);
        SamplingInferenceResult samplingInferenceResult = null;
        if (dArray != null && dArray.length != 0) {
            if (dArray.length > 0) {
                int[] nArray = null;
                double[] dArray2 = null;
                int n = 0;
                if (nSampleType == 3 || nSampleType == 5 || nSampleType == 6) {
                    n = (int)dArray[6];
                    nArray = new int[n];
                    dArray2 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = (int)dArray[7 + i];
                        dArray2[i] = dArray[7 + n + i];
                    }
                }
                int[] nArray2 = null;
                double[] dArray3 = null;
                double[] dArray4 = null;
                if (nSampleType == 6) {
                    int n2 = 7 + 2 * n;
                    n = (int)dArray[n2];
                    ++n2;
                    nArray2 = new int[n];
                    dArray3 = new double[n];
                    dArray4 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        nArray2[i] = (int)dArray[n2 + i];
                        dArray3[i] = dArray[n2 + n + i];
                        dArray4[i] = dArray[n2 + 2 * n + i];
                    }
                }
                samplingInferenceResult = new SamplingInferenceResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], nArray, dArray2, nArray2, dArray3, dArray4);
            }
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return samplingInferenceResult;
    }

    public static DatasetVector simpleRandomSampling(Dataset dataset, DatasetVector sampleRangeDataset, Datasource outputDatasource, String outputDatasetName, SimpleRandomSamplingParameter para) {
        int n = 1;
        return SamplingInference.internalSpatialSampling(dataset, sampleRangeDataset, outputDatasource, outputDatasetName, para, n, null);
    }

    public static DatasetVector systematicRandomSampling(Dataset dataset, DatasetVector sampleRangeDataset, Datasource outputDatasource, String outputDatasetName, SystematicRandomSamplingParameter para) {
        int n = 2;
        return SamplingInference.internalSpatialSampling(dataset, sampleRangeDataset, outputDatasource, outputDatasetName, para, n, null);
    }

    public static DatasetVector spatialSimpleRandomSampling(Dataset dataset, DatasetVector sampleRangeDataset, Datasource outputDatasource, String outputDatasetName, SpatialSimpleRandomSamplingParameter para) {
        int n = 4;
        return SamplingInference.internalSpatialSampling(dataset, sampleRangeDataset, outputDatasource, outputDatasetName, para, n, null);
    }

    public static DatasetVector layeredRandomSampling(Dataset dataset, DatasetVector layeredDataset, Datasource outputDatasource, String outputDatasetName, LayeredRandomSamplingParameter para) {
        int n = 3;
        return SamplingInference.internalSpatialSampling(dataset, layeredDataset, outputDatasource, outputDatasetName, para, n, null);
    }

    public static DatasetVector spatialLayeredRandomSampling(Dataset dataset, DatasetVector layeredDataset, Datasource outputDatasource, String outputDatasetName, SpatialLayeredRandomSamplingParameter para) {
        int n = 5;
        return SamplingInference.internalSpatialSampling(dataset, layeredDataset, outputDatasource, outputDatasetName, para, n, null);
    }

    public static DatasetVector sandwichRandomSampling(Dataset dataset, DatasetVector layeredDataset, DatasetVector reportingUnitDataset, Datasource outputDatasource, String outputDatasetName, SandwichRandomSamplingParameter para) {
        int n = 6;
        return SamplingInference.internalSpatialSampling(dataset, layeredDataset, outputDatasource, outputDatasetName, para, n, reportingUnitDataset);
    }

    public static SimpleRandomSamplingInferenceResult simpleRandomSamplingInference(DatasetVector pointDataset, String strSampleFieldName, Double dConfidenceLevel) {
        int n = 1;
        SamplingInferenceResult samplingInferenceResult = SamplingInference.internalSpatialSamplingInference(pointDataset, strSampleFieldName, dConfidenceLevel, n, null, null, null, null);
        SimpleRandomSamplingInferenceResult simpleRandomSamplingInferenceResult = new SimpleRandomSamplingInferenceResult(samplingInferenceResult);
        return simpleRandomSamplingInferenceResult;
    }

    public static SystematicRandomSamplingInferenceResult systematicRandomSamplingInference(DatasetVector pointDataset, String strSampleFieldName, Double dConfidenceLevel) {
        int n = 2;
        SamplingInferenceResult samplingInferenceResult = SamplingInference.internalSpatialSamplingInference(pointDataset, strSampleFieldName, dConfidenceLevel, n, null, null, null, null);
        SystematicRandomSamplingInferenceResult systematicRandomSamplingInferenceResult = new SystematicRandomSamplingInferenceResult(samplingInferenceResult);
        return systematicRandomSamplingInferenceResult;
    }

    public static SpatialSimpleRandomSamplingInferenceResult spatialSimpleRandomSamplingInference(DatasetVector pointDataset, String strSampleFieldName, Double dConfidenceLevel) {
        int n = 4;
        SamplingInferenceResult samplingInferenceResult = SamplingInference.internalSpatialSamplingInference(pointDataset, strSampleFieldName, dConfidenceLevel, n, null, null, null, null);
        SpatialSimpleRandomSamplingInferenceResult spatialSimpleRandomSamplingInferenceResult = new SpatialSimpleRandomSamplingInferenceResult(samplingInferenceResult);
        return spatialSimpleRandomSamplingInferenceResult;
    }

    public static LayeredRandomSamplingInferenceResult layeredRandomSamplingInference(DatasetVector pointDataset, String strSampleFieldName, Double dConfidenceLevel, String strLayeredIDFieldName, String strPopulationFieldName) {
        int n = 3;
        SamplingInferenceResult samplingInferenceResult = SamplingInference.internalSpatialSamplingInference(pointDataset, strSampleFieldName, dConfidenceLevel, n, strLayeredIDFieldName, strPopulationFieldName, null, null);
        LayeredRandomSamplingInferenceResult layeredRandomSamplingInferenceResult = new LayeredRandomSamplingInferenceResult(samplingInferenceResult);
        return layeredRandomSamplingInferenceResult;
    }

    public static SpatialLayeredRandomSamplingInferenceResult spatialLayeredRandomSamplingInference(DatasetVector pointDataset, String strSampleFieldName, Double dConfidenceLevel, String strLayeredIDFieldName, String strPopulationFieldName) {
        int n = 5;
        SamplingInferenceResult samplingInferenceResult = SamplingInference.internalSpatialSamplingInference(pointDataset, strSampleFieldName, dConfidenceLevel, n, strLayeredIDFieldName, strPopulationFieldName, null, null);
        SpatialLayeredRandomSamplingInferenceResult spatialLayeredRandomSamplingInferenceResult = new SpatialLayeredRandomSamplingInferenceResult(samplingInferenceResult);
        return spatialLayeredRandomSamplingInferenceResult;
    }

    public static SandwichRandomSamplingInferenceResult sandwichRandomSamplingInference(DatasetVector pointDataset, DatasetVector layeredDataset, DatasetVector reportingUnitDataset, String strSampleFieldName, Double dConfidenceLevel, String strLayeredIDFieldName, String strPopulationFieldName) {
        int n = 6;
        SamplingInferenceResult samplingInferenceResult = SamplingInference.internalSpatialSamplingInference(pointDataset, strSampleFieldName, dConfidenceLevel, n, strLayeredIDFieldName, strPopulationFieldName, layeredDataset, reportingUnitDataset);
        SandwichRandomSamplingInferenceResult sandwichRandomSamplingInferenceResult = new SandwichRandomSamplingInferenceResult(samplingInferenceResult);
        return sandwichRandomSamplingInferenceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SamplingInference";
        boolean bl = InternalToolkitSpatialStatistics.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SamplingInference.fireStepped(steppedEvent);
        InternalToolkitSpatialStatistics.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialStatistics.managerProducts(InternalToolkitSpatialStatistics.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialStatistics.verifyLicense(arrayList);
    }
}

