/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialstatistics.ClusteringDistributionsNative;
import com.supermap.analyst.spatialstatistics.InternalDatasetVector;
import com.supermap.analyst.spatialstatistics.InternalDatasets;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.InternalToolkitSpatialStatistics;
import com.supermap.analyst.spatialstatistics.OptimizedParameter;
import com.supermap.analyst.spatialstatistics.PatternsParameter;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import java.util.ArrayList;
import java.util.Vector;

public class ClusteringDistributions {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private ClusteringDistributions() {
    }

    public static DatasetVector hotSpotAnalyst(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, PatternsParameter patternsParameter) {
        ClusteringDistributions.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (patternsParameter == null) {
            String string = InternalResource.loadString("patternsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)patternsParameter);
        String[] stringArray = new String[1];
        long l4 = ClusteringDistributionsNative.jni_HotSpotAnalyst(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)patternsParameter));
        return datasetVector;
    }

    public static DatasetVector clusterOutlierAnalyst(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, PatternsParameter patternsParameter) {
        ClusteringDistributions.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (patternsParameter == null) {
            String string = InternalResource.loadString("patternsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)patternsParameter);
        String[] stringArray = new String[1];
        long l4 = ClusteringDistributionsNative.jni_ClusterOutlierAnalyst(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)patternsParameter));
        return datasetVector;
    }

    public static DatasetVector optimizedHotSpotAnalyst(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, OptimizedParameter optimizedParameter) {
        ClusteringDistributions.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (optimizedParameter == null) {
            String string = InternalResource.loadString("optimizedParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        String string = optimizedParameter.getAssessmentFieldName();
        int n = InternalEnum.getUGCValue(optimizedParameter.getAggregationMethod());
        long l3 = 0L;
        if (optimizedParameter.getBoundingPolygons() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)optimizedParameter.getBoundingPolygons());
        }
        long l4 = 0L;
        if (optimizedParameter.getAggregatingPolygons() != null) {
            l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)optimizedParameter.getAggregatingPolygons());
        }
        String[] stringArray = new String[1];
        long l5 = ClusteringDistributionsNative.jni_OptimizedHotSpotAnalyst(l, l2, targetDatasetName, string, n, l3, l4, stringArray);
        DatasetVector datasetVector = null;
        if (l5 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetVector;
    }

    private static DatasetVector densityBasedClustering(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, int minPilePointCount, double searchDistance, Unit unit, int clusterSensitivity, int clusteringMethod) {
        ClusteringDistributions.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (minPilePointCount < 2) {
            String string = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (clusteringMethod != 2) {
            if (searchDistance < 0.0) {
                String string = InternalResource.loadString("searchDistance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            PrjCoordSys prjCoordSys = sourceDatasetVector.getPrjCoordSys();
            if (prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
                String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (clusteringMethod == 3 && clusterSensitivity != -1 && (clusterSensitivity < 0 || clusterSensitivity > 100)) {
                String string = InternalResource.loadString("clusterSensitivity", "ArgumentValueOutOfRange", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        String[] stringArray = new String[1];
        long l3 = ClusteringDistributionsNative.jni_DensityBasedClustering(l, l2, targetDatasetName, minPilePointCount, searchDistance, unit.value(), clusterSensitivity, clusteringMethod, stringArray);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetVector;
    }

    public static DatasetVector densityBasedClustering(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, int minPilePointCount, double searchDistance, Unit unit) {
        return ClusteringDistributions.densityBasedClustering(sourceDatasetVector, targetDatasource, targetDatasetName, minPilePointCount, searchDistance, unit, 0, 1);
    }

    public static DatasetVector hierarchicalDensityBasedClustering(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, int minPilePointCount) {
        return ClusteringDistributions.densityBasedClustering(sourceDatasetVector, targetDatasource, targetDatasetName, minPilePointCount, 0.0, Unit.METER, 0, 2);
    }

    public static DatasetVector orderingDensityBasedClustering(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, int minPilePointCount, double searchDistance, Unit unit, int clusterSensitivity) {
        return ClusteringDistributions.densityBasedClustering(sourceDatasetVector, targetDatasource, targetDatasetName, minPilePointCount, searchDistance, unit, clusterSensitivity, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ClusteringDistributions";
        boolean bl = InternalToolkitSpatialStatistics.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        ClusteringDistributions.fireStepped(steppedEvent);
        InternalToolkitSpatialStatistics.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialStatistics.managerProducts(InternalToolkitSpatialStatistics.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialStatistics.verifyLicense(arrayList);
    }
}

