/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialstatistics.AnalyzingPatternsNative;
import com.supermap.analyst.spatialstatistics.AnalyzingPatternsResult;
import com.supermap.analyst.spatialstatistics.DistanceMethod;
import com.supermap.analyst.spatialstatistics.GeographicalDetectorResult;
import com.supermap.analyst.spatialstatistics.IncrementalParameter;
import com.supermap.analyst.spatialstatistics.IncrementalResult;
import com.supermap.analyst.spatialstatistics.InternalDatasetVector;
import com.supermap.analyst.spatialstatistics.InternalDatasets;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.InternalToolkitSpatialStatistics;
import com.supermap.analyst.spatialstatistics.PatternsParameter;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class AnalyzingPatterns {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private AnalyzingPatterns() {
    }

    public static AnalyzingPatternsResult autoCorrelation(DatasetVector sourceDatasetVector, PatternsParameter patternsParameter) {
        AnalyzingPatterns.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (patternsParameter == null) {
            String string = InternalResource.loadString("patternsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)patternsParameter);
        String[] stringArray = new String[1];
        double[] dArray = AnalyzingPatternsNative.jni_Autocorrelation(l, l2, stringArray);
        AnalyzingPatternsResult analyzingPatternsResult = null;
        if (null != dArray && dArray.length > 0) {
            analyzingPatternsResult = new AnalyzingPatternsResult(dArray);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)patternsParameter));
        return analyzingPatternsResult;
    }

    public static AnalyzingPatternsResult highOrLowClustering(DatasetVector sourceDatasetVector, PatternsParameter patternsParameter) {
        AnalyzingPatterns.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (patternsParameter == null) {
            String string = InternalResource.loadString("patternsParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)patternsParameter);
        String[] stringArray = new String[1];
        double[] dArray = AnalyzingPatternsNative.jni_HighOrLowClustering(l, l2, stringArray);
        AnalyzingPatternsResult analyzingPatternsResult = null;
        if (null != dArray && dArray.length > 0) {
            analyzingPatternsResult = new AnalyzingPatternsResult(dArray);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)patternsParameter));
        return analyzingPatternsResult;
    }

    public static IncrementalResult[] incrementalAutoCorrelation(DatasetVector sourceDatasetVector, IncrementalParameter incrementalParameter) {
        AnalyzingPatterns.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (incrementalParameter == null) {
            String string = InternalResource.loadString("incrementalParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)incrementalParameter);
        String[] stringArray = new String[1];
        double[] dArray = AnalyzingPatternsNative.jni_IncrementalAutoCorrelation(l, l2, stringArray);
        IncrementalResult[] incrementalResultArray = null;
        if (null != dArray && dArray.length > 0) {
            int n = dArray.length / 6;
            incrementalResultArray = new IncrementalResult[n];
            double[] dArray2 = new double[5];
            double d = 0.0;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                IncrementalResult incrementalResult;
                d = dArray[n2++];
                dArray2[0] = dArray[n2++];
                dArray2[1] = dArray[n2++];
                dArray2[2] = dArray[n2++];
                dArray2[3] = dArray[n2++];
                dArray2[4] = dArray[n2++];
                AnalyzingPatternsResult analyzingPatternsResult = new AnalyzingPatternsResult(dArray2);
                incrementalResultArray[i] = incrementalResult = new IncrementalResult(d, analyzingPatternsResult);
            }
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)incrementalParameter));
        return incrementalResultArray;
    }

    public static AnalyzingPatternsResult averageNearestNeighbor(DatasetVector sourceDatasetVector, double studyArea, DistanceMethod distanceMethod) {
        AnalyzingPatterns.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (studyArea < 0.0) {
            String string = InternalResource.loadString("studyArea", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        DistanceMethod distanceMethod2 = distanceMethod;
        if (sourceDatasetVector.getPrjCoordSys().getType() == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && distanceMethod != DistanceMethod.EUCLIDEAN) {
            distanceMethod2 = DistanceMethod.EUCLIDEAN;
        }
        int n = InternalEnum.getUGCValue(distanceMethod2);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        String[] stringArray = new String[1];
        double[] dArray = AnalyzingPatternsNative.jni_AverageNearestNeighbor(l, studyArea, n, stringArray);
        AnalyzingPatternsResult analyzingPatternsResult = null;
        if (null != dArray && dArray.length > 0) {
            analyzingPatternsResult = new AnalyzingPatternsResult(dArray);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return analyzingPatternsResult;
    }

    public static GeographicalDetectorResult geographicalDetector(DatasetVector sourceDataset, String modelField, String[] arrExplanatory, boolean isFactorDetector, boolean isEcologicalDetector, boolean isInteractionDetector, boolean isRiskDetector, Datasource targetDatasource) {
        return AnalyzingPatterns.internalGeographicalDetector(sourceDataset, modelField, arrExplanatory, isFactorDetector, isEcologicalDetector, isInteractionDetector, isRiskDetector, targetDatasource, null);
    }

    public static GeographicalDetectorResult geographicalDetector(DatasetVector sourceDataset, String modelField, String[] arrExplanatory, boolean isFactorDetector, boolean isEcologicalDetector, boolean isInteractionDetector, boolean isRiskDetector, Datasource targetDatasource, String filePath) {
        return AnalyzingPatterns.internalGeographicalDetector(sourceDataset, modelField, arrExplanatory, isFactorDetector, isEcologicalDetector, isInteractionDetector, isRiskDetector, targetDatasource, filePath);
    }

    public static GeographicalDetectorResult geographicalDetector(DatasetGrid sourceDataset, DatasetGrid[] arrExplanatoryGrid, int nSampleCount, boolean isFactorDetector, boolean isEcologicalDetector, boolean isInteractionDetector, boolean isRiskDetector, Datasource targetDatasource, String filePath) {
        AnalyzingPatterns.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (arrExplanatoryGrid == null || arrExplanatoryGrid.length == 0) {
            String string = InternalResource.loadString("arrExplanatoryGrid", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        int n = arrExplanatoryGrid.length;
        for (int i = 0; i < n; ++i) {
            if (arrExplanatoryGrid[i] != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)arrExplanatoryGrid[i]) != 0L) continue;
            String string = InternalResource.loadString("arrExplanatoryGrid[" + i + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (nSampleCount != -1 && nSampleCount < 100) {
            String string = InternalResource.loadString("nSampleCount", "ArgumentValueOutOfRange", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(isFactorDetector || isEcologicalDetector || isInteractionDetector || isRiskDetector)) {
            String string = InternalResource.loadString("isFactorDetector,isEcologicalDetector,isInteractionDetector,isRiskDetector", "Global_ArgumentTypeInvalid", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        int n2 = arrExplanatoryGrid.length;
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)arrExplanatoryGrid[i]);
        }
        String[] stringArray = new String[1];
        long l2 = 0L;
        if (targetDatasource != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) != 0L) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        }
        long[] lArray2 = new long[4];
        long l3 = AnalyzingPatternsNative.jni_GeographicalDetector1(l, lArray, nSampleCount, isFactorDetector, isEcologicalDetector, isInteractionDetector, isRiskDetector, l2, filePath, lArray2, stringArray);
        GeographicalDetectorResult geographicalDetectorResult = null;
        if (l3 != 0L) {
            DatasetVector datasetVector = null;
            DatasetVector datasetVector2 = null;
            DatasetVector datasetVector3 = null;
            DatasetVector datasetVector4 = null;
            if (lArray2[0] != 0L && targetDatasource != null) {
                datasetVector = InternalDatasetVector.createInstance(lArray2[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            if (lArray2[1] != 0L && targetDatasource != null) {
                datasetVector2 = InternalDatasetVector.createInstance(lArray2[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector2);
            }
            if (lArray2[2] != 0L && targetDatasource != null) {
                datasetVector3 = InternalDatasetVector.createInstance(lArray2[2], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector3);
            }
            if (lArray2[3] != 0L && targetDatasource != null) {
                datasetVector4 = InternalDatasetVector.createInstance(lArray2[3], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector4);
            }
            geographicalDetectorResult = new GeographicalDetectorResult(l3, datasetVector, datasetVector2, datasetVector3, datasetVector4);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
        return geographicalDetectorResult;
    }

    private static GeographicalDetectorResult internalGeographicalDetector(DatasetVector sourceDataset, String modelField, String[] arrExplanatory, boolean isFactorDetector, boolean isEcologicalDetector, boolean isInteractionDetector, boolean isRiskDetector, Datasource targetDatasource, String filePath) {
        AnalyzingPatterns.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (modelField == null || modelField.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("modelField", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (arrExplanatory == null || arrExplanatory.length == 0) {
            String string = InternalResource.loadString("arrExplanatory", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        int n = arrExplanatory.length;
        for (int i = 0; i < n; ++i) {
            if (arrExplanatory[i] != null && !arrExplanatory[i].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("arrExplanatory[" + i + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(isFactorDetector || isEcologicalDetector || isInteractionDetector || isRiskDetector)) {
            String string = InternalResource.loadString("isFactorDetector,isEcologicalDetector,isInteractionDetector,isRiskDetector", "Global_ArgumentTypeInvalid", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        int n2 = arrExplanatory.length;
        String[] stringArray = new String[1];
        long l2 = 0L;
        if (targetDatasource != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) != 0L) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        }
        long[] lArray = new long[4];
        long l3 = AnalyzingPatternsNative.jni_GeographicalDetector(l, modelField, arrExplanatory, isFactorDetector, isEcologicalDetector, isInteractionDetector, isRiskDetector, l2, filePath, lArray, stringArray);
        GeographicalDetectorResult geographicalDetectorResult = null;
        if (l3 != 0L) {
            DatasetVector datasetVector = null;
            DatasetVector datasetVector2 = null;
            DatasetVector datasetVector3 = null;
            DatasetVector datasetVector4 = null;
            if (lArray[0] != 0L && targetDatasource != null) {
                datasetVector = InternalDatasetVector.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            if (lArray[1] != 0L && targetDatasource != null) {
                datasetVector2 = InternalDatasetVector.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector2);
            }
            if (lArray[2] != 0L && targetDatasource != null) {
                datasetVector3 = InternalDatasetVector.createInstance(lArray[2], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector3);
            }
            if (lArray[3] != 0L && targetDatasource != null) {
                datasetVector4 = InternalDatasetVector.createInstance(lArray[3], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector4);
            }
            geographicalDetectorResult = new GeographicalDetectorResult(l3, datasetVector, datasetVector2, datasetVector3, datasetVector4);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
        return geographicalDetectorResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "AnalyzingPatterns";
        boolean bl = InternalToolkitSpatialStatistics.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        AnalyzingPatterns.fireStepped(steppedEvent);
        InternalToolkitSpatialStatistics.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialStatistics.managerProducts(InternalToolkitSpatialStatistics.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialStatistics.verifyLicense(arrayList);
    }
}

