/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.TerrainCacheInfoNative;
import com.supermap.data.processing.TerrainCacheType;
import java.util.ArrayList;

public class TerrainCacheInfo
extends InternalHandleDisposable {
    public TerrainCacheInfo() {
        long l = TerrainCacheInfoNative.jni_New();
        this.setHandle(l, true);
    }

    private TerrainCacheInfo(long handle) {
        this.setHandle(handle, false);
    }

    public boolean isValid() {
        return TerrainCacheInfoNative.jni_IsValid(this.getHandle());
    }

    public boolean load(String filename) {
        if (filename == null) {
            String string = InternalResource.loadString("filename", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return TerrainCacheInfoNative.jni_Load(this.getHandle(), filename);
    }

    public TerrainCacheType getType() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TerrainCacheInfoNative.jni_GetType(this.getHandle());
        return (TerrainCacheType)InternalEnum.parseUGCValue(TerrainCacheType.class, n);
    }

    public ArrayList<TerrainCacheInfo> getSubCacheInfos() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TerrainCacheInfo> arrayList = new ArrayList<TerrainCacheInfo>();
        long[] lArray = TerrainCacheInfoNative.jni_GetLayersMesh(this.getHandle());
        for (int i = 0; i < lArray.length; ++i) {
            TerrainCacheInfo terrainCacheInfo = new TerrainCacheInfo(lArray[i]);
            arrayList.add(terrainCacheInfo);
        }
        return arrayList;
    }

    public String getConnectionInfo() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        return TerrainCacheInfoNative.jni_GetConnectionInfo(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TerrainCacheInfoNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

