/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.BuildResultInfo;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.CacheStrategy;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalProcessingToolkit;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.MapCacheBuilderNative;
import com.supermap.data.processing.MapCacheVersion;
import com.supermap.data.processing.MapTileType;
import com.supermap.data.processing.MapTilingMode;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import com.supermap.mapping.Map;
import com.supermap.tilestorage.TileStorageConnection;
import com.supermap.tilestorage.TileVersion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MapCacheBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private Map m_map = null;
    private Dataset m_dataset = null;
    private GeoRegion m_clipRegion = null;
    private long m_selfEventHandle;
    transient Vector m_steppedListeners;
    private static String m_senderMethodName;

    public MapCacheBuilder() {
        long l = MapCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.Initialize(null, null, null);
    }

    public MapCacheBuilder(Map map, String outputFolder, double[] outputScales) {
        long l = MapCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.Initialize(map, outputFolder, outputScales);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_map;
    }

    public void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (map == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)map) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)map) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)map);
        }
        MapCacheBuilderNative.jni_SetMap(this.getHandle(), l);
        this.m_map = map;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    private Dataset getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    private void setDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        long l2 = 0L;
        if (dataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L) {
            if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE && dataset.getType() != DatasetType.GRIDCOLLECTION && dataset.getType() != DatasetType.IMAGECOLLECTION) {
                String string = InternalResource.loadString("dataset", "DatasetTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset.getDatasource().getWorkspace());
        }
        MapCacheBuilderNative.jni_SetDataset(this.getHandle(), l, l2);
        this.m_dataset = dataset;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null) {
            long l = MapCacheBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this.m_clipRegion = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this.m_clipRegion, false);
            }
        } else {
            long l = MapCacheBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                InternalGeoRegion.clearHandle(this.m_clipRegion);
                InternalGeoRegion.refreshHandle(this.m_clipRegion, l);
            } else {
                InternalGeoRegion.clearHandle(this.m_clipRegion);
                this.m_clipRegion = null;
            }
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = null;
        if (value != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
                String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
            geoRegion = new GeoRegion(value);
            MapCacheBuilderNative.jni_SetClipRegion(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        } else {
            MapCacheBuilderNative.jni_SetClipRegion(this.getHandle(), 0L);
        }
        this.m_clipRegion = geoRegion;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        MapCacheBuilderNative.jni_SetBounds(this.getHandle(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheBuilderNative.jni_GetCacheName(this.getHandle());
        if ((string == null || string.length() == 0) && this.m_map != null) {
            string = this.m_map.getName();
        }
        return string;
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetCacheName(this.getHandle(), value);
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetOutputScalesCount(this.getHandle());
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        MapCacheBuilderNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public void setOutputScaleCaptions(HashMap<Double, String> scaleCaptions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (scaleCaptions == null) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = scaleCaptions.size();
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        Set<Map.Entry<Double, String>> set = scaleCaptions.entrySet();
        Iterator<Map.Entry<Double, String>> iterator = set.iterator();
        Map.Entry<Double, String> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            stringArray[i] = entry.getValue();
        }
        MapCacheBuilderNative.jni_SetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
    }

    public double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetOutputScales(this.getHandle());
    }

    public void setOutputScales(double[] values) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!MapCacheBuilderNative.jni_SetOutputScales(this.getHandle(), values)) {
            String string = InternalResource.loadString("setOutputScales()", "CacheBuilder_IllegalScales", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    @Deprecated
    private CacheImageSize getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageSize(this.getHandle());
        CacheImageSize cacheImageSize = null;
        switch (n) {
            case 0: {
                cacheImageSize = CacheImageSize.SIZE64;
                break;
            }
            case 1: {
                cacheImageSize = CacheImageSize.SIZE128;
                break;
            }
            case 2: {
                cacheImageSize = CacheImageSize.SIZE256;
                break;
            }
            case 3: {
                cacheImageSize = CacheImageSize.SIZE512;
                break;
            }
            case 4: {
                cacheImageSize = CacheImageSize.SIZE1024;
                break;
            }
            case 5: {
                cacheImageSize = CacheImageSize.SIZE2048;
                break;
            }
            default: {
                cacheImageSize = CacheImageSize.SIZE256;
            }
        }
        return cacheImageSize;
    }

    @Deprecated
    private void setImageSize(CacheImageSize imageSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(imageSize);
        MapCacheBuilderNative.jni_SetIamgeSize(this.getHandle(), n);
    }

    public int getImageCompress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageCompress(this.getHandle());
        return n;
    }

    public void setImageCompress(int imageCompress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (imageCompress > 100 || imageCompress < 0) {
            String string = InternalResource.loadString("setImageCompress()", "MapCacheBuidlerImageCompressIncorrect", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetImageCompress(this.getHandle(), imageCompress);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
        return string;
    }

    public void setOutputFolder(String outputFolder) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (outputFolder.trim().length() == 0) {
            String string = InternalResource.loadString("setOutputFolder()", "OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), outputFolder);
    }

    public boolean isTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsTransparent(this.getHandle());
    }

    public void setTransparent(boolean bool) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetTransparentc(this.getHandle(), bool);
    }

    public boolean isFillMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsFillMargin(this.getHandle());
    }

    public void setFillMargin(boolean bool) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetFillMargin(this.getHandle(), bool);
    }

    @Deprecated
    private CacheImageType getImageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageType(this.getHandle());
        CacheImageType cacheImageType = null;
        cacheImageType = (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
        return cacheImageType;
    }

    @Deprecated
    private void setImageType(CacheImageType cacheImageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheImageType);
        MapCacheBuilderNative.jni_SetImageType(this.getHandle(), n);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetStorageType(this.getHandle());
        StorageType storageType = null;
        storageType = (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
        return storageType;
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(storageType);
        MapCacheBuilderNative.jni_SetStorageType(this.getHandle(), n);
    }

    @Deprecated
    private CacheStrategy getCacheStrategy() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheStrategy()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetStrategy(this.getHandle());
        CacheStrategy cacheStrategy = null;
        cacheStrategy = (CacheStrategy)InternalEnum.parseUGCValue(CacheStrategy.class, n);
        return cacheStrategy;
    }

    @Deprecated
    private void setCacheStrategy(CacheStrategy cacheStrategy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheStrategy()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheStrategy);
        MapCacheBuilderNative.jni_SetStrategy(this.getHandle(), n);
    }

    public Rectangle2D getIndexBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheBuilderNative.jni_GetIndexBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setIndexBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        MapCacheBuilderNative.jni_SetIndexBounds(this.getHandle(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String passwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetPassword(this.getHandle(), passwd);
    }

    public boolean build() {
        return this.build(true);
    }

    public boolean build(boolean buildTile) {
        String string;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_map != null && this.m_map.isContainLayerChart() && InternalProcessingToolkit.getChartLicenseState() != 0) {
            return false;
        }
        String string3 = this.getCacheName();
        if (string3.contains("\\") || string3.contains("/") || string3.contains(":") || string3.contains("*") || string3.contains("?") || string3.contains("\"") || string3.contains("<") || string3.contains(">") || string3.contains("|")) {
            String string4 = InternalResource.loadString("CacheNameInvalid", "CacheBuilderCacheNameInvalid", "processing_resources");
            throw new IllegalArgumentException(string4);
        }
        MapCacheVersion mapCacheVersion = this.getVersion();
        if (this.m_map != null && mapCacheVersion != MapCacheVersion.VERSION_10 && mapCacheVersion != MapCacheVersion.VERSION_50 && ((string = this.m_map.getName()).contains("\\") || string.contains("/") || string.contains(":") || string.contains("*") || string.contains("?") || string.contains("\"") || string.contains("<") || string.contains(">") || string.contains("|"))) {
            String string5 = InternalResource.loadString("CacheNameInvalid", "CacheBuilderCacheNameInvalid", "processing_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.m_dataset != null && this.m_map == null && this.getVersion().value() < MapCacheVersion.VERSION_50.value()) {
            string = InternalResource.loadString("CacheParameterInvalid", "DatasetNotSupportVersion", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getTileFormat() == TileFormat.PBF) {
            return this.build(true, true);
        }
        int n = MapCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle, buildTile);
        return this.processBuildResult(n);
    }

    public boolean build(boolean buildVectorTile, boolean buildStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map != null && this.m_map.isContainLayerChart() && InternalProcessingToolkit.getChartLicenseState() != 0) {
            return false;
        }
        String string = this.getCacheName();
        if (string.contains("\\") || string.contains("/") || string.contains(":") || string.contains("*") || string.contains("?") || string.contains("\"") || string.contains("<") || string.contains(">") || string.contains("|")) {
            String string2 = InternalResource.loadString("CacheNameInvalid", "CacheBuilderCacheNameInvalid", "processing_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.getTileFormat() != TileFormat.PBF) {
            String string3 = "TileFormat must be PBF!";
            throw new IllegalArgumentException(string3);
        }
        return MapCacheBuilderNative.jni_BuildMVT(this.getHandle(), this.m_selfEventHandle, buildVectorTile, buildStyle);
    }

    public boolean build(int level, int row, int col) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTileFormat() != TileFormat.PBF) {
            String string = "TileFormat must be PBF!";
            throw new IllegalArgumentException(string);
        }
        if (!this.isMVTWithoutFilter()) {
            String string = "mvt without filter must be true!";
            throw new IllegalArgumentException(string);
        }
        return MapCacheBuilderNative.jni_BuildMVTTile(this.getHandle(), level, row, col);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTileFormat() == TileFormat.PBF) {
            return this.buildWithoutConfigFile(true, true);
        }
        int n = MapCacheBuilderNative.jni_BuildWithoutConfig(this.getHandle(), this.m_selfEventHandle);
        return this.processBuildResult(n);
    }

    public boolean buildWithoutConfigFile(boolean buildVectorTile, boolean buildStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTileFormat() != TileFormat.PBF) {
            String string = "TileFormat must be PBF!";
            throw new IllegalArgumentException(string);
        }
        return MapCacheBuilderNative.jni_BuildMVTWithoutConfig(this.getHandle(), this.m_selfEventHandle, buildVectorTile, buildStyle);
    }

    public boolean toConfigFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getMap() == null) {
            String string = InternalResource.loadString("toConfigFile()", "MapCacheBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (path == null) {
            String string = InternalResource.loadString("toConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (path.length() == 0) {
            String string = InternalResource.loadString("toConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = ".sci";
        if (!path.endsWith(string)) {
            path = path + string;
        }
        boolean bl = MapCacheBuilderNative.jni_ToConfigFile(this.getHandle(), path);
        return bl;
    }

    public boolean fromConfigFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (path == null) {
            String string = InternalResource.loadString("fromConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (path.length() == 0) {
            String string = InternalResource.loadString("fromConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheBuilderNative.jni_FromConfigFile(this.getHandle(), path);
        return bl;
    }

    public boolean mergeConfigFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mergeConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (path == null) {
            String string = InternalResource.loadString("mergeConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (path.length() == 0) {
            String string = InternalResource.loadString("mergeConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheBuilderNative.jni_MergeConfigFile(this.getHandle(), path);
        return bl;
    }

    public String computeImageFileName(Point2D center, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCacheBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{center.getX(), center.getY()};
        String string = MapCacheBuilderNative.jni_ComputeImageFileName(this.getHandle(), dArray, scale);
        return string;
    }

    public String[] computeImageFileName(Rectangle2D imageBounds, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCacheBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{imageBounds.getLeft(), imageBounds.getBottom(), imageBounds.getRight(), imageBounds.getTop()};
        String string = MapCacheBuilderNative.jni_ComputeImageFileName(this.getHandle(), dArray, scale);
        return InternalToolkitProcessing.splitString(string, "\\|");
    }

    public boolean computeOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheBuilderNative.jni_ComputeOutputScales(this.getHandle());
        return bl;
    }

    public double[] getDefultOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefultOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetDefulatOutputScales(this.getHandle());
    }

    public HashMap<Double, String> getGlobalLevelScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGlobalLevelScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = MapCacheBuilderNative.jni_GetGlobalLevelScales(this.getHandle());
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                Double d2 = new Double(d);
                Integer n = new Integer(i);
                String string = n.toString();
                hashMap.put(d2, string);
            }
        }
        return hashMap;
    }

    public Rectangle2D getGlobalIndexBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGlobalIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = MapCacheBuilderNative.jni_GetGlobalIndexBounds(this.getHandle());
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(MapCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.clearSelfEventHandle();
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            MapCacheBuilderNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    private void Initialize(Map map, String outputFolder, double[] outputScales) {
        if (map != null) {
            this.setMap(map);
        }
        if (outputFolder != null) {
            this.setOutputFolder(outputFolder);
        }
        if (outputScales != null) {
            this.setOutputScales(outputScales);
        }
        this.m_selfEventHandle = MapCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public Rectangle2D getImageBounds(String imageFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (imageFile == null) {
            String string = InternalResource.loadString("getImageBounds()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (imageFile.length() == 0) {
            String string = InternalResource.loadString("getImageBounds()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheBuilderNative.jni_GetImageBounds(this.getHandle(), imageFile, dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public String getHashCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHashCode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetHashCode(this.getHandle());
    }

    public byte[] getImageData(String imgFilePath, String strPwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageData()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetImageData(this.getHandle(), imgFilePath, strPwd);
    }

    @Deprecated
    private boolean getCacheUsingNewScheme() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCacheUsingNewScheme()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetCacheUsingNewScheme(this.getHandle());
    }

    @Deprecated
    private void setCacheUsingNewScheme(boolean bool) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCacheUsingNewScheme()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetCacheUsingNewScheme(this.getHandle(), bool);
    }

    public void setHashCodeEnabled(boolean enable) {
        MapCacheBuilderNative.jni_SetHashCodeEnabled(this.getHandle(), enable);
    }

    public boolean isHashCodeEnabled() {
        return MapCacheBuilderNative.jni_IsHashCodeEnabled(this.getHandle());
    }

    public MapCacheVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetVersion(this.getHandle());
        MapCacheVersion mapCacheVersion = null;
        mapCacheVersion = (MapCacheVersion)InternalEnum.parseUGCValue(MapCacheVersion.class, n);
        return mapCacheVersion;
    }

    public void setVersion(MapCacheVersion version) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(version);
        MapCacheBuilderNative.jni_SetVersion(this.getHandle(), n);
    }

    public boolean originalToCompact(String originalFileName, String compactPath, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("originalToCompact()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_OriginalToCompact(this.getHandle(), originalFileName, compactPath, password);
    }

    public static HashMap<Double, String> globalLevelToScale(int[] levels, PrjCoordSys value, TileSize tileSize) {
        if (levels == null) {
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(tileSize);
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] >= 0 && levels[i] <= 20) continue;
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        double[] dArray = MapCacheBuilderNative.jni_GlobalLevelToScale(levels, l, n);
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                Double d2 = new Double(d);
                Integer n2 = new Integer(levels[i]);
                String string = n2.toString();
                hashMap.put(d2, string);
            }
        }
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
        return hashMap;
    }

    @Deprecated
    public static HashMap<Double, String> globalLevelToScale(int[] levels, PrjCoordSys value, CacheImageSize imageSize) {
        TileSize tileSize = TileSize.SIZE64;
        switch (imageSize.value()) {
            case 64: {
                tileSize = TileSize.SIZE64;
                break;
            }
            case 128: {
                tileSize = TileSize.SIZE128;
                break;
            }
            case 256: {
                tileSize = TileSize.SIZE256;
                break;
            }
            case 512: {
                tileSize = TileSize.SIZE512;
                break;
            }
            case 1024: 
            case 2048: {
                tileSize = TileSize.SIZE1024;
                break;
            }
        }
        return MapCacheBuilder.globalLevelToScale(levels, value, tileSize);
    }

    public HashMap<Double, String> globalLevelToScale(int[] levels) {
        if (levels == null) {
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map) == 0L) {
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] >= 0) continue;
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheImageSize cacheImageSize = this.getImageSize();
        int n = InternalEnum.getUGCValue(cacheImageSize);
        PrjCoordSys prjCoordSys = this.m_map.getPrjCoordSys();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        double[] dArray = MapCacheBuilderNative.jni_GlobalLevelToScale(levels, l, n);
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                Double d2 = new Double(d);
                Integer n2 = new Integer(levels[i]);
                String string = n2.toString();
                hashMap.put(d2, string);
            }
        }
        return hashMap;
    }

    @Deprecated
    private MapTileType getTileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetTileType(this.getHandle());
        MapTileType mapTileType = null;
        mapTileType = (MapTileType)InternalEnum.parseUGCValue(MapTileType.class, n);
        return mapTileType;
    }

    @Deprecated
    private void setTileType(MapTileType tileType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getVersion() == MapCacheVersion.VERSION_10) {
            String string = InternalResource.loadString("setMapTileType()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        int n = InternalEnum.getUGCValue(tileType);
        MapCacheBuilderNative.jni_SetTileType(this.getHandle(), n);
    }

    private boolean processBuildResult(int result) {
        boolean bl = false;
        if (result == -1) {
            String string = InternalResource.loadString("build()", "Global_NotEnoughMemory", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (result == 0) {
            bl = false;
        } else if (result == 1) {
            bl = true;
        }
        return bl;
    }

    @Deprecated
    private boolean Appendbuild() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map != null && this.m_map.isContainLayerChart() && InternalProcessingToolkit.getChartLicenseState() != 0) {
            return false;
        }
        boolean bl = MapCacheBuilderNative.jni_AppendBuild(this.getHandle(), this.m_selfEventHandle);
        return bl;
    }

    public double getDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetDPI(this.getHandle());
    }

    public void setDPI(double dpi) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (dpi < 0.0) {
            String string = InternalResource.loadString("build()", "ArgumentShouldNotBeNegative", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetDPI(this.getHandle(), dpi);
    }

    public boolean isAppending() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsAppending(this.getHandle());
    }

    public void setIsAppending(boolean isAppending) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsAppending(this.getHandle(), isAppending);
    }

    public void setTilingMode(MapTilingMode tilingMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilingMode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getVersion() == MapCacheVersion.VERSION_10) {
            String string = InternalResource.loadString("setTilingMode()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        int n = InternalEnum.getUGCValue(tilingMode);
        MapCacheBuilderNative.jni_SetTileType(this.getHandle(), n);
    }

    public MapTilingMode getTilingMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingMode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetTileType(this.getHandle());
        MapTilingMode mapTilingMode = null;
        mapTilingMode = (MapTilingMode)InternalEnum.parseUGCValue(MapTilingMode.class, n);
        return mapTilingMode;
    }

    public TileSize getTileSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageSize(this.getHandle());
        TileSize tileSize = null;
        switch (n) {
            case 0: {
                tileSize = TileSize.SIZE64;
                break;
            }
            case 1: {
                tileSize = TileSize.SIZE128;
                break;
            }
            case 2: {
                tileSize = TileSize.SIZE256;
                break;
            }
            case 3: {
                tileSize = TileSize.SIZE512;
                break;
            }
            case 4: {
                tileSize = TileSize.SIZE1024;
                break;
            }
            default: {
                tileSize = TileSize.SIZE256;
            }
        }
        return tileSize;
    }

    public void setTileSize(TileSize tileSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(tileSize);
        MapCacheBuilderNative.jni_SetIamgeSize(this.getHandle(), n);
    }

    public TileFormat getTileFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageType(this.getHandle());
        TileFormat tileFormat = null;
        tileFormat = (TileFormat)InternalEnum.parseUGCValue(TileFormat.class, n);
        return tileFormat;
    }

    public void setTileFormat(TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(tileFormat);
        MapCacheBuilderNative.jni_SetImageType(this.getHandle(), n);
    }

    void setBigImageSize(int size) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setChunkSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetBigImageSize(this.getHandle(), size);
    }

    public BuildResultInfo getBuildResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheBuildLog()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = MapCacheBuilderNative.jni_GetBuildResult(this.getHandle());
        if (l != 0L) {
            return new BuildResultInfo(l, false);
        }
        return null;
    }

    public boolean isDeleteLogFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDeleteLogFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsDeleteLogFile(this.getHandle());
    }

    public void setIsDeleteLogFile(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsDeleteLogFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsDeleteLogFile(this.getHandle(), value);
    }

    public boolean isBlockOverRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRecordGroupInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsRecordBlockInfo(this.getHandle());
    }

    @Deprecated
    private void setisBlockOverRecord(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsRecordGroupInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsRecordBlockInfo(this.getHandle(), value);
    }

    public void setBlockOverRecord(boolean value) {
        this.setisBlockOverRecord(value);
    }

    public boolean isScaleOverRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRecordScaleInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsRecordScaleInfo(this.getHandle());
    }

    @Deprecated
    private void setisScaleOverRecord(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsRecordScaleInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsRecordScaleInfo(this.getHandle(), value);
    }

    public void setScaleOverRecord(boolean value) {
        this.setisScaleOverRecord(value);
    }

    public boolean isTaskOverRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRecordTotalInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsRecordTotalInfo(this.getHandle());
    }

    @Deprecated
    private void setisTaskOverRecord(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsRecordTotalInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsRecordTotalInfo(this.getHandle(), value);
    }

    public void setTaskOverRecord(boolean value) {
        this.setisTaskOverRecord(value);
    }

    public void resumable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resumable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetErrorLog(this.getHandle(), value);
    }

    private int getRevisionNumber() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetRevisionNumber(this.getHandle());
    }

    private void setRevisionNumber(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetRevisionNumber(this.getHandle(), value);
    }

    private int getMaxRevisionNumber() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomMaxVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetMaxRevisionNumber(this.getHandle());
    }

    private void setBuildThreadCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetBuildThreadCount(this.getHandle(), value);
    }

    private int getBuildThreadCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomMaxVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetBuildThreadCount(this.getHandle());
    }

    public void setConnectionInfo(TileStorageConnection info) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConnectionInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (info == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)info) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (info != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)info) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)info);
        }
        MapCacheBuilderNative.jni_SetConnectionInfo(this.getHandle(), l);
    }

    public TileStorageConnection getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConnectionInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TileStorageConnection tileStorageConnection = new TileStorageConnection();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)tileStorageConnection);
        if (MapCacheBuilderNative.jni_GetConnectionInfo(this.getHandle(), l)) {
            return tileStorageConnection;
        }
        return null;
    }

    public void setVersionInfo(TileVersion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVersionInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            MapCacheBuilderNative.jni_SetTileVersion(this.getHandle(), 0L);
        } else {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
            if (l == 0L) {
                String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
                throw new IllegalArgumentException(string);
            }
            MapCacheBuilderNative.jni_SetTileVersion(this.getHandle(), l);
        }
    }

    public TileVersion getVersionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersionInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TileVersion tileVersion = new TileVersion();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)tileVersion);
        if (MapCacheBuilderNative.jni_GetTileVersion(this.getHandle(), l)) {
            return tileVersion;
        }
        return null;
    }

    public boolean createMongoDB() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("createMongoDB()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_CreateMongoDB(this.getHandle());
    }

    public boolean updateMongoDB() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateMongoDB()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_UpdateMongoDB(this.getHandle());
    }

    public boolean isMultiProcessing() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMultiProcessing()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsMultiProcessing(this.getHandle());
    }

    public void setMultiProcessing(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiProcessing()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMultiProcessing(this.getHandle(), value);
    }

    public boolean isIgnoreInvalidDrawing() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isIgnoreInvalidDrawing()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsIgnoreInvalidDrawing(this.getHandle());
    }

    public void setIgnoreInvalidDrawing(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreInvalidDrawing()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIgnoreInvalidDrawing(this.getHandle(), value);
    }

    public boolean isMVTStyleWithoutFont() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMVTStyleWithoutFont()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsMVTStyleWithoutFont(this.getHandle());
    }

    public void setMVTStyleWithoutFont(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMVTStyleWithoutFont()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMVTStyleWithoutFont(this.getHandle(), value);
    }

    public boolean isMVTWithAllField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMVTWithAllField()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsMVTWithAllField(this.getHandle());
    }

    public void setMVTWithAllField(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMVTWithAllField()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMVTWithAllField(this.getHandle(), value);
    }

    public int getMVTTileBuffer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMVTTileBuffer()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetMVTTileBuffer(this.getHandle());
    }

    public void setMVTTileBuffer(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMVTTileBuffer()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMVTTileBuffer(this.getHandle(), value);
    }

    public int getMVTTileExtent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMVTTileExtent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetMVTTileExtent(this.getHandle());
    }

    public void setMVTTileExtent(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMVTTileExtent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMVTTileExtent(this.getHandle(), value);
    }

    public boolean isMVTWithoutFilter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMVTWithoutFilter()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsMVTWithoutFilter(this.getHandle());
    }

    public void setMVTWithoutFilter(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMVTWithoutFilter()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMVTWithoutFilter(this.getHandle(), value);
    }

    public boolean isMVTSimplifyGeometry() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMVTSimplifyGeometry()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsMVTSimplifyGeometry(this.getHandle());
    }

    public void setMVTSimplifyGeometry(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMVTSimplifyGeometry()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetMVTSimplifyGeometry(this.getHandle(), value);
    }

    public static String exportGlyph(String path, String name, int start, int end) {
        if (path.isEmpty() || name.isEmpty()) {
            String string = InternalResource.loadString("exportGlyph()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (start < 0 || start > 65535 || end < 0 || end > 65535 || start > end) {
            String string = InternalResource.loadString("exportGlyph()", "ArgumentOutOfRange", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_ExportGlyph(path, name, start, end);
    }

    public static MapCacheBuilder mongoDB2Builder(String server, String database, String name, String user, String password) {
        if (server.isEmpty() || database.isEmpty() || name.isEmpty()) {
            String string = InternalResource.loadString("mongoDB2Builder()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilder mapCacheBuilder = new MapCacheBuilder();
        if (mapCacheBuilder.getHandle() != 0L) {
            MapCacheBuilderNative.jni_MongoDB2Builder(mapCacheBuilder.getHandle(), server, database, name, user, password);
        }
        return mapCacheBuilder;
    }

    public boolean isBuildFromOriginalResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBuildFromOriginalResolution()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsBuildFromOriginalResolution(this.getHandle());
    }

    public void setBuildFromOriginalResolution(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBuildFromOriginalResolution()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetBuildFromOriginalResolution(this.getHandle(), value);
    }

    public double getScaleOriginalResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleOriginalResolution()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetScaleOriginalResolution(this.getHandle());
    }

    public void setScaleOriginalResolution(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleOriginalResolution()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetScaleOriginalResolution(this.getHandle(), value);
    }
}

