/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.MapCache3DBuilderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.mapping.Map;
import java.util.Vector;

public class MapCache3DBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private Map m_map = null;
    private GeoRegion m_clipRegion = null;
    private long m_selfEventHandle;
    transient Vector<SteppedListener> m_steppedListeners;
    private static String m_senderMethodName;

    public MapCache3DBuilder() {
        long l = MapCache3DBuilderNative.jni_New();
        this.setHandle(l, true);
        this.Initialize(null, null, null);
    }

    public MapCache3DBuilder(Map map, String outputFolder) {
        long l = MapCache3DBuilderNative.jni_New();
        this.setHandle(l, true);
        this.Initialize(map, outputFolder, null);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public MapCache3DBuilder(Map map, String outputFolder, String name) {
        long l = MapCache3DBuilderNative.jni_New();
        this.setHandle(l, true);
        this.Initialize(map, outputFolder, name);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_map;
    }

    public void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)map) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetMap(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)map));
        this.m_map = map;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null) {
            long l = MapCache3DBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this.m_clipRegion = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this.m_clipRegion, false);
            }
        } else {
            long l = MapCache3DBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                InternalGeoRegion.clearHandle(this.m_clipRegion);
                InternalGeoRegion.refreshHandle(this.m_clipRegion, l);
            } else {
                InternalGeoRegion.clearHandle(this.m_clipRegion);
                this.m_clipRegion = null;
            }
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = null;
        if (value != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
                String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
            geoRegion = new GeoRegion(value);
            MapCache3DBuilderNative.jni_SetClipRegion(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        } else {
            MapCache3DBuilderNative.jni_SetClipRegion(this.getHandle(), 0L);
        }
        this.m_clipRegion = geoRegion;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCache3DBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        MapCache3DBuilderNative.jni_SetBounds(this.getHandle(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_GetCacheName(this.getHandle());
        if ((string == null || string.length() == 0) && this.m_map != null) {
            string = this.m_map.getName();
        }
        return string;
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetCacheName(this.getHandle(), value);
    }

    public CacheImageSize getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetImageSize(this.getHandle());
        CacheImageSize cacheImageSize = null;
        switch (n) {
            case 0: {
                cacheImageSize = CacheImageSize.SIZE64;
                break;
            }
            case 1: {
                cacheImageSize = CacheImageSize.SIZE128;
                break;
            }
            case 2: {
                cacheImageSize = CacheImageSize.SIZE256;
                break;
            }
            case 3: {
                cacheImageSize = CacheImageSize.SIZE512;
                break;
            }
            case 4: {
                cacheImageSize = CacheImageSize.SIZE1024;
                break;
            }
            case 5: {
                cacheImageSize = CacheImageSize.SIZE2048;
                break;
            }
            default: {
                cacheImageSize = CacheImageSize.SIZE256;
            }
        }
        return cacheImageSize;
    }

    public void setImageSize(CacheImageSize imageSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(imageSize);
        MapCache3DBuilderNative.jni_SetIamgeSize(this.getHandle(), n);
    }

    public int getImageCompress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetImageCompress(this.getHandle());
        return n;
    }

    public void setImageCompress(int imageCompress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetImageCompress(this.getHandle(), imageCompress);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_GetOutputFolder(this.getHandle());
        return string;
    }

    public void setOutputFolder(String outputFolder) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetOutputFolder(this.getHandle(), outputFolder);
    }

    public boolean isTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_IsTransparent(this.getHandle());
    }

    public void setTransparent(boolean bool) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetTransparentc(this.getHandle(), bool);
    }

    public CacheImageType getImageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetImageType(this.getHandle());
        CacheImageType cacheImageType = null;
        cacheImageType = (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
        return cacheImageType;
    }

    public boolean isFillMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_IsFillMargin(this.getHandle());
    }

    public void setFillMargin(boolean bool) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetFillMargin(this.getHandle(), bool);
    }

    public void setImageType(CacheImageType cacheImageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheImageType);
        MapCache3DBuilderNative.jni_SetImageType(this.getHandle(), n);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetStorageType(this.getHandle());
        StorageType storageType = null;
        storageType = (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
        return storageType;
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(storageType);
        MapCache3DBuilderNative.jni_SetStorageType(this.getHandle(), n);
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetBeginLevel(this.getHandle());
    }

    public void setBeginLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetBeginLevel(this.getHandle(), value);
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetEndlevel(this.getHandle());
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public void setEndLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetEndlevel(this.getHandle(), value);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String passwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetPassword(this.getHandle(), passwd);
    }

    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_ComputeLevel(this.getHandle());
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getCacheName().contains("\\") || this.getCacheName().contains("/")) {
            String string = InternalResource.loadString("build()", "Global_PathIsNotValid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("build()", "Global_PathIsNotValid", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = MapCache3DBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
        if (n == -1) {
            String string = InternalResource.loadString("build()", "Global_NotEnoughMemory", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Global_PathIsNotValid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getMap() == null) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = MapCache3DBuilderNative.jni_BuildWithoutConfig(this.getHandle(), this.m_selfEventHandle);
        if (n == -1) {
            String string = InternalResource.loadString("build()", "Global_NotEnoughMemory", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean toConfigFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getMap() == null) {
            String string = InternalResource.loadString("toConfigFile()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null) {
            String string = InternalResource.loadString("toConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName.length() == 0) {
            String string = InternalResource.loadString("toConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = ".sci3d";
        if (!fileName.endsWith(string)) {
            fileName = fileName + string;
        }
        boolean bl = MapCache3DBuilderNative.jni_ToConfigFile(this.getHandle(), fileName);
        return bl;
    }

    public boolean fromConfigFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null) {
            String string = InternalResource.loadString("fromConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName.length() == 0) {
            String string = InternalResource.loadString("fromConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCache3DBuilderNative.jni_FromConfigFile(this.getHandle(), fileName);
        return bl;
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setProcessThreadsCount(int threadCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetProcessThreadsCount(this.getHandle(), threadCount);
    }

    public String[] computeImageFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_ComputeImageFileName(this.getHandle());
        return InternalToolkitProcessing.splitString(string, "\\|");
    }

    public String[] computeImageFileName(int specialLevel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_map == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_ComputeImageFileName(this.getHandle(), specialLevel);
        return InternalToolkitProcessing.splitString(string, "\\|");
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector<SteppedListener> vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stepped(event);
            }
        }
    }

    static void steppedCallBack(MapCache3DBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCache3DBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.clearSelfEventHandle();
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            MapCache3DBuilderNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    private void Initialize(Map map, String outputFolder, String name) {
        if (map != null) {
            this.setMap(map);
        }
        if (outputFolder != null) {
            this.setOutputFolder(outputFolder);
        }
        if (name != null) {
            this.setCacheName(name);
        }
        this.setTransparent(false);
        this.setImageType(CacheImageType.PNG);
        this.m_clipRegion = null;
        this.m_selfEventHandle = MapCache3DBuilderNative.jni_NewSelfEventHandle(this);
    }

    Rectangle2D[] getTaskBounds(Rectangle2D recBounds, int level, int taskCount) {
        int n;
        if (recBounds.isEmpty() || recBounds == null || taskCount <= 0) {
            return null;
        }
        double d = recBounds.getTop();
        double d2 = recBounds.getBottom();
        double d3 = recBounds.getLeft();
        double d4 = recBounds.getRight();
        double d5 = 180.0 / (double)(1 << level);
        int n2 = (int)((d3 += 180.0) / d5);
        int n3 = (int)Math.ceil((d4 += 180.0) / d5);
        int n4 = (int)((180.0 - (d += 90.0)) / d5);
        int n5 = (int)Math.ceil((180.0 - (d2 += 90.0)) / d5);
        int n6 = n5 - n4 + 1;
        int n7 = n6 * (n = n3 - n2 + 1);
        if (n7 < taskCount) {
            taskCount = n7;
        }
        int n8 = (int)Math.ceil((float)n / (float)taskCount);
        int n9 = (int)Math.ceil((float)n6 / (float)taskCount);
        n7 = n8 * n9;
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n7];
        for (int i = 0; i < n9; ++i) {
            for (int j = 0; j < n8; ++j) {
                Rectangle2D rectangle2D;
                double d6 = (double)(n2 + j * taskCount) * d5 - 180.0;
                double d7 = (double)(n2 + (j + 1) * taskCount) * d5 - 180.0;
                double d8 = 90.0 - (double)(n4 + i * taskCount) * d5;
                double d9 = 90.0 - (double)(n4 + (i + 1) * taskCount) * d5;
                rectangle2DArray[n8 * i + j] = rectangle2D = new Rectangle2D(d6, d9, d7, d8);
            }
        }
        return rectangle2DArray;
    }
}

