/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.processing.CacheProcessToolsNative;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.tilestorage.TileStorageConnection;
import com.supermap.tilestorage.TileStorageManager;

public class CacheProcessTools
extends InternalHandleDisposable {
    public static byte[] extractCacheFiles(String strPath, int blockFactor, String[] tileNames, String password) {
        if (tileNames == null || tileNames.length == 0) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        return CacheProcessToolsNative.jni_ExtractCacheFiles(strPath, 0L, blockFactor, tileNames, password);
    }

    public static byte[] extractCacheFiles(TileStorageConnection connection, String visionName, String[] tileNames) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)connection);
        if (tileNames == null || tileNames.length == 0 || l == 0L) {
            return null;
        }
        return CacheProcessToolsNative.jni_ExtractHistoryCacheFiles("", l, visionName, tileNames, "");
    }

    public static byte[] extractCacheFiles(TileStorageManager tileManager, int blockFactor, String[] tileNames) {
        long l = tileManager.getTileStorageHandle();
        if (tileNames == null || tileNames.length == 0 || l == 0L) {
            return null;
        }
        return CacheProcessToolsNative.jni_ExtractCacheFiles("", l, blockFactor, tileNames, "");
    }

    public static byte[] extractCacheFile(String strPath, int blockFactor, String tileName, String password) {
        if (tileName == null || tileName.length() == 0) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        return CacheProcessToolsNative.jni_ExtractCacheFile(strPath, 0L, blockFactor, tileName, password);
    }

    public static byte[] extractCacheFile(TileStorageManager tileManager, int blockFactor, String tileName) {
        long l = tileManager.getTileStorageHandle();
        if (tileName == null || tileName.length() == 0 || l == 0L) {
            return null;
        }
        return CacheProcessToolsNative.jni_ExtractCacheFile("", l, blockFactor, tileName, "");
    }

    public static boolean TINToCacheFiles(String configFile, String outPath, int blockScale) {
        if (configFile == null || outPath == null) {
            return false;
        }
        return CacheProcessToolsNative.jni_TINToCacheFiles(configFile, outPath, blockScale);
    }

    public static boolean terrainCacheToMongoDB(String configFile, TileStorageConnection connection, int blockScale, String configMongoFile) {
        if (configFile == null || connection == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)connection);
        return CacheProcessToolsNative.jni_TINToMongoDB(configFile, l, blockScale, configMongoFile);
    }

    @Deprecated
    public static boolean TINToMongoDB(String configFile, TileStorageConnection connection, int blockScale, String configMongoFile) {
        if (configFile == null || connection == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)connection);
        return CacheProcessToolsNative.jni_TINToMongoDB(configFile, l, blockScale, configMongoFile);
    }

    public static boolean imageCacheToMongoDB(String configFile, TileStorageConnection connection, String configMongoFile) {
        if (configFile == null || connection == null || configMongoFile == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)connection);
        return CacheProcessToolsNative.jni_ImageCacheToMongoDB(configFile, l, configMongoFile);
    }

    public static boolean openMemoryCache(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        return CacheProcessToolsNative.jni_OpenMemoryCache(path);
    }

    public static boolean closeMemoryCache(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        return CacheProcessToolsNative.jni_CloseMemoryCache(path);
    }

    public void dispose() {
    }
}

