/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Environment;
import com.supermap.data.GeoRegion;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderTINNative;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TINTile;
import com.supermap.data.processing.TerrainCacheInfo;
import com.supermap.data.processing.TilingSchemeOption;
import com.supermap.tilestorage.TileStorageManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class CacheBuilderTIN
extends InternalHandleDisposable {
    private static transient Vector m_steppedListeners;
    private static long m_selfEventHandle;
    private static String m_senderMethodName;
    private static License m_license;
    private boolean m_isNeededToReplace;
    private boolean m_isUserDefinedDealt;
    private DatasetGrid m_datasetGrid;
    private Dataset m_dataset;
    private GeoRegion m_clipRegion;
    private Dataset m_datasetImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public CacheBuilderTIN() {
        CacheBuilderTIN.verifyLicense();
        this.m_isNeededToReplace = false;
        long l = CacheBuilderTINNative.jni_New();
        this.setHandle(l, true);
        this.m_isUserDefinedDealt = false;
        this.m_dataset = null;
        this.m_datasetGrid = null;
        this.m_datasetImage = null;
        this.m_clipRegion = null;
        m_selfEventHandle = CacheBuilderTINNative.jni_NewSelfEventHandle(this);
    }

    private void clearSelfEventHandle() {
        if (m_selfEventHandle != 0L) {
            CacheBuilderTINNative.jni_DeleteSelfEventHandle(m_selfEventHandle);
            m_selfEventHandle = 0L;
        }
    }

    protected void clearHandle() {
        if (this.m_dataset != null) {
            this.m_dataset = null;
        }
        if (this.m_datasetGrid != null) {
            this.m_datasetGrid = null;
        }
        if (this.m_datasetImage != null) {
            this.m_datasetImage = null;
        }
        if (this.m_clipRegion != null) {
            InternalGeoRegion.clearHandle(this.m_clipRegion);
            this.m_clipRegion = null;
        }
        this.setHandle(0L);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderTINNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.clearSelfEventHandle();
        }
    }

    public DatasetGrid getDataset() {
        return this.m_datasetGrid;
    }

    public void setDataset(DatasetGrid value) {
        if (value != null) {
            long l = CacheBuilderTINNative.jni_SetDataset(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
            if (this.getHandle() != l) {
                this.setHandle(0L);
                this.setHandle(l, true);
            }
        } else {
            throw new IllegalStateException("Dataset is null");
        }
        this.m_datasetGrid = value;
    }

    public void setDatasetPoint(DatasetVector value) {
        if (value != null) {
            long l = CacheBuilderTINNative.jni_SetDataset(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
            if (this.getHandle() != l) {
                this.setHandle(0L);
                this.setHandle(l, true);
            }
        } else {
            throw new IllegalStateException("Dataset is null");
        }
        this.m_dataset = value;
    }

    public DatasetVector getDatasetPoint() {
        return (DatasetVector)this.m_dataset;
    }

    public Dataset getDatasetImage() {
        return this.m_datasetImage;
    }

    public void setDatasetImage(Dataset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)value) != 0L) {
            this.m_datasetImage = value;
            CacheBuilderTINNative.jni_SetDatasetImage(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        }
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderTINNative.jni_GetOutputFolder(this.getHandle());
        File file = new File(string);
        String string2 = file.getParent();
        return string2;
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_isNeededToReplace = value.contains("\\");
        CacheBuilderTINNative.jni_SetOutputFolder(this.getHandle(), value);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetCacheName(this.getHandle(), value);
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetBeginLevel(this.getHandle());
    }

    public void setBeginLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetBeginLevel(this.getHandle(), value);
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetEndLevel(this.getHandle());
    }

    public void setEndLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetEndLevel(this.getHandle(), value);
    }

    public boolean isEncodeDXT() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_IsEncodeDXT(this.getHandle());
    }

    public void setEncodeDXT(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetEncodeDXT(this.getHandle(), value);
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setProcessThreadsCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetProcessThreadsCount(this.getHandle(), value);
    }

    public TilingSchemeOption getTilingScheme() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderTINNative.jni_GetTilingScheme(this.getHandle());
        return (TilingSchemeOption)InternalEnum.parseUGCValue(TilingSchemeOption.class, n);
    }

    public void setTilingScheme(TilingSchemeOption value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetTilingScheme(this.getHandle(), value.value());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        CacheBuilderTINNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        CacheBuilderTINNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public GeoRegion getClipRegion() {
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_clipRegion = value;
        CacheBuilderTINNative.jni_SetClipRegion(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
    }

    public boolean isBuildNormalMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBuildNormalMap", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_IsBuildNormalMap(this.getHandle());
    }

    public void setBuildNormalMap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBuildNormalMap", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetBuildNormalMap(this.getHandle(), value);
    }

    public boolean isCompressed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCompressed", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_IsCompressed(this.getHandle());
    }

    public void setCompressed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressed", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetCompressed(this.getHandle(), value);
    }

    public int getNormalSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNormalSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetNormalSize(this.getHandle());
    }

    public void setNormalSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNormalSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetNormalSize(this.getHandle(), value);
    }

    public StorageType getStoreType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderTINNative.jni_GetStoreType(this.getHandle());
        return (StorageType)InternalEnum.parse(StorageType.class, (int)n);
    }

    public void setStoreType(StorageType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetStoreType(this.getHandle(), value.value());
    }

    public double getDealtOfEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDealtOfEndLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isUserDefinedDealt) {
            return CacheBuilderTINNative.jni_GetDealtOfEndLevel(this.getHandle());
        }
        return CacheBuilderTINNative.jni_GetDealtOfEndLevel2(this.getEndLevel());
    }

    public void setDealtOfEndLevel(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value > 0.0) {
            this.m_isUserDefinedDealt = true;
        } else {
            this.m_isUserDefinedDealt = false;
            value = 0.0;
        }
        CacheBuilderTINNative.jni_SetDealtOfEndLevel(this.getHandle(), value);
    }

    public boolean buildTIN() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(this.getOutputFolder());
        if (!file.exists()) {
            String string = InternalResource.loadString("CacheBuilderTIN", "OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getEndLevel() < this.getBeginLevel()) {
            String string = InternalResource.loadString("CacheBuilderTIN", "CacheBuilder_EndLevelCannotBeLessThanBeginLevel", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_BuildTIN(this.getHandle(), m_selfEventHandle);
    }

    public boolean buildOSGB() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(this.getOutputFolder());
        if (!file.exists()) {
            String string = InternalResource.loadString("CacheBuilderTIN", "OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getEndLevel() < this.getBeginLevel()) {
            String string = InternalResource.loadString("CacheBuilderTIN", "CacheBuilder_EndLevelCannotBeLessThanBeginLevel", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_BuildOSGB(this.getHandle(), m_selfEventHandle);
    }

    public boolean buildWaterMask(String sctFile, String sci3dFile, String sctOutFolder, String sctOutCacheName) {
        return CacheBuilderTINNative.jni_BuildWaterMask(sctFile, sci3dFile, sctOutFolder, sctOutCacheName);
    }

    public static boolean combineTerrainTIN(String strOut, String strCacheName, String strTinA, String strTinB) {
        return CacheBuilderTINNative.jni_CombineTerrainTIN(strOut, strCacheName, strTinA, strTinB, m_selfEventHandle);
    }

    public static boolean convertTinToOsgb(String strOut, String strCacheName, String strSct, ArrayList<Dataset> arrImage) {
        if (arrImage == null) {
            String string = InternalResource.loadString("arrImage", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[arrImage.size()];
        for (int i = 0; i < arrImage.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)arrImage.get(i));
        }
        return CacheBuilderTINNative.jni_ConvertTinToOsgb(strOut, strCacheName, strSct, lArray);
    }

    public static boolean compactCacheFiles(String strInCacheSCT, String strOutCachePath, String strCacheFileName) {
        return CacheBuilderTINNative.jni_CompactCacheFiles(strInCacheSCT, strOutCachePath, strCacheFileName);
    }

    protected void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(CacheBuilderTIN source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    public static boolean combineTerrainTINConfigFile(String strOutConfigPathName, ArrayList<String> arrInPathNames, boolean hasCacheFile) {
        if (strOutConfigPathName == null) {
            String string = InternalResource.loadString("strOutConfigPathName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (arrInPathNames == null || arrInPathNames.size() < 2) {
            String string = InternalResource.loadString("strInFileA", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = new String[arrInPathNames.size()];
        for (int i = 0; i < arrInPathNames.size(); ++i) {
            stringArray[i] = arrInPathNames.get(i);
        }
        return CacheBuilderTINNative.jni_CombineTerrainTINConfigFile(strOutConfigPathName, stringArray, hasCacheFile);
    }

    public static byte[] combineTerrainTINTiles(TerrainCacheInfo info, int level, int row, int col) {
        if (info == null || !info.isValid()) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)info);
        return CacheBuilderTINNative.jni_CombineTerrainTINTiles(l, level, row, col);
    }

    public static boolean combineTerrainTINTiles(TINTile outTile, List<TINTile> inTiles, TerrainCacheInfo info) {
        if (outTile == null || inTiles == null || inTiles.size() < 2) {
            String string = InternalResource.loadString("combineTerrainTINTiles", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = info != null ? InternalHandle.getHandle((com.supermap.data.InternalHandle)info) : 0L;
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outTile);
        long[] lArray = new long[inTiles.size()];
        for (int i = 0; i < inTiles.size(); ++i) {
            long l3;
            lArray[i] = l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)inTiles.get(i));
        }
        return CacheBuilderTINNative.jni_CombineTerrainTINTiless(l2, lArray, l);
    }

    public static byte[] combineTerrainTINTiles(TerrainCacheInfo info, List<TINTile> tiles) {
        if (info == null || tiles == null || tiles.size() == 0) {
            String string = InternalResource.loadString("combineTerrainTINTiles", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)info);
        long[] lArray = new long[tiles.size()];
        for (int i = 0; i < tiles.size(); ++i) {
            long l2;
            lArray[i] = l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)tiles.get(i));
        }
        return CacheBuilderTINNative.jni_CombineTerrainTINTiles3(l, lArray);
    }

    public static byte[] combineTerrainTINTiles(TerrainCacheInfo info, HashMap<String, TileStorageManager> tileStorageMap, int level, int row, int col) {
        if (info == null || !info.isValid() || tileStorageMap == null || tileStorageMap.size() == 0) {
            String string = InternalResource.loadString("combineTerrainTINTiles", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)info);
        String[] stringArray = new String[tileStorageMap.size()];
        long[] lArray = new long[tileStorageMap.size()];
        int n = 0;
        for (String string : tileStorageMap.keySet()) {
            TileStorageManager tileStorageManager = tileStorageMap.get(string);
            stringArray[n] = string;
            lArray[n] = tileStorageManager.getTileStorageHandle();
            ++n;
        }
        return CacheBuilderTINNative.jni_CombineTerrainTINTiles2(l, level, row, col, stringArray, lArray);
    }

    public static boolean getTINTiles(TINTile outTile, TerrainCacheInfo info) {
        if (info == null || !info.isValid() || outTile == null) {
            String string = InternalResource.loadString("getTINTiles", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)info);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outTile);
        return CacheBuilderTINNative.jni_GetTINTile(l2, l);
    }

    int[] getDefaultLevel(double resolution) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        CacheBuilderTINNative.jni_GetDefaultLevel(this.getHandle(), resolution, nArray);
        return nArray;
    }

    int[] getTerrainBlockers(int level) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTerrainBlockers", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[4];
        CacheBuilderTINNative.jni_GetTerrainBlocks(this.getHandle(), level, nArray);
        return nArray;
    }

    boolean generateLeafTile(TINTile tile) {
        if (tile == null) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTerrainBlockers", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)tile);
        long l2 = tile.getImageGrid();
        boolean bl = CacheBuilderTINNative.jni_GenerateLeafTile(this.getHandle(), l, l2);
        return bl;
    }

    boolean generateParentTile(TINTile tile) {
        if (tile == null) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GenerateParentTile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)tile);
        long l2 = tile.getImageGrid();
        boolean bl = CacheBuilderTINNative.jni_GenerateParentTile(this.getHandle(), l, l2);
        return bl;
    }

    boolean generateConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GenerateConfigFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = CacheBuilderTINNative.jni_GenerateConfigFile(this.getHandle());
        return bl;
    }

    public boolean buildAvailableBoundsInfo(String strInConfigPathName) {
        return CacheBuilderTINNative.jni_BuildAvailableBoundsInfo(strInConfigPathName);
    }

    public int getBlockScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetBlockFactor(this.getHandle());
    }

    public void setBlockScale(int blockScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetBlockFactor(this.getHandle(), blockScale);
    }

    public String getZField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_GetZField(this.getHandle());
    }

    public void setZField(String zFieldValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderTIN", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderTINNative.jni_SetZField(this.getHandle(), zFieldValue);
    }

    public boolean limitTerrainTIN(String strOutConfigPathName, String strInConfigPathName, Double dMinHigh, Double dMaxHigh) {
        return CacheBuilderTINNative.jni_LimitTerrainTIN(strOutConfigPathName, strInConfigPathName, dMinHigh, dMaxHigh);
    }

    public boolean buildSpatialIndex(String strInConfigPathName) {
        return CacheBuilderTINNative.jni_BuildSpatialIndex(strInConfigPathName);
    }

    public boolean buildNormalMap(DatasetGrid datasetGrid, String strOutConfigPathName, String strInConfigPathName, int normalSize) {
        if (datasetGrid == null) {
            String string = InternalResource.loadString("getDatasetGrid", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderTINNative.jni_BuildNormalMap(InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid), strOutConfigPathName, strInConfigPathName, normalSize);
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitProcessing.managerProducts(InternalToolkitProcessing.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitProcessing.verifyLicense(arrayList);
    }
}

