/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Environment;
import com.supermap.data.GeoModel3D;
import com.supermap.data.Point3D;
import com.supermap.data.QueryParameter;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.threeddesigner.InternalDatasetVector;
import com.supermap.realspace.threeddesigner.InternalDatasets;
import com.supermap.realspace.threeddesigner.InternalGeometry;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import com.supermap.realspace.threeddesigner.ModelFileType;
import com.supermap.realspace.threeddesigner.ModelToolsNative;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public abstract class ModelTools {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    public static boolean geoMode3DsToKML(ArrayList<GeoModel3D> listGeo, String kmlFullPath, ModelFileType fileType) {
        if (null == listGeo) {
            String string = InternalResource.loadString("listGeo", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[listGeo.size()];
        for (int i = 0; i < listGeo.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)listGeo.get(i));
        }
        return ModelToolsNative.jni_GeoMode3DsToKML(lArray, kmlFullPath, fileType.value());
    }

    public static GeoModel3D compose(ArrayList<GeoModel3D> listGeoModels) {
        if (null == listGeoModels) {
            String string = InternalResource.loadString("listGeoModels", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[listGeoModels.size()];
        for (int i = 0; i < listGeoModels.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)listGeoModels.get(i));
        }
        long l = ModelToolsNative.jni_Compose(lArray);
        if (l == 0L) {
            return null;
        }
        return (GeoModel3D)InternalGeometry.createInstance(l);
    }

    public static ArrayList<GeoModel3D> translate(ArrayList<GeoModel3D> listGeoModels, double dbX, double dbY, double dbZ) {
        if (null == listGeoModels) {
            String string = InternalResource.loadString("listGeoModels", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listGeoModels.size() == 0) {
            return null;
        }
        boolean bl = listGeoModels.get(0).isLonLat();
        for (int i = 1; i < listGeoModels.size(); ++i) {
            if (listGeoModels.get(i).isLonLat() == bl) continue;
            String string = InternalResource.loadString("listGeoModels", "ArgumentInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[listGeoModels.size()];
        for (int i = 0; i < listGeoModels.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)listGeoModels.get(i));
        }
        long[] lArray2 = ModelToolsNative.jni_Translate(lArray, dbX, dbY, dbZ);
        lArray = null;
        if (lArray2 == null) {
            return null;
        }
        ArrayList<GeoModel3D> arrayList = new ArrayList<GeoModel3D>();
        for (int i = 0; i < lArray2.length; ++i) {
            arrayList.add((GeoModel3D)InternalGeometry.createInstance(lArray2[i]));
        }
        lArray2 = null;
        return arrayList;
    }

    public static ArrayList<GeoModel3D> rotate(ArrayList<GeoModel3D> listGeoModels, Point3D rotatePoint, double dXAngle, double dYAngle, double dZAngle) {
        if (null == listGeoModels) {
            String string = InternalResource.loadString("listGeoModels", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listGeoModels.size() == 0) {
            return null;
        }
        long[] lArray = new long[listGeoModels.size()];
        for (int i = 0; i < listGeoModels.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)listGeoModels.get(i));
        }
        long[] lArray2 = ModelToolsNative.jni_Rotate(lArray, rotatePoint.getX(), rotatePoint.getY(), rotatePoint.getZ(), dXAngle, dYAngle, dZAngle);
        lArray = null;
        if (lArray2 == null) {
            return null;
        }
        ArrayList<GeoModel3D> arrayList = new ArrayList<GeoModel3D>();
        for (int i = 0; i < lArray2.length; ++i) {
            arrayList.add((GeoModel3D)InternalGeometry.createInstance(lArray2[i]));
        }
        lArray2 = null;
        return arrayList;
    }

    public static boolean instanceDatasetModel(DatasetVector datasetVectorSrc, Datasource datasourceDes, String name) {
        if (datasetVectorSrc == null) {
            String string = InternalResource.loadString("datasetVectorSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorSrc);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVectorSrc", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasourceDes == null) {
            String string = InternalResource.loadString("datasourceDes", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasourceDes);
        if (l2 == 0L) {
            String string = InternalResource.loadString("datasourceDes", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        long l3 = ModelToolsNative.jni_InstanceDatasetModel(l, l2, name);
        if (l3 != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l3, datasourceDes);
            InternalDatasets.add(datasourceDes.getDatasets(), (Dataset)datasetVector);
            bl = true;
        }
        return bl;
    }

    public static void getInstanceInfo(DatasetVector dtModel, HashMap<String, Integer> dicSkeleton, HashMap<String, Integer> dicMaterial, HashMap<String, Integer> dicTexture) {
        String string;
        int n;
        if (dtModel == null) {
            String string2 = InternalResource.loadString("dtModel", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dtModel);
        if (l == 0L) {
            String string3 = InternalResource.loadString("dtModel", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string3);
        }
        if (dicSkeleton == null) {
            String string4 = InternalResource.loadString("dicSkeleton", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string4);
        }
        if (dicMaterial == null) {
            String string5 = InternalResource.loadString("dicMaterial", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string5);
        }
        if (dicTexture == null) {
            String string6 = InternalResource.loadString("dicTexture", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string6);
        }
        int[] nArray = new int[3];
        long[] lArray = ModelToolsNative.jni_GetInstanceInfo(l, nArray);
        String[] stringArray = new String[nArray[0]];
        int[] nArray2 = new int[nArray[0]];
        String[] stringArray2 = new String[nArray[1]];
        int[] nArray3 = new int[nArray[1]];
        String[] stringArray3 = new String[nArray[2]];
        int[] nArray4 = new int[nArray[2]];
        ModelToolsNative.jni_GetInstanceInfo2(lArray, stringArray, nArray2, stringArray2, nArray3, stringArray3, nArray4);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            dicSkeleton.put(string, nArray2[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            dicMaterial.put(string, nArray3[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            string = stringArray3[n];
            dicTexture.put(string, nArray4[n]);
        }
    }

    public static boolean delete(DatasetVector datasetVector, QueryParameter deleteParam) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVector", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (deleteParam == null) {
            String string = InternalResource.loadString("deleteParam", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)deleteParam);
        if (l2 == 0L) {
            String string = InternalResource.loadString("deleteParam", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelToolsNative.jni_Delete(l, l2);
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ModelTools";
        boolean bl = InternalToolkitThreeDDesigner.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string, bl);
        ModelTools.fireStepped(steppedEvent);
        InternalToolkitThreeDDesigner.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

