/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.terrainanalyst;

import com.supermap.analyst.terrainanalyst.InternalResource;
import com.supermap.data.GeoRegion;
import com.supermap.data.Point2D;

public class QuadMeshParameter {
    private GeoRegion m_QuadMeshRegion;
    private int m_nRow;
    private int m_nCol;
    private Point2D m_LeftBottomPoint;
    private Point2D m_RightBottomPoint;
    private Point2D m_RightTopPoint;
    private Point2D m_LeftTopPoint;
    private String m_RowField;
    private String m_ColField;

    public QuadMeshParameter() {
        this.m_QuadMeshRegion = null;
        this.m_nRow = 2;
        this.m_nCol = 2;
        this.m_LeftBottomPoint = Point2D.getEMPTY();
        this.m_RightBottomPoint = Point2D.getEMPTY();
        this.m_RightTopPoint = Point2D.getEMPTY();
        this.m_LeftTopPoint = Point2D.getEMPTY();
        this.m_RowField = "";
        this.m_ColField = "";
    }

    public QuadMeshParameter(GeoRegion quadMeshRegion, int rowCount, int colCount, Point2D leftBottomPoint, Point2D rightBottomPoint, Point2D rightTopPoint, Point2D leftTopPoint, String rowField, String colField) {
        if (quadMeshRegion == null) {
            String string = InternalResource.loadString("quadMeshRegion", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (rowCount < 2) {
            String string = InternalResource.loadString("rowCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (colCount < 2) {
            String string = InternalResource.loadString("colCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (leftBottomPoint.isEmpty()) {
            String string = InternalResource.loadString("leftBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (rightBottomPoint.isEmpty()) {
            String string = InternalResource.loadString("rightBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (rightTopPoint.isEmpty()) {
            String string = InternalResource.loadString("rightTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (leftTopPoint.isEmpty()) {
            String string = InternalResource.loadString("leftTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_QuadMeshRegion = quadMeshRegion;
        this.m_nRow = rowCount;
        this.m_nCol = colCount;
        this.m_LeftBottomPoint = leftBottomPoint;
        this.m_RightBottomPoint = rightBottomPoint;
        this.m_RightTopPoint = rightTopPoint;
        this.m_LeftTopPoint = leftTopPoint;
        this.m_RowField = rowField;
        this.m_ColField = colField;
    }

    public QuadMeshParameter(QuadMeshParameter quadMeshParameter) {
        if (quadMeshParameter == null) {
            String string = InternalResource.loadString("quadMeshParameter", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getQuadMeshRegion() == null) {
            String string = InternalResource.loadString("quadMeshRegion", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRowCount() < 2) {
            String string = InternalResource.loadString("rowCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getColCount() < 2) {
            String string = InternalResource.loadString("colCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getLeftBottomPoint().isEmpty()) {
            String string = InternalResource.loadString("leftBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRightBottomPoint().isEmpty()) {
            String string = InternalResource.loadString("rightBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRightTopPoint().isEmpty()) {
            String string = InternalResource.loadString("rightTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getLeftTopPoint().isEmpty()) {
            String string = InternalResource.loadString("leftTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_QuadMeshRegion = quadMeshParameter.getQuadMeshRegion();
        this.m_nRow = quadMeshParameter.getRowCount();
        this.m_nCol = quadMeshParameter.getColCount();
        this.m_LeftBottomPoint = quadMeshParameter.getLeftBottomPoint();
        this.m_RightBottomPoint = quadMeshParameter.getRightBottomPoint();
        this.m_RightTopPoint = quadMeshParameter.getRightTopPoint();
        this.m_LeftTopPoint = quadMeshParameter.getLeftTopPoint();
        this.m_RowField = quadMeshParameter.getRowField();
        this.m_ColField = quadMeshParameter.getColField();
    }

    public GeoRegion getQuadMeshRegion() {
        return this.m_QuadMeshRegion;
    }

    public int getRowCount() {
        return this.m_nRow;
    }

    public int getColCount() {
        return this.m_nCol;
    }

    public Point2D getLeftBottomPoint() {
        return this.m_LeftBottomPoint;
    }

    public Point2D getRightBottomPoint() {
        return this.m_RightBottomPoint;
    }

    public Point2D getRightTopPoint() {
        return this.m_RightTopPoint;
    }

    public Point2D getLeftTopPoint() {
        return this.m_LeftTopPoint;
    }

    public String getRowField() {
        return this.m_RowField;
    }

    public String getColField() {
        return this.m_ColField;
    }

    public void setQuadMeshRegion(GeoRegion value) {
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_QuadMeshRegion = value;
    }

    public void setRowCount(int value) {
        if (value < 2) {
            String string = InternalResource.loadString("value", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nRow = value;
    }

    public void setColCount(int value) {
        if (value < 2) {
            String string = InternalResource.loadString("value", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nCol = value;
    }

    public void setLeftBottomPoint(Point2D value) {
        if (value.isEmpty()) {
            String string = InternalResource.loadString("leftBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_LeftBottomPoint = value;
    }

    public void setRightBottomPoint(Point2D value) {
        if (value.isEmpty()) {
            String string = InternalResource.loadString("rightBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_RightBottomPoint = value;
    }

    public void setRightTopPoint(Point2D value) {
        if (value.isEmpty()) {
            String string = InternalResource.loadString("rightTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_RightTopPoint = value;
    }

    public void setLeftTopPoint(Point2D value) {
        if (value.isEmpty()) {
            String string = InternalResource.loadString("leftTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_LeftTopPoint = value;
    }

    public void setRowField(String value) {
        this.m_RowField = value;
    }

    public void setColField(String value) {
        this.m_ColField = value;
    }
}

