/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.EcologicalDetectorResult;
import com.supermap.analyst.spatialstatistics.FactorDetectorResult;
import com.supermap.analyst.spatialstatistics.GeographicalDetectorResultNative;
import com.supermap.analyst.spatialstatistics.InteractionDetectorResult;
import com.supermap.analyst.spatialstatistics.InternalHandleDisposable;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.RiskDetectorResult;
import com.supermap.data.DatasetVector;

public class GeographicalDetectorResult
extends InternalHandleDisposable {
    private DatasetVector m_FactorDetectorResultDataset = null;
    private DatasetVector m_RiskDetectorResultDataset = null;
    private DatasetVector m_InteractionDetectorResultDataset = null;
    private DatasetVector m_EcologicalDetectorResultDataset = null;

    GeographicalDetectorResult(long handle, DatasetVector FactorDetectorResultDataset, DatasetVector RiskDetectorResultDataset, DatasetVector InteractionDetectorResultDataset, DatasetVector EcologicalDetectorResultDataset) {
        this.setHandle(handle, false);
        this.m_FactorDetectorResultDataset = FactorDetectorResultDataset;
        this.m_RiskDetectorResultDataset = RiskDetectorResultDataset;
        this.m_InteractionDetectorResultDataset = InteractionDetectorResultDataset;
        this.m_EcologicalDetectorResultDataset = EcologicalDetectorResultDataset;
    }

    public String[] getVariables() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVariables()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        return GeographicalDetectorResultNative.jni_GDVariables(this.getHandle());
    }

    public FactorDetectorResult[] getFactorDetectorResults() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFactorDetectorResults()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeographicalDetectorResultNative.jni_GDFactorDetector(this.getHandle());
        FactorDetectorResult[] factorDetectorResultArray = null;
        if (lArray != null && lArray.length != 0) {
            factorDetectorResultArray = new FactorDetectorResult[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                factorDetectorResultArray[i] = new FactorDetectorResult(lArray[i]);
            }
        }
        return factorDetectorResultArray;
    }

    public RiskDetectorResult getRiskDetectorResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("geRiskDetectorResult()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        long l = GeographicalDetectorResultNative.jni_GDRiskDetector(this.getHandle());
        RiskDetectorResult riskDetectorResult = null;
        if (l != 0L) {
            riskDetectorResult = new RiskDetectorResult(l);
        }
        return riskDetectorResult;
    }

    public InteractionDetectorResult getInteractionDetectorResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("geInteractionDetectorResult()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        long l = GeographicalDetectorResultNative.jni_GDInteractionDetector(this.getHandle());
        InteractionDetectorResult interactionDetectorResult = null;
        if (l != 0L) {
            interactionDetectorResult = new InteractionDetectorResult(l);
        }
        return interactionDetectorResult;
    }

    public EcologicalDetectorResult getEcologicalDetectorResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("geEcologicalDetectorResult()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        long l = GeographicalDetectorResultNative.jni_GDEcologicalDetector(this.getHandle());
        EcologicalDetectorResult ecologicalDetectorResult = null;
        if (l != 0L) {
            ecologicalDetectorResult = new EcologicalDetectorResult(l);
        }
        return ecologicalDetectorResult;
    }

    public DatasetVector getFactorDetectorResultDataset() {
        return this.m_FactorDetectorResultDataset;
    }

    public DatasetVector getRiskDetectorResultDataset() {
        return this.m_RiskDetectorResultDataset;
    }

    public DatasetVector getInteractionDetectorResultDataset() {
        return this.m_InteractionDetectorResultDataset;
    }

    public DatasetVector getEcologicalDetectorResultDataset() {
        return this.m_EcologicalDetectorResultDataset;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            GeographicalDetectorResultNative.jni_GDRDelete(super.getHandle());
            this.setHandle(0L);
        }
    }
}

